/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.componente;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class JDegradePanel
extends JPanel {
    private static final Color COR_INICIAL_PADRAO = new Color(82, 126, 198);
    private static final Color COR_FINAL_PADRAO = Color.WHITE;
    private Point pontoInicioDegrade;
    private Point pontoFimDegrade;
    private Color corInicial;
    private Color corFinal;

    public JDegradePanel() {
        this.inicializarPadrao();
    }

    public JDegradePanel(boolean pIsDoubleBuffered) {
        super(pIsDoubleBuffered);
        this.inicializarPadrao();
    }

    public JDegradePanel(LayoutManager pLayoutManager) {
        super(pLayoutManager);
        this.inicializarPadrao();
    }

    public JDegradePanel(LayoutManager pLayoutManager, boolean pIsDoubleBuffered) {
        super(pLayoutManager, pIsDoubleBuffered);
        this.inicializarPadrao();
    }

    protected void inicializarPadrao() {
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        GradientPaint gradient = new GradientPaint(this.getPontoInicioDegrade(), this.getCorInicial(), this.getPontoFimDegrade(), this.getCorFinal(), false);
        g2.setPaint(gradient);
        g2.fillRect(0, 0, w, h);
    }

    public Point getPontoInicioDegrade() {
        if (this.pontoInicioDegrade == null) {
            return new Point(0, 0);
        }
        return this.pontoInicioDegrade;
    }

    public void setPontoInicioDegrade(Point pontoInicioDegrade) {
        this.pontoInicioDegrade = pontoInicioDegrade;
    }

    public Point getPontoFimDegrade() {
        if (this.pontoFimDegrade == null) {
            return new Point(this.getWidth(), 0);
        }
        return this.pontoFimDegrade;
    }

    public void setPontoFimDegrade(Point pontoFimDegrade) {
        this.pontoFimDegrade = pontoFimDegrade;
    }

    public Color getCorInicial() {
        if (this.corInicial == null) {
            return COR_INICIAL_PADRAO;
        }
        return this.corInicial;
    }

    public void setCorInicial(Color corInicial) {
        this.corInicial = corInicial;
    }

    public Color getCorFinal() {
        if (this.corFinal == null) {
            return COR_FINAL_PADRAO;
        }
        return this.corFinal;
    }

    public void setCorFinal(Color corFinal) {
        this.corFinal = corFinal;
    }
}

