/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.componente;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import org.apache.commons.collections.map.HashedMap;
import serpro.ppgd.app.acoes.MudarPainelAction;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.itr.gui.componente.DashedBorder;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosString;

public class JTaskAction
extends JLabel {
    private static final long serialVersionUID = 1L;
    public static final Color BACKGROUND_COLOR = new Color(240, 245, 240);
    protected static final Color DEFAULT_LAST_ACCESSED_BACKGROUND = new Color(210, 230, 210);
    protected static final Border DEFAULT_FOCUS_BORDER = new DashedBorder(Color.gray, 1, 1, 1);
    protected static final Border DEFAULT_EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    protected static int LINE_WRAP_LOCATION = 50;
    protected static HashedMap mapUnderlineFont = new HashedMap();
    protected static HashedMap mapPlainFont = new HashedMap();
    protected Action action;
    private boolean lastAccessed;
    private Color lastAccessedBackground;
    protected String backupName;
    private boolean permiteAbrirEmAbas;
    private boolean abaFixa = false;
    private static boolean usouAbas = false;

    public JTaskAction(String pName, String pCommandAction) {
        this(pName, pCommandAction, null);
    }

    public JTaskAction(String pName, String pCommandAction, Icon pIcon) {
        this(pName, pCommandAction, pIcon, 2);
    }

    public JTaskAction(String pName, String pCommandAction, Icon pIcon, boolean permiteAbrirEmAbas) {
        this(pName, pCommandAction, pIcon, 2);
        this.permiteAbrirEmAbas = permiteAbrirEmAbas;
    }

    public JTaskAction(String pName, String pCommandAction, Icon pIcon, int pHorizontalAlignment) {
        this(pName, pIcon, pHorizontalAlignment);
        this.action = new MudarPainelAction(pCommandAction);
    }

    public JTaskAction(String pName, Action pAction) {
        this(pName, pAction, null);
    }

    public JTaskAction(String pName, Action pAction, Icon pIcon) {
        this(pName, pAction, pIcon, 2);
    }

    public JTaskAction(String pName, Action pAction, Icon pIcon, boolean permiteAbrirEmAbas) {
        this(pName, pAction, pIcon, 2);
        this.permiteAbrirEmAbas = permiteAbrirEmAbas;
    }

    public JTaskAction(String pName, Action pAction, Icon pIcon, int pHorizontalAlignment) {
        this(pName, pIcon, pHorizontalAlignment);
        this.action = pAction;
    }

    protected JTaskAction(String pName, Icon pIcon, int pHorizontalAlignment) {
        super(UtilitariosString.strToHtml((String)UtilitariosString.insereQuebraDeLinha((String)pName, (int)LINE_WRAP_LOCATION, (String)"<BR>")), pIcon, pHorizontalAlignment);
        this.setName(pName);
        this.backupName = UtilitariosString.strToHtml((String)UtilitariosString.insereQuebraDeLinha((String)pName, (int)LINE_WRAP_LOCATION, (String)"<BR>"));
        this.setFocusable(true);
        this.setOpaque(true);
        this.setBackground(BACKGROUND_COLOR);
        this.setBorder(DEFAULT_EMPTY_BORDER);
        this.setFont(FontesUtil.FONTE_MENOR);
        this.setForeground(new Color(30, 105, 140));
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                JTaskAction.this.setBorder(DEFAULT_EMPTY_BORDER);
            }

            @Override
            public void focusGained(FocusEvent e) {
                JTaskAction.this.setBorder(DEFAULT_FOCUS_BORDER);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!FabricaUtilitarios.isWindows()) {
                    this.talvezExibirPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (FabricaUtilitarios.isWindows()) {
                    this.talvezExibirPopup(e);
                }
            }

            private void talvezExibirPopup(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    JTaskAction.this.doClick(e.isControlDown());
                } else if (JTaskAction.this.permiteAbrirEmAbas) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem menuNovaAba = new JMenuItem("Abrir em nova aba");
                    menuNovaAba.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JTaskAction.this.doClick(true);
                            usouAbas = true;
                        }
                    });
                    popup.add(menuNovaAba);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JTaskAction.this.setText(JTaskAction.this.getText().replaceAll("<html>", "<html><u>").replaceAll("</html>", "</u></html>"));
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JTaskAction.this.setText(JTaskAction.this.getText().replaceAll("<html><u>", "<html>").replaceAll("</u></html>", "</html>"));
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    JTaskAction.this.actionPerformed(null);
                }
            }
        });
    }

    public void doClick(boolean novaAba) {
        this.requestFocusInWindow();
        int mod = novaAba ? 2 : 0;
        ActionEvent event = new ActionEvent(this, 0, this.getName(), mod);
        this.actionPerformed(event);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.action != null && this.isEnabled()) {
            if (event == null) {
                event = new ActionEvent(this, 0, this.getName());
            }
            GuiUtil.startWaitCursor();
            this.action.actionPerformed(event);
            GuiUtil.stopWaitCursor();
        }
    }

    public boolean isLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(boolean lastAccessed) {
        this.lastAccessed = lastAccessed;
        if (lastAccessed) {
            this.setBackground(this.getLastAccessedBackground());
        } else {
            this.setBackground(BACKGROUND_COLOR);
        }
    }

    public Color getLastAccessedBackground() {
        if (this.lastAccessedBackground == null) {
            return DEFAULT_LAST_ACCESSED_BACKGROUND;
        }
        return this.lastAccessedBackground;
    }

    public void setLastAccessedBackground(Color lastAccessedBackground) {
        this.lastAccessedBackground = lastAccessedBackground;
    }

    public String getActionCommand() {
        String lCommandAction = "";
        if (this.action instanceof MudarPainelAction) {
            MudarPainelAction lAction = (MudarPainelAction)this.action;
            lCommandAction = lAction.getCommandAction();
        }
        return lCommandAction;
    }

    public void setMinimized(boolean pMinimized) {
        if (pMinimized) {
            this.setText("");
            this.setToolTipText(this.backupName);
        } else {
            this.setText(this.backupName);
            this.setToolTipText(null);
        }
    }

    public Action getAction() {
        return this.action;
    }

    public static boolean isUsouAbas() {
        return usouAbas;
    }

    public boolean isAbaFixa() {
        return this.abaFixa;
    }

    public void setAbaFixa(boolean abaFixa) {
        this.abaFixa = abaFixa;
    }

    static {
        if (GuiUtil.getProporcaoTelaAtual() < GuiUtil.getProporcaoTela16por9()) {
            System.out.println("Proporcao da tela eh menor que 16:9, reduzindo aba lateral...");
            LINE_WRAP_LOCATION = 42;
        }
    }
}

