/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.componente.autocomplete;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import serpro.ppgd.negocio.ElementoTabela;

public class JAutoCompleteComboModel
extends AbstractListModel
implements MutableComboBoxModel {
    protected ArrayList<ElementoTabela> dados = new ArrayList();
    protected ArrayList<ElementoTabela> dadosFiltrado;
    protected ElementoTabela itemSelecionado;
    protected boolean matchStartOnly;
    protected boolean caseSensitive;

    public JAutoCompleteComboModel() {
        this.dadosFiltrado = new ArrayList();
        this.matchStartOnly = false;
        this.caseSensitive = false;
    }

    public JAutoCompleteComboModel(ElementoTabela[] pItens) {
        this();
        this.setDados(pItens, this.dados);
        this.setDados(pItens, this.dadosFiltrado);
        this.selecionarPrimeiroElemento();
    }

    private void setDados(ElementoTabela[] pItens, ArrayList<ElementoTabela> pLista) {
        pLista.ensureCapacity(pItens.length);
        int c = pItens.length;
        for (int i = 0; i < c; ++i) {
            pLista.add(pItens[i]);
        }
    }

    public JAutoCompleteComboModel(List<ElementoTabela> pLista) {
        this.dados.addAll(pLista);
        this.dadosFiltrado = new ArrayList();
        this.dadosFiltrado.addAll(pLista);
        this.selecionarPrimeiroElemento();
    }

    private void selecionarPrimeiroElemento() {
        if (this.getSize() > 0) {
            this.itemSelecionado = (ElementoTabela)this.getElementAt(0);
        }
    }

    @Override
    public Object getElementAt(int index) {
        return this.dadosFiltrado.get(index);
    }

    @Override
    public int getSize() {
        return this.dadosFiltrado.size();
    }

    public void addElement(Object obj) {
        this.dadosFiltrado.add((ElementoTabela)obj);
    }

    public void insertElementAt(Object obj, int index) {
        this.dadosFiltrado.add(index, (ElementoTabela)obj);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void removeElement(Object obj) {
        int index = this.dadosFiltrado.indexOf(obj);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    @Override
    public void removeElementAt(int index) {
        ElementoTabela lElemento = (ElementoTabela)this.getElementAt(index);
        if (lElemento == this.itemSelecionado) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.dadosFiltrado.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public Object getSelectedItem() {
        return this.itemSelecionado;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        ElementoTabela lElemento = null;
        lElemento = anItem instanceof String ? this.getItemByPattern((String)anItem) : (ElementoTabela)anItem;
        if (this.itemSelecionado != null && !this.itemSelecionado.equals(lElemento) || this.itemSelecionado == null && lElemento != null) {
            this.itemSelecionado = lElemento;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public void setSelectedItemPorCodigo(String pCodigo) {
        for (ElementoTabela lElemento : this.dadosFiltrado) {
            if (!lElemento.getConteudo(0).toLowerCase().equals(pCodigo.toLowerCase())) continue;
            this.itemSelecionado = lElemento;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public int indexOf(String pPattern) {
        if (pPattern != null && !pPattern.isEmpty()) {
            for (int i = 0; i < this.dadosFiltrado.size(); ++i) {
                ElementoTabela lElemento = this.dadosFiltrado.get(i);
                if (!lElemento.getConteudo(1).toLowerCase().equals(pPattern.toLowerCase())) continue;
                return i;
            }
        }
        return -1;
    }

    public ElementoTabela getItemByPattern(String pPattern) {
        if (pPattern != null && !pPattern.isEmpty()) {
            for (ElementoTabela lElemento : this.dadosFiltrado) {
                if (!lElemento.getConteudo(1).toLowerCase().equals(pPattern.toLowerCase())) continue;
                return lElemento;
            }
        }
        return null;
    }

    public void updatePattern(String pPattern) {
        int size1 = this.getSize();
        this.dadosFiltrado.clear();
        if (pPattern == null || pPattern.isEmpty()) {
            this.dadosFiltrado.addAll(this.dados);
        } else {
            pPattern = pPattern.toLowerCase();
            for (ElementoTabela lElemento : this.dados) {
                if (!this.buscar(lElemento.getConteudo(1), pPattern)) continue;
                this.dadosFiltrado.add(lElemento);
            }
        }
        int size2 = this.getSize();
        if (size1 < size2) {
            this.fireIntervalAdded(this, size1, size2 - 1);
            this.fireContentsChanged(this, 0, size1 - 1);
        } else if (size1 > size2) {
            this.fireIntervalRemoved(this, size2, size1 - 1);
            this.fireContentsChanged(this, 0, size2 - 1);
        }
    }

    protected boolean buscar(String pTitulo, String pPattern) {
        String lTitulo = pTitulo;
        String lPattern = pPattern;
        if (!this.caseSensitive) {
            lTitulo = lTitulo.toLowerCase();
            lPattern = lPattern.toLowerCase();
        }
        lTitulo = Normalizer.normalize(lTitulo, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
        lPattern = Normalizer.normalize(lPattern, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
        if (this.matchStartOnly) {
            return lTitulo.startsWith(lPattern);
        }
        return lTitulo.contains(lPattern);
    }

    public boolean isMatchStartOnly() {
        return this.matchStartOnly;
    }

    public void setMatchStartOnly(boolean matchStartOnly) {
        this.matchStartOnly = matchStartOnly;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }
}

