/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.conversormedidas;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.editors.PPGDFormattedTextField;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.AreaHectares;
import serpro.ppgd.itr.ValorPositivo;
import serpro.ppgd.itr.conversormedidas.Medida;
import serpro.ppgd.itr.gui.conversormedidas.PainelMedidasForm;
import serpro.ppgd.itr.gui.table.editors.PPGDCellEditorIf;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Valor;

public class PainelMedidasComValorInterno
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JDialog janela = null;
    private PainelMedidasForm calculadoraForm = null;
    private Valor memoria = null;
    private String operador = null;
    private boolean iniciouOperacao = false;
    private boolean reiniciaDigitos = false;
    private boolean isTransporteEmTabela;
    private EscutadorMouse escutadorMouse;
    private boolean transportando = false;
    private PlataformaPPGD plataforma = PlataformaPPGD.getPlataforma();
    private JComponent contentPlataforma;
    private Component glassPlataforma;
    private JMenuBar menuBar;
    private Component destComponent;
    private Medida objMedida;

    public PainelMedidasComValorInterno() {
        super(new BorderLayout());
        this.setBackground(new Color(220, 236, 244));
        this.objMedida = new Medida();
        this.calculadoraForm = new PainelMedidasForm(this.objMedida);
        this.calculadoraForm.addActionListener(this);
        this.memoria = new Valor(null, "Mem\u00f3ria");
        this.menuBar = this.plataforma.getJanelaPrincipal().getJMenuBar();
        this.contentPlataforma = (JComponent)this.plataforma.getJanelaPrincipal().getContentPane();
        this.add((Component)this.calculadoraForm, "Center");
        this.escutadorMouse = new EscutadorMouse();
    }

    private void compactaJanela() {
        if (this.getJanela() != null) {
            this.calculadoraForm.setCompacto(true);
            this.getJanela().pack();
        }
    }

    private void descompactaJanela() {
        if (this.getJanela() != null) {
            this.calculadoraForm.setCompacto(false);
            this.getJanela().pack();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("Transportar".equals(cmd)) {
            this.iniciaTransportar();
        } else if ("Cancelar transporte".equals(cmd)) {
            this.terminouTransporte();
        } else if ("Fechar".equals(cmd)) {
            ((JDialog)SwingUtilities.getRoot(this)).dispatchEvent(new WindowEvent((Window)SwingUtilities.getRoot(this), 201));
        }
        this.calculadoraForm.getTecladoForm().getAreaConvertida().grabFocus();
    }

    private void iniciaTransportar() {
        this.isTransporteEmTabela = false;
        this.compactaJanela();
        this.updateUI();
        this.glassPlataforma = this.plataforma.getJanelaPrincipal().getGlassPane();
        this.glassPlataforma.setVisible(true);
        this.glassPlataforma.addMouseMotionListener(this.escutadorMouse);
        this.glassPlataforma.addMouseListener(this.escutadorMouse);
        this.setTransportando(true);
    }

    private boolean podeTransportarParaGrid(int lin, int col) {
        this.isTransporteEmTabela = true;
        if (lin >= 0 && col >= 0 && ((JTable)this.destComponent).isCellEditable(lin, col)) {
            ((JTable)this.destComponent).editCellAt(lin, col);
            PPGDCellEditorIf cellEditor = (PPGDCellEditorIf)((Object)((JTable)this.destComponent).getCellEditor(lin, col));
            JEditCampo edit = cellEditor.getEditCampo();
            if ((edit.getInformacao() instanceof Valor || edit.getInformacao() instanceof Valor) && edit.getInformacao().isHabilitado() && !edit.getInformacao().isReadOnly()) {
                return true;
            }
        }
        return false;
    }

    private void aplicaCursorPodeTransportar() {
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void aplicaCursorNaoPodeTransportar() {
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(DragSource.DefaultCopyNoDrop);
    }

    private void tentaTransportar() {
        if (this.destComponent instanceof PPGDFormattedTextField) {
            PPGDFormattedTextField formattedTextField = (PPGDFormattedTextField)this.destComponent;
            Informacao info = formattedTextField.getInformacao();
            if (this.destComponent.isEnabled() && info != null && info.isHabilitado() && !info.isReadOnly() && info instanceof AreaHectares) {
                Valor valorDest = (Valor)formattedTextField.getInformacao();
                String valorDeTransporte = this.calculadoraForm.getTecladoForm().getAreaConvertida().getInformacao().asString();
                valorDeTransporte = valorDeTransporte.replaceAll("\\.", "");
                if (Double.valueOf(valorDeTransporte = valorDeTransporte.replace(',', '.')) < 0.0 && info instanceof ValorPositivo && !this.isTransporteEmTabela) {
                    GuiUtil.mostrarAviso("ErroDeTentativaDeTrasnporteDeValorNegativo");
                } else {
                    formattedTextField.setText(this.calculadoraForm.getTecladoForm().getAreaConvertida().getInformacao().asString());
                    formattedTextField.requestFocus();
                }
                this.terminouTransporte();
            }
        }
    }

    public void terminouTransporte() {
        if (this.isTransportando()) {
            this.descompactaJanela();
            this.glassPlataforma.removeMouseMotionListener(this.escutadorMouse);
            this.glassPlataforma.removeMouseListener(this.escutadorMouse);
            this.aplicaCursorDefault();
            this.setTransportando(false);
        }
    }

    private void aplicaCursorDefault() {
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getDefaultCursor());
        super.setCursor(Cursor.getDefaultCursor());
    }

    private void setTransportando(boolean transportando) {
        this.transportando = transportando;
    }

    public boolean isTransportando() {
        return this.transportando;
    }

    public void setJanela(JDialog janela) {
        this.janela = janela;
    }

    public JDialog getJanela() {
        return this.janela;
    }

    class EscutadorMouse
    extends MouseAdapter {
        EscutadorMouse() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (PainelMedidasComValorInterno.this.isTransportando()) {
                PainelMedidasComValorInterno.this.tentaTransportar();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (PainelMedidasComValorInterno.this.menuBar != null) {
                y -= PainelMedidasComValorInterno.this.menuBar.getHeight();
            }
            PainelMedidasComValorInterno.this.destComponent = SwingUtilities.getDeepestComponentAt(PainelMedidasComValorInterno.this.contentPlataforma, x, y);
            if (PainelMedidasComValorInterno.this.isTransportando()) {
                if (PainelMedidasComValorInterno.this.destComponent instanceof PPGDFormattedTextField) {
                    Informacao info = ((PPGDFormattedTextField)PainelMedidasComValorInterno.this.destComponent).getInformacao();
                    if (PainelMedidasComValorInterno.this.destComponent.isEnabled() && info != null && info instanceof AreaHectares && info.isHabilitado() && !info.isReadOnly()) {
                        PainelMedidasComValorInterno.this.aplicaCursorPodeTransportar();
                    }
                } else if (PainelMedidasComValorInterno.this.destComponent instanceof JTable) {
                    int col;
                    Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), PainelMedidasComValorInterno.this.destComponent);
                    int lin = ((JTable)PainelMedidasComValorInterno.this.destComponent).rowAtPoint(p);
                    if (PainelMedidasComValorInterno.this.podeTransportarParaGrid(lin, col = ((JTable)PainelMedidasComValorInterno.this.destComponent).columnAtPoint(p))) {
                        PainelMedidasComValorInterno.this.aplicaCursorPodeTransportar();
                    } else {
                        PainelMedidasComValorInterno.this.aplicaCursorNaoPodeTransportar();
                    }
                } else {
                    PainelMedidasComValorInterno.this.aplicaCursorNaoPodeTransportar();
                }
            }
        }
    }
}

