/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.demaiscondominos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.itr.demaiscondominos.Condomino;
import serpro.ppgd.itr.demaiscondominos.DemaisCondominos;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.ITRTableAb;
import serpro.ppgd.itr.gui.ITRTableModelAb;
import serpro.ppgd.itr.gui.JITRToolbar;
import serpro.ppgd.itr.gui.PainelPrincipalAb;
import serpro.ppgd.itr.gui.TableLista;
import serpro.ppgd.itr.gui.TableListaModel;
import serpro.ppgd.itr.gui.TableListaSumario;
import serpro.ppgd.itr.gui.demaiscondominos.PainelCondominoDetalhe;
import serpro.ppgd.itr.gui.demaiscondominos.TableModelCondominos;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.gui.util.ITRTableDecorator;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelCondominosLista
extends PainelPrincipalAb {
    public static final String TITULO = "<html>Documento de Informa\u00e7\u00e3o e Atualiza\u00e7\u00e3o Cadastral do ITR - Diac<br>Demais Cond\u00f4minos</html>";
    public static final String HELP_ID = "Preenchimento das Fichas/Demais Cond\u00f4minos";
    private static int QUANTIDADE_MAXIMA_REGISTROS;
    private JEditValor edtTotalCondominos;
    private JITRToolbar irpfToolbar;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JLabel lblMunicipio;
    private TableLista tableLista;

    public PainelCondominosLista() {
        this.initComponents();
        this.associarInformacao();
        this.getTabela().setRowHeight(30);
        this.configurarTamanhoColunas();
        ITRTableDecorator.decorate(this.getTabela(), this);
        this.getTabela().getSelectionModel().addListSelectionListener(this.irpfToolbar);
        try {
            QUANTIDADE_MAXIMA_REGISTROS = Integer.valueOf(MensagemUtil.getMensagem("quantidade.demais.condominos"));
        }
        catch (NumberFormatException ex) {
            QUANTIDADE_MAXIMA_REGISTROS = 10;
        }
    }

    @Override
    public void preFecharDeclaracao() {
    }

    private void associarInformacao() {
        DemaisCondominos condominos = ControladorGui.getDeclaracaoAberta().getDemaisCondominos();
        this.edtTotalCondominos.setInformacao((Informacao)condominos.getTotalCondominos());
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableLista = this.instanciarTabela(this.getTableModel(), this.getColunaOrdenacao(), this.getColunasOrdenaveis());
        this.irpfToolbar = new JITRToolbar();
        this.jPanel3 = new JPanel();
        this.lblMunicipio = new JLabel();
        this.edtTotalCondominos = new JEditValor();
        this.jLabel1 = new JLabel();
        this.setBackground(new Color(240, 245, 240));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(195, 195, 195)));
        this.jScrollPane1.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane1.setViewportView(this.tableLista);
        this.irpfToolbar.addToolBarListener(this);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jScrollPane1, -1, 644, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.irpfToolbar, -2, -1, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 299, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.irpfToolbar, -2, -1, -2).addContainerGap()));
        this.jPanel3.setBackground(new Color(233, 248, 233));
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.lblMunicipio.setFont(FontesUtil.FONTE_NORMAL);
        this.lblMunicipio.setForeground(new Color(89, 89, 89));
        this.lblMunicipio.setText("<html>Total de cond\u00f4minos (inclusive o declarante)</html>");
        this.lblMunicipio.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.lblMunicipio, -2, 322, -2).addPreferredGap(0).add((Component)this.edtTotalCondominos, -2, 74, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.lblMunicipio, -2, -1, -2).add((Component)this.edtTotalCondominos, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2).add(18, 18, 18)));
        this.jLabel1.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.jLabel1.setForeground(new Color(30, 105, 140));
        this.jLabel1.setText("Dados dos Demais Cond\u00f4minos");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public ITRTableAb getTabela() {
        return this.tableLista;
    }

    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(5);
        tcm.getColumn(1).setPreferredWidth(50);
        tcm.getColumn(2).setPreferredWidth(200);
        tcm.getColumn(3).setPreferredWidth(50);
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista2 = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista2.accessibleColumnHeader = new String[]{"Item", "CPF ou CNPJ", "Nome da Pessoa F\u00edsica ou Nome empresarial", "Percentual"};
        return tableLista2;
    }

    protected String getClassePainelNavegacao() {
        return PainelCondominoDetalhe.class.getName();
    }

    protected String getButtonHelpID() {
        return HELP_ID;
    }

    protected TableListaModel getTableModel() {
        return new TableModelCondominos((ObjetoNegocio)ControladorGui.getDeclaracaoAberta().getDemaisCondominos());
    }

    protected int getColunaOrdenacao() {
        return 0;
    }

    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    @Override
    public String getTituloPainel() {
        return TITULO;
    }

    @Override
    public void preExibir() {
        ((Colecao)((ITRTableModelAb)this.getTabela().getModel()).getObjetoNegocio()).excluirRegistrosEmBranco();
        ((ITRTableModelAb)this.getTabela().getModel()).refresh();
        if (this.getTabela().getModel().getRowCount() > 0) {
            this.getTabela().selecionaCelula(1, 0);
        }
        this.atualizarVisualizacao();
        this.edtTotalCondominos.getButtonMensagem().setVisible(false);
    }

    private void atualizarVisualizacao() {
        if (this.getTabela().getRowCount() == QUANTIDADE_MAXIMA_REGISTROS) {
            this.getIrpfToolbar().getBtnNovo().setEnabled(false);
        } else {
            this.getIrpfToolbar().getBtnNovo().setEnabled(true);
        }
    }

    @Override
    public JComponent getDefaultFocus() {
        return this.getTabela();
    }

    @Override
    public void onBtnNovoClick(ActionEvent e) {
        TableModelCondominos lModel = (TableModelCondominos)this.getTabela().getModel();
        ControladorGui.acionarPainel(new PainelCondominoDetalhe());
        lModel.refresh();
    }

    @Override
    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            ITRTableModelAb model = (ITRTableModelAb)this.getTabela().getModel();
            DemaisCondominos colCondominos = (DemaisCondominos)model.getObjetoNegocio();
            Condomino condomino = (Condomino)((Object)colCondominos.itens().get(indiceVetor));
            ControladorGui.acionarPainel(new PainelCondominoDetalhe(condomino));
        } else {
            GuiUtil.mostrarAviso("111138");
        }
    }

    @Override
    public void onBtnExcluirClick(ActionEvent e) {
        ITRTableAb tabela = this.getTabela();
        boolean temSumario = tabela instanceof TableListaSumario;
        if (!(tabela.getSelectedRow() < 0 || temSumario && tabela.getSelectedRow() >= tabela.getRowCount() - 1)) {
            int linhaTabela = tabela.getSelectedRow();
            int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela);
            TableListaModel model = (TableListaModel)tabela.getModel();
            Colecao colecao = (Colecao)model.getObjetoNegocio();
            if (GuiUtil.mostrarConfirma("111136", new String[]{"cond\u00f4mino"})) {
                colecao.itens().remove(indiceVetor);
                this.atualizarVisualizacao();
                this.getDefaultFocus().requestFocusInWindow();
                if (this.getTabela().getModel().getRowCount() > 0) {
                    if (linhaTabela == this.getTabela().getModel().getRowCount()) {
                        this.getTabela().selecionaCelula(1, linhaTabela - 1);
                    } else {
                        this.getTabela().selecionaCelula(1, linhaTabela);
                    }
                }
            }
        } else {
            GuiUtil.mostrarAviso("111138");
        }
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/ITR40x40/demais_condominos3.png");
    }

    public JITRToolbar getIrpfToolbar() {
        return this.irpfToolbar;
    }

    @Override
    public String getMensagemTela() {
        return MensagemUtil.getMensagem("quantidade_condominos_excedida");
    }

    @Override
    public boolean isTelaComMensagem() {
        return true;
    }

    @Override
    public String getHelpID() {
        return this.getButtonHelpID();
    }
}

