/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.app.PlataformaITRPGD;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.ProcessoSwing;
import serpro.ppgd.infraestrutura.util.Tarefa;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.IdImovel;
import serpro.ppgd.itr.gui.ListaDecRepositorioTableModel;
import serpro.ppgd.itr.gui.TableSorter;
import serpro.ppgd.itr.gui.dialogs.PainelConfirmarExibirPendencias;
import serpro.ppgd.itr.gui.dialogs.PainelConfirmarGravar;
import serpro.ppgd.itr.gui.dialogs.PainelConfirmarTransmitir;
import serpro.ppgd.itr.gui.dialogs.PainelListaDeclaracao;
import serpro.ppgd.itr.gui.dialogs.PainelLocalizadorPasta;
import serpro.ppgd.itr.gui.dialogs.PainelVerificarPendenciasPopup;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.txt.UtilitariosTXT;
import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;
import serpro.receitanet.ControleReceitanet;
import serpro.receitanet.Receitanet;

public class PainelGravarDeclaracao
extends JPanel {
    public static final String HELP_ID = "Gravar uma C\u00f3pia de Seguran\u00e7a";
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    private JButton btnTodas;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private PainelListaDeclaracao pnlListaDec;
    private PainelLocalizadorPasta pnlLocalizadorPasta;

    public PainelGravarDeclaracao() {
        this.initComponents();
        PlataformaPPGD plataforma = PlataformaPPGD.getPlataforma();
        ((PlataformaITRPGD)plataforma).getHelpPDF().setHelpID(this, HELP_ID);
        ((PlataformaITRPGD)plataforma).getHelpPDF().setHelpID(this.btnAjuda, HELP_ID);
        this.pnlLocalizadorPasta.setTitulo("Selecionar pasta para grava\u00e7\u00e3o de declara\u00e7\u00e3o ITR " + ConstantesGlobais.EXERCICIO);
        TableSorter sorter = new TableSorter(new ListaDecRepositorioTableModel(ITRFacade.getListaIdDeclaracoes()), this.pnlListaDec.getTblDeclaracao().getTableHeader());
        sorter.setColumnComparator(String.class, TableSorter.LEXICAL_COMPARATOR);
        sorter.setColumnComparator(IdImovel.class, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((IdImovel)o1).getNirf().compareTo(((IdImovel)o2).getNirf());
            }
        });
        this.pnlListaDec.getTblDeclaracao().setModel(sorter);
        this.pnlListaDec.getTblDeclaracao().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelGravarDeclaracao.this.pnlListaDec.getTblDeclaracao().getSelectedRowCount() > 0) {
                    PainelGravarDeclaracao.this.btnOk.setEnabled(true);
                } else {
                    PainelGravarDeclaracao.this.btnOk.setEnabled(false);
                }
            }
        });
        this.pnlListaDec.getTblDeclaracao().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelGravarDeclaracao.this.pnlListaDec.getTblDeclaracao().getSelectedRowCount() > 0) {
                    PainelGravarDeclaracao.this.btnOkActionPerformed(null);
                }
            }
        });
        if (this.pnlListaDec.getTblDeclaracao().getRowCount() > 0) {
            this.pnlListaDec.getTblDeclaracao().setRowSelectionInterval(0, 0);
        }
    }

    public PainelGravarDeclaracao(IdentificadorDeclaracao idDec) {
        this();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Gravar_Disquete_para_Entrega_a_SRF");
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, "Gravar_Disquete_para_Entrega_a_SRF");
        ListaDecRepositorioTableModel model = (ListaDecRepositorioTableModel)((TableSorter)this.pnlListaDec.getTblDeclaracao().getModel()).getTableModel();
        int index = model.getIds().indexOf(idDec);
        int selected = ((TableSorter)this.pnlListaDec.getTblDeclaracao().getModel()).getViewIndex(index);
        this.pnlListaDec.getTblDeclaracao().setRowSelectionInterval(selected, selected);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.btnTodas = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.pnlListaDec = new PainelListaDeclaracao();
        this.pnlLocalizadorPasta = new PainelLocalizadorPasta();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.setBackground(new Color(240, 245, 240));
        this.jPanel1.setBackground(new Color(240, 245, 240));
        this.jPanel1.setForeground(new Color(255, 255, 255));
        this.btnOk.setMnemonic('G');
        this.btnOk.setText("<html><body><u>G</u>ravar</body></html>");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelGravarDeclaracao.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelGravarDeclaracao.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.btnAjuda.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelGravarDeclaracao.this.btnAjudaActionPerformed(evt);
            }
        });
        this.btnTodas.setMnemonic('S');
        this.btnTodas.setText("Selecionar todas");
        this.btnTodas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelGravarDeclaracao.this.btnTodasActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.btnTodas).addPreferredGap(0, 440, Short.MAX_VALUE).add((Component)this.btnOk, -2, -1, -2).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.btnCancelar).add((Component)this.btnAjuda).add((Component)this.btnTodas).add((Component)this.btnOk, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk, this.btnTodas}, 2);
        this.jPanel2.setBackground(new Color(240, 245, 240));
        this.jPanel2.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(new Font("Arial", 0, 11));
        this.jLabel1.setForeground(new Color(30, 105, 140));
        this.jLabel1.setText("Selecione uma ou mais declara\u00e7\u00f5es na lista abaixo ou pressione o bot\u00e3o \"Selecionar Todas\":");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addContainerGap(339, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel1));
        this.jPanel3.setBackground(new Color(240, 245, 240));
        this.jLabel2.setFont(new Font("Arial", 0, 11));
        this.jLabel2.setForeground(new Color(30, 105, 140));
        this.jLabel2.setText("Selecione a pasta onde ser\u00e1 feita a grava\u00e7\u00e3o:");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).addContainerGap(564, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jLabel2));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.pnlLocalizadorPasta, -1, 717, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.pnlListaDec, -1, 717, Short.MAX_VALUE).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(0).add((Component)this.pnlLocalizadorPasta, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.pnlListaDec, -2, 282, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addContainerGap(20, Short.MAX_VALUE)));
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.pnlListaDec.getTblDeclaracao().getSelectedRowCount() > 0) {
            ((JDialog)SwingUtilities.getRoot(this)).dispatchEvent(new WindowEvent((Window)SwingUtilities.getRoot(this), 201));
            int[] selecteds = this.pnlListaDec.getTblDeclaracao().getSelectedRows();
            ListaDecRepositorioTableModel model = (ListaDecRepositorioTableModel)((TableSorter)this.pnlListaDec.getTblDeclaracao().getModel()).getTableModel();
            GravarDeclaracaoAction acao = new GravarDeclaracaoAction();
            for (int i = 0; i < selecteds.length; ++i) {
                int index = ((TableSorter)this.pnlListaDec.getTblDeclaracao().getModel()).modelIndex(selecteds[i]);
                IdentificadorDeclaracao id = (IdentificadorDeclaracao)model.getIds().get(index);
                int ret = acao.verificarPendencias(id, i + 1, selecteds.length);
                if (ret == 2) {
                    ret = acao.gravar(this.pnlLocalizadorPasta.getPasta(), id, i + 1, selecteds.length);
                    if (ret == 3) {
                        id.liberarInformacoes();
                        break;
                    }
                    if (ret == 5) {
                        ret = acao.confirmarTransmitir(id, this.pnlLocalizadorPasta.getPasta(), i + 1, selecteds.length);
                        if (ret == 5) {
                            ret = acao.transmitir(false, i + 1, selecteds.length);
                        } else if (ret == 6) {
                            ret = acao.transmitir(true, i + 1, selecteds.length);
                        } else if (ret == 3) {
                            id.liberarInformacoes();
                            break;
                        }
                    }
                } else if (ret == 3) {
                    id.liberarInformacoes();
                    break;
                }
                id.liberarInformacoes();
            }
            if (ITRFacade.getDeclaracaoAberta() == null) {
                ITRFacade.limparRepositorioXML();
                ITRFacade.setDeclaracaoEmMemoria(null);
            }
        }
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).dispatchEvent(new WindowEvent((Window)SwingUtilities.getRoot(this), 201));
    }

    private void btnAjudaActionPerformed(ActionEvent evt) {
    }

    private void btnTodasActionPerformed(ActionEvent evt) {
        this.pnlListaDec.getTblDeclaracao().selectAll();
    }

    private static class GravarDeclaracaoAction {
        private int qtdGravadas = 0;
        public static final int RETORNO_PROXIMA = 0;
        public static final int RETORNO_EXIBIR_PENDENCIAS = 1;
        public static final int RETORNO_GRAVAR = 2;
        public static final int RETORNO_CANCELAR = 3;
        public static final int RETORNO_CONFIRMAR_TRANSMITIR = 5;
        public static final int RETORNO_TRANSMITIR = 5;
        public static final int RETORNO_TRANSMITIR_COM_CERTIFICADO = 6;
        public static final int RETORNO_VERIFICAR_PENDENCIAS = 7;
        private static Receitanet receitaNet = null;
        private File lastFileDec = null;
        private FileFilter fileFilterDecTransmitida = ITRFacade.obterNovoFileFilterArquivoDecTransmitida();

        private GravarDeclaracaoAction() {
        }

        public int gravar(File destino, IdentificadorDeclaracao id, int indice, int total) {
            File fileDec = new File(destino.getPath() + File.separator + ITRFacade.obterNomeArquivoDec(id));
            if (fileDec.exists() && fileDec.isFile()) {
                String nirf = id.getNirf().asString();
                Object msg = null;
                msg = this.fileFilterDecTransmitida.accept(fileDec) ? MensagemUtil.getMensagem("900079", new String[]{UtilitariosString.formataNIRF((String)nirf)}) + "\n \n" + MensagemUtil.getMensagem("900080") + "\n \n" + MensagemUtil.getMensagem("900081") : MensagemUtil.getMensagem("800015", new String[]{UtilitariosString.formataNIRF((String)nirf)});
                int ret = GuiUtil.confirmaPaginado((String)msg, "Declara\u00e7\u00e3o", indice, total, 1, 3);
                if (ret == 1) {
                    return 0;
                }
                if (ret == 2) {
                    return 3;
                }
            }
            try {
                this.lastFileDec = ITRFacade.gravarParaEntrega(destino, id.getNirf().asString());
                ++this.qtdGravadas;
            }
            catch (GeracaoTxtException e) {
                GuiUtil.confirmaPaginado(e.getMessage(), "Declara\u00e7\u00e3o", indice, total, 2, 0);
                return 0;
            }
            catch (Exception e) {
                String nirf = id.getNirf().asString();
                GuiUtil.confirmaPaginado(MensagemUtil.getMensagem("110270", new String[]{UtilitariosString.formataNIRF((String)nirf)}), "Declara\u00e7\u00e3o", indice, total, 2, 0);
                return 0;
            }
            return 5;
        }

        public Receitanet getReceitaNet() {
            try {
                if (receitaNet == null) {
                    receitaNet = new ControleReceitanet();
                }
                return receitaNet;
            }
            catch (Exception e) {
                GuiUtil.mostrarErro("110145");
                return null;
            }
        }

        public int transmitir(final boolean certificado, final int indice, final int total) {
            if (this.getReceitaNet() == null) {
                return 3;
            }
            if (this.lastFileDec == null) {
                return 0;
            }
            Integer ret = (Integer)ProcessoSwing.executa((Tarefa)new Tarefa(){

                public Object run() {
                    File dec = lastFileDec;
                    StringBuffer msgBuffer = new StringBuffer();
                    int ret = 0;
                    try {
                        ret = this.getReceitaNet().enviarDeclaracao((Window)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), dec, certificado, msgBuffer);
                    }
                    catch (Exception e) {
                        ret = 1;
                        msgBuffer = new StringBuffer(e.getMessage());
                    }
                    if (ret == 0 || ret == 2) {
                        GuiUtil.informaPaginado(msgBuffer.toString(), "Declara\u00e7\u00e3o", indice, total, 1);
                        File fileRec = UtilitariosTXT.getRECCorrespondente(dec);
                        if (!dec.getParentFile().equals(ITRFacade.obterPastaPadraoGravadas()) && fileRec != null) {
                            UtilitariosArquivo.copiaArquivo((String)dec.toString(), (String)ITRFacade.obterPastaPadraoGravadas().getAbsolutePath());
                            UtilitariosArquivo.copiaArquivo((String)fileRec.toString(), (String)ITRFacade.obterPastaPadraoGravadas().getAbsolutePath());
                        }
                        if (fileRec != null) {
                            UtilitariosArquivo.copiaArquivo((String)dec.toString(), (String)ITRFacade.obterPastaPadraoTransmitidas().getAbsolutePath());
                            UtilitariosArquivo.copiaArquivo((String)fileRec.toString(), (String)ITRFacade.obterPastaPadraoTransmitidas().getAbsolutePath());
                        }
                    } else if (GuiUtil.confirmaPaginado(msgBuffer.toString(), "Declara\u00e7\u00e3o", indice, total, 2, 0) == 2) {
                        return new Integer(3);
                    }
                    return new Integer(0);
                }
            });
            return ret;
        }

        public int verificarPendencias(IdentificadorDeclaracao id, int indice, int total) {
            List pendencias = null;
            int qtdAvisos = 0;
            int qtdErros = 0;
            try {
                pendencias = ITRFacade.verificarPendencias(id.getNirf().asString());
                for (Pendencia pendencia : pendencias) {
                    if (pendencia.getSeveridade() == 2) {
                        ++qtdAvisos;
                    }
                    if (pendencia.getSeveridade() != 3 && pendencia.getSeveridade() != 5) continue;
                    ++qtdErros;
                }
                int retorno = 2;
                do {
                    if (qtdErros > 0) {
                        retorno = this.confirmarExibirPendencias(id, indice, total);
                    } else if (qtdAvisos > 0) {
                        retorno = this.confirmarGravar(id, indice, total);
                    }
                    if (retorno != 1) continue;
                    retorno = this.exibirPendencias(id);
                } while (retorno == 7);
                return retorno;
            }
            catch (Exception e) {
                GuiUtil.mostrarErro("110270", new String[]{id.getNirf().getConteudoFormatado()});
                return 0;
            }
        }

        public int exibirPendencias(IdentificadorDeclaracao id) throws RepositorioXMLException, HashInvalidoException {
            DeclaracaoITR dec = ITRFacade.obterDeclaracaoRepositorio(id.getNirf().naoFormatado());
            PainelVerificarPendenciasPopup painel = new PainelVerificarPendenciasPopup(FabricaUtilitarios.verificarPendencias((Object)((Object)dec)));
            painel.preExibir();
            if (dec != null) {
                GuiUtil.exibeDialog(painel, true, "Rela\u00e7\u00e3o de Pend\u00eancias", false);
            }
            switch (painel.getRetorno()) {
                case 1: {
                    return 7;
                }
                case 3: {
                    painel.imprimirPendencias(dec.getIdentificadorDeclaracao());
                    return 3;
                }
                case 2: {
                    ControladorGui.abrirDeclaracao(dec.getIdentificadorDeclaracao(), false);
                    painel.selecionaPendencia();
                }
            }
            return 3;
        }

        public int confirmarExibirPendencias(IdentificadorDeclaracao id, int indice, int total) {
            PainelConfirmarExibirPendencias painel = new PainelConfirmarExibirPendencias(id.getNirf().getConteudoFormatado(), id.getNomeImovel().getConteudoFormatado(), indice, total, UtilitariosString.insereQuebraDeLinha((String)MensagemUtil.getMensagem("110120"), (int)60, (String)"<br>"));
            GuiUtil.exibeDialog(painel, true, "Gravar Declara\u00e7\u00e3o para Entrega \u00e0 RFB", false);
            switch (painel.getRetorno()) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 3;
                }
            }
            return 0;
        }

        public int confirmarGravar(IdentificadorDeclaracao id, int indice, int total) {
            PainelConfirmarGravar painelConfirmarGravar = new PainelConfirmarGravar(id.getNirf().getConteudoFormatado(), id.getNomeImovel().getConteudoFormatado(), indice, total, UtilitariosString.insereQuebraDeLinha((String)MensagemUtil.getMensagem("110125"), (int)80, (String)"<br>"));
            GuiUtil.exibeDialog(painelConfirmarGravar, true, "Gravar Declara\u00e7\u00e3o para Entrega \u00e0 RFB", false);
            switch (painelConfirmarGravar.getRetorno()) {
                case 1: {
                    return 2;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 3;
                }
            }
            return 0;
        }

        public int confirmarTransmitir(IdentificadorDeclaracao id, File destino, int indice, int total) {
            PainelConfirmarTransmitir painel = new PainelConfirmarTransmitir(id.getNirf().getConteudoFormatado(), id.getNomeImovel().getConteudoFormatado(), indice, total, MensagemUtil.getMensagem("110105") + "<br>" + ITRUtil.compactarPathString(destino, 77, 37));
            GuiUtil.exibeDialog(painel, true, "Transmitir via Internet", false);
            switch (painel.getRetorno()) {
                case 4: {
                    if (painel.isCertificado()) {
                        return 6;
                    }
                    return 5;
                }
                case 3: {
                    return 3;
                }
            }
            return 0;
        }

        public int getQtdGravadas() {
            return this.qtdGravadas;
        }

        public File getLastFileDec() {
            return this.lastFileDec;
        }
    }
}

