/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.app.PlataformaITRPGD;
import serpro.ppgd.gui.xbeans.JEditLogico;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.gui.IdImovel;
import serpro.ppgd.itr.gui.ListaDecGravadaTableModel;
import serpro.ppgd.itr.gui.ListaDecRepositorioTableModel;
import serpro.ppgd.itr.gui.ListaDeclaracaoTableModel;
import serpro.ppgd.itr.gui.PainelBarraProgresso;
import serpro.ppgd.itr.gui.dialogs.PainelImprimirDarfQuota;
import serpro.ppgd.itr.gui.dialogs.PainelListaDeclaracao;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.gui.util.TarefaMonitorada;
import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.util.TabelaMensagens;

public class PainelImprimirDarf
extends JPanel {
    private static final String TITULO_IMPRIMIR = "Imprimir";
    public static final String HELP_ID = "Imprimir Darf de Imposto";
    public static final String TIPO_IMPRESSAO_VISUALIZAR = "visualizar";
    public static final String TIPO_IMPRESSAO_PDF = "pdf";
    public static final String TIPO_IMPRESSAO_IMPRIMIR = "imprimir";
    private TableRowSorter<ListaDeclaracaoTableModel> sorterPreenchimento;
    private TableRowSorter<ListaDecGravadaTableModel> sorterTransmitidas;
    private PainelBarraProgresso barraProgresso;
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    private JButton btnTodas;
    private JEditLogico edtTipoImpressao;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTextField jTextField1;
    private JTabbedPane tabbedPane;
    private PainelListaDeclaracao pnlListaDecPreenchimento;
    private PainelListaDeclaracao pnlListaDecTransmitidas;

    public PainelImprimirDarf() {
        this.initComponents();
        this.pnlListaDecPreenchimento.hideTransmitidas();
        PlataformaPPGD plataforma = PlataformaPPGD.getPlataforma();
        ((PlataformaITRPGD)plataforma).getHelpPDF().setHelpID(this, HELP_ID);
        ((PlataformaITRPGD)plataforma).getHelpPDF().setHelpID(this.btnAjuda, HELP_ID);
        Logico tipoImpressao = new Logico();
        tipoImpressao.addOpcao(TIPO_IMPRESSAO_VISUALIZAR, "Visualizar Impress\u00e3o     ");
        tipoImpressao.addOpcao(TIPO_IMPRESSAO_PDF, "Gerar PDF     ");
        tipoImpressao.addOpcao(TIPO_IMPRESSAO_IMPRIMIR, "Imprimir     ");
        tipoImpressao.setConteudo(TIPO_IMPRESSAO_VISUALIZAR);
        this.edtTipoImpressao.setInformacao((Informacao)tipoImpressao);
        this.edtTipoImpressao.setFont(this.edtTipoImpressao.getFont().deriveFont(1));
        this.edtTipoImpressao.setForeground(new Color(0, 0, 128));
        this.configurarAbas();
    }

    private void configurarAbas() {
        this.configurarAbaPreenchimento();
        this.configurarAbaTransmitidas();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PainelImprimirDarf.this.atualizarInterfaceParaAbaAtiva();
            }
        });
        this.tabbedPane.setSelectedIndex(0);
        this.atualizarInterfaceParaAbaAtiva();
    }

    private void configurarAbaPreenchimento() {
        ListaDecRepositorioTableModel listaDecRepositorioTableModel = new ListaDecRepositorioTableModel(ITRFacade.getListaIdDeclaracoes());
        listaDecRepositorioTableModel.filtrarModificados();
        this.sorterPreenchimento = new TableRowSorter<ListaDecRepositorioTableModel>(listaDecRepositorioTableModel);
        this.sorterPreenchimento.setComparator(0, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((IdImovel)o1).getNirf().compareTo(((IdImovel)o2).getNirf());
            }
        });
        RowSorter.SortKey sk = new RowSorter.SortKey(3, SortOrder.ASCENDING);
        ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
        keys.add(sk);
        this.sorterPreenchimento.setSortKeys(keys);
        this.pnlListaDecPreenchimento.getTblDeclaracao().setModel((TableModel)this.sorterPreenchimento.getModel());
        this.pnlListaDecPreenchimento.getTblDeclaracao().setRowSorter(this.sorterPreenchimento);
        this.configurarListenersTabela(this.pnlListaDecPreenchimento);
        if (this.pnlListaDecPreenchimento.getTblDeclaracao().getRowCount() > 0) {
            this.pnlListaDecPreenchimento.getTblDeclaracao().setRowSelectionInterval(0, 0);
        }
    }

    private void configurarAbaTransmitidas() {
        File origem = ITRFacade.obterPastaPadraoTransmitidas();
        File[] arqDecs = origem.listFiles(ITRFacade.obterNovoFileFilterArquivoDecUltimaTransmitida());
        ListaDecGravadaTableModel tbModel = new ListaDecGravadaTableModel(arqDecs);
        this.sorterTransmitidas = new TableRowSorter<ListaDecGravadaTableModel>(tbModel);
        this.sorterTransmitidas.setComparator(0, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((IdImovel)o1).getNirf().compareTo(((IdImovel)o2).getNirf());
            }
        });
        RowSorter.SortKey sk = new RowSorter.SortKey(3, SortOrder.ASCENDING);
        ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
        keys.add(sk);
        this.sorterTransmitidas.setSortKeys(keys);
        this.pnlListaDecTransmitidas.getTblDeclaracao().setModel((TableModel)this.sorterTransmitidas.getModel());
        this.pnlListaDecTransmitidas.getTblDeclaracao().setRowSorter(this.sorterTransmitidas);
        this.configurarListenersTabela(this.pnlListaDecTransmitidas);
        if (this.pnlListaDecTransmitidas.getTblDeclaracao().getRowCount() > 0) {
            this.pnlListaDecTransmitidas.getTblDeclaracao().setRowSelectionInterval(0, 0);
        }
    }

    private void configurarListenersTabela(final PainelListaDeclaracao painel) {
        painel.getTblDeclaracao().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int rowCount = painel.getTblDeclaracao().getSelectedRowCount();
                if (rowCount > 0) {
                    PainelImprimirDarf.this.btnOk.setEnabled(true);
                    if (rowCount > 1) {
                        PainelImprimirDarf.this.edtTipoImpressao.getInformacao().setConteudo(PainelImprimirDarf.TIPO_IMPRESSAO_IMPRIMIR);
                        PainelImprimirDarf.this.edtTipoImpressao.getInformacao().setHabilitado(false);
                    } else {
                        PainelImprimirDarf.this.edtTipoImpressao.getInformacao().setHabilitado(true);
                    }
                } else {
                    PainelImprimirDarf.this.btnOk.setEnabled(false);
                }
            }
        });
        painel.getTblDeclaracao().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && painel.getTblDeclaracao().getSelectedRowCount() > 0) {
                    PainelImprimirDarf.this.btnOkActionPerformed(null);
                }
            }
        });
    }

    private void atualizarInterfaceParaAbaAtiva() {
        int rowCount;
        PainelListaDeclaracao painelAtivo = this.getPainelListaAtivo();
        if (painelAtivo.getTblDeclaracao().getRowCount() > 0) {
            this.btnTodas.setEnabled(true);
            if (painelAtivo.getTblDeclaracao().getSelectedRowCount() == 0) {
                painelAtivo.getTblDeclaracao().setRowSelectionInterval(0, 0);
            }
        } else {
            this.btnTodas.setEnabled(false);
        }
        this.btnOk.setEnabled((rowCount = painelAtivo.getTblDeclaracao().getSelectedRowCount()) > 0);
        if (rowCount > 1) {
            this.edtTipoImpressao.getInformacao().setConteudo(TIPO_IMPRESSAO_IMPRIMIR);
            this.edtTipoImpressao.getInformacao().setHabilitado(false);
        } else {
            this.edtTipoImpressao.getInformacao().setHabilitado(true);
        }
    }

    private PainelListaDeclaracao getPainelListaAtivo() {
        int selectedTab = this.tabbedPane.getSelectedIndex();
        if (selectedTab == 0) {
            return this.pnlListaDecTransmitidas;
        }
        return this.pnlListaDecPreenchimento;
    }

    public PainelImprimirDarf(IdentificadorDeclaracao idDec, boolean tabelaSelecionavel) {
        this();
        this.tabbedPane.setSelectedIndex(1);
        ListaDecRepositorioTableModel model = (ListaDecRepositorioTableModel)this.pnlListaDecPreenchimento.getTblDeclaracao().getModel();
        int index = model.getIds().indexOf(idDec);
        int selected = this.pnlListaDecPreenchimento.getTblDeclaracao().convertRowIndexToView(index);
        this.pnlListaDecPreenchimento.getTblDeclaracao().setRowSelectionInterval(selected, selected);
        this.pnlListaDecPreenchimento.getTblDeclaracao().setEnabled(tabelaSelecionavel);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.btnTodas = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.btnOk = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.pnlListaDecPreenchimento = new PainelListaDeclaracao();
        this.pnlListaDecTransmitidas = new PainelListaDeclaracao();
        this.jPanel3 = new JPanel();
        this.edtTipoImpressao = new JEditLogico();
        this.jPanel4 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jTextField1 = new JTextField();
        this.setBackground(new Color(240, 245, 240));
        this.setForeground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(240, 245, 240));
        this.jPanel1.setForeground(new Color(255, 255, 255));
        this.btnTodas.setMnemonic('S');
        this.btnTodas.setText("Selecionar Todas");
        this.btnTodas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirDarf.this.btnTodasActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirDarf.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.setToolTipText("Imprimir Darf");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirDarf.this.btnOkActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.btnTodas).addPreferredGap(0, 521, Short.MAX_VALUE).add((Component)this.btnOk).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.btnCancelar).add((Component)this.btnAjuda).add((Component)this.btnTodas).add((Component)this.btnOk)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk, this.btnTodas}, 2);
        this.jPanel2.setBackground(new Color(240, 245, 240));
        this.jPanel2.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(30, 105, 140));
        this.jLabel1.setText("Selecione uma ou mais declara\u00e7\u00f5es na lista abaixo ou pressione o bot\u00e3o \"Selecionar Todas\":");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addContainerGap(372, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel1, -1, 27, Short.MAX_VALUE));
        this.jPanel3.setBackground(new Color(240, 245, 240));
        this.jPanel3.setForeground(new Color(255, 255, 255));
        this.edtTipoImpressao.setOrientacaoTexto(2);
        this.edtTipoImpressao.setCursor(new Cursor(0));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.edtTipoImpressao, -1, 933, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.edtTipoImpressao, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBackground(new Color(240, 245, 240));
        this.jPanel4.setForeground(new Color(255, 255, 255));
        this.jPanel4.setPreferredSize(new Dimension(215, 25));
        this.jLabel5.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel5.setForeground(new Color(30, 105, 140));
        this.jLabel5.setText("Nome do Contribuinte:");
        this.jLabel5.setMaximumSize(new Dimension(73, 25));
        this.jLabel5.setMinimumSize(new Dimension(73, 25));
        this.jLabel5.setPreferredSize(new Dimension(73, 25));
        this.jTextField1.setPreferredSize(new Dimension(73, 25));
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirDarf.this.jTextField1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel5, -2, 132, -2).add(4, 4, 4).add((Component)this.jTextField1, -2, 437, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jTextField1, -2, -1, -2).add((Component)this.jLabel5, -2, -1, -2)));
        this.tabbedPane.addTab("Transmitidas", GuiUtil.getImage("/icones/png16px/AB_transmitido.png"), this.pnlListaDecTransmitidas);
        this.tabbedPane.addTab("Em preenchimento", GuiUtil.getImage("/icones/png16px/Icon_barraTitulo_16px.png"), this.pnlListaDecPreenchimento);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.tabbedPane, -1, 957, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.tabbedPane, -2, 320, -2).addPreferredGap(0).add((Component)this.jPanel3, -2, 42, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).dispatchEvent(new WindowEvent((Window)SwingUtilities.getRoot(this), 201));
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        final PainelListaDeclaracao painelAtivo = this.getPainelListaAtivo();
        if (painelAtivo.getTblDeclaracao().getSelectedRowCount() > 0) {
            ((JDialog)SwingUtilities.getRoot(this)).dispatchEvent(new WindowEvent((Window)SwingUtilities.getRoot(this), 201));
            TarefaMonitorada tarefa = new TarefaMonitorada(){

                @Override
                public Object doInBackGround() {
                    int[] selecteds = painelAtivo.getTblDeclaracao().getSelectedRows();
                    this.setMax(selecteds.length);
                    this.setProgress(0);
                    int progresso = 0;
                    for (int i = 0; i < selecteds.length && !this.cancelado(); ++i) {
                        progresso = i + 1;
                        this.setNota(progresso + " de " + selecteds.length);
                        this.setProgress(progresso);
                        int index = painelAtivo.getTblDeclaracao().convertRowIndexToModel(selecteds[i]);
                        try {
                            PainelImprimirDarfQuota painelQuotas;
                            Integer[] quotas;
                            int qdtQuotas;
                            ListaDeclaracaoTableModel model;
                            if (PainelImprimirDarf.this.tabbedPane.getSelectedIndex() == 0) {
                                model = (ListaDecGravadaTableModel)painelAtivo.getTblDeclaracao().getModel();
                                File arqDec = ((ListaDecGravadaTableModel)model).getDecFiles()[index];
                                IdImovel idImovel = ITRFacade.obterIdImovelDecGravada(arqDec);
                                String cibFormatado = ITRUtil.formatarIdentificacaoImovel(idImovel.getNirf());
                                DeclaracaoITR dec = ITRFacade.getDeclaracao(idImovel.getNirf());
                                qdtQuotas = dec.getCalculoImposto().getQtdCotas().getConteudo().intValue();
                                quotas = null;
                                if (qdtQuotas > 1) {
                                    painelQuotas = new PainelImprimirDarfQuota(qdtQuotas);
                                    GuiUtil.exibeDialog(painelQuotas, true, "Imprimir Darf - CIB: " + cibFormatado, false);
                                    quotas = painelQuotas.getQuotas();
                                } else {
                                    quotas = new Integer[]{new Integer(0)};
                                }
                                if (quotas.length <= 0) continue;
                                if (PainelImprimirDarf.this.edtTipoImpressao.getInformacao().getConteudoFormatado().equals(PainelImprimirDarf.TIPO_IMPRESSAO_IMPRIMIR)) {
                                    ITRFacade.imprimirDarfDecTrasmitida(arqDec, quotas).imprimir();
                                    continue;
                                }
                                if (PainelImprimirDarf.this.edtTipoImpressao.getInformacao().getConteudoFormatado().equals(PainelImprimirDarf.TIPO_IMPRESSAO_VISUALIZAR)) {
                                    ITRFacade.imprimirDarfDecTrasmitida(arqDec, quotas).visualizar();
                                    continue;
                                }
                                if (!PainelImprimirDarf.this.edtTipoImpressao.getInformacao().getConteudoFormatado().equals(PainelImprimirDarf.TIPO_IMPRESSAO_PDF)) continue;
                                ITRFacade.imprimirDarfDecTrasmitida(arqDec, quotas).gerarPDF();
                                continue;
                            }
                            model = (ListaDecRepositorioTableModel)painelAtivo.getTblDeclaracao().getModel();
                            IdentificadorDeclaracao id = (IdentificadorDeclaracao)((ListaDecRepositorioTableModel)model).getIds().get(index);
                            DeclaracaoITR dec = ITRFacade.obterDeclaracaoRepositorio(id.getNirf().asString());
                            boolean imune = dec.getImovel().getIsento().getConteudoFormatado().equals(Logico.SIM);
                            String cibFormatado = ITRUtil.formatarIdentificacaoImovel(id.getNirf().naoFormatado());
                            if (imune) {
                                GuiUtil.informa(TabelaMensagens.getTabelaMensagens().msg("800185", new String[]{cibFormatado}), PainelImprimirDarf.TITULO_IMPRIMIR, 1);
                                continue;
                            }
                            dec.getContribuinte().getNi().validar();
                            if (!dec.getContribuinte().getNi().isValido()) {
                                GuiUtil.informa(TabelaMensagens.getTabelaMensagens().msg("110340", new String[]{cibFormatado}), PainelImprimirDarf.TITULO_IMPRIMIR, 1);
                                continue;
                            }
                            if (dec.getCalculoImposto().getValorTotalImovel().isVazio()) {
                                GuiUtil.informa(TabelaMensagens.getTabelaMensagens().msg("110340", new String[]{cibFormatado}), PainelImprimirDarf.TITULO_IMPRIMIR, 1);
                                continue;
                            }
                            qdtQuotas = dec.getCalculoImposto().getQtdCotas().getConteudo().intValue();
                            quotas = null;
                            if (qdtQuotas > 1) {
                                painelQuotas = new PainelImprimirDarfQuota(qdtQuotas);
                                GuiUtil.exibeDialog(painelQuotas, true, "Imprimir Darf - CIB: " + cibFormatado, false);
                                quotas = painelQuotas.getQuotas();
                            } else {
                                quotas = new Integer[]{new Integer(0)};
                            }
                            if (quotas.length <= 0) continue;
                            if (PainelImprimirDarf.this.edtTipoImpressao.getInformacao().getConteudoFormatado().equals(PainelImprimirDarf.TIPO_IMPRESSAO_IMPRIMIR)) {
                                ITRFacade.imprimirDarfDecPreenchimento(dec, quotas).imprimir();
                                continue;
                            }
                            if (PainelImprimirDarf.this.edtTipoImpressao.getInformacao().getConteudoFormatado().equals(PainelImprimirDarf.TIPO_IMPRESSAO_VISUALIZAR)) {
                                ITRFacade.imprimirDarfDecPreenchimento(dec, quotas).visualizar();
                                continue;
                            }
                            if (!PainelImprimirDarf.this.edtTipoImpressao.getInformacao().getConteudoFormatado().equals(PainelImprimirDarf.TIPO_IMPRESSAO_PDF)) continue;
                            ITRFacade.imprimirDarfDecPreenchimento(dec, quotas).gerarPDF();
                            continue;
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                    this.fechar();
                    return null;
                }
            };
            if (ITRFacade.getDeclaracaoAberta() == null) {
                ITRFacade.limparRepositorioXML();
                ITRFacade.setDeclaracaoEmMemoria(null);
            }
            this.barraProgresso = new PainelBarraProgresso("Imprimindo Darf de Imposto", tarefa);
            this.barraProgresso.exibir();
            this.barraProgresso = null;
        }
    }

    private void btnTodasActionPerformed(ActionEvent evt) {
        this.getPainelListaAtivo().getTblDeclaracao().selectAll();
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
    }
}

