/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.app.PlataformaITRPGD;
import serpro.ppgd.gui.xbeans.JEditLogico;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.gui.IdImovel;
import serpro.ppgd.itr.gui.ListaDecGravadaTableModel;
import serpro.ppgd.itr.gui.PainelBarraProgresso;
import serpro.ppgd.itr.gui.dialogs.PainelListaDeclaracao;
import serpro.ppgd.itr.gui.dialogs.PainelLocalizadorPasta;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.gui.util.TarefaMonitorada;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.repositorio.RepositorioException;

public class PainelImprimirRecibo
extends JPanel {
    public static final String TIPO_IMPRESSAO_VISUALIZAR = "visualizar";
    public static final String TIPO_IMPRESSAO_PDF = "pdf";
    public static final String TIPO_IMPRESSAO_IMPRIMIR = "imprimir";
    public static final String HELP_ID = "Imprimir Recibo de Entrega";
    private TableRowSorter<ListaDecGravadaTableModel> sorter;
    private PainelBarraProgresso barraProgresso;
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    private JButton btnTodas;
    private JEditLogico edtTipoImpressao;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private PainelListaDeclaracao painelListaDeclaracao1;
    private PainelListaDeclaracao pnlListaDec;
    private PainelLocalizadorPasta pnlLocalizadorPasta;

    public PainelImprimirRecibo() {
        this.initComponents();
        PlataformaPPGD plataforma = PlataformaPPGD.getPlataforma();
        ((PlataformaITRPGD)plataforma).getHelpPDF().setHelpID(this, HELP_ID);
        ((PlataformaITRPGD)plataforma).getHelpPDF().setHelpID(this.btnAjuda, HELP_ID);
        this.pnlLocalizadorPasta.setTitulo("Selecionar a unidade para impress\u00e3o de recibo");
        this.pnlLocalizadorPasta.setBtnSelecionarTooltip("Selecionar o Recibo para a Impress\u00e3o");
        this.pnlLocalizadorPasta.setPasta(ITRFacade.obterPastaPadraoTransmitidas());
        Logico tipoImpressao = new Logico();
        tipoImpressao.addOpcao(TIPO_IMPRESSAO_VISUALIZAR, "Visualizar Impress\u00e3o     ");
        tipoImpressao.addOpcao(TIPO_IMPRESSAO_PDF, "Gerar PDF     ");
        tipoImpressao.addOpcao(TIPO_IMPRESSAO_IMPRIMIR, "Imprimir     ");
        tipoImpressao.setConteudo(TIPO_IMPRESSAO_VISUALIZAR);
        this.edtTipoImpressao.setInformacao((Informacao)tipoImpressao);
        this.edtTipoImpressao.setFont(this.edtTipoImpressao.getFont().deriveFont(1));
        this.edtTipoImpressao.setForeground(new Color(0, 0, 128));
        this.pnlLocalizadorPasta.getTextoPasta().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ListaDecGravadaTableModel model = (ListaDecGravadaTableModel)PainelImprimirRecibo.this.pnlListaDec.getTblDeclaracao().getModel();
                model.setDecFiles(PainelImprimirRecibo.this.pnlLocalizadorPasta.getPasta().listFiles(ITRFacade.obterNovoFileFilterArquivoDecUltimaTransmitida()));
            }
        });
        File origem = this.pnlLocalizadorPasta.getPasta();
        File[] arqDecs = origem.listFiles(ITRFacade.obterNovoFileFilterArquivoDecUltimaTransmitida());
        ListaDecGravadaTableModel tbModel = new ListaDecGravadaTableModel(arqDecs);
        this.sorter = new TableRowSorter<ListaDecGravadaTableModel>(tbModel);
        this.sorter.setComparator(0, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((IdImovel)o1).getNirf().compareTo(((IdImovel)o2).getNirf());
            }
        });
        RowSorter.SortKey sk = new RowSorter.SortKey(3, SortOrder.ASCENDING);
        ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
        keys.add(sk);
        this.sorter.setSortKeys(keys);
        this.pnlListaDec.getTblDeclaracao().setModel((TableModel)this.sorter.getModel());
        this.pnlListaDec.getTblDeclaracao().setRowSorter(this.sorter);
        this.pnlListaDec.getTblDeclaracao().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int rowCount = PainelImprimirRecibo.this.pnlListaDec.getTblDeclaracao().getSelectedRowCount();
                if (rowCount > 0) {
                    PainelImprimirRecibo.this.btnOk.setEnabled(true);
                    if (rowCount > 1) {
                        PainelImprimirRecibo.this.edtTipoImpressao.getInformacao().setConteudo(PainelImprimirRecibo.TIPO_IMPRESSAO_IMPRIMIR);
                        PainelImprimirRecibo.this.edtTipoImpressao.getInformacao().setHabilitado(false);
                    } else {
                        PainelImprimirRecibo.this.edtTipoImpressao.getInformacao().setHabilitado(true);
                    }
                } else {
                    PainelImprimirRecibo.this.btnOk.setEnabled(false);
                }
            }
        });
        this.pnlListaDec.getTblDeclaracao().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelImprimirRecibo.this.pnlListaDec.getTblDeclaracao().getSelectedRowCount() > 0) {
                    PainelImprimirRecibo.this.btnOkActionPerformed(null);
                }
            }
        });
        if (this.pnlListaDec.getTblDeclaracao().getRowCount() > 0) {
            this.pnlListaDec.getTblDeclaracao().setRowSelectionInterval(0, 0);
            this.btnTodas.setEnabled(true);
        } else {
            this.btnTodas.setEnabled(false);
        }
    }

    private void initComponents() {
        this.painelListaDeclaracao1 = new PainelListaDeclaracao();
        this.jPanel1 = new JPanel();
        this.btnTodas = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.btnOk = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.pnlListaDec = new PainelListaDeclaracao();
        this.jPanel3 = new JPanel();
        this.edtTipoImpressao = new JEditLogico();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.pnlLocalizadorPasta = new PainelLocalizadorPasta();
        this.setBackground(new Color(240, 245, 240));
        this.setForeground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(240, 245, 240));
        this.jPanel1.setForeground(new Color(255, 255, 255));
        this.btnTodas.setMnemonic('S');
        this.btnTodas.setText("Selecionar Todas");
        this.btnTodas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirRecibo.this.btnTodasActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirRecibo.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirRecibo.this.btnOkActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.btnTodas).addPreferredGap(0, 496, Short.MAX_VALUE).add((Component)this.btnOk).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.btnCancelar).add((Component)this.btnAjuda).add((Component)this.btnTodas).add((Component)this.btnOk)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk, this.btnTodas}, 2);
        this.jPanel2.setBackground(new Color(240, 245, 240));
        this.jPanel2.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(30, 105, 140));
        this.jLabel1.setText("Selecione uma ou mais declara\u00e7\u00f5es na lista abaixo ou pressione o bot\u00e3o \"Selecionar Todas\":");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addContainerGap(347, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel1, -1, 27, Short.MAX_VALUE));
        this.jPanel3.setBackground(new Color(240, 245, 240));
        this.jPanel3.setForeground(new Color(255, 255, 255));
        this.edtTipoImpressao.setOrientacaoTexto(2);
        this.edtTipoImpressao.setCursor(new Cursor(0));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.edtTipoImpressao, -1, 908, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(0, 0, 0).add((Component)this.edtTipoImpressao, -2, -1, -2)));
        this.jPanel4.setBackground(new Color(240, 245, 240));
        this.jPanel4.setForeground(new Color(255, 255, 255));
        this.jLabel2.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel2.setForeground(new Color(30, 105, 140));
        this.jLabel2.setText("Selecione a pasta contendo declara\u00e7\u00f5es transmitidas para impress\u00e3o do recibo:");
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).addContainerGap(427, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jLabel2));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.pnlListaDec, -1, 932, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.pnlLocalizadorPasta, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel4, -2, -1, -2).addPreferredGap(0).add((Component)this.pnlLocalizadorPasta, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.pnlListaDec, -2, 303, -2).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).dispatchEvent(new WindowEvent((Window)SwingUtilities.getRoot(this), 201));
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.pnlListaDec.getTblDeclaracao().getSelectedRowCount() > 0) {
            ((JDialog)SwingUtilities.getRoot(this)).dispatchEvent(new WindowEvent((Window)SwingUtilities.getRoot(this), 201));
            TarefaMonitorada tarefa = new TarefaMonitorada(){

                @Override
                public Object doInBackGround() {
                    int[] selecteds = PainelImprimirRecibo.this.pnlListaDec.getTblDeclaracao().getSelectedRows();
                    this.setMax(selecteds.length);
                    this.setProgress(0);
                    int progresso = 0;
                    ListaDecGravadaTableModel model = (ListaDecGravadaTableModel)PainelImprimirRecibo.this.pnlListaDec.getTblDeclaracao().getModel();
                    for (int i = 0; i < selecteds.length && !this.cancelado(); ++i) {
                        progresso = i + 1;
                        this.setNota(progresso + " de " + selecteds.length);
                        this.setProgress(progresso);
                        int index = PainelImprimirRecibo.this.pnlListaDec.getTblDeclaracao().convertRowIndexToModel(selecteds[i]);
                        File arqDec = model.getDecFiles()[index];
                        try {
                            if (PainelImprimirRecibo.this.edtTipoImpressao.getInformacao().getConteudoFormatado().equals(PainelImprimirRecibo.TIPO_IMPRESSAO_VISUALIZAR)) {
                                ITRFacade.imprimirRecibo(arqDec).visualizar();
                                continue;
                            }
                            if (PainelImprimirRecibo.this.edtTipoImpressao.getInformacao().getConteudoFormatado().equals(PainelImprimirRecibo.TIPO_IMPRESSAO_PDF)) {
                                ITRFacade.imprimirRecibo(arqDec).gerarPDF();
                                continue;
                            }
                            if (!PainelImprimirRecibo.this.edtTipoImpressao.getInformacao().getConteudoFormatado().equals(PainelImprimirRecibo.TIPO_IMPRESSAO_IMPRIMIR)) continue;
                            ITRFacade.imprimirRecibo(arqDec).imprimir();
                            continue;
                        }
                        catch (RepositorioException e) {
                            int ret = GuiUtil.confirmaPaginado(e.getMessage(), "Imprimir Recibo", i + 1, selecteds.length, 2, 0);
                            if (ret != 2) continue;
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                    this.fechar();
                    return null;
                }
            };
            if (ITRFacade.getDeclaracaoAberta() == null) {
                ITRFacade.limparRepositorioXML();
                ITRFacade.setDeclaracaoEmMemoria(null);
            }
            this.barraProgresso = new PainelBarraProgresso("Imprimindo Recibo", tarefa);
            this.barraProgresso.exibir();
            this.barraProgresso = null;
        }
    }

    private void btnTodasActionPerformed(ActionEvent evt) {
        this.pnlListaDec.getTblDeclaracao().selectAll();
    }
}

