/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import serpro.ppgd.gui.UtilitariosGUI;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.negocio.Alfa;

public class PainelLocalizadorPasta
extends JPanel {
    private File pasta;
    private Alfa textoPasta;
    private String titulo;
    private String btnSelecionarTooltip;
    private JButton btnProcurar;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField txtPasta;

    public PainelLocalizadorPasta() {
        this.initComponents();
        this.textoPasta = new Alfa();
        this.setPasta(ITRFacade.obterPastaPadraoGravadas());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.txtPasta = new JTextField();
        this.jPanel2 = new JPanel();
        this.btnProcurar = new JButton();
        this.setBackground(new Color(240, 245, 240));
        this.setForeground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
        this.jPanel1.setBackground(new Color(240, 245, 240));
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.jPanel1.setForeground(new Color(255, 255, 255));
        this.jPanel1.setLayout(new BorderLayout());
        this.txtPasta.setEditable(false);
        this.txtPasta.setFont(new Font("Arial", 0, 11));
        this.txtPasta.setEnabled(false);
        this.jPanel1.add((Component)this.txtPasta, "Center");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setBackground(new Color(240, 245, 240));
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.jPanel2.setForeground(new Color(255, 255, 255));
        this.jPanel2.setLayout(new BorderLayout());
        this.btnProcurar.setMnemonic('P');
        this.btnProcurar.setText("Procurar...");
        this.btnProcurar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelLocalizadorPasta.this.btnProcurarActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.btnProcurar, "Center");
        this.add((Component)this.jPanel2, "East");
    }

    private void btnProcurarActionPerformed(ActionEvent evt) {
        if (System.getProperty("os.name").startsWith("Mac")) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            FileDialog fd = new FileDialog((Frame)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "Selecionar", 0);
            fd.setModal(true);
            fd.setDirectory(this.getPasta().getAbsolutePath());
            fd.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            if (fd.getFile() != null) {
                this.setPasta(new File(fd.getDirectory(), fd.getFile()));
            }
        } else {
            JFileChooser fc = UtilitariosGUI.setFileChooserProperties((String)this.getTitulo(), (String)"Selecionar", (String)"Selecionar", (String)this.getBtnSelecionarTooltip());
            fc.setApproveButtonText("Selecionar");
            fc.setMultiSelectionEnabled(false);
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileSelectionMode(1);
            fc.setCurrentDirectory(this.getPasta());
            int retorno = fc.showOpenDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal());
            if (retorno == 0) {
                this.setPasta(fc.getSelectedFile());
            }
        }
    }

    public File getPasta() {
        return this.pasta;
    }

    public void setPasta(File f) {
        String caminho = f.getPath();
        if (f.listFiles() != null) {
            this.pasta = f;
            if (System.getProperty("os.name").startsWith("Windows")) {
                caminho = caminho.replaceFirst("/", "");
            }
            this.textoPasta.setConteudo(caminho);
            this.txtPasta.setText(caminho);
        } else {
            GuiUtil.mostrarAviso("Pasta " + caminho + " n\u00e3o dispon\u00edvel!");
        }
    }

    public Alfa getTextoPasta() {
        return this.textoPasta;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public String getBtnSelecionarTooltip() {
        return this.btnSelecionarTooltip;
    }

    public void setBtnSelecionarTooltip(String btnSelecionarTooltip) {
        this.btnSelecionarTooltip = btnSelecionarTooltip;
    }
}

