/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.app.PlataformaITRPGD;
import serpro.ppgd.gui.xbeans.JEditNirf;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.PainelDeclaracaoAb;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NIRF;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class PainelNovaDeclaracao
extends PainelDeclaracaoAb {
    private static final long serialVersionUID = 2126797944595121174L;
    IdentificadorDeclaracao idDec;
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    private JEditNirf edtNirf;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public PainelNovaDeclaracao() {
        this.initComponents();
        this.idDec = new IdentificadorDeclaracao();
        this.edtNirf.setCaracteresValidos(ITRUtil.obterCaracteresValidosIdentificacaoImovel());
        this.edtNirf.setInformacao((Informacao)this.idDec.getNirf());
        this.edtNirf.setMascara(ITRUtil.obterMascaraIdentificacaoImovel(this.edtNirf.getInformacao().naoFormatado()));
        this.inibirEnterNavegacaoFocoBotoes();
        PlataformaPPGD plataforma = PlataformaPPGD.getPlataforma();
        ((PlataformaITRPGD)plataforma).getHelpPDF().setHelpID(this, "Criar uma Nova Declara\u00e7\u00e3o");
        ((PlataformaITRPGD)plataforma).getHelpPDF().setHelpID(this.btnAjuda, "Criar uma Nova Declara\u00e7\u00e3o");
        if (FabricaUtilitarios.isMac()) {
            this.edtNirf.getComponenteEditor().grabFocus();
        }
        ((JTextField)this.edtNirf.getComponenteFoco()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PainelNovaDeclaracao.this.btnOkActionPerformed(e);
            }
        });
    }

    @Override
    public void preExibir() {
    }

    private void inibirEnterNavegacaoFocoBotoes() {
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(9, 0));
        this.btnOk.setFocusTraversalKeys(0, set);
        this.btnCancelar.setFocusTraversalKeys(0, set);
        this.btnAjuda.setFocusTraversalKeys(0, set);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.edtNirf = new JEditNirf();
        this.jLabel1 = new JLabel();
        this.setBackground(new Color(240, 245, 240));
        this.setMinimumSize(new Dimension(250, 65));
        this.jPanel1.setBackground(new Color(240, 245, 240));
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelNovaDeclaracao.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelNovaDeclaracao.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('j');
        this.btnAjuda.setText("Ajuda");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.btnOk, -2, 110, -2).add(5, 5, 5).add((Component)this.btnCancelar, -2, 110, -2).add(5, 5, 5).add((Component)this.btnAjuda, -2, 110, -2)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.btnOk).add((Component)this.btnCancelar).add((Component)this.btnAjuda));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jLabel2.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.jLabel2.setForeground(new Color(30, 105, 140));
        this.jLabel2.setHorizontalAlignment(2);
        this.jLabel2.setText("CIB ");
        this.edtNirf.setPreferredSize(new Dimension(95, 21));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(120, 120, 120).add((Component)this.jLabel2).add(5, 5, 5).add((Component)this.edtNirf, -2, 110, -2).addContainerGap(120, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(3, 3, 3).add((Component)this.jLabel2)).add((Component)this.edtNirf, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel1.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.jLabel1.setForeground(new Color(30, 105, 140));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Informe a identifica\u00e7\u00e3o do Im\u00f3vel na Receita Federal");
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jPanel1, -2, -1, -2).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(59, 59, 59).add((Component)this.jLabel1)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -2, 17, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addContainerGap()));
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        NIRF nirf = this.idDec.getNirf();
        nirf.setConteudo(nirf.naoFormatado().toUpperCase());
        this.idDec.setNirf(nirf);
        this.edtNirf.setMascara(ITRUtil.obterMascaraIdentificacaoImovel(this.idDec.getNirf().naoFormatado()));
        if (this.idDec.getNirf().isVazio()) {
            this.mostrarErro("300045");
            return;
        }
        if (!ITRUtil.isNumeroImovelValido(this.idDec.getNirf().naoFormatado())) {
            this.mostrarErro("300050");
            return;
        }
        if (ITRFacade.existeDeclaracao(this.idDec.getNirf().naoFormatado())) {
            if (!GuiUtil.mostrarConfirma("900135", new String[]{this.idDec.getNirf().formatado()})) {
                this.edtNirf.setaFoco(false);
                return;
            }
        } else {
            ITRFacade.criarDeclaracao(this.idDec);
        }
        this.edtNirf.setarCampo();
        ((JDialog)SwingUtilities.getRoot(this)).dispatchEvent(new WindowEvent((Window)SwingUtilities.getRoot(this), 201));
        try {
            ControladorGui.abrirDeclaracao(this.idDec, true);
        }
        catch (HashInvalidoException e) {
            ControladorGui.tratarException((Exception)((Object)e));
        }
    }

    private void mostrarErro(String codigo) {
        GuiUtil.mostrarErro(codigo);
        this.edtNirf.setaFoco(false);
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).dispatchEvent(new WindowEvent((Window)SwingUtilities.getRoot(this), 201));
    }
}

