/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.ProcessoSwing;
import serpro.ppgd.infraestrutura.util.Tarefa;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.gui.IdImovel;
import serpro.ppgd.itr.gui.ListaDecGravadaTableModel;
import serpro.ppgd.itr.gui.TableSorter;
import serpro.ppgd.itr.gui.dialogs.PainelListaDeclaracao;
import serpro.ppgd.itr.gui.dialogs.PainelLocalizadorPasta;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.txt.UtilitariosTXT;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.receitanet.ControleReceitanet;
import serpro.receitanet.Receitanet;

public class PainelTransmitirDeclaracao
extends JPanel {
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    private JButton btnTodas;
    private JCheckBox chkCertificado;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private PainelListaDeclaracao pnlListaDec;
    private PainelLocalizadorPasta pnlLocalizadorPasta;

    public PainelTransmitirDeclaracao() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Menu_Declaracao_Transmitir_pela_Internet");
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, "Menu_Declaracao_Transmitir_pela_Internet");
        this.pnlLocalizadorPasta.setTitulo("Selecionar pasta para transmiss\u00e3o de declara\u00e7\u00e3o ITR " + ConstantesGlobais.EXERCICIO);
        this.pnlLocalizadorPasta.getTextoPasta().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ListaDecGravadaTableModel model = (ListaDecGravadaTableModel)((TableSorter)PainelTransmitirDeclaracao.this.pnlListaDec.getTblDeclaracao().getModel()).getTableModel();
                model.setDecFiles(PainelTransmitirDeclaracao.this.pnlLocalizadorPasta.getPasta().listFiles(ITRFacade.obterNovoFileFilterArquivoDec()));
            }
        });
        File origem = this.pnlLocalizadorPasta.getPasta();
        File[] arqDecs = origem.listFiles(ITRFacade.obterNovoFileFilterArquivoDec());
        ListaDecGravadaTableModel tbModel = new ListaDecGravadaTableModel(arqDecs);
        TableSorter sorter = new TableSorter(tbModel, this.pnlListaDec.getTblDeclaracao().getTableHeader());
        sorter.setColumnComparator(String.class, TableSorter.LEXICAL_COMPARATOR);
        sorter.setColumnComparator(IdImovel.class, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((IdImovel)o1).getNirf().compareTo(((IdImovel)o2).getNirf());
            }
        });
        this.pnlListaDec.getTblDeclaracao().setModel(sorter);
        this.pnlListaDec.getTblDeclaracao().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelTransmitirDeclaracao.this.pnlListaDec.getTblDeclaracao().getSelectedRowCount() > 0) {
                    PainelTransmitirDeclaracao.this.btnOk.setEnabled(true);
                } else {
                    PainelTransmitirDeclaracao.this.btnOk.setEnabled(false);
                }
            }
        });
        this.pnlListaDec.getTblDeclaracao().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelTransmitirDeclaracao.this.pnlListaDec.getTblDeclaracao().getSelectedRowCount() > 0) {
                    PainelTransmitirDeclaracao.this.btnOkActionPerformed(null);
                }
            }
        });
        if (this.pnlListaDec.getTblDeclaracao().getRowCount() > 0) {
            this.pnlListaDec.getTblDeclaracao().setRowSelectionInterval(0, 0);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.btnTodas = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.pnlListaDec = new PainelListaDeclaracao();
        this.pnlLocalizadorPasta = new PainelLocalizadorPasta();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.chkCertificado = new JCheckBox();
        this.setBackground(new Color(240, 245, 240));
        this.jPanel1.setBackground(new Color(240, 245, 240));
        this.btnOk.setMnemonic('T');
        this.btnOk.setText("Transmitir");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelTransmitirDeclaracao.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelTransmitirDeclaracao.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.btnAjuda.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelTransmitirDeclaracao.this.btnAjudaActionPerformed(evt);
            }
        });
        this.btnTodas.setMnemonic('S');
        this.btnTodas.setText("Selecionar Todas");
        this.btnTodas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelTransmitirDeclaracao.this.btnTodasActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.btnTodas).addPreferredGap(0, 325, Short.MAX_VALUE).add((Component)this.btnOk).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.btnCancelar).add((Component)this.btnAjuda).add((Component)this.btnTodas).add((Component)this.btnOk)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk, this.btnTodas}, 2);
        this.jPanel2.setBackground(new Color(240, 245, 240));
        this.jLabel1.setFont(new Font("Arial", 0, 11));
        this.jLabel1.setForeground(new Color(30, 105, 140));
        this.jLabel1.setText("Selecione uma ou mais declara\u00e7\u00f5es na lista abaixo ou pressione o bot\u00e3o \"Selecionar Todas\":");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addContainerGap(250, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel1));
        this.jPanel3.setBackground(new Color(240, 245, 240));
        this.jLabel2.setFont(new Font("Arial", 0, 11));
        this.jLabel2.setForeground(new Color(30, 105, 140));
        this.jLabel2.setText("Selecione a pasta contendo declara\u00e7\u00f5es gravadas para transmiss\u00e3o:");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).addContainerGap(362, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jLabel2));
        this.chkCertificado.setBackground(new Color(240, 245, 240));
        this.chkCertificado.setFont(new Font("Arial", 0, 11));
        this.chkCertificado.setForeground(new Color(30, 105, 140));
        this.chkCertificado.setText("Transmitir Utilizando Certifica\u00e7\u00e3o Digital");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((Component)this.chkCertificado)).add(2, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.pnlLocalizadorPasta, -1, 628, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.pnlListaDec, -1, 628, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(0).add((Component)this.pnlLocalizadorPasta, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.pnlListaDec, -2, 282, -2).addPreferredGap(0).add((Component)this.chkCertificado).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addContainerGap(20, Short.MAX_VALUE)));
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.pnlListaDec.getTblDeclaracao().getSelectedRowCount() > 0) {
            ((JDialog)SwingUtilities.getRoot(this)).dispatchEvent(new WindowEvent((Window)SwingUtilities.getRoot(this), 201));
            ProcessoSwing.executa((Tarefa)new Tarefa(){

                public Object run() {
                    int[] selecteds = PainelTransmitirDeclaracao.this.pnlListaDec.getTblDeclaracao().getSelectedRows();
                    ListaDecGravadaTableModel model = (ListaDecGravadaTableModel)((TableSorter)PainelTransmitirDeclaracao.this.pnlListaDec.getTblDeclaracao().getModel()).getTableModel();
                    TransmitirAction acao = new TransmitirAction();
                    for (int i = 0; i < selecteds.length; ++i) {
                        int index = ((TableSorter)PainelTransmitirDeclaracao.this.pnlListaDec.getTblDeclaracao().getModel()).modelIndex(selecteds[i]);
                        File arqDec = model.getDecFiles()[index];
                        if (acao.transmitir(arqDec, PainelTransmitirDeclaracao.this.chkCertificado.isSelected(), i + 1, selecteds.length) == acao.RETORNO_CANCELAR) break;
                    }
                    return null;
                }
            });
            if (ITRFacade.getDeclaracaoAberta() == null) {
                ITRFacade.limparRepositorioXML();
                ITRFacade.setDeclaracaoEmMemoria(null);
            }
        }
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).dispatchEvent(new WindowEvent((Window)SwingUtilities.getRoot(this), 201));
    }

    private void btnAjudaActionPerformed(ActionEvent evt) {
    }

    private void btnTodasActionPerformed(ActionEvent evt) {
        this.pnlListaDec.getTblDeclaracao().selectAll();
    }

    private static class TransmitirAction {
        private int qtdTransmitidas = 0;
        public final int RETORNO_PROXIMA = 0;
        public final int RETORNO_CANCELAR = 3;
        private static Receitanet receitaNet = null;

        private TransmitirAction() {
        }

        public int transmitir(final File dec, final boolean certificado, final int indice, final int total) {
            if (this.getReceitaNet() == null) {
                return 3;
            }
            Integer ret = (Integer)ProcessoSwing.executa((Tarefa)new Tarefa(){

                public Object run() {
                    StringBuffer msgBuffer = new StringBuffer();
                    int ret = 0;
                    try {
                        ret = this.getReceitaNet().enviarDeclaracao((Window)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), dec, certificado, msgBuffer);
                        msgBuffer = MensagemUtil.tratarMsgRetornoReceitanet(msgBuffer);
                    }
                    catch (Exception e) {
                        ret = 1;
                        msgBuffer = new StringBuffer(e.getMessage());
                    }
                    if (ret == 0 || ret == 2) {
                        GuiUtil.informaPaginado(msgBuffer.toString(), "Declara\u00e7\u00e3o", indice, total, 1);
                        ++qtdTransmitidas;
                        File fileRec = UtilitariosTXT.getRECCorrespondente(dec);
                        if (!dec.getParentFile().equals(ITRFacade.obterPastaPadraoGravadas()) && fileRec != null) {
                            UtilitariosArquivo.copiaArquivo((String)dec.toString(), (String)ITRFacade.obterPastaPadraoGravadas().getAbsolutePath());
                            UtilitariosArquivo.copiaArquivo((String)fileRec.toString(), (String)ITRFacade.obterPastaPadraoGravadas().getAbsolutePath());
                        }
                        if (fileRec != null) {
                            UtilitariosArquivo.copiaArquivo((String)dec.toString(), (String)ITRFacade.obterPastaPadraoTransmitidas().getAbsolutePath());
                            UtilitariosArquivo.copiaArquivo((String)fileRec.toString(), (String)ITRFacade.obterPastaPadraoTransmitidas().getAbsolutePath());
                        }
                    } else if (GuiUtil.confirmaPaginado(msgBuffer.toString(), "Declara\u00e7\u00e3o", indice, total, 2, 0) == 2) {
                        return new Integer(3);
                    }
                    return new Integer(0);
                }
            });
            return ret;
        }

        public Receitanet getReceitaNet() {
            try {
                if (receitaNet == null) {
                    receitaNet = new ControleReceitanet();
                }
                return receitaNet;
            }
            catch (Exception e) {
                GuiUtil.mostrarErro("110145");
                return null;
            }
        }

        public int getQtdTransmitidas() {
            return this.qtdTransmitidas;
        }
    }
}

