/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.pendencia.TableModelPendencia;
import serpro.ppgd.gui.pendencia.TablePendencia;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.PainelDeclaracaoAb;
import serpro.ppgd.itr.gui.pendencias.EditTablePendenciasITR;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.impressao.ImpressaoDeclaracao;
import serpro.ppgd.negocio.Pendencia;

public class PainelVerificarPendencias
extends PainelDeclaracaoAb {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Verificar Pend\u00eancias";
    public static final int RETORNO_FECHAR = 1;
    public static final int RETORNO_SELECIONAR_PENDENCIA = 2;
    public static final int RETORNO_IMPRIMIR = 3;
    private ImageIcon imagemTitulo;
    private int totalErros = 0;
    private int totalAjuda = 0;
    private int retorno = 1;
    private List<Pendencia> listaPendencias;
    private JTextField edtTotalAvisos;
    private JTextField edtTotalErros;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JLabel lblTotalAvisos;
    private JLabel lblTotalErros;
    private EditTablePendenciasITR tblPendencia;

    public PainelVerificarPendencias() {
        this.initComponents();
    }

    public PainelVerificarPendencias(List<Pendencia> listaPendencias) {
        this();
        this.imagemTitulo = GuiUtil.getImage("/icones/ITR40x40/verificacao_pendencias.png");
        this.listaPendencias = listaPendencias;
    }

    protected String getTotalErros() {
        return "" + this.totalErros;
    }

    protected int getQtdTotalErros() {
        return this.totalErros;
    }

    protected String getTotalAvisos() {
        return "" + this.totalAjuda;
    }

    protected int getQtdTotalAvisos() {
        return this.totalAjuda;
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanel1 = new JPanel();
        this.lblTotalErros = new JLabel();
        this.edtTotalErros = new JTextField();
        this.jPanel3 = new JPanel();
        this.lblTotalAvisos = new JLabel();
        this.edtTotalAvisos = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.tblPendencia = new EditTablePendenciasITR();
        this.setBackground(new Color(240, 245, 240));
        this.jPanel2.setBackground(new Color(229, 238, 243));
        this.jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(161, 168, 171)), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.jPanel2.setLayout(new GridLayout(1, 0));
        this.jLabel4.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel4.setForeground(new Color(30, 105, 140));
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/icones/png14px/erro.png")));
        this.jLabel4.setText(" Impede a grava\u00e7\u00e3o ou entrega da declara\u00e7\u00e3o \u00e0 RFB.");
        this.jPanel2.add(this.jLabel4);
        this.jLabel5.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel5.setForeground(new Color(30, 105, 140));
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/icones/png14px/atencao.png")));
        this.jLabel5.setText(" N\u00e3o impede a grava\u00e7\u00e3o ou entrega da declara\u00e7\u00e3o \u00e0 RFB.");
        this.jPanel2.add(this.jLabel5);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel1.setBackground(new Color(205, 224, 239));
        this.jPanel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(177, 188, 199)), BorderFactory.createEmptyBorder(1, 10, 1, 1)));
        this.jPanel1.setPreferredSize(new Dimension(636, 35));
        this.jPanel1.setLayout(new FlowLayout(0));
        this.lblTotalErros.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTotalErros.setForeground(new Color(30, 105, 140));
        this.lblTotalErros.setText("Total de Erros ");
        this.jPanel1.add(this.lblTotalErros);
        this.edtTotalErros.setEditable(false);
        this.edtTotalErros.setPreferredSize(new Dimension(45, 23));
        this.edtTotalErros.setRequestFocusEnabled(false);
        this.jPanel1.add(this.edtTotalErros);
        this.jPanel3.setMinimumSize(new Dimension(5, 100));
        this.jPanel3.setOpaque(false);
        this.jPanel3.setPreferredSize(new Dimension(40, 4));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 40, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        this.jPanel1.add(this.jPanel3);
        this.lblTotalAvisos.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTotalAvisos.setForeground(new Color(30, 105, 140));
        this.lblTotalAvisos.setText("Total de Avisos");
        this.jPanel1.add(this.lblTotalAvisos);
        this.edtTotalAvisos.setEditable(false);
        this.edtTotalAvisos.setPreferredSize(new Dimension(45, 23));
        this.edtTotalAvisos.setRequestFocusEnabled(false);
        this.jPanel1.add(this.edtTotalAvisos);
        this.jPanel4.add((Component)this.jPanel1, "Last");
        this.tblPendencia.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PainelVerificarPendencias.this.tblPendenciaMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)((Object)this.tblPendencia));
        this.tblPendencia.getColumnModel().setColumnMargin(0);
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel4, -1, 415, Short.MAX_VALUE).add(7, 7, 7).add((Component)this.jPanel2, -2, -1, -2).addContainerGap()));
    }

    private void tblPendenciaMouseClicked(MouseEvent evt) {
        if (!ControladorGui.isDeclaracaoAberta()) {
            this.setRetorno(2);
            ((JDialog)SwingUtilities.getRoot(this)).dispatchEvent(new WindowEvent((Window)SwingUtilities.getRoot(this), 201));
        }
    }

    public int getRetorno() {
        return this.retorno;
    }

    public void setRetorno(int retorno) {
        this.retorno = retorno;
    }

    public TablePendencia getTblPendencia() {
        return this.tblPendencia;
    }

    @Override
    public boolean isPodeSair() {
        return true;
    }

    @Override
    public String getTituloPainel() {
        return "Rela\u00e7\u00e3o de Pend\u00eancias";
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return this.imagemTitulo;
    }

    @Override
    public void posExibir() {
        super.posExibir();
        this.jScrollPane1.grabFocus();
    }

    @Override
    public void preExibir() {
        this.setRetorno(1);
        TableModelPendencia model = (TableModelPendencia)this.getTblPendencia().getModel();
        this.jScrollPane1.getViewport().setBackground(Color.white);
        model.atualizaPendencias(this.listaPendencias);
        this.totalErros = model.getTotalErros();
        this.totalAjuda = model.getTotalAvisos();
        this.edtTotalErros.setText("" + model.getTotalErros());
        this.edtTotalAvisos.setText("" + model.getTotalAvisos());
    }

    @Override
    public String getMensagemTela() {
        return "<html>Para corrigir erro ou aviso, clique na respectiva descri\u00e7\u00e3o, que o programa mostrar\u00e1 o campo a ser corrigido.</html>";
    }

    @Override
    public boolean isTelaComMensagem() {
        return true;
    }

    @Override
    public String getHelpID() {
        return HELP_ID;
    }

    @Override
    public void executaImpressao() {
        DeclaracaoITR dec = ControladorGui.getDeclaracaoAberta();
        if (dec == null) {
            this.setRetorno(3);
            ((JDialog)SwingUtilities.getRoot(this)).dispatchEvent(new WindowEvent((Window)SwingUtilities.getRoot(this), 201));
        } else {
            this.imprimirPendencias(dec.getIdentificadorDeclaracao());
        }
    }

    @Override
    public boolean isTelaComImpressao() {
        return true;
    }

    public void imprimirPendencias(IdentificadorDeclaracao id) {
        ImpressaoDeclaracao imp = new ImpressaoDeclaracao();
        TableModelPendencia model = (TableModelPendencia)this.getTblPendencia().getModel();
        imp.imprimirPendencias(model.getListaPendencias(), id).visualizar();
    }

    public List<Pendencia> getListaPendencias() {
        return this.listaPendencias;
    }

    public void setListaPendencias(List<Pendencia> listaPendencias) {
        this.listaPendencias = listaPendencias;
    }
}

