/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.imovel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import serpro.ppgd.app.PlataformaITRPGD;
import serpro.ppgd.app.acoes.MudarPainelAction;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.NavegacaoIf;
import serpro.ppgd.itr.gui.PainelAuxiliarObrigatoriedade;
import serpro.ppgd.itr.gui.PainelDeclaracaoAb;
import serpro.ppgd.itr.imovel.Imovel;
import serpro.ppgd.negocio.Logico;

public class PainelMotivoIsento
extends PainelDeclaracaoAb {
    private static final long serialVersionUID = 5426382283681155883L;
    public static final String HELP_ID = "Preenchimento das Fichas/Dados do Im\u00f3vel Rural";
    private ButtonGroup btGroupMotivo;
    private JButton btnCancelar;
    private JButton btnOk;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel lblExplicacao;
    private JRadioButton rbMotivoA;
    private JRadioButton rbMotivoB;
    private JRadioButton rbMotivoC;
    private JRadioButton rbMotivoD;
    private JRadioButton rbMotivoE;

    public PainelMotivoIsento() {
        this.initComponents();
        ActionListener habilitaOK = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PainelMotivoIsento.this.rbMotivoA.isSelected() || PainelMotivoIsento.this.rbMotivoB.isSelected() || PainelMotivoIsento.this.rbMotivoC.isSelected() || PainelMotivoIsento.this.rbMotivoD.isSelected() || PainelMotivoIsento.this.rbMotivoE.isSelected()) {
                    PainelMotivoIsento.this.btnOk.setEnabled(true);
                }
            }
        };
        this.rbMotivoA.addActionListener(habilitaOK);
        this.rbMotivoB.addActionListener(habilitaOK);
        this.rbMotivoC.addActionListener(habilitaOK);
        this.rbMotivoD.addActionListener(habilitaOK);
        this.rbMotivoE.addActionListener(habilitaOK);
        PlataformaPPGD plataforma = PlataformaPPGD.getPlataforma();
        ((PlataformaITRPGD)plataforma).getHelpPDF().setHelpID(this, HELP_ID);
    }

    @Override
    public void preExibir() {
        this.prepararExibicao();
    }

    private void initComponents() {
        this.btGroupMotivo = new ButtonGroup();
        this.jLabel14 = new JLabel();
        this.jPanel1 = new JPanel();
        this.rbMotivoA = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.rbMotivoB = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.rbMotivoC = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.rbMotivoD = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.btnOk = new JButton();
        this.jPanel2 = new JPanel();
        this.lblExplicacao = new JLabel();
        this.jButton1 = new JButton();
        this.btnCancelar = new JButton();
        this.rbMotivoE = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.setBackground(new Color(240, 245, 240));
        this.jLabel14.setFont(new Font("Arial", 1, 12));
        this.jLabel14.setForeground(new Color(30, 105, 140));
        this.jLabel14.setText("Escolha um dos motivos de enquadramento de imunidade ou isen\u00e7\u00e3o do ITR");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.rbMotivoA.setBackground(new Color(255, 255, 255));
        this.btGroupMotivo.add(this.rbMotivoA);
        this.rbMotivoA.setFont(new Font("Arial", 0, 11));
        this.rbMotivoA.setForeground(new Color(89, 89, 89));
        this.rbMotivoA.setMinimumSize(new Dimension(110, 80));
        this.rbMotivoA.setPreferredSize(new Dimension(110, 80));
        this.rbMotivoA.setVerticalAlignment(1);
        this.rbMotivoA.setVerticalTextPosition(1);
        this.jLabel1.setFont(new Font("Arial", 0, 11));
        this.jLabel1.setForeground(new Color(89, 89, 89));
        this.jLabel1.setText("<html><font color=\"#004A6A\"><b>A.</b></font> Imune por ser pequena gleba rural (im\u00f3vel com \u00e1rea igual ou inferior a 100 ha, se localizado na Amaz\u00f4nia Ocidental ou no Pantanal; a 50 ha, se no Pol\u00edgono das Secas ou na Amaz\u00f4nia Oriental; e a 30 ha, se em qualquer outro munic\u00edpio), desde que o propriet\u00e1rio a explore, com aux\u00edlio de sua fam\u00edlia ou de empregado, vedado arrendamento, comodato ou parceria, e que n\u00e3o possua qualquer outro im\u00f3vel rural ou urbano;</html>");
        this.jLabel1.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.rbMotivoB.setBackground(new Color(255, 255, 255));
        this.btGroupMotivo.add(this.rbMotivoB);
        this.rbMotivoB.setFont(new Font("Arial", 0, 11));
        this.rbMotivoB.setForeground(new Color(89, 89, 89));
        this.rbMotivoB.setMinimumSize(new Dimension(110, 80));
        this.rbMotivoB.setPreferredSize(new Dimension(110, 80));
        this.rbMotivoB.setVerticalAlignment(1);
        this.rbMotivoB.setVerticalTextPosition(1);
        this.jLabel2.setFont(new Font("Arial", 0, 11));
        this.jLabel2.setForeground(new Color(89, 89, 89));
        this.jLabel2.setText("<html><font color=\"#004A6A\"><b>B.</b></font> Isento por ser parte de um conjunto de im\u00f3veis de um mesmo propriet\u00e1rio, cuja soma das \u00e1reas n\u00e3o ultrapasse os limites da pequena gleba rural, desde que os explore, s\u00f3 ou com sua fam\u00edlia, admitida ajuda eventual de terceiros, vedado arrendamento, comodato ou parceria e que n\u00e3o possua qualquer im\u00f3vel urbano;</html>");
        this.jLabel2.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.rbMotivoC.setBackground(new Color(255, 255, 255));
        this.btGroupMotivo.add(this.rbMotivoC);
        this.rbMotivoC.setFont(new Font("Arial", 0, 11));
        this.rbMotivoC.setForeground(new Color(89, 89, 89));
        this.rbMotivoC.setMinimumSize(new Dimension(110, 80));
        this.rbMotivoC.setPreferredSize(new Dimension(110, 80));
        this.rbMotivoC.setVerticalAlignment(1);
        this.rbMotivoC.setVerticalTextPosition(1);
        this.jLabel3.setFont(new Font("Arial", 0, 11));
        this.jLabel3.setForeground(new Color(89, 89, 89));
        this.jLabel3.setText("<html><font color=\"#004A6A\"><b>C.</b></font> Isento por estar compreendido em programa oficial de reforma agr\u00e1ria, caracterizado pelas autoridades competentes como assentamento, cuja fra\u00e7\u00e3o ideal por fam\u00edlia assentada n\u00e3o ultrapassa os limites da pequena gleba rural, com titula\u00e7\u00e3o em nome coletivo, explorado por associa\u00e7\u00e3o ou cooperativa de produ\u00e7\u00e3o, vedado arrendamento, comodato ou parceria, e nenhum assentado seja possuidor, individual ou coletivamente, de qualquer outro im\u00f3vel rural ou urbano;</html>");
        this.jLabel3.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.rbMotivoD.setBackground(new Color(255, 255, 255));
        this.btGroupMotivo.add(this.rbMotivoD);
        this.rbMotivoD.setFont(new Font("Arial", 0, 11));
        this.rbMotivoD.setForeground(new Color(89, 89, 89));
        this.rbMotivoD.setMinimumSize(new Dimension(110, 80));
        this.rbMotivoD.setPreferredSize(new Dimension(110, 80));
        this.rbMotivoD.setVerticalAlignment(1);
        this.rbMotivoD.setVerticalTextPosition(1);
        this.jLabel4.setFont(new Font("Arial", 0, 11));
        this.jLabel4.setForeground(new Color(89, 89, 89));
        this.jLabel4.setText("<html><font color=\"#004A6A\"><b>D.</b></font> Imune por ser pertencente \u00e0 Uni\u00e3o, a estado, ao Distrito Federal ou a munic\u00edpio; \u00e0 autarquia ou funda\u00e7\u00e3o institu\u00edda e mantida pelo Poder P\u00fablico, desde que vinculado \u00e0s suas finalidades essenciais ou \u00e0s delas decorrentes; e \u00e0 institui\u00e7\u00e3o de educa\u00e7\u00e3o e de assist\u00eancia social, sem fins lucrativos, desde que vinculado \u00e0s suas finalidades essenciais, atendidos os requisitos da lei;</html>");
        this.jLabel4.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        this.btnOk.setText("Confirmar");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelMotivoIsento.this.btnOkActionPerformed(evt);
            }
        });
        this.jPanel2.setBackground(new Color(234, 242, 251));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(195, 195, 195)));
        this.lblExplicacao.setFont(new Font("Arial", 1, 11));
        this.lblExplicacao.setForeground(new Color(30, 105, 140));
        this.lblExplicacao.setHorizontalAlignment(4);
        this.lblExplicacao.setText("<html>Caso n\u00e3o tenha conseguido enquadrar o seu<br>im\u00f3vel em um dos motivos acima, responda \u00e0s perguntas a seguir</html>");
        this.jButton1.setAction(new MudarPainelAction(NavegacaoIf.PAINEL_PEGUNTAS_ISENTO));
        this.jButton1.setText("Responder \u00e0s Perguntas");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.lblExplicacao, -1, 487, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblExplicacao).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton1))).addContainerGap()));
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelMotivoIsento.this.btnCancelarActionPerformed(evt);
            }
        });
        this.rbMotivoE.setBackground(new Color(255, 255, 255));
        this.btGroupMotivo.add(this.rbMotivoE);
        this.rbMotivoE.setFont(new Font("Arial", 0, 11));
        this.rbMotivoE.setForeground(new Color(89, 89, 89));
        this.rbMotivoE.setMinimumSize(new Dimension(110, 80));
        this.rbMotivoE.setPreferredSize(new Dimension(110, 80));
        this.rbMotivoE.setVerticalAlignment(1);
        this.rbMotivoE.setVerticalTextPosition(1);
        this.jLabel5.setFont(new Font("Arial", 0, 11));
        this.jLabel5.setForeground(new Color(89, 89, 89));
        this.jLabel5.setText("<html><font color=\"#004A6A\"><b>E.</b></font> Isento por ter a \u00e1rea total reconhecida como ocupada por remanescentes de comunidades de quilombos, estar sob a ocupa\u00e7\u00e3o direta e ser explorado, individual ou coletivamente, por seus membros.</html>");
        this.jLabel5.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbMotivoB, -2, 18, -2).addComponent(this.rbMotivoC, -2, 18, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbMotivoA, -2, 18, -2).addComponent(this.rbMotivoD, -2, 18, -2).addComponent(this.rbMotivoE, -2, 18, -2)).addGap(1, 1, 1).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, 672, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel3, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel4, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel5, -2, 0, Short.MAX_VALUE)))).addGap(14, 14, 14))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnOk, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancelar, -2, 121, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1).addComponent(this.rbMotivoA, -2, 43, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2).addComponent(this.rbMotivoB, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3).addComponent(this.rbMotivoC, -2, 57, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4, -1, 15, Short.MAX_VALUE).addComponent(this.rbMotivoD, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel5, -1, 42, Short.MAX_VALUE).addComponent(this.rbMotivoE, -2, 0, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOk).addComponent(this.btnCancelar)).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel14).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, 383, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        String motivo = "";
        if (this.rbMotivoA.isSelected()) {
            motivo = "A";
        } else if (this.rbMotivoB.isSelected()) {
            motivo = "B";
        } else if (this.rbMotivoC.isSelected()) {
            motivo = "C";
        } else if (this.rbMotivoD.isSelected()) {
            motivo = "D";
        } else if (this.rbMotivoE.isSelected()) {
            motivo = "E";
        }
        DeclaracaoITR pDec = ITRFacade.getDeclaracaoAberta();
        pDec.getImovel().getMotivoIsencao().setConteudo(motivo);
        if (motivo.length() == 0) {
            pDec.getImovel().getIsento().setConteudo(Logico.NAO);
        }
        PainelAuxiliarObrigatoriedade.getInstance().setObrigatoriedade(pDec.obrigadoDeclarar(), pDec.getImovel().getIsento());
        ControladorGui.acionarPainel(NavegacaoIf.PAINEL_IDENTIFICACAO_IMOVEL);
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        if (ITRFacade.getDeclaracaoAberta().getImovel().getMotivoIsencao().isVazio()) {
            ITRFacade.getDeclaracaoAberta().getImovel().getIsento().setConteudo(Logico.NAO);
        }
        ControladorGui.acionarPainel(NavegacaoIf.PAINEL_IDENTIFICACAO_IMOVEL);
    }

    private void prepararExibicao() {
        Imovel imovel = ITRFacade.getDeclaracaoAberta().getImovel();
        if (imovel.getPessoaFisica().getConteudoFormatado().equals("2")) {
            this.rbMotivoA.setEnabled(false);
            this.rbMotivoB.setEnabled(false);
            this.rbMotivoC.setEnabled(false);
            this.rbMotivoD.setEnabled(true);
            this.rbMotivoE.setEnabled(true);
            this.jLabel1.setEnabled(false);
            this.jLabel2.setEnabled(false);
            this.jLabel3.setEnabled(false);
            this.jLabel4.setEnabled(true);
            this.jLabel5.setEnabled(true);
            this.jLabel4.setForeground(Color.black);
            this.jLabel5.setForeground(Color.black);
        } else {
            this.rbMotivoD.setEnabled(false);
            this.rbMotivoE.setEnabled(false);
            boolean motivoAB = imovel.pequenaGleba() && imovel.getPertenceCondominio().getConteudoFormatado().equals(Logico.NAO);
            boolean motivoC = imovel.getPertenceCondominio().getConteudoFormatado().equals(Logico.SIM);
            this.rbMotivoA.setEnabled(motivoAB);
            this.rbMotivoB.setEnabled(motivoAB);
            this.rbMotivoC.setEnabled(motivoC);
            this.jLabel1.setEnabled(motivoAB);
            this.jLabel2.setEnabled(motivoAB);
            this.jLabel3.setEnabled(motivoC);
            if (motivoAB) {
                this.jLabel1.setForeground(Color.black);
                this.jLabel2.setForeground(Color.black);
            }
            if (motivoC) {
                this.jLabel3.setForeground(Color.black);
            }
            this.jLabel4.setEnabled(false);
            this.jLabel5.setEnabled(false);
        }
        this.btnOk.setEnabled(true);
        String motivo = imovel.getMotivoIsencao().asString().trim();
        int indiceMotivo = -1;
        if (motivo.length() > 0) {
            indiceMotivo = "ABCDE".indexOf(motivo.charAt(0));
        }
        switch (indiceMotivo) {
            case 0: {
                this.rbMotivoA.setSelected(true);
                break;
            }
            case 1: {
                this.rbMotivoB.setSelected(true);
                break;
            }
            case 2: {
                this.rbMotivoC.setSelected(true);
                break;
            }
            case 3: {
                this.rbMotivoD.setSelected(true);
                break;
            }
            case 4: {
                this.rbMotivoE.setSelected(true);
                break;
            }
            default: {
                this.btnOk.setEnabled(false);
                this.btGroupMotivo.remove(this.rbMotivoA);
                this.btGroupMotivo.remove(this.rbMotivoB);
                this.btGroupMotivo.remove(this.rbMotivoC);
                this.btGroupMotivo.remove(this.rbMotivoD);
                this.btGroupMotivo.remove(this.rbMotivoE);
                this.rbMotivoA.setSelected(false);
                this.rbMotivoB.setSelected(false);
                this.rbMotivoC.setSelected(false);
                this.rbMotivoD.setSelected(false);
                this.rbMotivoE.setSelected(false);
                this.btGroupMotivo.add(this.rbMotivoA);
                this.btGroupMotivo.add(this.rbMotivoB);
                this.btGroupMotivo.add(this.rbMotivoC);
                this.btGroupMotivo.add(this.rbMotivoD);
                this.btGroupMotivo.add(this.rbMotivoE);
            }
        }
    }

    @Override
    public String getHelpID() {
        return HELP_ID;
    }
}

