/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.imovel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import serpro.ppgd.app.PlataformaITRPGD;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.AreaHectares;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.NavegacaoIf;
import serpro.ppgd.itr.gui.PainelDeclaracaoAb;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.imovel.Imovel;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;

public class PainelPerguntasImuneIsento
extends PainelDeclaracaoAb {
    public static final String TITULO = "<html>Documento de Informa\u00e7\u00e3o e Atualiza\u00e7\u00e3o Cadastral do ITR - Diac<br>Dados do Im\u00f3vel Rural - Imunidade/Isen\u00e7\u00e3o</html>";
    private static final String NOME_ARQUIVO_ESTADOS = "/perguntasIsencao.properties";
    public static final String HELP_ID = "Preenchimento das Fichas/Dados do Im\u00f3vel Rural";
    private Properties propertiesPerguntas = UtilitariosArquivo.loadProperties((String)"/perguntasIsencao.properties", this.getClass());
    private static String[] codMensagens = new String[]{"1001", "1002", "1002", "1026", "1027", "1003", "1006", "1029", "1004", "1005", "1006", "1007", "1001", "1002", "1026", "1027", "1028", "1013", "1014", "1016", "1015", "1017", "1018", "1019", "1020", "1021", "1022", "1023", "1024", "1025", "1008", "1009", "1010", "1011", "1012", "1036", "1029", "1037", "1029", "1039", "1040"};
    private static String[][] perguntasArea = new String[][]{{"1008", "100,0"}, {"1009", "100,0"}, {"1010", "50,0"}, {"1011", "50,0"}, {"1012", "30,0"}};
    private int qtdRespostasArea = 0;
    private AreaHectares areaTotal = new AreaHectares();
    private boolean validarArea;
    private static int RESPOSTA_SIM = 0;
    private static int RESPOSTA_NAO = 1;
    private static char[] respostasAbrev = new char[]{'S', 'N'};
    private static String[] respostasExtenso = new String[]{"Sim", "N\u00e3o"};
    private static String[] mensagens;
    private int indicePerguntaAtual;
    private JEditValor edtAreaPergunta;
    private JButton btnOkArea;
    private Valor areaPergunta;
    private boolean exibindoSimNao = true;
    private JButton btnConfirmar;
    private StringBuffer textoRespostas;
    private String textoPerguntaAtual;
    private String cabecalhoTextoRespostas = "<html><font size='2' face='arial'><table border=0>";
    private String rodapeTextorespostas = "</table></font></html>";
    private int indice = 1;
    private JButton btnCancelar;
    private JButton btnNao;
    private JButton btnReiniciar;
    private JButton btnSair;
    private JButton btnSim;
    private JEditorPane jEditorPane1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JLabel lblPergunta;
    private JPanel pnlPerguntas;
    private JPanel pnlRespostas;
    private JPanel pnlSimNao;

    public PainelPerguntasImuneIsento() {
        this.initComponents();
        if (mensagens == null) {
            mensagens = new String[codMensagens.length];
            for (int i = 0; i < codMensagens.length; ++i) {
                PainelPerguntasImuneIsento.mensagens[i] = MensagemUtil.getMensagem(codMensagens[i]);
            }
        }
        this.textoRespostas = new StringBuffer();
        this.areaPergunta = new Valor();
        this.areaPergunta.setMaximoDigitosParteInteira(8);
        this.areaPergunta.setCasasDecimais(1);
        this.edtAreaPergunta = new JEditValor((Informacao)this.areaPergunta);
        this.edtAreaPergunta.setButtonMensagem(null);
        this.edtAreaPergunta.setPreferredSize(new Dimension(75, 20));
        this.edtAreaPergunta.getComponenteEditor().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    PainelPerguntasImuneIsento.this.btnOkArea.doClick();
                }
            }
        });
        this.btnOkArea = new JButton();
        this.btnOkArea.setMnemonic('O');
        this.btnOkArea.setText("Ok");
        this.btnOkArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelPerguntasImuneIsento.this.areaPergunta.setConteudo(((JFormattedTextField)PainelPerguntasImuneIsento.this.edtAreaPergunta.getComponenteEditor()).getText());
                ((JFormattedTextField)PainelPerguntasImuneIsento.this.edtAreaPergunta.getComponenteEditor()).setText(PainelPerguntasImuneIsento.this.areaPergunta.getConteudoFormatado());
                PainelPerguntasImuneIsento.this.edtAreaPergunta.chamaValidacao();
                PainelPerguntasImuneIsento.this.onBtnAreaPerguntaClicked();
            }
        });
        this.btnConfirmar = new JButton();
        this.btnConfirmar.setMnemonic('C');
        this.btnConfirmar.setText("Confirmar");
        this.btnConfirmar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelPerguntasImuneIsento.this.onBtnConfirmarClicked(evt);
            }
        });
        PlataformaPPGD plataforma = PlataformaPPGD.getPlataforma();
        ((PlataformaITRPGD)plataforma).getHelpPDF().setHelpID(this, HELP_ID);
    }

    @Override
    public void preExibir() {
        this.iniciar();
    }

    public void iniciar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PainelPerguntasImuneIsento.this.qtdRespostasArea = 0;
                PainelPerguntasImuneIsento.this.areaTotal.clear();
                PainelPerguntasImuneIsento.this.pnlPerguntas.setBackground(new Color(234, 242, 251));
                PainelPerguntasImuneIsento.this.lblPergunta.setIcon(null);
                PainelPerguntasImuneIsento.this.areaPergunta.clear();
                PainelPerguntasImuneIsento.this.pnlSimNao.removeAll();
                PainelPerguntasImuneIsento.this.pnlSimNao.add(PainelPerguntasImuneIsento.this.btnSim);
                PainelPerguntasImuneIsento.this.pnlSimNao.add(PainelPerguntasImuneIsento.this.btnNao);
                PainelPerguntasImuneIsento.this.pnlSimNao.repaint();
                PainelPerguntasImuneIsento.this.exibindoSimNao = true;
                PainelPerguntasImuneIsento.this.jEditorPane1.setText("<html><body></body></html>");
                PainelPerguntasImuneIsento.this.textoRespostas = new StringBuffer();
                Imovel imovel = ITRFacade.getDeclaracaoAberta().getImovel();
                String tipoPessoa = imovel.getPessoaFisica().asString();
                PainelPerguntasImuneIsento.this.indicePerguntaAtual = tipoPessoa.equals("2") ? 39 : (!imovel.pequenaGleba() ? 12 : 0);
                PainelPerguntasImuneIsento.this.indice = 1;
                PainelPerguntasImuneIsento.this.exibirPergunta();
            }
        });
    }

    public void exibirPergunta() {
        Imovel imovel = ITRFacade.getDeclaracaoAberta().getImovel();
        String pergunta = codMensagens[this.indicePerguntaAtual];
        this.textoPerguntaAtual = mensagens[this.indicePerguntaAtual];
        if (imovel.getMunicipio().getElementoTabela().getConteudo(3).toString().equals("4") && pergunta == "1008" || imovel.getMunicipio().getElementoTabela().getConteudo(3).toString().equals("5") && pergunta == "1009" || imovel.getMunicipio().getElementoTabela().getConteudo(3).toString().equals("3") && pergunta == "1010" || imovel.getMunicipio().getElementoTabela().getConteudo(3).toString().equals("2") && pergunta == "1011" || imovel.getMunicipio().getElementoTabela().getConteudo(3).toString().equals("1") && pergunta == "1012") {
            this.textoPerguntaAtual = this.textoPerguntaAtual + ", inclusive a deste";
            this.validarArea = true;
        } else {
            this.validarArea = false;
        }
        this.lblPergunta.setText("<html><b>" + this.indice + ".</b> " + this.textoPerguntaAtual);
        if (this.exibindoSimNao) {
            for (int i = 0; i < perguntasArea.length; ++i) {
                if (!perguntasArea[i][0].equals(codMensagens[this.indicePerguntaAtual])) continue;
                this.pnlSimNao.removeAll();
                this.pnlSimNao.add((Component)this.edtAreaPergunta);
                this.pnlSimNao.add(this.btnOkArea);
                this.pnlSimNao.repaint();
                this.edtAreaPergunta.getComponenteEditor().requestFocus();
                this.exibindoSimNao = false;
                break;
            }
            if (this.exibindoSimNao) {
                this.btnSim.requestFocusInWindow();
            }
        } else {
            this.areaPergunta.setConteudo("0,0");
            this.edtAreaPergunta.getComponenteEditor().requestFocus();
        }
    }

    public void avaliaResposta(int resposta) {
        this.exibirResposta(resposta);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PainelPerguntasImuneIsento.this.jScrollPane1.getVerticalScrollBar().setValue(PainelPerguntasImuneIsento.this.jScrollPane1.getVerticalScrollBar().getMaximum());
            }
        });
        String chave = Integer.toString(this.indicePerguntaAtual) + respostasAbrev[resposta];
        String proximoEstado = this.propertiesPerguntas.getProperty(chave).trim();
        if (proximoEstado.length() == 0) {
            this.exibirConfirmacao(proximoEstado, "<html>De acordo com as informa\u00e7\u00f5es prestadas, o im\u00f3vel n\u00e3o est\u00e1 nem imune nem isento do ITR.</html>");
        } else {
            int indiceImune = "ABCDE".indexOf(proximoEstado.charAt(0));
            if (indiceImune >= 0) {
                StringBuffer msg = new StringBuffer("<html>De acordo com as informa\u00e7\u00f5es prestadas, o im\u00f3vel est\u00e1 ");
                switch (indiceImune) {
                    case 0: 
                    case 3: {
                        msg.append("imune");
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        msg.append("isento");
                    }
                }
                msg.append(" do ITR por motivo de enquadramento ");
                msg.append(proximoEstado);
                msg.append(".</html>");
                this.exibirConfirmacao(proximoEstado, msg.toString());
            } else {
                this.indicePerguntaAtual = Integer.parseInt(proximoEstado);
                this.exibirPergunta();
            }
        }
    }

    public void exibirConfirmacao(String comando, String msg) {
        this.pnlPerguntas.setBackground(new Color(255, 255, 225));
        this.lblPergunta.setIcon(GuiUtil.getImage("/icones/png14px/atencao.png"));
        this.lblPergunta.setText(msg);
        this.btnConfirmar.setActionCommand(comando);
        this.pnlSimNao.removeAll();
        this.pnlSimNao.add(this.btnConfirmar);
        this.btnConfirmar.requestFocus();
    }

    public void exibirResposta(int resposta) {
        this.textoRespostas.append("<tr>");
        this.textoRespostas.append("<td><font size=\"3\" color=\"#004A6A\"><b>");
        this.textoRespostas.append(this.indice);
        this.textoRespostas.append(".</b></font><font size=\"3\"> ");
        this.textoRespostas.append(this.textoPerguntaAtual);
        this.textoRespostas.append("</font></td><td width=100 align=center><font size=\"3\">");
        if (this.exibindoSimNao) {
            this.textoRespostas.append(respostasExtenso[resposta]);
        } else {
            this.textoRespostas.append(this.areaPergunta.getConteudoFormatado());
            this.areaPergunta.setConteudo("0,0");
        }
        this.textoRespostas.append("</font></td></tr>");
        this.jEditorPane1.setText(this.cabecalhoTextoRespostas + this.textoRespostas.toString() + this.rodapeTextorespostas);
        ++this.indice;
    }

    protected void onBtnAreaPerguntaClicked() {
        if (this.areaPergunta.isValido()) {
            if (this.validarArea && this.areaPergunta.comparacao("<", (Valor)ITRFacade.getDeclaracaoEmMemoria().getImovel().getAreaTotal())) {
                JOptionPane.showMessageDialog(SwingUtilities.getRootPane(this), UtilitariosString.insereQuebraDeLinha((String)MensagemUtil.getMensagem("1035"), (int)120, (String)"\n"), "ITR " + ConstantesGlobais.EXERCICIO, 1);
                this.areaPergunta.setConteudo("0,0");
                this.edtAreaPergunta.getComponenteEditor().requestFocusInWindow();
                return;
            }
            this.areaTotal.append('+', this.areaPergunta);
            if (++this.qtdRespostasArea == 5 && this.areaTotal.comparacao("<=", ITRFacade.getDeclaracaoEmMemoria().getImovel().getAreaTotal())) {
                this.avaliaResposta(RESPOSTA_NAO);
                JOptionPane.showMessageDialog(SwingUtilities.getRootPane(this), UtilitariosString.insereQuebraDeLinha((String)MensagemUtil.getMensagem("1038"), (int)120, (String)"\n"), "ITR " + ConstantesGlobais.EXERCICIO, 1);
                return;
            }
            int resposta = RESPOSTA_NAO;
            for (int i = 0; i < perguntasArea.length; ++i) {
                if (!codMensagens[this.indicePerguntaAtual].equals(perguntasArea[i][0]) || !this.areaPergunta.comparacao("<=", perguntasArea[i][1])) continue;
                resposta = RESPOSTA_SIM;
            }
            this.avaliaResposta(resposta);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.pnlPerguntas = new JPanel();
        this.lblPergunta = new JLabel();
        this.pnlRespostas = new JPanel();
        this.pnlSimNao = new JPanel();
        this.btnSim = new JButton();
        this.btnNao = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.btnSair = new JButton();
        this.jPanel4 = new JPanel();
        this.btnReiniciar = new JButton();
        this.btnCancelar = new JButton();
        this.jLabel2 = new JLabel();
        this.setBackground(new Color(240, 245, 240));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.pnlPerguntas.setBackground(new Color(234, 242, 251));
        this.pnlPerguntas.setBorder(BorderFactory.createLineBorder(new Color(195, 195, 195)));
        this.lblPergunta.setFont(new Font("Arial", 0, 11));
        this.lblPergunta.setForeground(new Color(30, 105, 140));
        this.lblPergunta.setText("Pergunta XXX?");
        this.pnlRespostas.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.pnlRespostas.setOpaque(false);
        this.pnlSimNao.setOpaque(false);
        this.pnlSimNao.setLayout(new GridLayout(1, 0, 5, 0));
        this.btnSim.setMnemonic('S');
        this.btnSim.setLabel("Sim");
        this.btnSim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelPerguntasImuneIsento.this.btnSimActionPerformed(evt);
            }
        });
        this.pnlSimNao.add(this.btnSim);
        this.btnNao.setMnemonic('N');
        this.btnNao.setText("N\u00e3o");
        this.btnNao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelPerguntasImuneIsento.this.btnNaoActionPerformed(evt);
            }
        });
        this.pnlSimNao.add(this.btnNao);
        GroupLayout pnlRespostasLayout = new GroupLayout(this.pnlRespostas);
        this.pnlRespostas.setLayout(pnlRespostasLayout);
        pnlRespostasLayout.setHorizontalGroup(pnlRespostasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlRespostasLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.pnlSimNao, -2, 144, -2)));
        pnlRespostasLayout.setVerticalGroup(pnlRespostasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRespostasLayout.createSequentialGroup().addContainerGap().addComponent(this.pnlSimNao, -2, -1, -2).addContainerGap(14, Short.MAX_VALUE)));
        GroupLayout pnlPerguntasLayout = new GroupLayout(this.pnlPerguntas);
        this.pnlPerguntas.setLayout(pnlPerguntasLayout);
        pnlPerguntasLayout.setHorizontalGroup(pnlPerguntasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlPerguntasLayout.createSequentialGroup().addContainerGap().addComponent(this.lblPergunta, -2, 435, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.pnlRespostas, -2, -1, -2).addContainerGap()));
        pnlPerguntasLayout.setVerticalGroup(pnlPerguntasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlPerguntasLayout.createSequentialGroup().addGroup(pnlPerguntasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPergunta, -2, 57, -2).addComponent(this.pnlRespostas, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane1.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane1.setOpaque(false);
        this.jEditorPane1.setEditable(false);
        this.jEditorPane1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jEditorPane1.setContentType("text/html");
        this.jEditorPane1.setFont(new Font("Arial", 0, 11));
        this.jEditorPane1.setForeground(new Color(89, 89, 89));
        this.jEditorPane1.setText("<html>\r\n  <head>\r\n\r\n  </head>\r\n  <body>\r\n<table><tr>\n<td>Perguntas</td><td>Respostas</td></tr>\n<td>\n      Est\u00e1 o im\u00f3vel compreendido em programa oficial de reforma agr\u00e1ria, caracterizado pelas autoridades competentes como assentamento?\r\n</td><td>Sim</td></tr>\n</table>\n  </body>\r\n</html>\r\n");
        this.jEditorPane1.setPreferredSize(new Dimension(106, 320));
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        this.jPanel3.setBackground(new Color(234, 242, 251));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(195, 195, 195)));
        this.jLabel1.setFont(new Font("Arial", 0, 11));
        this.jLabel1.setForeground(new Color(30, 105, 140));
        this.jLabel1.setText("<html><b>Para desistir das perguntas e voltar \u00e0 sele\u00e7\u00e3o de motivos <br> de enquadramento de imunidade e isen\u00e7\u00e3o do ITR<br>clique em Visualizar Motivos.</b></html>");
        this.btnSair.setMnemonic('D');
        this.btnSair.setText("Visualizar Motivos");
        this.btnSair.setToolTipText("Desistir das perguntas e voltar \u00e0 sele\u00e7\u00e3o de motivos de enquadramento de imunidade e isen\u00e7\u00e3o do ITR");
        this.btnSair.setMaximumSize(new Dimension(65, 29));
        this.btnSair.setMinimumSize(new Dimension(65, 29));
        this.btnSair.setPreferredSize(new Dimension(65, 29));
        this.btnSair.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelPerguntasImuneIsento.this.btnSairActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, 427, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnSair, -2, 142, -2).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnSair, -2, 29, -2).addComponent(this.jLabel1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBackground(new Color(255, 255, 255));
        this.btnReiniciar.setMnemonic('R');
        this.btnReiniciar.setToolTipText("Reiniciar perguntas");
        this.btnReiniciar.setLabel("Reiniciar");
        this.btnReiniciar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelPerguntasImuneIsento.this.btnReiniciarActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.setToolTipText("Cancelar opera\u00e7\u00e3o");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelPerguntasImuneIsento.this.btnCancelarActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnReiniciar, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancelar, -2, 140, -2).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnReiniciar).addComponent(this.btnCancelar)).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pnlPerguntas, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.pnlPerguntas, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 142, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 67, -2).addContainerGap()));
        this.jLabel2.setFont(new Font("Arial", 1, 12));
        this.jLabel2.setForeground(new Color(30, 105, 140));
        this.jLabel2.setText("Para verificar os requisitos de imunidade ou isen\u00e7\u00e3o do ITR, responda \u00e0s perguntas:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnSimActionPerformed(ActionEvent evt) {
        this.avaliaResposta(RESPOSTA_SIM);
    }

    private void btnNaoActionPerformed(ActionEvent evt) {
        this.avaliaResposta(RESPOSTA_NAO);
    }

    private void btnReiniciarActionPerformed(ActionEvent evt) {
        this.iniciar();
    }

    private void btnSairActionPerformed(ActionEvent evt) {
        ControladorGui.acionarPainel(NavegacaoIf.PAINEL_MOTIVO_ISENTO);
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        if (ITRFacade.getDeclaracaoAberta().getImovel().getMotivoIsencao().isVazio()) {
            ITRFacade.getDeclaracaoAberta().getImovel().getIsento().setConteudo(Logico.NAO);
        }
        ControladorGui.acionarPainel(NavegacaoIf.PAINEL_IDENTIFICACAO_IMOVEL);
    }

    private void onBtnConfirmarClicked(ActionEvent evt) {
        if (evt.getActionCommand().length() > 0) {
            ControladorGui.getDeclaracaoAberta().getImovel().getMotivoIsencao().setConteudo(evt.getActionCommand());
        } else {
            ControladorGui.getDeclaracaoAberta().getImovel().getIsento().setConteudo(Logico.NAO);
            ControladorGui.getDeclaracaoAberta().getImovel().getMotivoIsencao().clear();
        }
        ControladorGui.acionarPainel(NavegacaoIf.PAINEL_IDENTIFICACAO_IMOVEL);
    }

    @Override
    public String getTituloPainel() {
        return TITULO;
    }

    @Override
    public String getHelpID() {
        return HELP_ID;
    }
}

