/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.pendencias;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.gui.pendencia.LinhaPendencia;
import serpro.ppgd.gui.pendencia.TableModelPendencia;
import serpro.ppgd.gui.pendencia.TablePendencia;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.ITRTableAb;
import serpro.ppgd.itr.gui.PainelComAbasAb;
import serpro.ppgd.itr.gui.PainelDeclaracaoIf;
import serpro.ppgd.itr.gui.PainelListaAb;
import serpro.ppgd.itr.gui.demaiscondominos.PainelCondominosLista;
import serpro.ppgd.itr.gui.pendencias.TableModelPendenciaITR;
import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.UtilitariosString;

public class EditTablePendenciasITR
extends TablePendencia {
    private static int mouseRow = 0;
    private static int mouseColumn = 0;
    private Pendencia pendenciaSelecionada;

    public EditTablePendenciasITR() {
        super((TableModelPendencia)new TableModelPendenciaITR(new String[]{"Tipo", "Campo"}, 1, new int[]{15, 430}, new ArrayList()));
        this.configuraLayout();
        this.pendenciaSelecionada = null;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableModelPendencia model = (TableModelPendencia)EditTablePendenciasITR.this.getModel();
                int selRow = EditTablePendenciasITR.this.getSelectedRow();
                if (selRow > -1) {
                    Pendencia pendencia = model.getPendenciaAt(selRow);
                    if (ControladorGui.isDeclaracaoAberta()) {
                        EditTablePendenciasITR.this.selecionaPendencia(pendencia);
                    }
                    EditTablePendenciasITR.this.setPendenciaSelecionada(pendencia);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                mouseRow = -1;
                mouseColumn = -1;
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int lin = EditTablePendenciasITR.this.rowAtPoint(new Point(e.getX(), e.getY()));
                int col = EditTablePendenciasITR.this.columnAtPoint(new Point(e.getX(), e.getY()));
                if (lin != mouseRow || col != mouseColumn) {
                    mouseRow = lin;
                    mouseColumn = col;
                    EditTablePendenciasITR.this.repaint();
                }
            }
        });
        this.setDefaultRenderer(ImageIcon.class, new LabelPendenciaCellRenderer());
        this.setDefaultRenderer(LinhaPendencia.class, new LabelPendenciaCellRenderer());
    }

    public EditTablePendenciasITR(TableModelPendencia pTableModel) {
        super(pTableModel);
    }

    protected void abrirDeclaracao(ObjetoNegocio declaracao) {
    }

    protected ObjetoNegocio obterDeclaracaoAberta() {
        return ITRFacade.getInstancia().getDeclaracao();
    }

    protected void selecionarNodoArvore(String classe, Pendencia pendencia) {
        ITRUtil.setEstadoSistema(1);
        ControladorGui.acionarPainel(classe);
        ControladorGui.getJanelaPrincipal().setLastAccessedItem(classe);
        if (pendencia.getNomeAba() != null) {
            PainelDeclaracaoIf panel = ControladorGui.getPainelAtualmenteExibido();
            if (panel instanceof PainelComAbasAb) {
                ((PainelComAbasAb)panel).acionarAba(pendencia.getNomeAba(), true);
                if (pendencia.getNumItem() > -1 && ((PainelComAbasAb)panel).getTabbedPane().getSelectedComponent() instanceof PainelListaAb) {
                    this.tratarTelaLista(pendencia, (PainelListaAb)((PainelComAbasAb)panel).getTabbedPane().getSelectedComponent());
                }
            }
        } else if (pendencia.getNumItem() > -1) {
            PainelDeclaracaoIf panel = ControladorGui.getPainelAtualmenteExibido();
            if (panel instanceof PainelListaAb) {
                this.tratarTelaLista(pendencia, panel);
            } else if (panel instanceof PainelCondominosLista) {
                this.tratarTelaDemaisCondominos(pendencia, panel);
            }
        }
    }

    private void tratarTelaDemaisCondominos(Pendencia pendencia, PainelDeclaracaoIf panel) {
        ITRTableAb tabela = ((PainelCondominosLista)panel).getTabela();
        int indiceModel = pendencia.getNumItem() - 1;
        int indiceTabela = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToView(indiceModel);
        tabela.setRowSelectionInterval(indiceTabela, indiceTabela);
        ((PainelCondominosLista)panel).onBtnAbrirClick(null);
    }

    private void tratarTelaLista(Pendencia pendencia, PainelDeclaracaoIf panel) {
        ITRTableAb tabela = ((PainelListaAb)panel).getTabela();
        int indiceModel = pendencia.getNumItem() - 1;
        int indiceTabela = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToView(indiceModel);
        tabela.setRowSelectionInterval(indiceTabela, indiceTabela);
        ((PainelListaAb)panel).onBtnAbrirClick(null);
    }

    public void selecionaPendencia(Pendencia pendencia) {
        super.selecionaPendencia(pendencia);
        ITRUtil.setEstadoSistema(0);
    }

    public Pendencia getPendenciaSelecionada() {
        return this.pendenciaSelecionada;
    }

    protected void setPendenciaSelecionada(Pendencia pendenciaSelecionada) {
        this.pendenciaSelecionada = pendenciaSelecionada;
    }

    private class LabelPendenciaCellRenderer
    extends DefaultTableCellRenderer {
        private final Color COR_BG_TITULO_FICHA = new Color(205, 224, 239);
        private final Color COR_BG_LINHA_ALTERNADA = new Color(234, 242, 251);

        private LabelPendenciaCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof LinhaPendencia) {
                LinhaPendencia linhaPendencia = (LinhaPendencia)value;
                if (linhaPendencia.getSeveridade() == 0) {
                    String texto = linhaPendencia.getCampo();
                    texto = texto.replaceAll("(?i)<BR>", " ");
                    texto = texto.replaceAll("\n", " ");
                    texto = texto.replaceAll("(?i)<HTML>", " ");
                    texto = texto.replaceAll("(?i)</HTML>", " ");
                    c.setText("<html><b>" + texto + "</b></html>");
                    c.setForeground(Color.BLACK);
                    c.setBackground(this.COR_BG_TITULO_FICHA);
                } else {
                    String texto = linhaPendencia.getCampo();
                    texto = texto.replaceAll("(?i)<BR>", " ");
                    texto = texto.replaceAll("\n", " ");
                    texto = texto.replaceAll("(?i)<HTML>", " ");
                    texto = texto.replaceAll("(?i)</HTML>", " ");
                    c.setBackground(row % 2 == 0 ? this.COR_BG_LINHA_ALTERNADA : Color.WHITE);
                    if (mouseColumn > -1 && mouseColumn == column && mouseRow > -1 && mouseRow == row) {
                        c.setText("<html><u>" + UtilitariosString.insereQuebraDeLinha((String)texto, (int)107, (String)"<br>") + "</u></html>");
                        c.setForeground(Color.BLUE);
                    } else {
                        c.setText("<html>" + UtilitariosString.insereQuebraDeLinha((String)texto, (int)107, (String)"<br>") + "</html>");
                        c.setForeground(Color.BLACK);
                    }
                }
                if (EditTablePendenciasITR.this.getRowHeight(row) != c.getPreferredSize().height + 30) {
                    EditTablePendenciasITR.this.setRowHeight(row, c.getPreferredSize().height + 30);
                }
            } else {
                c.setHorizontalAlignment(0);
                if (value == null) {
                    c.setBackground(this.COR_BG_TITULO_FICHA);
                } else {
                    c.setBackground(row % 2 == 0 ? this.COR_BG_LINHA_ALTERNADA : Color.WHITE);
                }
                if (value != null && value instanceof ImageIcon && ((ImageIcon)value).getDescription() != null) {
                    if (((ImageIcon)value).getDescription().toLowerCase().contains("atencao")) {
                        c.getAccessibleContext().setAccessibleName("Aten\u00e7\u00e3o");
                    } else if (((ImageIcon)value).getDescription().toLowerCase().contains("erro")) {
                        c.getAccessibleContext().setAccessibleName("Erro");
                    }
                }
            }
            return this;
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
            } else {
                this.setIcon(null);
                super.setValue(value);
            }
        }
    }
}

