/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.util;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.StringEscapeUtils;
import serpro.ppgd.gui.pendencia.MapeamentoInformacaoEditCampo;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.JEditCodigo;
import serpro.ppgd.gui.xbeans.JEditLogico;
import serpro.ppgd.gui.xbeans.JEditOpcao;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.exception.NegocioException;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.gui.JEditCodigoKeyListener;
import serpro.ppgd.itr.gui.JanelaPrincipalITR;
import serpro.ppgd.itr.gui.PainelDeclaracaoAb;
import serpro.ppgd.itr.gui.PainelDeclaracaoIf;
import serpro.ppgd.itr.gui.componente.JCustomDialog;
import serpro.ppgd.itr.gui.componente.JHTMLPane;
import serpro.ppgd.itr.gui.util.DisabledGlassPane;
import serpro.ppgd.itr.util.HTMLUtil;
import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;

public class GuiUtil {
    public static final String FLAG_EXIBE_QUADRO_AVISO = "FLAG_EXIBE_QUADRO_AVISO";
    public static final String FLAG_DESATIVAR_ABERTURA = "FLAG_DESATIVAR_ABERTURA";
    public static final String OPCAO_DESATIVA_QUADRO_AVISO = "OPCAO_DESATIVA_QUADRO_AVISO";
    public static final String OPCAO_ATIVA_QUADRO_AVISO = "OPCAO_ATIVA_QUADRO_AVISO";
    public static final boolean HABILITA_QUADRO_NOVIDADES = true;
    private static HashMap<String, ImageIcon> cacheImagens;
    private static Font fonteSistema;
    private static String[] listaComponentesTemDeclaracao;

    public static Component getParent() {
        PlataformaPPGD lPlataformaPPGD = PlataformaPPGD.getPlataforma();
        JFrame lPai = null;
        if (lPlataformaPPGD != null) {
            try {
                lPai = lPlataformaPPGD.getJanelaPrincipal();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return lPai;
    }

    public static Component getParent(JPanel painel) {
        return SwingUtilities.getRoot(painel);
    }

    private static String getTituloTelaConfirmacao() {
        return MensagemUtil.getMensagem("TituloConfirmacao");
    }

    private static String getTituloTelaErro() {
        return MensagemUtil.getMensagem("TituloMensagemErro");
    }

    private static String getTituloTelaInfo() {
        return MensagemUtil.getMensagem("TituloMensagemInfo");
    }

    private static String getTituloTelaAviso() {
        return MensagemUtil.getMensagem("TituloMensagemAviso");
    }

    public static void mostrarErro(Component pPai, String pMensagem) {
        JOptionPane.showMessageDialog(pPai, pMensagem, GuiUtil.getTituloTelaErro(), 0);
    }

    public static boolean mostrarErroHTML(String pMensagem, String pTitulo, int pTipoMsg) {
        boolean erroHtml = true;
        if (pTipoMsg == 0 && pMensagem.toUpperCase().contains("C021")) {
            GuiUtil.mostrarErroHTML(HTMLUtil.obterMensagemHTMLComQuebraDeLinhas(MensagemUtil.getMensagem("C021"), 0), pTitulo);
        } else {
            erroHtml = false;
        }
        return erroHtml;
    }

    public static void mostrarErroHTML(String pMensagem, String pTitulo) {
        JHTMLPane pane = new JHTMLPane(pMensagem);
        pane.setOpaque(false);
        String msgAcessivel = StringEscapeUtils.unescapeHtml3((String)pMensagem.replaceAll("\\<.*?\\>", ""));
        GuiUtil.mostrarErro(GuiUtil.getParent(), pane, msgAcessivel, pTitulo);
    }

    public static void mostrarErro(Component pPai, Object pMensagem, String pMensagemAcessivel, String pTitulo) {
        JOptionPane pane = new JOptionPane(pMensagem, 0);
        pane.getAccessibleContext().setAccessibleDescription(pMensagemAcessivel);
        JDialog dialog = pane.createDialog(pPai, pTitulo);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void mostrarErro(String pChaveMsg) {
        GuiUtil.mostrarErro(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg));
    }

    public static void mostrarErro(String pChaveMsg, String[] pArgs) {
        GuiUtil.mostrarErro(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg, pArgs));
    }

    public static void mostrarErro(Exception pExcecao) {
        GuiUtil.mostrarErro(GuiUtil.getParent(), pExcecao.getMessage());
    }

    public static void mostrarErroFoco(NegocioException pExcecao) {
        GuiUtil.mostrarErro(GuiUtil.getParent(), pExcecao.getMessage());
        JComponent jComponent = (JComponent)MapeamentoInformacaoEditCampo.getEditAssociado((Informacao)pExcecao.getInformacao());
        jComponent.requestFocusInWindow();
    }

    public static void mostrarAviso(Component pPai, String pMensagem) {
        JOptionPane.showMessageDialog(pPai, pMensagem, GuiUtil.getTituloTelaAviso(), 2);
    }

    public static void mostrarAviso(String pChaveMsg) {
        GuiUtil.mostrarAviso(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg));
    }

    public static void mostrarAviso(String pChaveMsg, String[] pArgs) {
        GuiUtil.mostrarAviso(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg, pArgs));
    }

    public static void mostrarInfo(Component pPai, String pMensagem) {
        JOptionPane.showMessageDialog(pPai, pMensagem, GuiUtil.getTituloTelaInfo(), 1);
    }

    public static void mostrarInfo(String pChaveMsg) {
        GuiUtil.mostrarInfo(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg));
    }

    public static void mostrarInfo(String pChaveMsg, String[] pArgs) {
        GuiUtil.mostrarInfo(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg, pArgs));
    }

    public static boolean mostrarConfirma(Component pPai, String pMensagem) {
        return JOptionPane.showConfirmDialog(pPai, pMensagem, GuiUtil.getTituloTelaConfirmacao(), 0, 3) == 0;
    }

    public static boolean mostrarConfirma(Component pPai, String pMensagem, String pTitulo) {
        return JOptionPane.showConfirmDialog(pPai, pMensagem, pTitulo, 0, 3) == 0;
    }

    public static boolean mostrarConfirma(String pChaveMsg) {
        return GuiUtil.mostrarConfirma(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg));
    }

    public static boolean mostrarConfirma(String pChaveMsg, String pTitulo) {
        return GuiUtil.mostrarConfirma(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg), pTitulo);
    }

    public static boolean mostrarConfirma(String pChaveMsg, String[] pArgsMsg) {
        return GuiUtil.mostrarConfirma(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg, pArgsMsg));
    }

    public static boolean mostrarConfirma(String pChaveMsg, String[] pArgsMsg, String pTitulo) {
        return GuiUtil.mostrarConfirma(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha(pChaveMsg, pArgsMsg), pTitulo);
    }

    public static void exibeDialog(Object pPai, JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, Integer pLargura, Integer pAltura) {
        GuiUtil.exibeDialog(pPai, pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura, false);
    }

    public static void exibeDialog(Object pPai, JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, Integer pLargura, Integer pAltura, boolean pInibeSairNaoProgramado) {
        GuiUtil.exibeDialog(pPai, pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura, pInibeSairNaoProgramado, 2, true, false);
    }

    public static JDialog novoDialog(Object parent, JComponent c, boolean modal, String tit, boolean resizable) {
        JDialog dlg = null;
        dlg = parent == null ? new JDialog((Frame)null, tit, modal) : (parent instanceof Dialog ? new JDialog((Dialog)parent, tit, modal) : (parent instanceof Frame ? new JDialog((Frame)parent, tit, modal){

            protected void finalize() throws Throwable {
                super.finalize();
            }
        } : new JDialog((Frame)null, tit, modal)));
        dlg.getContentPane().add(c);
        dlg.pack();
        dlg.setLocationRelativeTo(null);
        dlg.setResizable(resizable);
        dlg.setDefaultCloseOperation(0);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JDialog d = (JDialog)e.getSource();
                d.setVisible(false);
                d.dispose();
            }
        });
        return dlg;
    }

    public static void exibeDialog(Object pPai, JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, Integer pLargura, Integer pAltura, boolean pInibeSairNaoProgramado, int defaultCloseOperation, boolean exibeBarraTitulo, boolean disabledGlass) {
        JComponent lComponent;
        GuiUtil.adicionarEnterComoTeclaDeNavegacao((JPanel)pComp);
        JCustomDialog lDialogo = null;
        if (pPai == null) {
            lDialogo = new JCustomDialog((Frame)null, pTitulo, pModal, pInibeSairNaoProgramado);
        } else if (pPai instanceof Dialog) {
            lDialogo = new JCustomDialog((Dialog)pPai, pTitulo, pModal, pInibeSairNaoProgramado);
            lDialogo.setLocationRelativeTo((Dialog)pPai);
        } else {
            lDialogo = pPai instanceof Frame ? new JCustomDialog((Frame)pPai, pTitulo, pModal, pInibeSairNaoProgramado) : new JCustomDialog((Frame)null, pTitulo, pModal, pInibeSairNaoProgramado);
        }
        lDialogo.getContentPane().add(pComp);
        lDialogo.setUndecorated(!exibeBarraTitulo);
        lDialogo.setDefaultCloseOperation(defaultCloseOperation);
        if (pComp instanceof WindowListener) {
            lDialogo.addWindowListener((WindowListener)((Object)pComp));
        }
        if (pComp instanceof PainelDeclaracaoIf) {
            ((PainelDeclaracaoIf)((Object)pComp)).initListener();
        }
        if (pLargura != null && pAltura != null) {
            lDialogo.setSize(pLargura, pAltura);
        } else {
            lDialogo.pack();
        }
        lDialogo.setLocationRelativeTo(null);
        lDialogo.setResizable(pRedimensionavel);
        if (pComp instanceof PainelDeclaracaoAb && (lComponent = ((PainelDeclaracaoAb)pComp).getDefaultFocus()) != null && ITRUtil.getEstadoSistema() != 1) {
            lComponent.requestFocusInWindow();
        }
        if (disabledGlass) {
            Component glassPaneAnterior = PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane();
            DisabledGlassPane glassPane = new DisabledGlassPane();
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setGlassPane(glassPane);
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane();
            glassPane.activate("");
            lDialogo.setVisible(true);
            glassPane.deactivate();
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setGlassPane(glassPaneAnterior);
        } else {
            lDialogo.setVisible(true);
        }
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().repaint();
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().validate();
    }

    public static void exibePainelDeclaracao(Object pPai, JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, Integer pLargura, Integer pAltura) {
        GuiUtil.exibeDialog(pPai, pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura);
    }

    public static void exibeDialog(JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel) {
        GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), pComp, pModal, pTitulo, pRedimensionavel, null, null);
    }

    public static void exibePainelDeclaracao(JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel) {
        GuiUtil.exibePainelDeclaracao(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), pComp, pModal, pTitulo, pRedimensionavel, null, null);
    }

    public static void exibeDialog(JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, int pLargura, int pAltura) {
        GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura);
    }

    public static void exibePainelDeclaracao(JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, int pLargura, int pAltura) {
        GuiUtil.exibePainelDeclaracao(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura);
    }

    public static ImageIcon getImage(String pPath) {
        ImageIcon lImg = cacheImagens.get(pPath);
        if (lImg == null) {
            lImg = new ImageIcon(GuiUtil.class.getResource(pPath));
            cacheImagens.put(pPath, lImg);
        }
        return lImg;
    }

    public static void abreURL(String pURL) {
        String os = System.getProperty("os.name").toLowerCase();
        try {
            if (os.startsWith("mac os")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, pURL);
            } else if (os.startsWith("windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + pURL);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    String lMensagem = MensagemUtil.getMensagem("NavegadorNaoEncontrado");
                    throw new Exception(lMensagem);
                }
                Runtime.getRuntime().exec(new String[]{browser, pURL});
            }
        }
        catch (Exception e) {
            GuiUtil.mostrarErro("ErroNavegadorInternet", new String[]{e.getLocalizedMessage()});
        }
    }

    public static void fecharDialog(JPanel pPainel) {
        Component lFramePai = SwingUtilities.getRoot(pPainel);
        if (lFramePai != null) {
            lFramePai.setVisible(false);
        }
    }

    public static void adicionarEnterComoTeclaDeNavegacao(JPanel pPainel) {
        Set<AWTKeyStroke> forwardKeys = pPainel.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(forwardKeys);
        newForwardKeys.add(KeyStroke.getKeyStroke(10, 0));
        pPainel.setFocusTraversalKeys(0, newForwardKeys);
        GuiUtil.manterTabComoTeclaDeNavegacao(pPainel);
    }

    public static void manterTabComoTeclaDeNavegacao(Container pPainel) {
        for (Component component : pPainel.getComponents()) {
            if (component instanceof JButton) {
                JButton btn = (JButton)component;
                HashSet<KeyStroke> set = new HashSet<KeyStroke>();
                set.add(KeyStroke.getKeyStroke(9, 0));
                btn.setFocusTraversalKeys(0, set);
                continue;
            }
            if (!(component instanceof Container)) continue;
            GuiUtil.manterTabComoTeclaDeNavegacao((Container)component);
        }
    }

    public static void setaFonteTodosLabelContainer(Container c) {
        GuiUtil.setaFonteTodosLabelContainer(c, fonteSistema);
    }

    public static void setaFonteTodosLabelContainer(Container c, Font pFonte) {
        Component[] components = c.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Font fonte = pFonte;
            if (components[i] instanceof JComponent && ((JComponent)components[i]).getBorder() instanceof TitledBorder) {
                TitledBorder t = (TitledBorder)((JComponent)components[i]).getBorder();
                t.setTitleFont(fonte);
            }
            if (components[i] instanceof JEditLogico || components[i] instanceof JLabel || components[i] instanceof JEditOpcao) {
                components[i].setFont(fonte);
                continue;
            }
            if (!(components[i] instanceof Container)) continue;
            GuiUtil.setaFonteTodosLabelContainer((Container)components[i], fonte);
        }
    }

    protected static Font obterFonteSistema() {
        boolean temArial = false;
        boolean temSansSerif = false;
        boolean temDialog = false;
        Font fontDefault = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontnames = ge.getAvailableFontFamilyNames();
        for (int i = 0; i < fontnames.length; ++i) {
            if (fontnames[i].equals("SansSerif")) {
                temSansSerif = true;
                continue;
            }
            if (fontnames[i].equals("Arial")) {
                temArial = true;
                continue;
            }
            if (!fontnames[i].equals("Dialog")) continue;
            temDialog = true;
        }
        boolean isLinux = false;
        if (System.getProperty("os.name").startsWith("Linux")) {
            isLinux = true;
            fontDefault = temSansSerif ? new Font("SansSerif", 0, 10) : (temArial ? new Font("Arial", 0, 10) : (temDialog ? new Font("Dialog", 0, 10) : new Font("Default", 0, 10)));
        } else {
            fontDefault = temSansSerif ? new Font("SansSerif", 0, 11) : (temArial ? new Font("Arial", 0, 10) : (temDialog ? new Font("Dialog", 0, 10) : new Font("Default", 0, 10)));
        }
        if (!isLinux) {
            UIManager.put("Button.font", fontDefault);
        }
        UIManager.put("RadioButton.font", fontDefault);
        UIManager.put("CheckBox.font", fontDefault);
        UIManager.put("FileChooser.font", fontDefault);
        UIManager.put("Label.font", fontDefault);
        UIManager.put("List.font", fontDefault);
        UIManager.put("RadioButtonMenuItem.font", fontDefault);
        UIManager.put("PopupMenu.font", fontDefault);
        UIManager.put("Frame.font", fontDefault);
        UIManager.put("Panel.font", fontDefault);
        UIManager.put("ScrollPane.font", fontDefault);
        UIManager.put("Viewport.font", fontDefault);
        UIManager.put("TabbedPane.font", fontDefault);
        UIManager.put("Table.font", fontDefault);
        UIManager.put("TextField.font", fontDefault);
        UIManager.put("FormattedTextField.font", fontDefault);
        UIManager.put("TextArea.font", fontDefault);
        UIManager.put("TextPane.font", fontDefault);
        UIManager.put("EditorPane.font", fontDefault);
        UIManager.put("TitledBorder.font", fontDefault);
        UIManager.put("ToolBar.font", fontDefault);
        UIManager.put("Tree.font", fontDefault);
        UIManager.put("EditValorTotal.font", fontDefault.deriveFont(1));
        return fontDefault;
    }

    public static void ajustaLabel(JLabel pCampo, int pMaximo) {
        String text = pCampo.getText();
        if (text.length() > pMaximo) {
            pCampo.setToolTipText(text);
            pCampo.setText(text.substring(0, pMaximo) + "...");
        }
    }

    public static void startWaitCursor() {
        Component lGlassPane = PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane();
        lGlassPane.setVisible(true);
        lGlassPane.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void stopWaitCursor() {
        Component lGlassPane = PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane();
        lGlassPane.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static int confirmaPaginado(String msg, String subTitulo, int indice, int total, int opcao, int tipoMsg) {
        StringBuffer titulo = new StringBuffer();
        if (total > 1) {
            titulo.append(subTitulo);
            titulo.append(" ");
            titulo.append(indice);
            titulo.append(" de ");
            titulo.append(total);
        }
        if (indice < total) {
            return GuiUtil.confirma(msg, titulo.toString(), opcao, tipoMsg);
        }
        if (opcao == 1) {
            return GuiUtil.confirma(msg, titulo.toString(), 0, tipoMsg);
        }
        GuiUtil.informa(msg, titulo.toString(), tipoMsg);
        return 0;
    }

    public static int confirma(String msg, String subTitulo, int opcao, int tipoMsg) {
        int ret;
        StringBuffer titulo = new StringBuffer("ITR " + ConstantesGlobais.EXERCICIO);
        if (subTitulo != null && subTitulo.length() > 0) {
            titulo.append(" - ");
            titulo.append(subTitulo);
        }
        if ((ret = JOptionPane.showConfirmDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), ITRUtil.inserirQuebraLinha(msg, 100, "\n"), titulo.toString(), opcao, tipoMsg)) == -1) {
            if (opcao == 0) {
                return 1;
            }
            return 2;
        }
        return ret;
    }

    public static void informa(String msg, String subTitulo, int tipoMsg) {
        StringBuffer strTitulo = new StringBuffer("ITR " + ConstantesGlobais.EXERCICIO);
        if (subTitulo != null && subTitulo.length() > 0) {
            strTitulo.append(" - ");
            strTitulo.append(subTitulo);
        }
        if (!GuiUtil.mostrarErroHTML(msg, strTitulo.toString(), tipoMsg)) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), ITRUtil.inserirQuebraLinha(msg, 100, "\n"), strTitulo.toString(), tipoMsg);
        }
    }

    public static void corrigeTeclaEnterComboMacintosh(JEditCodigo combo) {
        combo.setFocusTraversalKeys(0, GuiUtil.retirarEnterNavegacaoFoco((JComponent)combo));
        combo.getComponenteFoco().addKeyListener(new JEditCodigoKeyListener((JEditCampo)combo));
    }

    public static Set retirarEnterNavegacaoFoco(JComponent componente) {
        Set<AWTKeyStroke> oldForwardKeys = componente.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(oldForwardKeys);
        forwardKeys.remove(KeyStroke.getKeyStroke(10, 0));
        return forwardKeys;
    }

    public static void informaPaginado(String msg, String subTitulo, int indice, int total, int tipoMsg) {
        StringBuffer titulo = new StringBuffer();
        if (total > 1) {
            titulo.append(subTitulo);
            titulo.append(" ");
            titulo.append(indice);
            titulo.append(" de ");
            titulo.append(total);
        }
        GuiUtil.informa(msg, titulo.toString(), tipoMsg);
    }

    public static void atualizarTitulo() {
        StringBuffer title = new StringBuffer("Im\u00f3vel Rural: ");
        DeclaracaoITR dec = ControladorGui.getDeclaracaoAberta();
        if (dec != null) {
            title.append(dec.getImovel().getNomeImovel().formatado());
            title.append(" - CIB: ");
            title.append(ITRUtil.formatarIdentificacaoImovel(dec.getIdentificadorDeclaracao().getNirf().naoFormatado()));
            title.append("");
        }
        ((JanelaPrincipalITR)PlataformaPPGD.getPlataforma().getJanelaPrincipal()).getjMenuInfoContribuinte().setText(title.toString());
    }

    public static float getProporcaoTela16por9() {
        return 1.7777778f;
    }

    public static float getProporcaoTelaAtual() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        float width = 16.0f;
        float height = 10.0f;
        if (gd.getDisplayMode() != null) {
            width = gd.getDisplayMode().getWidth();
            height = gd.getDisplayMode().getHeight();
        }
        return width / height;
    }

    static {
        listaComponentesTemDeclaracao = new String[]{"menuDeclAbrir", "menuDeclExcluir", "menuDeclGravarParaSRF", "menuDeclImprimirDeclaracao", "menuDeclImprimirDarf", "menuFerrCopSegGravar", "buttonImprimir", "buttonAbrir", "buttonGravarCopiaSeg", "buttonGravarEntregaSRF"};
        cacheImagens = new HashMap();
    }
}

