/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.gui.util;

import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;
import org.icepdf.ri.common.ComponentKeyBinding;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.common.views.AnnotationCallback;
import serpro.ppgd.negocio.util.LogPPGD;

public class PdfUtil {
    public static void exibirPdf(String pdfBase64, String descricao, String nomeArquivo) {
        if (StringUtils.isEmpty((CharSequence)pdfBase64)) {
            LogPPGD.erro((String)"PDF informado inexistente ou n\u00ef\u00bf\u00bdo pode ser recuperado para exibi\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo.");
        }
        byte[] pdf = Base64.getDecoder().decode(pdfBase64);
        PdfUtil.exibirPdf(pdf, descricao, nomeArquivo);
    }

    public static void exibirPdf(byte[] pdf, String descricao, String nomeArquivo) {
        SwingController controller = new SwingController();
        SwingViewBuilder factory = new SwingViewBuilder(controller);
        JPanel viewerComponentPanel = factory.buildViewerPanel();
        ComponentKeyBinding.install((SwingController)controller, (JComponent)viewerComponentPanel);
        controller.getDocumentViewController().setAnnotationCallback((AnnotationCallback)new MyAnnotationCallback(controller.getDocumentViewController()));
        controller.openDocument(pdf, 0, pdf.length, descricao, nomeArquivo);
        controller.setPageViewMode(2, true);
        controller.setPageFitMode(4, false);
        controller.getDocumentViewController().setZoom(1.0f);
        JFrame window = new JFrame(descricao);
        window.getContentPane().add(viewerComponentPanel);
        window.setDefaultCloseOperation(2);
        window.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        window.pack();
        window.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gerarArquivo(String pNome, byte[] pConteudo) {
        FileOutputStream outputStream;
        block4: {
            outputStream = null;
            File file = new File(pNome);
            try {
                if (file.exists()) break block4;
                outputStream = FileUtils.openOutputStream((File)file);
                ((OutputStream)outputStream).write(pConteudo);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
        IOUtils.closeQuietly(outputStream);
    }

    public static void apagarArquivo(File caminho) {
        if (caminho.isFile()) {
            caminho.delete();
        }
    }

    public static void gravarArquivo(String pdfBase64, String caminhoArquivo) {
        byte[] pdfByte = Base64.getDecoder().decode(pdfBase64);
        PdfUtil.apagarArquivo(new File(caminhoArquivo));
        PdfUtil.gerarArquivo(caminhoArquivo, pdfByte);
    }

    public static byte[] mergePdfs(String[] pdfs, String destino) {
        byte[] pdfGerado = null;
        try {
            PDFMergerUtility ut = new PDFMergerUtility();
            for (String pdfBase64 : pdfs) {
                ByteArrayInputStream pdf = new ByteArrayInputStream(Base64.getDecoder().decode(pdfBase64));
                ut.addSource((InputStream)pdf);
            }
            ut.setDestinationFileName(destino);
            ut.mergeDocuments();
            File file = new File(destino);
            pdfGerado = Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            LogPPGD.erro((String)("Ocorreu um erro ao fazer o merge de PDFs: " + e.getMessage()));
        }
        return pdfGerado;
    }

    public static void imprimir(String[] pdfs, String destino) {
        File f = new File(destino);
        try {
            PdfUtil.mergePdfs(pdfs, destino);
            PDDocument document = PDDocument.load((File)f);
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPageable((Pageable)new PDFPageable(document));
            job.setPrintService(PrinterJob.getPrinterJob().getPrintService());
            job.print();
            document.close();
            PdfUtil.apagarArquivo(f);
            LogPPGD.debug((String)"O arquivo PDF foi enviado para impress\u00e3o com sucesso.");
        }
        catch (PrinterException | IOException e) {
            LogPPGD.erro((String)("Ocorreu uma falha na impress\u00e3o do PDF: " + e.getMessage()));
        }
    }

    public static void abrirPdfComVisualizadorPadrao(String pdfBase64, String nomeArquivo) {
        if (StringUtils.isEmpty((CharSequence)pdfBase64)) {
            LogPPGD.erro((String)"PDF informado inexistente ou n\u00e3o pode ser recuperado para exibi\u00e7\u00e3o.");
        }
        byte[] pdf = Base64.getDecoder().decode(pdfBase64);
        PdfUtil.abrirPdfComVisualizadorPadrao(pdf, nomeArquivo);
    }

    public static void abrirPdfComVisualizadorPadrao(byte[] pdf, String nomeArquivo) {
        try {
            File tempFile = File.createTempFile(nomeArquivo, ".pdf");
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])pdf);
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(tempFile);
            } else {
                LogPPGD.erro((String)"Abertura de PDF com o visualizador padr\u00e3o do sistema n\u00e3o suportada neste ambiente.");
            }
        }
        catch (IOException e) {
            LogPPGD.erro((String)("Ocorreu um erro ao tentar abrir o PDF com o visualizador padr\u00e3o\u00a3o do sistema: " + e.getMessage()));
        }
    }

    public static void abrirPdfSistema(byte[] pdf, String descricao, String nomeArquivo) {
        if (pdf == null || pdf.length == 0) {
            LogPPGD.erro((String)"PDF informado inexistente ou n\u00c3\u00a3o pode ser recuperado para exibi\u00e7\u00e3o.");
            return;
        }
        try {
            File arquivoTemp = File.createTempFile(nomeArquivo, ".pdf");
            arquivoTemp.deleteOnExit();
            Files.write(arquivoTemp.toPath(), pdf, new OpenOption[0]);
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                if (desktop.isSupported(Desktop.Action.OPEN)) {
                    desktop.open(arquivoTemp);
                    LogPPGD.debug((String)("PDF aberto com visualizador padr\u00e3o do sistema: " + descricao));
                } else {
                    LogPPGD.erro((String)"Abertura do PDF n\u00e3o suportada pelo sistema.");
                }
            } else {
                LogPPGD.erro((String)"N\u00e3o suportado pelo sistema.");
            }
        }
        catch (IOException e) {
            LogPPGD.erro((String)("Erro ao abrir PDF com visualizador do sistema: " + e.getMessage()));
        }
    }

    public static void abrirPdfSistema(String pdfBase64, String descricao, String nomeArquivo) {
        if (StringUtils.isEmpty((CharSequence)pdfBase64)) {
            LogPPGD.erro((String)"PDF informado inexistente ou n\u00c3\u00a3o pode ser recuperado para exibi\u00e7\u00e3o.");
            return;
        }
        byte[] pdf = Base64.getDecoder().decode(pdfBase64);
        PdfUtil.abrirPdfSistema(pdf, descricao, nomeArquivo);
    }
}

