/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.imovel;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import serpro.ppgd.itr.AreaHectares;
import serpro.ppgd.itr.CodigoIncra;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.ObservadorEspacosDuplicados;
import serpro.ppgd.itr.ValidadorCaracteres;
import serpro.ppgd.itr.gui.imovel.PainelImovel;
import serpro.ppgd.itr.imovel.ValidadorMudancaAreaIsencao;
import serpro.ppgd.itr.imovel.ValidadorMudancaCondominioIsencao;
import serpro.ppgd.itr.imovel.ValidadorMudancaMunicipioIsencao;
import serpro.ppgd.itr.tabelas.CadastroTabelasITR;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CEP;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCEP;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNrImovelIncra;

public class Imovel
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String LABEL_PESSOA_FISICA = "Pessoa F\u00edsica";
    public static final String LABEL_PESSOA_JURIDICA = "Pessoa Jur\u00eddica";
    public static final String PESSOA_FISICA = "1";
    public static final String PESSOA_JURIDICA = "2";
    public static final String DECLARANTE_PESSOA_FISICA = "2";
    public static final String DECLARANTE_PESSOA_JURIDICA = "4";
    public static final String IND_LOC_DEMAIS_REGIOES = "1";
    public static final String IND_LOC_AMAZONIA_ORIENTAL = "2";
    public static final String IND_LOC_POLIGONO_DA_SECA = "3";
    public static final String IND_LOC_AMAZONIA_OCIDENTAL = "4";
    public static final String IND_LOC_PANTANAL = "5";
    public static final String LABEL_MOTIVO_ISENCAO = "Motivo - ";
    public static final String OPCAO_MOTIVO_ISENCAO_A = "A";
    public static final String OPCAO_MOTIVO_ISENCAO_B = "B";
    public static final String OPCAO_MOTIVO_ISENCAO_C = "C";
    public static final String OPCAO_MOTIVO_ISENCAO_D = "D";
    public static final String OPCAO_MOTIVO_ISENCAO_E = "E";
    public static final String FLAG_DECLARACAO_ENQUADRADA = "1";
    public static final String FLAG_DECLARACAO_NAO_ENQUADRADA = "2";
    public static final List<String> LISTA_OPCOES_MOTIVO_ISENCAO = Arrays.asList("A", "B", "C", "D", "E");
    private IdentificadorDeclaracao identificadorDeclaracao;
    private Alfa nomeImovel;
    private CodigoIncra codigoIncra = new CodigoIncra(this, "C\u00f3digo do Im\u00f3vel no INCRA");
    private AreaHectares areaTotal = new AreaHectares(this, "\u00c1rea Total do Im\u00f3vel - ha");
    private Codigo tipoLogradouro = new Codigo((ObjetoNegocio)this, "Tipo do Logradouro", CadastroTabelasITR.getTiposLogradouroImovel());
    private Alfa logradouro = new Alfa((ObjetoNegocio)this, "Logradouro", 56);
    private Alfa distrito = new Alfa((ObjetoNegocio)this, "Distrito", 40);
    private CEP cep = new CEP((ObjetoNegocio)this, "CEP");
    private Codigo uf = new Codigo((ObjetoNegocio)this, "UF", CadastroTabelasITR.getUfs());
    private Codigo municipio = new Codigo((ObjetoNegocio)this, "Munic\u00edpio de Localiza\u00e7\u00e3o do Im\u00f3vel (Domic\u00edlio Tribut\u00e1rio)", new Vector());
    private Logico pessoaFisica = new Logico((ObjetoNegocio)this, "Tipo Contribuinte");
    private Logico isento = new Logico((ObjetoNegocio)this, "O im\u00f3vel est\u00e1 imune ou isento do ITR?");
    private Logico pertenceCondominio = new Logico((ObjetoNegocio)this, "O Im\u00f3vel pertence a um condom\u00ednio?");
    private Alfa nomeMunicipio = new Alfa((ObjetoNegocio)this, "Nome do Munic\u00edpio");
    private Alfa motivoIsencao = new Alfa((ObjetoNegocio)this, "Motivo Isen\u00e7\u00e3o");
    private Alfa enquadrada = new Alfa((ObjetoNegocio)this, "Declara\u00e7\u00e3o enquadrada?");
    private Alfa ultimoEnquadramento = new Alfa((ObjetoNegocio)this, "Ultimo Enquadramento");
    private static final String NOME_FICHA = "Dados do Im\u00f3vel Rural";

    public Imovel(IdentificadorDeclaracao id) {
        this.identificadorDeclaracao = id;
        this.nomeImovel = this.identificadorDeclaracao.getNomeImovel();
        this.uf.setSimples(true);
        this.uf.setColunaFiltro(0);
        this.municipio.setSimples(true);
        this.municipio.setColunaFiltro(1);
        this.pessoaFisica.addOpcao("1", LABEL_PESSOA_FISICA);
        this.pessoaFisica.addOpcao("2", LABEL_PESSOA_JURIDICA);
        this.pessoaFisica.setConteudo("1");
        this.isento.addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.isento.addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.isento.setConteudo(Logico.NAO);
        this.pertenceCondominio.addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.pertenceCondominio.addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.pertenceCondominio.setConteudo(Logico.NAO);
        this.tipoLogradouro.setSimples(true);
        this.tipoLogradouro.setColunaFiltro(0);
        this.adicionarObservadores();
        this.adicionarValidadores();
        this.setFicha(NOME_FICHA);
    }

    private void adicionarValidadores() {
        this.nomeImovel.addValidador((ValidadorIf)new ValidadorCaracteres(3, MensagemUtil.getMensagem("110250"), "[a-zA-Z0-9\u00e7\u00c7\\s'&.,\\-\\\\/\u00e2\u00c2\u00e1\u00c1\u00e9\u00c9\u00ed\u00cd\u00f3\u00d3\u00fa\u00da\u00ea\u00ca\u00f4\u00d4\u00fc\u00dc\u00e0\u00c0\u00e3\u00c3\u00f5\u00d5]*"));
        this.nomeImovel.addValidador((ValidadorIf)new ValidadorNaoNulo(2, MensagemUtil.getMensagem("15")));
        this.codigoIncra.addValidador((ValidadorIf)new ValidadorNaoNulo(2, MensagemUtil.getMensagem("179")));
        this.codigoIncra.addValidador((ValidadorIf)new ValidadorNrImovelIncra(3, MensagemUtil.getMensagem("180")));
        this.codigoIncra.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("180")){

            public RetornoValidacao validarImplementado() {
                if (this.getInformacao().naoFormatado().trim().equalsIgnoreCase("0000000000000")) {
                    return new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                }
                return null;
            }
        });
        this.tipoLogradouro.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("66")));
        this.logradouro.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("65")));
        this.logradouro.addValidador((ValidadorIf)new ValidadorCaracteres(3, MensagemUtil.getMensagem("110250"), "[a-zA-Z0-9\u00e7\u00c7\\s'/;(),.\\-\u00e2\u00c2\u00e1\u00c1\u00e9\u00c9\u00ed\u00cd\u00f3\u00d3\u00fa\u00da\u00ea\u00ca\u00f4\u00d4\u00fc\u00dc\u00e0\u00c0\u00e3\u00c3\u00f5\u00d5]*"));
        this.distrito.addValidador((ValidadorIf)new ValidadorCaracteres(3, MensagemUtil.getMensagem("110250"), "[a-zA-Z0-9\u00e7\u00c7\\s'/;(),.\\-\u00e2\u00c2\u00e1\u00c1\u00e9\u00c9\u00ed\u00cd\u00f3\u00d3\u00fa\u00da\u00ea\u00ca\u00f4\u00d4\u00fc\u00dc\u00e0\u00c0\u00e3\u00c3\u00f5\u00d5]*"));
        this.cep.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("75")));
        this.cep.addValidador((ValidadorIf)new ValidadorCEP(3){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = super.validarImplementado();
                if (retorno != null) {
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("77"));
                }
                return retorno;
            }
        });
        ValidadorNaoNulo validadorCepMunicipio = new ValidadorNaoNulo(2){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = new RetornoValidacao(this.getSeveridade());
                if (!Imovel.this.getMunicipio().isVazio() && !Imovel.this.getCep().isVazio()) {
                    int cepIni2 = 0;
                    int cepFim2 = 0;
                    int cepIni3 = 0;
                    int cepFim3 = 0;
                    int cepIni1 = Integer.parseInt(Imovel.this.municipio.getConteudoAtual(4).substring(0, 8));
                    int cepFim1 = Integer.parseInt(Imovel.this.municipio.getConteudoAtual(4).substring(8, 16));
                    if (Imovel.this.municipio.getConteudoAtual(4).length() >= 32) {
                        cepIni2 = Integer.parseInt(Imovel.this.municipio.getConteudoAtual(4).substring(16, 24));
                        cepFim2 = Integer.parseInt(Imovel.this.municipio.getConteudoAtual(4).substring(24, 32));
                        if (Imovel.this.municipio.getConteudoAtual(4).length() >= 48) {
                            cepIni3 = Integer.parseInt(Imovel.this.municipio.getConteudoAtual(4).substring(32, 40));
                            cepFim3 = Integer.parseInt(Imovel.this.municipio.getConteudoAtual(4).substring(40, 48));
                        }
                    }
                    int cepDigitado = 0;
                    try {
                        cepDigitado = Integer.parseInt(Imovel.this.getCep().naoFormatado().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (cepDigitado == 0) {
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("76"));
                        return retorno;
                    }
                    if (!(cepDigitado >= cepIni1 && cepDigitado <= cepFim1 || cepDigitado >= cepIni2 && cepDigitado <= cepFim2 || cepDigitado >= cepIni3 && cepDigitado <= cepFim3)) {
                        retorno.setMensagemValidacao(MensagemUtil.getMensagem("76"));
                        return retorno;
                    }
                }
                return null;
            }
        };
        this.cep.addValidador((ValidadorIf)validadorCepMunicipio);
        this.uf.addValidador((ValidadorIf)new ValidadorNaoNulo(3, MensagemUtil.getMensagem("80")));
        this.municipio.addValidador((ValidadorIf)new ValidadorNaoNulo(3, "Munic\u00edpio ausente."));
        this.municipio.addValidador((ValidadorIf)new ValidadorMudancaMunicipioIsencao("", this));
        this.getAreaTotal().addValidador((ValidadorIf)new ValidadorMudancaAreaIsencao("", this));
        ValidadorMudancaCondominioIsencao validadorCondominioIsencaoSim = new ValidadorMudancaCondominioIsencao("", this);
        validadorCondominioIsencaoSim.setValorOpcaoDoLogico(Logico.SIM);
        this.getPertenceCondominio().addValidador((ValidadorIf)validadorCondominioIsencaoSim);
        ValidadorMudancaCondominioIsencao validadorCondominioIsencaoNao = new ValidadorMudancaCondominioIsencao("", this);
        validadorCondominioIsencaoNao.setValorOpcaoDoLogico(Logico.NAO);
        this.getPertenceCondominio().addValidador((ValidadorIf)validadorCondominioIsencaoNao);
        this.getPertenceCondominio().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Imovel.this.getIsento().formatado().equals(Logico.SIM)) {
                    if (Imovel.this.getPertenceCondominio().formatado().equals(Logico.SIM)) {
                        if (Imovel.this.getMotivoIsencao().formatado().equals(Imovel.OPCAO_MOTIVO_ISENCAO_A)) {
                            String msg = MensagemUtil.getMensagem("110380");
                            this.setMensagemValidacao(msg);
                            return new RetornoValidacao(msg);
                        }
                        if (Imovel.this.getMotivoIsencao().formatado().equals(Imovel.OPCAO_MOTIVO_ISENCAO_B)) {
                            String msg = MensagemUtil.getMensagem("110390");
                            this.setMensagemValidacao(msg);
                            return new RetornoValidacao(msg);
                        }
                    } else if (Imovel.this.getPertenceCondominio().formatado().equals(Logico.NAO) && Imovel.this.getMotivoIsencao().formatado().equals(Imovel.OPCAO_MOTIVO_ISENCAO_C)) {
                        String msg = MensagemUtil.getMensagem("110400");
                        this.setMensagemValidacao(msg);
                        return new RetornoValidacao(msg);
                    }
                }
                return null;
            }
        });
        ValidadorNaoNulo validadorMotivoIsencaoVazio = new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retorno = new RetornoValidacao(this.getSeveridade());
                if (Imovel.this.isento.formatado().equals(Logico.SIM) && (Imovel.this.motivoIsencao.isVazio() || !LISTA_OPCOES_MOTIVO_ISENCAO.contains(Imovel.this.motivoIsencao.formatado()))) {
                    retorno.setMensagemValidacao(MensagemUtil.getMensagem("215"));
                    return retorno;
                }
                return null;
            }
        };
        this.motivoIsencao.addValidador((ValidadorIf)validadorMotivoIsencaoVazio);
        ValidadorNaoNulo validadorRetificadora = new ValidadorNaoNulo(3, MensagemUtil.getMensagem("185"));
        this.identificadorDeclaracao.getRetificadora().addValidador((ValidadorIf)validadorRetificadora);
        ValidadorNaoNulo validadorAreaZerada = new ValidadorNaoNulo(3);
        validadorAreaZerada.setMensagemValidacao(MensagemUtil.getMensagem("20"));
        this.getAreaTotal().addValidador((ValidadorIf)validadorAreaZerada);
    }

    private void adicionarObservadores() {
        this.municipio.addObservador(new Observador(){

            public void notifica(Object object, String string, Object object0, Object object1) {
                Imovel.this.getAreaTotal().disparaObservadores();
                if (!Imovel.this.municipio.isVazio()) {
                    Imovel.this.nomeMunicipio.setConteudo(UtilitariosString.removeAcentos((String)Imovel.this.municipio.getConteudoAtual(1)));
                } else {
                    Imovel.this.nomeMunicipio.clear();
                }
            }
        });
        this.uf.addObservador(new Observador(){

            public void notifica(Object object, String string, Object object0, Object object1) {
                String conteudoUf = Imovel.this.uf.getConteudoAtual(0);
                if (conteudoUf != null && conteudoUf.trim().length() > 0) {
                    Imovel.this.municipio.clear();
                    Imovel.this.municipio.setColecaoElementoTabela(CadastroTabelasITR.getListaMunicipios(conteudoUf.trim()));
                }
            }
        });
        this.logradouro.addObservador((Observador)new ObservadorEspacosDuplicados());
        this.distrito.addObservador((Observador)new ObservadorEspacosDuplicados());
    }

    protected List recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.identificadorDeclaracao.getRetificadora());
        retorno.add(this.identificadorDeclaracao.getNumeroReciboDeclaracaoAnterior());
        retorno.add(this.nomeImovel);
        retorno.add(this.areaTotal);
        retorno.add(this.codigoIncra);
        retorno.add(this.tipoLogradouro);
        retorno.add(this.logradouro);
        retorno.add(this.distrito);
        retorno.add(this.uf);
        retorno.add(this.municipio);
        retorno.add(this.cep);
        retorno.add(this.motivoIsencao);
        retorno.add(this.pertenceCondominio);
        return retorno;
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao() {
        return this.identificadorDeclaracao;
    }

    public void setIdentificadorDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
    }

    public Alfa getNomeImovel() {
        return this.nomeImovel;
    }

    public void setNomeImovel(Alfa nomeImovel) {
        this.nomeImovel = nomeImovel;
    }

    public CodigoIncra getCodigoIncra() {
        return this.codigoIncra;
    }

    public void setCodigoIncra(CodigoIncra codigoIncra) {
        this.codigoIncra = codigoIncra;
    }

    public AreaHectares getAreaTotal() {
        return this.areaTotal;
    }

    public void setAreaTotal(AreaHectares areaTotal) {
        this.areaTotal = areaTotal;
    }

    public Codigo getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    public void setTipoLogradouro(Codigo tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    public Alfa getDistrito() {
        return this.distrito;
    }

    public void setDistrito(Alfa distrito) {
        this.distrito = distrito;
    }

    public CEP getCep() {
        return this.cep;
    }

    public void setCep(CEP cep) {
        this.cep = cep;
    }

    public Codigo getUf() {
        return this.uf;
    }

    public void setUf(Codigo uf) {
        this.uf = uf;
    }

    public Codigo getMunicipio() {
        return this.municipio;
    }

    public void setMunicipio(Codigo municipio) {
        this.municipio = municipio;
    }

    public Alfa getNomeMunicipio() {
        return this.nomeMunicipio;
    }

    public void setNomeMunicipio(Alfa nomeMunicipio) {
        this.nomeMunicipio = nomeMunicipio;
    }

    public Logico getPessoaFisica() {
        return this.pessoaFisica;
    }

    public void setPessoaFisica(Logico pessoaFisica) {
        this.pessoaFisica = pessoaFisica;
    }

    public Logico getIsento() {
        return this.isento;
    }

    public void setIsento(Logico isento) {
        this.isento = isento;
    }

    public Alfa getMotivoIsencao() {
        return this.motivoIsencao;
    }

    public void setMotivoIsencao(Alfa motivoIsencao) {
        this.motivoIsencao = motivoIsencao;
    }

    public Logico getPertenceCondominio() {
        return this.pertenceCondominio;
    }

    public void setPertenceCondominio(Logico pertenceCondominio) {
        this.pertenceCondominio = pertenceCondominio;
    }

    public Alfa getLogradouro() {
        return this.logradouro;
    }

    public void setLogradouro(Alfa logradouro) {
        this.logradouro = logradouro;
    }

    public Alfa getEnquadrada() {
        return this.enquadrada;
    }

    public void setEnquadrada(Alfa enquadrada) {
        this.enquadrada = enquadrada;
    }

    public Alfa getUltimoEnquadramento() {
        return this.ultimoEnquadramento;
    }

    public void setUltimoEnquadramento(Alfa ultimoEnquadramento) {
        this.ultimoEnquadramento = ultimoEnquadramento;
    }

    public boolean enquadramento() {
        return this.enquadramento(this.getAreaTotal(), this.getMunicipio().getElementoTabela());
    }

    public boolean enquadramento(AreaHectares area, ElementoTabela opcaoMunicipio) {
        if (opcaoMunicipio == null) {
            return false;
        }
        if (opcaoMunicipio.getConteudo(3).toString().equals("4") || opcaoMunicipio.getConteudo(3).toString().equals(IND_LOC_PANTANAL)) {
            return area.comparacao(">=", "1000,0");
        }
        if (opcaoMunicipio.getConteudo(3).toString().equals("2") || opcaoMunicipio.getConteudo(3).toString().equals(IND_LOC_POLIGONO_DA_SECA)) {
            return area.comparacao(">=", "500,0");
        }
        if (opcaoMunicipio.getConteudo(3).toString().equals("1")) {
            return area.comparacao(">=", "200,0");
        }
        if (this.getMunicipio().isVazio()) {
            return false;
        }
        return false;
    }

    public boolean pequenaGleba() {
        return this.pequenaGleba(this.getMunicipio().getElementoTabela(), this.getAreaTotal());
    }

    public boolean pequenaGleba(ElementoTabela opcaoMunicipio, AreaHectares areaTotal) {
        if (opcaoMunicipio != null) {
            if (opcaoMunicipio.getConteudo(3).equals("4") || opcaoMunicipio.getConteudo(3).equals(IND_LOC_PANTANAL)) {
                return areaTotal.comparacao("<=", "100,0");
            }
            if (opcaoMunicipio.getConteudo(3).equals("2") || opcaoMunicipio.getConteudo(3).equals(IND_LOC_POLIGONO_DA_SECA)) {
                return areaTotal.comparacao("<=", "50,0");
            }
            if (opcaoMunicipio.getConteudo(3).equals("1")) {
                return areaTotal.comparacao("<=", "30,0");
            }
        }
        return false;
    }

    public String getClasseFicha() {
        return PainelImovel.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return null;
    }
}

