/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.imovel;

import serpro.ppgd.itr.AreaHectares;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.util.UtilitariosString;

public class ValidadorMudancaEnquadramentoAreaTotal
extends ValidadorImpeditivoDefault {
    private boolean limpezaCamposUtilizacaoImovel = false;
    private boolean limpezaFichaAtividadePecuariaExtrativa = false;
    DeclaracaoITR dec = null;

    public ValidadorMudancaEnquadramentoAreaTotal(String msg, DeclaracaoITR pDec) {
        super(msg);
        this.dec = pDec;
    }

    public void acaoOk() {
        if (this.limpezaFichaAtividadePecuariaExtrativa) {
            this.dec.getAtividadePecuaria().limpaValoresPreenchidos();
            this.dec.getAtividadeExtrativa().limpaValoresPreenchidos();
            this.dec.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaPastagens().clear();
            this.dec.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaExploracaoExtrativa().clear();
            this.dec.getAreaNaoUtilizada().getAreasNaoAceitas().getAreaExploracaoExtrativa().clear();
            this.dec.getAreaNaoUtilizada().getAreasNaoAceitas().getAreaPastagem().clear();
        } else if (this.limpezaCamposUtilizacaoImovel) {
            this.dec.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaPastagens().clear();
            this.dec.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaExploracaoExtrativa().clear();
        }
    }

    public void acaoCancelar() {
    }

    public String getTituloPopup() {
        return "ITR " + ConstantesGlobais.EXERCICIO;
    }

    public RetornoValidacao validarImplementado() {
        this.limpezaCamposUtilizacaoImovel = false;
        this.limpezaFichaAtividadePecuariaExtrativa = false;
        boolean estaEnquadrada = this.estaEnquadrada();
        boolean vaiFicarEnquadrada = this.vaiFicarEnquadrada();
        if (estaEnquadrada) {
            if (!(vaiFicarEnquadrada || this.dec.getAtividadeExtrativa().isVazio() && this.dec.getAtividadePecuaria().isVazio())) {
                this.limpezaFichaAtividadePecuariaExtrativa = true;
                return new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("5"));
            }
        } else if (!(!vaiFicarEnquadrada || this.dec.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaPastagens().isVazio() && this.dec.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaExploracaoExtrativa().isVazio())) {
            this.limpezaCamposUtilizacaoImovel = true;
            return new RetornoValidacao(UtilitariosString.insereQuebraDeLinha((String)MensagemUtil.getMensagem("10"), (int)120, (String)"\n"));
        }
        return null;
    }

    protected boolean vaiFicarEnquadrada() {
        AreaHectares novaArea = new AreaHectares();
        novaArea.setConteudo((String)this.getProximoConteudo());
        return this.dec.getImovel().enquadramento(novaArea, this.dec.getImovel().getMunicipio().getElementoTabela());
    }

    protected boolean estaEnquadrada() {
        return this.dec.getImovel().enquadramento();
    }
}

