/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.imovel;

import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.demaiscondominos.Condomino;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorImpeditivoLogico;

public class ValidadorMudancaIsento
extends ValidadorImpeditivoLogico {
    private DeclaracaoITR dec = null;
    private boolean imovelEnquadrado = true;

    public ValidadorMudancaIsento(String msg, DeclaracaoITR pDec) {
        super(msg);
        this.dec = pDec;
    }

    public void acaoOk() {
        this.dec.getUtilizacaoImovel().zera();
        this.dec.getAreaNaoUtilizada().zera();
        this.dec.getCalculoImposto().zeraValores();
        this.dec.getAtividadePecuaria().limpaValoresPreenchidos();
        this.dec.getAtividadeExtrativa().limpaValoresPreenchidos();
    }

    public void acaoCancelar() {
    }

    public String getTituloPopup() {
        return "ITR " + ConstantesGlobais.EXERCICIO;
    }

    public RetornoValidacao validarImplementado() {
        if (this.dec.getImovel().getUf().isVazio() || this.dec.getImovel().getMunicipio().isVazio() || this.dec.getImovel().getAreaTotal().isVazio()) {
            this.setSeveridade((byte)5);
            return new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("95"));
        }
        if (this.dec.getImovel().getPessoaFisica().getConteudoFormatado().equals("1") && !this.dec.getImovel().pequenaGleba() && this.dec.getImovel().getPertenceCondominio().getConteudoFormatado().equals(Logico.NAO)) {
            this.setSeveridade((byte)5);
            return new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("60"));
        }
        if (this.dec.getImovel().getPessoaFisica().getConteudoFormatado().equals("1") && this.dec.getImovel().getPertenceCondominio().getConteudoFormatado().equals(Logico.SIM)) {
            for (Condomino condomino : this.dec.getDemaisCondominos().recuperarLista()) {
                if (condomino.getNi().asString().length() != 14) continue;
                this.setSeveridade((byte)5);
                return new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("60"));
            }
        }
        this.imovelEnquadrado = this.dec.getImovel().enquadramento();
        if (this.imovelEnquadrado) {
            boolean temPreenchimento;
            boolean bl = temPreenchimento = !this.dec.getUtilizacaoImovel().isVazio() || !this.dec.getAreaNaoUtilizada().isVazio() || !this.dec.getCalculoImposto().isVazio() || !this.dec.getAtividadePecuaria().isVazio() || !this.dec.getAtividadeExtrativa().isVazio();
            if (temPreenchimento) {
                this.setSeveridade((byte)4);
                return new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("130"));
            }
        } else {
            boolean temPreenchimento;
            boolean bl = temPreenchimento = !this.dec.getUtilizacaoImovel().isVazio() || !this.dec.getAreaNaoUtilizada().isVazio() || !this.dec.getCalculoImposto().isVazio();
            if (temPreenchimento) {
                this.setSeveridade((byte)4);
                return new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinha("135"));
            }
        }
        if (this.dec.getCalculoImposto().isVazio()) {
            this.dec.getCalculoImposto().zeraValores();
        }
        return null;
    }
}

