/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.imovel;

import serpro.ppgd.itr.imovel.Imovel;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;

public class ValidadorMudancaMunicipioIsencao
extends ValidadorImpeditivoDefault {
    Imovel imovel = null;

    public ValidadorMudancaMunicipioIsencao(String msg, Imovel pImovel) {
        super(msg);
        this.imovel = pImovel;
        this.setTipoExibicao(0);
        this.setSeveridade((byte)4);
    }

    public void acaoOk() {
        this.imovel.getIsento().setConteudo(Logico.NAO);
        this.imovel.getMotivoIsencao().clear();
    }

    public void acaoCancelar() {
    }

    public String getTituloPopup() {
        return "ITR " + ConstantesGlobais.EXERCICIO;
    }

    public RetornoValidacao validarImplementado() {
        ElementoTabela proximoMunicipio = (ElementoTabela)this.getProximoConteudo();
        if (proximoMunicipio == null) {
            return null;
        }
        if (this.imovel.getIsento().getConteudoFormatado().equals(Logico.SIM) && !this.imovel.pequenaGleba(proximoMunicipio, this.imovel.getAreaTotal())) {
            String msg = null;
            if (this.imovel.getMotivoIsencao().getConteudoFormatado().equals("A")) {
                msg = MensagemUtil.getMensagemComQuebraDeLinha("105");
                this.setMensagemValidacao(msg);
                return new RetornoValidacao(msg);
            }
            if (this.imovel.getMotivoIsencao().getConteudoFormatado().equals("B") || this.imovel.getMotivoIsencao().getConteudoFormatado().equals("C")) {
                msg = MensagemUtil.getMensagemComQuebraDeLinha("105");
                this.setMensagemValidacao(msg);
                return new RetornoValidacao(msg);
            }
        }
        return null;
    }
}

