/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.impressao;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.commons.lang3.StringUtils;
import serpro.ppgd.gui.pendencia.LinhaPendencia;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.DarfPayload;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.declaracao.ComplementoRecibo;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.impressao.Relatorio;
import serpro.ppgd.itr.impressao.RelatorioMultiploXMLITR;
import serpro.ppgd.itr.util.ArquivoUtil;
import serpro.ppgd.itr.util.BarramentoUtil;
import serpro.ppgd.itr.util.DataUtil;
import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class ImpressaoDeclaracao {
    private static final String LABEL_ERRO = "Erro";
    private static final String LABEL_AVISO = "Aviso";

    public String getPrefixoNomeArq(String nirf, Logico retificadora) {
        return nirf + "-ITR-" + ConstantesGlobais.EXERCICIO + (String)(retificadora.isVazio() ? "" : "-" + (retificadora.naoFormatado().equals(Logico.SIM) ? "RETIF" : "ORIGI"));
    }

    public RelatorioMultiploXMLITR imprimirDeclaracao(DeclaracaoITR dec, File decTransmitida) {
        RelatorioMultiploXMLITR relatorio = null;
        relatorio = ConstantesGlobaisITR.IMPRESSAO_DITR_WEB ? this.imprimirDeclaracaoDitrWeb(dec, decTransmitida) : this.imprimirDeclaracaoLocal(dec);
        return relatorio;
    }

    private RelatorioMultiploXMLITR imprimirDeclaracaoDitrWeb(DeclaracaoITR dec, File decTransmitida) {
        RelatorioMultiploXMLITR relatorio = new RelatorioMultiploXMLITR();
        String nomeArq = this.getPrefixoNomeArq(dec.getIdentificadorDeclaracao().getNirf().naoFormatado(), dec.getIdentificadorDeclaracao().getRetificadora()) + "-Declaracao";
        String[] impressaoDitrWeb = new String[1];
        String recBase64 = "";
        String decBase64 = "";
        if (decTransmitida != null) {
            decBase64 = ArquivoUtil.lerArquivoToBase64(decTransmitida.getAbsolutePath().toString());
            recBase64 = ITRUtil.obterReciboBase64(dec);
        } else {
            decBase64 = ITRUtil.obterDeclaracaoBase64(dec);
        }
        impressaoDitrWeb[0] = BarramentoUtil.imprimirDeclaracao(decBase64, recBase64);
        relatorio.setTitulo("Declara\u00e7\u00e3o");
        relatorio.setImpressaoDitrWeb(true);
        relatorio.setNomeArquivo(nomeArq);
        relatorio.setDocImpressaoDitrWeb(impressaoDitrWeb);
        return relatorio;
    }

    public RelatorioMultiploXMLITR imprimirDeclaracaoLocal(DeclaracaoITR dec) {
        IdentificadorDeclaracao identificadorDec = dec.getIdentificadorDeclaracao();
        String pathDados = identificadorDec.getPathArquivo();
        String nomeArq = this.getPrefixoNomeArq(dec.getIdentificadorDeclaracao().getNirf().naoFormatado(), dec.getIdentificadorDeclaracao().getRetificadora()) + "-Declaracao";
        RelatorioMultiploXMLITR novaImpressao = new RelatorioMultiploXMLITR("Declara\u00e7\u00e3o", "relDeclaracaoITR.jasper", identificadorDec.getPathArquivo(), "/classe", nomeArq);
        novaImpressao.addParametro("PATH", "");
        novaImpressao.addParametro("EXERCICIO", ConstantesGlobais.EXERCICIO);
        novaImpressao.addParametro("EXERCICIO_ANTERIOR", ConstantesGlobais.EXERCICIO_ANTERIOR);
        novaImpressao.addParametro("CIB", ITRUtil.formatarIdentificacaoImovel(identificadorDec.getNirf().naoFormatado()));
        novaImpressao.addParametro("enquadrada", new Boolean(dec.getImovel().enquadramento()).toString());
        novaImpressao.addParametro("tipoLogradouroImovelComAcento", dec.getImovel().getTipoLogradouro().getConteudoAtual(1).equals("") ? " " : dec.getImovel().getTipoLogradouro().getConteudoAtual(1));
        novaImpressao.addParametro("tipoLogradouroContribuinteComAcento", dec.getContribuinte().getTipoLogradouro().getConteudoAtual(1).equals("") ? " " : dec.getContribuinte().getTipoLogradouro().getConteudoAtual(1));
        novaImpressao.addParametro("nomeMunicipioImovelComAcento", dec.getImovel().getMunicipio().getConteudoAtual(1).equals("") ? " " : dec.getImovel().getMunicipio().getConteudoAtual(1));
        novaImpressao.addParametro("nomeMunicipioContribuinteComAcento", dec.getContribuinte().getMunicipio().getConteudoAtual(1).equals("") ? " " : dec.getContribuinte().getMunicipio().getConteudoAtual(1));
        novaImpressao.addParametro("codigoIncraFormatado", dec.getImovel().getCodigoIncra().getConteudoFormatado());
        return novaImpressao;
    }

    public RelatorioMultiploXMLITR imprimirDarfDecPreenchimento(DeclaracaoITR dec, Integer[] quotas) {
        RelatorioMultiploXMLITR relatorio = null;
        relatorio = ConstantesGlobaisITR.DARF_SENDA ? this.darfSendaDecPreenchimento(dec, quotas) : this.darfLocal(dec, quotas);
        return relatorio;
    }

    public RelatorioMultiploXMLITR imprimirDarfDecTrasmitida(ComplementoRecibo recibo, Integer[] quotas) {
        RelatorioMultiploXMLITR relatorio = null;
        relatorio = ConstantesGlobaisITR.DARF_SENDA ? this.darfSendaDecTransmitida(recibo, quotas) : this.darfLocal(null, quotas);
        return relatorio;
    }

    private RelatorioMultiploXMLITR darfSendaDecTransmitida(ComplementoRecibo recibo, Integer[] quotas) {
        RelatorioMultiploXMLITR relatorio = new RelatorioMultiploXMLITR();
        String nomeArq = this.getPrefixoNomeArq(recibo.getNirf().naoFormatado(), recibo.getRetificadora()) + "-Darf";
        String[] darfsSenda = new String[quotas.length];
        boolean sair = false;
        for (int i = 0; i < quotas.length && !sair; ++i) {
            switch (quotas[i]) {
                case 0: {
                    DarfPayload dpCotaUnica = this.createDPCota(true, recibo, null, 1, "QUOTA NICA");
                    darfsSenda[i] = BarramentoUtil.imprimirDarfSenda(dpCotaUnica);
                    break;
                }
                case 1: {
                    DarfPayload dpCotaUm = this.createDPCota(true, recibo, null, 1, "1 QUOTA");
                    darfsSenda[i] = BarramentoUtil.imprimirDarfSenda(dpCotaUm);
                    break;
                }
                case 2: {
                    DarfPayload dpCotaDois = this.createDPCota(true, recibo, null, 2, "2 QUOTA");
                    darfsSenda[i] = BarramentoUtil.imprimirDarfSenda(dpCotaDois);
                    break;
                }
                case 3: {
                    DarfPayload dpCotaTres = this.createDPCota(true, recibo, null, 3, "3 QUOTA");
                    darfsSenda[i] = BarramentoUtil.imprimirDarfSenda(dpCotaTres);
                    break;
                }
                case 4: {
                    DarfPayload dpCotaQuatro = this.createDPCota(true, recibo, null, 4, "4 QUOTA");
                    darfsSenda[i] = BarramentoUtil.imprimirDarfSenda(dpCotaQuatro);
                    break;
                }
            }
            sair = StringUtils.isEmpty((CharSequence)darfsSenda[i]);
        }
        relatorio.setDarf(true);
        relatorio.setNomeArquivo(nomeArq);
        relatorio.setDarfsSenda(darfsSenda);
        return relatorio;
    }

    private DarfPayload createDarfPayloadDecTransmitida(ComplementoRecibo rec) {
        DarfPayload dp = new DarfPayload();
        dp.setCodigoReceita(1070);
        dp.setTipoNi(this.tipoContribuinte(rec.getNiContribuinte().naoFormatado()));
        dp.setNi(rec.getNiContribuinte().naoFormatado());
        dp.setValorPrincipal(Double.parseDouble(rec.getValorQuota().asString().replace(",", ".")));
        dp.setDataVencimento(DataUtil.formatarDataDarf(null));
        dp.setNirf(rec.getNirf().naoFormatado());
        dp.setNumeroReferencia(dp.getNirf());
        dp.setObservacao1("CIB: " + ITRUtil.formatarIdentificacaoImovel(rec.getNirf().naoFormatado()));
        dp.setObservacao2("");
        dp.setDataPeriodoApuracao(DataUtil.formatarDataDarf("01/01/" + ConstantesGlobais.EXERCICIO));
        dp.setArea(rec.getAreaImovel().formatado());
        dp.setExercicio(Integer.valueOf(ConstantesGlobais.EXERCICIO));
        return dp;
    }

    private RelatorioMultiploXMLITR darfSendaDecPreenchimento(DeclaracaoITR dec, Integer[] quotas) {
        RelatorioMultiploXMLITR relatorio = new RelatorioMultiploXMLITR();
        String nomeArq = this.getPrefixoNomeArq(dec.getIdentificadorDeclaracao().getNirf().naoFormatado(), dec.getIdentificadorDeclaracao().getRetificadora()) + "-Darf";
        String[] darfsSenda = new String[quotas.length];
        boolean sair = false;
        for (int i = 0; i < quotas.length && !sair; ++i) {
            switch (quotas[i]) {
                case 0: {
                    DarfPayload dpCotaUnica = this.createDPCota(false, null, dec, 1, "QUOTA \u00daNICA");
                    darfsSenda[i] = BarramentoUtil.imprimirDarfSenda(dpCotaUnica);
                    break;
                }
                case 1: {
                    DarfPayload dpCotaUm = this.createDPCota(false, null, dec, 1, "1\u00aa QUOTA");
                    darfsSenda[i] = BarramentoUtil.imprimirDarfSenda(dpCotaUm);
                    break;
                }
                case 2: {
                    DarfPayload dpCotaDois = this.createDPCota(false, null, dec, 2, "2\u00aa QUOTA");
                    darfsSenda[i] = BarramentoUtil.imprimirDarfSenda(dpCotaDois);
                    break;
                }
                case 3: {
                    DarfPayload dpCotaTres = this.createDPCota(false, null, dec, 3, "3\u00aa QUOTA");
                    darfsSenda[i] = BarramentoUtil.imprimirDarfSenda(dpCotaTres);
                    break;
                }
                case 4: {
                    DarfPayload dpCotaQuatro = this.createDPCota(false, null, dec, 4, "4\u00aa QUOTA");
                    darfsSenda[i] = BarramentoUtil.imprimirDarfSenda(dpCotaQuatro);
                    break;
                }
            }
            sair = StringUtils.isEmpty((CharSequence)darfsSenda[i]);
        }
        relatorio.setTitulo("Darf");
        relatorio.setDarf(true);
        relatorio.setNomeArquivo(nomeArq);
        relatorio.setDarfsSenda(darfsSenda);
        return relatorio;
    }

    private DarfPayload createDarfPayloadDecPreenchimento(DeclaracaoITR dec) {
        DarfPayload dp = new DarfPayload();
        dp.setCodigoReceita(1070);
        dp.setTipoNi(this.tipoContribuinte(dec.getContribuinte().getNi().naoFormatado()));
        dp.setNi(dec.getContribuinte().getNi().naoFormatado());
        dp.setValorPrincipal(Double.parseDouble(dec.getCalculoImposto().getValorQuota().asString().replace(",", ".")));
        dp.setDataVencimento(DataUtil.formatarDataDarf(null));
        dp.setNirf(dec.getIdentificadorDeclaracao().getNirf().naoFormatado());
        dp.setNumeroReferencia(dp.getNirf());
        dp.setObservacao1("CIB: " + ITRUtil.formatarIdentificacaoImovel(dec.getIdentificadorDeclaracao().getNirf().naoFormatado()));
        dp.setObservacao2("");
        dp.setDataPeriodoApuracao(DataUtil.formatarDataDarf("01/01/" + ConstantesGlobais.EXERCICIO));
        dp.setArea(dec.getImovel().getAreaTotal().formatado());
        dp.setExercicio(Integer.valueOf(ConstantesGlobais.EXERCICIO));
        return dp;
    }

    private DarfPayload createDPCota(boolean decTrasmitida, ComplementoRecibo rec, DeclaracaoITR dec, Integer cota, String obsCota) {
        DarfPayload dp = new DarfPayload();
        dp = decTrasmitida ? this.createDarfPayloadDecTransmitida(rec) : this.createDarfPayloadDecPreenchimento(dec);
        dp.setObservacao2(obsCota);
        dp.setCota(cota);
        return dp;
    }

    private Integer tipoContribuinte(String ni) {
        if (ni.length() == 14) {
            return 2;
        }
        return 1;
    }

    private RelatorioMultiploXMLITR darfLocal(DeclaracaoITR dec, Integer[] quotas) {
        IdentificadorDeclaracao idDec = dec.getIdentificadorDeclaracao();
        RelatorioMultiploXMLITR relatorio = null;
        block7: for (int i = 0; i < quotas.length; ++i) {
            if (relatorio == null) {
                String nomeArq = this.getPrefixoNomeArq(idDec.getNirf().naoFormatado(), idDec.getRetificadora()) + "-Darf";
                String pathArq = idDec.getPathArquivo();
                relatorio = new RelatorioMultiploXMLITR("Darf", "relDarf.jasper", idDec.getPathArquivo(), "/classe", nomeArq);
                relatorio.addParametro("nirf", ITRUtil.formatarIdentificacaoImovel(idDec.getNirf().naoFormatado()));
                relatorio.addParametro("periodoApuracao", "01/01/" + ConstantesGlobais.EXERCICIO);
                relatorio.addParametro("icone", ClassLoader.getSystemClassLoader().getResource("icones/brasao.jpg").toString());
            } else {
                relatorio.addRelatorioXML("Darf", "relDarf.jasper", idDec.getPathArquivo(), "/classe");
            }
            String txt1 = "ITR - ";
            String txt2 = "Se pagamento ap\u00f3s o vencimento, para c\u00e1lculo dos acr\u00e9scimos legais acesse: <https://www.gov.br/receitafederal/pt-br> op\u00e7\u00e3o \"Sicalc\" no menu \"Onde Encontro?\" ";
            switch (quotas[i]) {
                case 0: {
                    relatorio.addParametro("observacao", txt1 + "QUOTA \u00daNICA\n" + txt2, i);
                    relatorio.addParametro("dataVencimento", FabricaUtilitarios.getProperties().getProperty("dataPrimeiraCotaDarf"), i);
                    continue block7;
                }
                case 1: {
                    relatorio.addParametro("observacao", txt1 + "1\u00aa QUOTA\n" + txt2, i);
                    relatorio.addParametro("dataVencimento", FabricaUtilitarios.getProperties().getProperty("dataPrimeiraCotaDarf"), i);
                    continue block7;
                }
                case 2: {
                    relatorio.addParametro("observacao", txt1 + "2\u00aa QUOTA - Para pagamento at\u00e9 o vencimento, acrescentar juros de mora de 1% sobre o valor da quota. " + txt2, i);
                    relatorio.addParametro("dataVencimento", FabricaUtilitarios.getProperties().getProperty("dataSegundaCotaDarf"), i);
                    continue block7;
                }
                case 3: {
                    relatorio.addParametro("observacao", txt1 + "3\u00aa QUOTA - Para pagamento at\u00e9 o vencimento, acrescentar juros Selic de out/" + ConstantesGlobais.EXERCICIO + " + 1% sobre o valor da quota. " + txt2, i);
                    relatorio.addParametro("dataVencimento", FabricaUtilitarios.getProperties().getProperty("dataTerceiraCotaDarf"), i);
                    continue block7;
                }
                case 4: {
                    relatorio.addParametro("observacao", txt1 + "4\u00aa QUOTA - Para pagamento at\u00e9 o vencimento, acrescentar juros Selic de out/" + ConstantesGlobais.EXERCICIO + " + nov/" + ConstantesGlobais.EXERCICIO + " + 1% sobre o valor da quota. " + txt2, i);
                    relatorio.addParametro("dataVencimento", FabricaUtilitarios.getProperties().getProperty("dataQuartaCotaDarf"), i);
                }
            }
        }
        return relatorio;
    }

    public RelatorioMultiploXMLITR imprimirDarfMulta(ComplementoRecibo recibo) {
        RelatorioMultiploXMLITR relatorio = null;
        try {
            relatorio = ConstantesGlobaisITR.DARF_SENDA ? this.darfMultaSenda(recibo) : this.darfMultaLocal(recibo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return relatorio;
    }

    public RelatorioMultiploXMLITR darfMultaSenda(ComplementoRecibo recibo) {
        RelatorioMultiploXMLITR relatorio = new RelatorioMultiploXMLITR();
        try {
            String nomeArq = this.getPrefixoNomeArq(recibo.getNirf().naoFormatado(), recibo.getRetificadora()) + "-Darf-Multa";
            String[] darfsSenda = new String[1];
            DarfPayload dpMulta = this.createDarfPayloadDecTransmitida(recibo);
            dpMulta.setCodigoReceita(5300);
            dpMulta.setValorPrincipal(Double.parseDouble(recibo.getValorMulta().asString().replace(",", ".")));
            dpMulta.setNumeroReferencia(recibo.getNumSequencial().naoFormatado());
            dpMulta.setCota(0);
            dpMulta.setDataVencimento(DataUtil.formatarDataDarf(recibo.getDataVencimento().getConteudoFormatado()));
            dpMulta.setDataPeriodoApuracao(DataUtil.formatarDataDarf(FabricaUtilitarios.getProperties().getProperty("periodoApuracao")));
            darfsSenda[0] = BarramentoUtil.imprimirDarfSenda(dpMulta);
            relatorio.setTitulo("Darf");
            relatorio.setDarf(true);
            relatorio.setNomeArquivo(nomeArq);
            relatorio.setDarfsSenda(darfsSenda);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return relatorio;
    }

    public RelatorioMultiploXMLITR darfMultaLocal(ComplementoRecibo recibo) {
        String nomeArq = this.getPrefixoNomeArq(recibo.getNirf().naoFormatado(), recibo.getRetificadora()) + "-Darf-Multa";
        RelatorioMultiploXMLITR relatorio = new RelatorioMultiploXMLITR("Darf", "relDarfMulta.jasper", nomeArq);
        String periodoApuracao = FabricaUtilitarios.getProperties().getProperty("periodoApuracao");
        relatorio.addParametro("nirf", ITRUtil.formatarIdentificacaoImovel(recibo.getNirf().naoFormatado()));
        relatorio.addParametro("icone", ClassLoader.getSystemClassLoader().getResource("icones/brasao.jpg").toString());
        relatorio.addParametro("nome", recibo.getNomeContribuinte().formatado());
        relatorio.addParametro("codigoNotificacao", recibo.getNumSequencial().formatado());
        relatorio.addParametro("dddTelefone", recibo.getDddTelefoneContribuinte().formatado());
        relatorio.addParametro("numTelefone", recibo.getTelefoneContribuinte().formatado());
        relatorio.addParametro("nomeImovel", recibo.getNomeImovel().formatado());
        relatorio.addParametro("areaTotal", recibo.getAreaImovel().formatado());
        relatorio.addParametro("cpfCnpj", recibo.getNiContribuinte().formatado());
        relatorio.addParametro("dataVencimento", recibo.getDataVencimento().formatado());
        relatorio.addParametro("periodoApuracao", periodoApuracao);
        relatorio.addParametro("valorQuota", recibo.getValorMulta().operacao('/', "2").formatado());
        relatorio.addParametro("observacoes", "Multa por Atraso na Entrega da Declara\u00e7\u00e3o do ITR/" + ConstantesGlobais.EXERCICIO + "\nValor da Multa: R$ " + recibo.getValorMulta().formatado() + "\nValor para pagamento at\u00e9 vencimento (redu\u00e7\u00e3o 50%): R$ " + recibo.getValorMulta().operacao('/', "2").formatado() + "\nDarf v\u00e1lido para pagamento at\u00e9 o vencimento: " + recibo.getDataVencimento().formatado());
        return relatorio;
    }

    public RelatorioMultiploXMLITR imprimirNotificacao(ComplementoRecibo recibo) {
        RelatorioMultiploXMLITR relatorio = null;
        relatorio = ConstantesGlobaisITR.IMPRESSAO_DITR_WEB ? this.imprimirNotificacaoDitrWeb(recibo) : this.imprimirNotificacaoLocal(recibo);
        return relatorio;
    }

    private RelatorioMultiploXMLITR imprimirNotificacaoDitrWeb(ComplementoRecibo recibo) {
        RelatorioMultiploXMLITR relatorio = new RelatorioMultiploXMLITR();
        String nomeArq = this.getPrefixoNomeArq(recibo.getNirf().naoFormatado(), recibo.getRetificadora()) + "-Notificacao";
        String[] impressaoDitrWeb = new String[]{BarramentoUtil.imprimirNotificacao(ITRUtil.obterDeclaracaoBase64(recibo), ITRUtil.obterReciboBase64(recibo))};
        relatorio.setTitulo("Notifica\u00e7\u00e3o");
        relatorio.setImpressaoDitrWeb(true);
        relatorio.setNomeArquivo(nomeArq);
        relatorio.setDocImpressaoDitrWeb(impressaoDitrWeb);
        return relatorio;
    }

    public RelatorioMultiploXMLITR imprimirNotificacaoLocal(ComplementoRecibo recibo) {
        String nomeArq = this.getPrefixoNomeArq(recibo.getNirf().naoFormatado(), recibo.getRetificadora()) + "-Notificacao";
        RelatorioMultiploXMLITR relatorio = new RelatorioMultiploXMLITR("Notifica\u00e7\u00e3o", "relNotificacao.jasper", nomeArq);
        relatorio.addParametro("nomeContribuinte", recibo.getNomeContribuinte().formatado());
        relatorio.addParametro("CPFCNPJ", recibo.getNiContribuinte().formatado());
        relatorio.addParametro("tipoDoc", recibo.getTipoContribuinte().naoFormatado());
        relatorio.addParametro("codigoImovel", ITRUtil.formatarIdentificacaoImovel(recibo.getNirf().naoFormatado()));
        relatorio.addParametro("areaImovel", recibo.getAreaImovel().formatado());
        relatorio.addParametro("municipioImovel", recibo.getNomeMunicipioImovel().formatado());
        relatorio.addParametro("UFImovel", recibo.getUfImovel().formatado());
        if (recibo.getRetificadora().formatado().equals(Logico.NAO)) {
            relatorio.addParametro("dataRecepcaoRelatorioNotificacao", recibo.getDataRecepcao().formatado());
        } else {
            relatorio.addParametro("dataRecepcaoOriginal", recibo.getDataRecepcaoOriginal().formatado());
            relatorio.addParametro("dataRecepcaoRelatorioNotificacao", recibo.getDataRecepcao().formatado());
        }
        relatorio.addParametro("declaracaoRetificadora", recibo.getRetificadora().formatado());
        String numRecibo = ITRUtil.formatarRecibo(recibo.getNumeroRecibo().formatado());
        relatorio.addParametro("numeroRecibo", numRecibo.substring(0, numRecibo.length() - 3));
        relatorio.addParametro("numeroReciboDv", numRecibo);
        relatorio.addParametro("codigoNotificacao", recibo.getNumSequencial().formatado());
        String qtdMesesAtraso = recibo.getQtdMesesAtraso().formatado().trim();
        if (qtdMesesAtraso.length() > 0) {
            qtdMesesAtraso = String.valueOf(Integer.valueOf(qtdMesesAtraso));
        }
        relatorio.addParametro("qtdMeses", qtdMesesAtraso);
        relatorio.addParametro("impostoDevido", recibo.getImpostoDevido().formatado());
        relatorio.addParametro("valorMulta", recibo.getValorMulta().formatado());
        Valor impostoDevido = new Valor("0,00");
        impostoDevido.append('+', recibo.getImpostoDevido());
        Valor multaCalculada = new Valor("0,00");
        BigDecimal imp = new BigDecimal(impostoDevido.naoFormatado().replaceAll("(,)", "."));
        BigDecimal qtd = new BigDecimal(recibo.getQtdMesesAtraso().naoFormatado());
        BigDecimal multa = imp.multiply(qtd).divide(new BigDecimal(100), 2, 3);
        multaCalculada = new Valor(multa.toString().replaceAll("(\\.)", ","));
        relatorio.addParametro("dataFinalEntrega", FabricaUtilitarios.getProperties().getProperty("dataPrazoEntrega"));
        relatorio.addParametro("multaCalculada", multaCalculada.formatado());
        relatorio.addParametro("nomeDelegado", recibo.getNomeDelegadoSRF().formatado());
        relatorio.addParametro("tipoCargo", recibo.getTipoDelegadoSRF().formatado());
        relatorio.addParametro("matricula", recibo.getNumMatriculaDelegadoSRF().formatado());
        relatorio.addParametro("nomeDelegacia", recibo.getTipoDelegacia().formatado() + " - " + recibo.getNomeUA().formatado());
        relatorio.addParametro("icone", ClassLoader.getSystemClassLoader().getResource("icones/brasao.jpg").toString());
        relatorio.addParametro("EXERCICIO", ConstantesGlobais.EXERCICIO);
        relatorio.addParametro("infoInstrucaoNormativa", ConstantesGlobaisITR.INFO_IN);
        return relatorio;
    }

    public RelatorioMultiploXMLITR imprimirRecibo(ComplementoRecibo recibo) {
        RelatorioMultiploXMLITR relatorio = null;
        relatorio = ConstantesGlobaisITR.IMPRESSAO_DITR_WEB ? this.imprimirReciboDitrWeb(recibo) : this.imprimirReciboLocal(recibo);
        return relatorio;
    }

    private RelatorioMultiploXMLITR imprimirReciboDitrWeb(ComplementoRecibo recibo) {
        RelatorioMultiploXMLITR relatorio = new RelatorioMultiploXMLITR();
        String nomeArq = this.getPrefixoNomeArq(recibo.getNirf().naoFormatado(), recibo.getRetificadora()) + "-Recibo";
        String[] impressaoDitrWeb = new String[]{BarramentoUtil.imprimirRecibo(ITRUtil.obterDeclaracaoBase64(recibo), ITRUtil.obterReciboBase64(recibo))};
        relatorio.setTitulo("Recibo");
        relatorio.setImpressaoDitrWeb(true);
        relatorio.setNomeArquivo(nomeArq);
        relatorio.setDocImpressaoDitrWeb(impressaoDitrWeb);
        return relatorio;
    }

    public RelatorioMultiploXMLITR imprimirReciboLocal(ComplementoRecibo recibo) {
        Object strTransmissao;
        MensagemAvisoRecibo msg;
        String nomeArq = this.getPrefixoNomeArq(recibo.getNirf().naoFormatado(), recibo.getRetificadora()) + "-Recibo";
        RelatorioMultiploXMLITR relatorio = new RelatorioMultiploXMLITR("Recibo", "relRecibo.jasper", nomeArq);
        relatorio.addParametro("EXERCICIO", ConstantesGlobais.EXERCICIO);
        relatorio.addParametro("codigoImovel", ITRUtil.formatarIdentificacaoImovel(recibo.getNirf().naoFormatado()));
        relatorio.addParametro("nomeImovel", recibo.getNomeImovel().formatado());
        relatorio.addParametro("logradouroImovel", recibo.getTipoLogradouroImovel().formatado() + " " + recibo.getLogradouroImovel().formatado());
        relatorio.addParametro("municipioImovel", recibo.getNomeMunicipioImovel().formatado());
        relatorio.addParametro("UFImovel", recibo.getUfImovel().formatado());
        relatorio.addParametro("CEPImovel", recibo.getCepImovel().formatado());
        relatorio.addParametro("nomeContribuinte", recibo.getNomeContribuinte().formatado());
        relatorio.addParametro("CPFCNPJ", recibo.getNiContribuinte().formatado());
        relatorio.addParametro("tipoDoc", recibo.getTipoContribuinte().naoFormatado());
        relatorio.addParametro("logradouroContribuinte", recibo.getTipoLogradouroContribuinte().formatado() + " " + recibo.getLogradouroContribuinte().formatado());
        relatorio.addParametro("numero", recibo.getNumeroEdnderecoContribuinte().formatado());
        relatorio.addParametro("complemento", recibo.getComplementoEnderecoContribuinte().formatado());
        relatorio.addParametro("bairro", recibo.getBairroEnderecoContribuinte().formatado());
        relatorio.addParametro("municipioContribuinte", recibo.getNomeMunicipioContribuinte().formatado());
        relatorio.addParametro("UFContribuinte", recibo.getUfContribuinte().formatado());
        relatorio.addParametro("CEPContribuinte", recibo.getCepContribuinte().formatado());
        relatorio.addParametro("dddTelefone", recibo.getDddTelefoneContribuinte().formatado());
        relatorio.addParametro("telefone", recibo.getTelefoneContribuinte().formatado());
        relatorio.addParametro("retificadora", recibo.getRetificadora().formatado());
        relatorio.addParametro("areaImovel", recibo.getAreaImovel().formatado());
        relatorio.addParametro("indImuneIsento", recibo.getImune().formatado());
        relatorio.addParametro("enquadramento", recibo.getEnquadramento().formatado());
        relatorio.addParametro("infoInstrucaoNormativa", ConstantesGlobaisITR.INFO_IN);
        ArrayList<MensagemAvisoRecibo> msgsValidador = new ArrayList<MensagemAvisoRecibo>();
        if (recibo.getIndNiContribuinteDifCafir().formatado().equals(Logico.SIM)) {
            msg = new MensagemAvisoRecibo();
            msg.setMensagem(MensagemUtil.getMensagem("110290"));
            msgsValidador.add(msg);
            msg.setNumero(new Integer(msgsValidador.size()));
        }
        if (recibo.getIndAreaImovelDifCafir().formatado().equals(Logico.SIM)) {
            msg = new MensagemAvisoRecibo();
            msg = new MensagemAvisoRecibo();
            msg.setMensagem(MensagemUtil.getMensagem("110300"));
            msgsValidador.add(msg);
            msg.setNumero(new Integer(msgsValidador.size()));
        }
        if (recibo.getIndVinculacao().formatado().equals(Logico.NAO) && recibo.getAreaImovel().comparacao(">", "50,0")) {
            msg = new MensagemAvisoRecibo();
            msg.setMensagem(MensagemUtil.getMensagem("111115"));
            msgsValidador.add(msg);
            msg.setNumero(new Integer(msgsValidador.size()));
        }
        if (msgsValidador.size() > 0) {
            JRBeanCollectionDataSource dsAvisos = new JRBeanCollectionDataSource(msgsValidador);
            relatorio.addParametro("AvisosRecibo", dsAvisos);
            relatorio.addParametro("SUBREPORT_DIR", UtilitariosArquivo.localizaArquivoEmClasspath((String)"/relSubAvisosRecibo.jasper").toString());
        }
        Valor impostoDevido = new Valor("0,00");
        if (recibo.getImune().formatado().equals(Logico.NAO)) {
            impostoDevido.append('+', recibo.getImpostoDevido());
            relatorio.addParametro("valorTributavel", recibo.getValorTributavel().formatado());
            relatorio.addParametro("impostoCalculado", recibo.getImpostoCalculado().formatado());
            relatorio.addParametro("impostoDevido", recibo.getImpostoDevido().formatado());
            relatorio.addParametro("qtdQuotas", recibo.getQtdQuotas().formatado());
            relatorio.addParametro("valorQuotaRecibo", recibo.getValorQuota().formatado());
        } else {
            relatorio.addParametro("valorTributavel", "0,00");
            relatorio.addParametro("impostoCalculado", "0,00");
            relatorio.addParametro("qtdQuotas", "0");
            relatorio.addParametro("valorQuotaRecibo", "0,00");
        }
        Valor multaCalculada = new Valor("0,00");
        if (!recibo.getNumSequencial().isVazio()) {
            relatorio.addRelatorioXML("Notifica\u00e7\u00e3o", "relNotificacao.jasper");
            BigDecimal imp = new BigDecimal(impostoDevido.naoFormatado().replaceAll("(,)", "."));
            BigDecimal qtd = new BigDecimal(recibo.getQtdMesesAtraso().naoFormatado());
            BigDecimal multa = imp.multiply(qtd).divide(new BigDecimal(100), 2, 3);
            multaCalculada = new Valor(multa.toString().replaceAll("(\\.)", ","));
            relatorio.addParametro("dataFinalEntrega", FabricaUtilitarios.getProperties().getProperty("dataPrazoEntrega"));
            if (!ConstantesGlobaisITR.DARF_SENDA) {
                relatorio.addRelatorioXML("Darf", "relDarfMulta.jasper");
                relatorio.addParametro("nirf", ITRUtil.formatarIdentificacaoImovel(recibo.getNirf().naoFormatado()));
                relatorio.addParametro("dataVencimento", recibo.getDataVencimento().formatado());
                relatorio.addParametro("nome", recibo.getNomeContribuinte().formatado());
                relatorio.addParametro("dddTelefone", recibo.getDddTelefoneContribuinte().formatado());
                relatorio.addParametro("numTelefone", recibo.getTelefoneContribuinte().formatado());
                relatorio.addParametro("areaTotal", recibo.getAreaImovel().formatado());
                relatorio.addParametro("cpfCnpj", recibo.getNiContribuinte().formatado());
                relatorio.addParametro("valorQuota", recibo.getValorMulta().operacao('/', "2").formatado());
                relatorio.addParametro("observacoes", "Multa por Atraso na Entrega da Declara\u00e7\u00e3o do ITR/" + ConstantesGlobais.EXERCICIO + "\nValor da Multa: R$ " + recibo.getValorMulta().formatado() + "\nValor para pagamento at\u00e9 vencimento (redu\u00e7\u00e3o 50%): R$ " + recibo.getValorMulta().operacao('/', "2").formatado() + "\nDarf v\u00e1lido para pagamento at\u00e9 o vencimento: " + recibo.getDataVencimento().formatado());
                String periodoApuracao = FabricaUtilitarios.getProperties().getProperty("periodoApuracao");
                relatorio.addParametro("periodoApuracao", periodoApuracao);
            } else {
                RelatorioMultiploXMLITR relatorioDarfMultaSenda = this.imprimirDarfMulta(recibo);
                relatorio.setTitulo("Recibo");
                relatorio.setReciboMaed(true);
                relatorio.setDarfsSenda(relatorioDarfMultaSenda.getDarfsSenda());
                relatorio.setNomeArquivo(nomeArq);
                relatorio.verificarDarfSendaGerado();
            }
            if (recibo.getRetificadora().formatado().equals(Logico.NAO)) {
                relatorio.addParametro("dataRecepcaoRelatorioNotificacao", recibo.getDataRecepcao().formatado());
            } else {
                relatorio.addParametro("dataRecepcaoOriginal", recibo.getDataRecepcaoOriginal().formatado());
                relatorio.addParametro("dataRecepcaoRelatorioNotificacao", recibo.getDataRecepcao().formatado());
            }
            relatorio.addParametro("declaracaoRetificadora", recibo.getRetificadora().formatado());
        }
        relatorio.addParametro("multaCalculada", multaCalculada.formatado());
        relatorio.addParametro("impostoDevido", impostoDevido.formatado());
        relatorio.addParametro("icone", ClassLoader.getSystemClassLoader().getResource("icones/brasao.jpg").toString());
        relatorio.addParametro("codigoNotificacao", recibo.getNumSequencial().formatado());
        relatorio.addParametro("certificado", recibo.getAssinaturaDeclaracao().formatado());
        relatorio.addParametro("dataRecepcao", recibo.getDataRecepcao().formatado());
        if (recibo.getExpressaoAplicativoTransmissao().formatado().equals("JV")) {
            strTransmissao = recibo.getExpressaoAplicativoTransmissao().formatado() + recibo.getCodAgenteTransmissor().formatado();
            relatorio.addParametro("transmissao", (String)strTransmissao);
        } else {
            strTransmissao = "";
            relatorio.addParametro("transmissao", (String)strTransmissao);
        }
        String tmpHoraRecp = recibo.getHoraRecepcao().formatado();
        if (tmpHoraRecp.trim().length() == 6) {
            StringBuffer strBufHoraRecepcao = new StringBuffer(tmpHoraRecp.substring(0, 2));
            strBufHoraRecepcao.append(":");
            strBufHoraRecepcao.append(tmpHoraRecp.substring(2, 4));
            strBufHoraRecepcao.append(":");
            strBufHoraRecepcao.append(tmpHoraRecp.substring(4, 6));
            tmpHoraRecp = strBufHoraRecepcao.toString();
        }
        relatorio.addParametro("horaRecepcao", tmpHoraRecp);
        relatorio.addParametro("assinatura", recibo.getAssinaturaEletronica().formatado());
        String numRecibo = ITRUtil.formatarRecibo(recibo.getNumeroRecibo().formatado());
        relatorio.addParametro("numeroRecibo", numRecibo.substring(0, numRecibo.length() - 3));
        relatorio.addParametro("numeroReciboDv", numRecibo);
        String qtdMesesAtraso = recibo.getQtdMesesAtraso().formatado().trim();
        if (qtdMesesAtraso.length() > 0) {
            qtdMesesAtraso = String.valueOf(Integer.valueOf(qtdMesesAtraso));
        }
        relatorio.addParametro("qtdMeses", qtdMesesAtraso);
        relatorio.addParametro("distrito", recibo.getDistritoImovel().formatado());
        relatorio.addParametro("valorMulta", recibo.getValorMulta().formatado());
        relatorio.addParametro("nomeDelegado", recibo.getNomeDelegadoSRF().formatado());
        relatorio.addParametro("tipoCargo", recibo.getTipoDelegadoSRF().formatado());
        relatorio.addParametro("matricula", recibo.getNumMatriculaDelegadoSRF().formatado());
        relatorio.addParametro("nomeDelegacia", recibo.getTipoDelegacia().formatado() + " - " + recibo.getNomeUA().formatado());
        return relatorio;
    }

    public Relatorio imprimirPendencias(List pendencias, IdentificadorDeclaracao idDec) {
        String nomeArq = this.getPrefixoNomeArq(idDec.getNirf().naoFormatado(), idDec.getRetificadora()) + "-Pendencias";
        Relatorio relatorio = new Relatorio("Pend\u00eancias", "rePendencias.jasper", idDec.getPathArquivo(), "/classe", 1, nomeArq);
        ArrayList<ItemPendencia> itens = new ArrayList<ItemPendencia>();
        String titulo = "";
        int erros = 0;
        int avisos = 0;
        for (int i = 0; i < pendencias.size(); ++i) {
            LinhaPendencia linha = (LinhaPendencia)pendencias.get(i);
            String campo = linha.getCampo().replaceAll("<([^>])*>", "");
            ItemPendencia item = new ItemPendencia();
            if (linha.getSeveridade() == 0) {
                titulo = campo;
            } else {
                item.setCampo(campo);
                item.setIcone("/icones/erro.png");
                switch (linha.getSeveridade()) {
                    case 3: {
                        item.setIcone("icones/png10px/erro.png");
                        item.setTipo(LABEL_ERRO);
                        ++erros;
                        break;
                    }
                    case 2: {
                        item.setIcone("icones/png10px/aviso.png");
                        item.setTipo(LABEL_AVISO);
                        ++avisos;
                    }
                }
            }
            item.setTitulo(titulo);
            itens.add(item);
        }
        JRBeanCollectionDataSource dsPendencias = new JRBeanCollectionDataSource(itens);
        relatorio.addParametro("EXERCICIO", ConstantesGlobais.EXERCICIO);
        relatorio.addParametro("pendencias", dsPendencias);
        relatorio.addParametro("erros", String.valueOf(erros));
        relatorio.addParametro("avisos", String.valueOf(avisos));
        relatorio.addParametro("SUBREPORT_DIR", UtilitariosArquivo.localizaArquivoEmClasspath((String)"/relSubPendencias.jasper").toString());
        return relatorio;
    }

    public static class ItemPendencia {
        private String tipo;
        private String titulo;
        private String campo;
        private String icone;

        public ItemPendencia() {
            this.tipo = "";
            this.titulo = "";
            this.campo = "";
            this.icone = "";
        }

        public ItemPendencia(String numero, String titulo, String campo, String tipo) {
            this.tipo = numero;
            this.titulo = titulo;
            this.campo = campo;
            this.icone = tipo;
        }

        public String getCampo() {
            return this.campo;
        }

        public void setCampo(String campo) {
            this.campo = campo;
        }

        public String getTipo() {
            return this.tipo;
        }

        public void setTipo(String numero) {
            this.tipo = numero;
        }

        public String getIcone() {
            return this.icone;
        }

        public void setIcone(String tipo) {
            this.icone = tipo;
        }

        public String getTitulo() {
            return this.titulo;
        }

        public void setTitulo(String titulo) {
            this.titulo = titulo;
        }
    }

    public class TabAvisoCNIR {
        private String areaInicial;
        private String areaFinal;
        private String dataInicial;
        private String dataFinal;

        public String getAreaInicial() {
            return this.areaInicial;
        }

        public void setAreaInicial(String areaInicial) {
            this.areaInicial = areaInicial;
        }

        public String getAreaFinal() {
            return this.areaFinal;
        }

        public void setAreaFinal(String areaFinal) {
            this.areaFinal = areaFinal;
        }

        public String getDataInicial() {
            return this.dataInicial;
        }

        public void setDataInicial(String dataInicial) {
            this.dataInicial = dataInicial;
        }

        public String getDataFinal() {
            return this.dataFinal;
        }

        public void setDataFinal(String dataFinal) {
            this.dataFinal = dataFinal;
        }
    }

    public static class MensagemAvisoRecibo {
        private String mensagem;
        private Integer numero;

        public String getMensagem() {
            return this.mensagem;
        }

        public void setMensagem(String mensagem) {
            this.mensagem = mensagem;
        }

        public Integer getNumero() {
            return this.numero;
        }

        public void setNumero(Integer numero) {
            this.numero = numero;
        }
    }
}

