/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.impressao;

import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.print.PrinterException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import serpro.ppgd.formatosexternos.PPGDJasperViewer;
import serpro.ppgd.formatosexternos.RelatorioIf;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.impressao.RelatorioUtil;
import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.negocio.util.LogPPGD;

public class Relatorio
implements RelatorioIf {
    private String xml;
    private String raiz;
    private String relatorioJasper;
    private String titulo;
    private String nomeArquivo;
    private boolean habilitado = true;
    private HashMap parametros = new HashMap();
    private int tipoOperacao = 1;

    public Relatorio(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz, int tipoOperacao, String nomeArquivo) {
        this.setTitulo(aTitulo);
        this.setRelatorioJasper(aRelatorioJasper.replaceAll("%20", " "));
        this.setXml(aXml);
        this.setRaiz(aRaiz);
        this.setTipoOperacao(tipoOperacao);
        this.setNomeArquivo(nomeArquivo);
    }

    public Relatorio(String aTitulo, String aRelatorioJasper, int tipoOperacao) {
        this.setTitulo(aTitulo);
        this.setRelatorioJasper(aRelatorioJasper.replaceAll("%20", " "));
        this.setTipoOperacao(tipoOperacao);
    }

    public void visualizar() {
        switch (this.getTipoOperacao()) {
            case 1: {
                this.visualizarRelatorio();
                break;
            }
            case 2: {
                this.gerarPDF();
                break;
            }
            case 3: {
                this.imprimir();
            }
        }
    }

    private void visualizarRelatorio() {
        try {
            JasperPrint print;
            JREmptyDataSource xmlDataSource;
            if (this.getXml() != null && !this.getXml().equals("")) {
                xmlDataSource = new JRXmlDataSource(this.getXml(), this.getRaiz());
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                print = JasperFillManager.fillReport((InputStream)streamRel, (Map)this.parametros, (JRDataSource)xmlDataSource);
            } else {
                xmlDataSource = new JREmptyDataSource();
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                print = JasperFillManager.fillReport((InputStream)streamRel, (Map)this.parametros, (JRDataSource)xmlDataSource);
            }
            print.setName(this.nomeArquivo);
            RelatorioUtil.removerPaginasEmBranco(print);
            PPGDJasperViewer viewer = new PPGDJasperViewer(print, false, new Locale("pt", "BR"));
            viewer.setTitle(this.getTitulo());
            viewer.setIconImage(Frame.getFrames()[1].getIconImage());
            viewer.setVisible(true);
            viewer.addWindowFocusListener(new WindowFocusListener(){
                private boolean firstLost = true;

                @Override
                public void windowLostFocus(WindowEvent e) {
                    if (this.firstLost) {
                        e.getWindow().toFront();
                        this.firstLost = false;
                    }
                }

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void gerarPDF() {
        try {
            JasperPrint print;
            JREmptyDataSource xmlDataSource;
            if (this.getXml() != null && !this.getXml().equals("")) {
                xmlDataSource = new JRXmlDataSource(this.getXml(), this.getRaiz());
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                print = JasperFillManager.fillReport((InputStream)streamRel, (Map)this.parametros, (JRDataSource)xmlDataSource);
            } else {
                xmlDataSource = new JREmptyDataSource();
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                print = JasperFillManager.fillReport((InputStream)streamRel, (Map)this.parametros, (JRDataSource)xmlDataSource);
            }
            RelatorioUtil.removerPaginasEmBranco(print);
            byte[] bytes = JasperExportManager.exportReportToPdf((JasperPrint)print);
            ITRUtil.exibirArquivoNavegador(bytes, this.nomeArquivo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addParametro(String nome, String valor) {
        this.parametros.put(nome, valor);
    }

    public void addParametro(String nome, Object valor) {
        this.parametros.put(nome, valor);
    }

    public HashMap getAllParametro() {
        return this.parametros;
    }

    public void imprimir() {
        try {
            JasperPrint print;
            if (this.getXml() != null && !this.getXml().equals("")) {
                JRXmlDataSource xmlDataSource = new JRXmlDataSource(this.getXml(), this.getRaiz());
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                print = JasperFillManager.fillReport((InputStream)streamRel, (Map)this.parametros, (JRDataSource)xmlDataSource);
            } else {
                JREmptyDataSource xmlDataSource = new JREmptyDataSource();
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                print = JasperFillManager.fillReport((InputStream)streamRel, (Map)this.parametros, (JRDataSource)xmlDataSource);
            }
            RelatorioUtil.removerPaginasEmBranco(print);
            JasperPrintManager.printReport((JasperPrint)print, (boolean)false);
        }
        catch (JRException e) {
            if (e.getCause() instanceof PrinterException) {
                GuiUtil.mostrarErro(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "Ocorreu um erro ao tentar imprimir. Por favor, verifique se:\n\t1. a impressora est\u00e1 ligada e conectada ao computador;\n\t2. a impressora est\u00e1 acess\u00edvel via rede (caso n\u00e3o seja local);\n\t3. a impressora possui papel;\n\t4. a impressora possui tinta.");
            }
            e.printStackTrace();
        }
    }

    public JasperPrint obterPaginas() {
        try {
            JasperPrint print;
            if (this.getXml() != null && !this.getXml().equals("")) {
                JRXmlDataSource xmlDataSource = new JRXmlDataSource(this.getXml(), this.getRaiz());
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                LogPPGD.debug((String)("rel jasper: " + this.getRelatorioJasper()));
                LogPPGD.debug((String)("streamrel: " + streamRel));
                print = JasperFillManager.fillReport((InputStream)streamRel, (Map)this.parametros, (JRDataSource)xmlDataSource);
            } else {
                JREmptyDataSource xmlDataSource = new JREmptyDataSource();
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                print = JasperFillManager.fillReport((InputStream)streamRel, (Map)this.parametros, (JRDataSource)xmlDataSource);
            }
            return print;
        }
        catch (JRException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setHabilitado(boolean habilitado) {
        this.habilitado = habilitado;
    }

    public boolean isHabilitado() {
        return this.habilitado;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public String getXml() {
        return this.xml;
    }

    private void setRaiz(String raiz) {
        this.raiz = raiz;
    }

    private String getRaiz() {
        return this.raiz;
    }

    private void setRelatorioJasper(String relatorioJasper) {
        this.relatorioJasper = relatorioJasper;
    }

    private String getRelatorioJasper() {
        return this.relatorioJasper;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void prepara() {
    }

    public boolean isPreparado() {
        return false;
    }

    public int getTipoOperacao() {
        return this.tipoOperacao;
    }

    public void setTipoOperacao(int tipoOperacao) {
        this.tipoOperacao = tipoOperacao;
    }

    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }
}

