/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.impressao;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import org.apache.commons.lang3.StringUtils;
import serpro.ppgd.formatosexternos.RelatorioIf;
import serpro.ppgd.formatosexternos.RelatorioXML;
import serpro.ppgd.gui.NavegadorHtml;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.gui.util.PdfUtil;
import serpro.ppgd.itr.util.ArquivoUtil;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class RelatorioMultiploXMLITR
implements RelatorioIf {
    private List<RelatorioXML> relatorios = new ArrayList<RelatorioXML>();
    private List<DuplaParam> parametros = new ArrayList<DuplaParam>();
    private String titulo;
    private String nomeArquivo;
    private JasperPrint jasperPrint;
    private String[] docImpressaoDitrWeb = null;
    private boolean impressaoDitrWeb = false;
    private String[] darfsSenda = null;
    private boolean darf = false;
    private boolean reciboMaed = false;
    private boolean preparado = false;
    private String PARAM_PAG_INICIAL = "pagInicial";

    public RelatorioMultiploXMLITR() {
    }

    public RelatorioMultiploXMLITR(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz, String nomeArquivo) {
        this.titulo = aTitulo;
        this.nomeArquivo = nomeArquivo;
        this.getRelatorios().add(new RelatorioXML(aTitulo, aRelatorioJasper, aXml, aRaiz));
    }

    public RelatorioMultiploXMLITR(String aTitulo, String aRelatorioJasper, String nomeArquivo) {
        this.titulo = aTitulo;
        this.nomeArquivo = nomeArquivo;
        this.getRelatorios().add(new RelatorioXML(aTitulo, aRelatorioJasper));
    }

    public RelatorioMultiploXMLITR(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz) {
        this.titulo = aTitulo;
        this.getRelatorios().add(new RelatorioXML(aTitulo, aRelatorioJasper, aXml, aRaiz));
    }

    public RelatorioMultiploXMLITR(String aTitulo, String aRelatorioJasper) {
        this.titulo = aTitulo;
        this.getRelatorios().add(new RelatorioXML(aTitulo, aRelatorioJasper));
    }

    public void addRelatorioXML(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz) {
        RelatorioXML novoRelatorio = new RelatorioXML(aTitulo, aRelatorioJasper, aXml, aRaiz);
        for (int x = 0; x < this.parametros.size(); ++x) {
            String nome = this.parametros.get(x).getNome();
            Object valor = this.parametros.get(x).getValor();
            novoRelatorio.addParametro(nome, valor);
        }
        this.getRelatorios().add(novoRelatorio);
    }

    public void addRelatorioXML(String aTitulo, String aRelatorioJasper) {
        RelatorioXML novoRelatorio = new RelatorioXML(aTitulo, aRelatorioJasper);
        for (int x = 0; x < this.parametros.size(); ++x) {
            String nome = this.parametros.get(x).getNome();
            Object valor = this.parametros.get(x).getValor();
            novoRelatorio.addParametro(nome, valor);
        }
        this.getRelatorios().add(novoRelatorio);
    }

    public void imprimir() {
        if (ConstantesGlobaisITR.DARF_SENDA && this.isDarf()) {
            if (this.verificarDarfSendaGerado()) {
                this.imprimirPDF(this.getDarfsSenda());
            }
        } else if (this.isReciboMaed()) {
            this.imprimirPDF(this.getBase64ReciboMaed());
        } else if (this.isImpressaoDitrWeb()) {
            this.imprimirPDF(this.getDocImpressaoDitrWeb());
        } else {
            this.imprimirJasper();
        }
    }

    private void imprimirJasper() {
        try {
            this.prepara();
            JasperPrintManager.printReport((JasperPrint)this.jasperPrint, (boolean)false);
            LogPPGD.debug((String)"Impress\u00e3o via JASPER realizada!");
        }
        catch (JRException e) {
            LogPPGD.erro((String)("Ocorreu uma falha na impress\u00e3o do JasperPrint: " + e.getMessage()));
        }
    }

    private void imprimirPDF(String[] conteudoBase64) {
        String file = this.obterCaminhoArquivo().concat(this.obterNomeArquivo()).concat(".pdf");
        PdfUtil.imprimir(conteudoBase64, file);
        LogPPGD.debug((String)"Impress\u00e3o via PDF realizada!");
    }

    public void gerarPDF() {
        if (ConstantesGlobaisITR.DARF_SENDA && this.isDarf()) {
            if (this.verificarDarfSendaGerado()) {
                this.gerarPDF(this.getDarfsSenda());
            }
        } else if (this.isReciboMaed()) {
            this.gerarPDF(this.getBase64ReciboMaed());
        } else if (this.isImpressaoDitrWeb()) {
            this.gerarPDF(this.getDocImpressaoDitrWeb());
        } else {
            this.gerarPdfJasper();
        }
    }

    private void gerarPDF(String[] conteudoBase64) {
        try {
            String file = this.obterCaminhoArquivo().concat(this.obterNomeArquivo()).concat(".pdf");
            PdfUtil.apagarArquivo(new File(file));
            PdfUtil.mergePdfs(conteudoBase64, file);
            NavegadorHtml.executarNavegador((String)("file://" + file));
        }
        catch (Exception e) {
            LogPPGD.erro((String)("Ocorreu uma falha na gera\u00e7\u00e3o do PDF: " + e.getMessage()));
        }
    }

    private void gerarPdfJasper() {
        try {
            byte[] bytes = this.getBytesPdfJasper();
            String nomeArq = this.obterNomeArquivo();
            Object caminho = this.obterCaminhoArquivo();
            caminho = (String)caminho + nomeArq + ".pdf";
            FileOutputStream stream = new FileOutputStream((String)caminho);
            stream.write(bytes);
            stream.close();
            NavegadorHtml.executarNavegador((String)("file://" + (String)caminho));
        }
        catch (Exception e) {
            LogPPGD.erro((String)("Ocorreu uma falha na gera\u00e7\u00e3o do PDF do Jasper: " + e.getMessage()));
        }
    }

    private byte[] getBytesPdfJasper() throws JRException {
        this.prepara();
        byte[] bytes = JasperExportManager.exportReportToPdf((JasperPrint)this.jasperPrint);
        return bytes;
    }

    private String obterCaminhoArquivo() {
        String caminho = FabricaUtilitarios.isLinux() || FabricaUtilitarios.isMac() ? UtilitariosArquivo.getPathUsuario() : UtilitariosArquivo.getPathAplicacao();
        caminho = caminho.concat("temp").concat(File.separator);
        ArquivoUtil.criarDiretorios(caminho);
        return caminho;
    }

    private String obterNomeArquivo() {
        Object nomeArq;
        if (this.getNomeArquivo() != null) {
            nomeArq = this.getNomeArquivo();
        } else {
            long diferenciador = new Date().getTime();
            nomeArq = "relatorio" + diferenciador;
        }
        return nomeArq;
    }

    public void prepara() {
        if (!this.isPreparado()) {
            int pageCount = 1;
            this.setJasperPrint(new JasperPrint());
            int y = this.getRelatorios().size();
            for (int x = 0; x < y; ++x) {
                this.addParametro(this.PARAM_PAG_INICIAL, String.valueOf(pageCount), x);
                JasperPrint printTmp = this.getRelatorios().get(x).obterPaginas();
                List lista = printTmp.getPages();
                pageCount += lista.size();
                if (x == 0) {
                    this.setJasperPrint(printTmp);
                    continue;
                }
                for (int i = 0; i < lista.size(); ++i) {
                    this.getJasperPrint().addPage((JRPrintPage)lista.get(i));
                }
            }
            this.getJasperPrint().setName(this.getNomeArquivo());
            this.preparado = true;
        }
    }

    public void visualizar() {
        if (ConstantesGlobaisITR.DARF_SENDA && this.isDarf()) {
            if (this.verificarDarfSendaGerado()) {
                this.visualizarPdf(this.getDarfsSenda(), this.getTitulo());
            }
        } else if (this.isReciboMaed()) {
            this.visualizarPdf(this.getBase64ReciboMaed(), this.getTitulo());
        } else if (this.isImpressaoDitrWeb()) {
            this.visualizarPdf(this.getDocImpressaoDitrWeb(), this.getTitulo());
        } else {
            this.visualizarJasper();
        }
    }

    public void visualizarJasper() {
        try {
            String[] pdfBase64 = new String[1];
            byte[] pdf = this.getBytesPdfJasper();
            pdfBase64[0] = Base64.getEncoder().encodeToString(pdf);
            this.visualizarPdf(pdfBase64, this.getTitulo());
        }
        catch (Exception e) {
            LogPPGD.erro((String)("Ocorreu uma falha na visualiza\u00e7\u00e3o do relatorio Jasper: " + e.getMessage()));
        }
    }

    public void visualizarPdf(String[] conteudoBase64, String titulo) {
        try {
            String nomeArquivo = this.obterNomeArquivo();
            String file = this.obterCaminhoArquivo().concat(nomeArquivo).concat(".pdf");
            byte[] pdf = PdfUtil.mergePdfs(conteudoBase64, file);
            PdfUtil.abrirPdfComVisualizadorPadrao(pdf, nomeArquivo);
            PdfUtil.apagarArquivo(new File(file));
        }
        catch (Exception e) {
            LogPPGD.erro((String)("Ocorreu uma falha na visualiza\u00e7\u00e3o do PDF: " + e.getMessage()));
        }
    }

    private String[] getBase64ReciboMaed() {
        String[] reciboMaed = new String[2];
        try {
            byte[] reciboPdf = this.getBytesPdfJasper();
            reciboMaed[0] = Base64.getEncoder().encodeToString(reciboPdf);
            if (this.getDarfsSenda().length > 0) {
                reciboMaed[1] = this.darfsSenda[0];
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)("Ocorreu uma falha na obten\u00e7\u00e3o do PDF base64 Recicbo com MAED: " + e.getMessage()));
        }
        return reciboMaed;
    }

    public boolean verificarDarfSendaGerado() {
        boolean darfCriado = true;
        String darfs = "";
        for (String darf : this.getDarfsSenda()) {
            if (!StringUtils.isNotEmpty((CharSequence)darf)) continue;
            darfs = darfs.concat(darf);
        }
        if (StringUtils.isEmpty((CharSequence)darfs)) {
            LogPPGD.debug((String)"A impress\u00e3o do Darf n\u00e3o p\u00f4de ser realizada.");
            darfCriado = false;
        }
        return darfCriado;
    }

    public void addParametro(String nome, String valor) {
        for (int x = 0; x < this.getRelatorios().size(); ++x) {
            this.getRelatorios().get(x).addParametro(nome, valor);
        }
        this.parametros.add(new DuplaParam(nome, valor));
    }

    public void addParametro(String nome, String valor, int indice) {
        this.getRelatorios().get(indice).addParametro(nome, valor);
    }

    public void addParametro(String nome, Object valor) {
        for (int x = 0; x < this.getRelatorios().size(); ++x) {
            this.getRelatorios().get(x).addParametro(nome, valor);
        }
        this.parametros.add(new DuplaParam(nome, valor));
    }

    public void addParametroUltimo(String nome, String valor) {
        this.getRelatorios().get(this.getRelatorios().size() - 1).addParametro(nome, valor);
    }

    public List<DuplaParam> getAllParametro() {
        return this.parametros;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String aTitulo) {
        this.titulo = aTitulo;
    }

    public boolean isHabilitado() {
        return false;
    }

    public void setHabilitado(boolean aHabilitado) {
    }

    public boolean isPreparado() {
        return this.preparado;
    }

    public int getQtdPaginas() {
        int qtd = -1;
        if (this.isPreparado()) {
            qtd = this.jasperPrint.getPages().size();
        }
        return qtd;
    }

    public void setRelatorios(List<RelatorioXML> relatorios) {
        this.relatorios = relatorios;
    }

    public List<RelatorioXML> getRelatorios() {
        return this.relatorios;
    }

    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    protected JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    protected void setJasperPrint(JasperPrint jasperPrint) {
        this.jasperPrint = jasperPrint;
    }

    public String[] getDarfsSenda() {
        return this.darfsSenda;
    }

    public void setDarfsSenda(String[] darfsSenda) {
        this.darfsSenda = darfsSenda;
    }

    public boolean isDarf() {
        return this.darf;
    }

    public void setDarf(boolean darf) {
        this.darf = darf;
    }

    public boolean isReciboMaed() {
        return this.reciboMaed;
    }

    public void setReciboMaed(boolean reciboMaed) {
        this.reciboMaed = reciboMaed;
    }

    public String[] getDocImpressaoDitrWeb() {
        return this.docImpressaoDitrWeb;
    }

    public void setDocImpressaoDitrWeb(String[] docImpressaoDitrWeb) {
        this.docImpressaoDitrWeb = docImpressaoDitrWeb;
    }

    public boolean isImpressaoDitrWeb() {
        return this.impressaoDitrWeb;
    }

    public void setImpressaoDitrWeb(boolean impressaoDitrWeb) {
        this.impressaoDitrWeb = impressaoDitrWeb;
    }

    private class DuplaParam {
        String nome;
        Object valor;

        public String getNome() {
            return this.nome;
        }

        public void setNome(String nome) {
            this.nome = nome;
        }

        public Object getValor() {
            return this.valor;
        }

        public void setValor(Object valor) {
            this.valor = valor;
        }

        public DuplaParam(String nome, Object valor) {
            this.nome = nome;
            this.valor = valor;
        }
    }
}

