/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.nuvem;

import com.google.gson.Gson;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jsignnet.aplicacao.Hash;
import jsignnet.crypto.X509CertificadoWrapper;
import jsignnet.erro.ErroAoGerarPKCS7;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.exception.AplicacaoException;
import serpro.ppgd.itr.exception.BarramentoException;
import serpro.ppgd.itr.nuvem.BarramentoITRUtil;
import serpro.ppgd.itr.nuvem.RetornoBarramento;
import serpro.ppgd.itr.nuvem.UsuarioLogado;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class BarramentoITRFService {
    public static final String RETORNO_OK = "00";
    public static final String RETORNO_CAPTCHA_INCORRETO = "90";
    public static final String RETORNO_ERRO = "99";
    public static final String RETORNO_ERRO_406 = "406";
    public static final String RETORNO_CPF_NAO_EXISTE = "94";
    private static final String URL_BASE_REST = !ConstantesGlobaisITR.FASE.equalsIgnoreCase("Producao") ? ConstantesGlobaisITR.URL_BARRAMENTO_HOM : ConstantesGlobaisITR.URL_BARRAMENTO_PRO;
    public static final String CONTEXTO_LOCALHOST_GOV = "/itr/login";
    public static final String URL_AUTENTICACAO_GOV_LOGIN = URL_BASE_REST + "/barramento/acessogov/login";
    public static final String URL_AUTENTICACAO_GOV_LOGOUT = URL_BASE_REST + "/barramento/acessogov/logout/redirect";
    private static final String URL_AUTENTICACAO_GOV_TOKEN = URL_BASE_REST + "/barramento/acessogov/login/token";
    public static final String URL_AUTENTICACAO_GOV_CONFRIMA_LOGIN = URL_BASE_REST + "/barramento/acessogov/login/finished";
    public static final String URL_DATA_HORA = URL_BASE_REST + "/dataHora";
    private static final String versaoPGD = FabricaUtilitarios.getProperties().getProperty("versao_txt");
    private static HttpServer server = null;
    private static UsuarioLogado usuarioLogado = null;
    private static String token = null;

    private BarramentoITRFService() {
    }

    public static Map<String, String> getQueryMap(String query) {
        String[] params = query.split("&");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String param : params) {
            String[] paramPair = param.split("=");
            String name = paramPair[0];
            String value = paramPair[1];
            map.put(name, value);
        }
        return map;
    }

    public static void logout() {
        usuarioLogado = null;
        token = null;
    }

    private static boolean login(HttpExchange httpExchange, String originalState) throws BarramentoException {
        boolean ret;
        String url;
        String query = httpExchange.getRequestURI().getQuery();
        System.out.println("Query: " + query);
        BarramentoException ex = null;
        if (query != null) {
            Object mensagemRetorno;
            String codigoRetorno;
            block9: {
                Map<String, String> queryMap = BarramentoITRFService.getQueryMap(query);
                String code = queryMap.get("code");
                String state = queryMap.get("state");
                if (originalState.equals(state)) {
                    try {
                        token = BarramentoITRFService.obterTokenAcessoITR(code, state);
                        usuarioLogado = BarramentoITRFService.obterUsuarioLogado(token);
                        codigoRetorno = "0";
                        mensagemRetorno = usuarioLogado.getNome();
                        if (ConstantesGlobaisITR.FASE.equalsIgnoreCase("Producao")) break block9;
                        try {
                            System.out.println("tokenAcessoITR:" + new String(Base64.decodeBase64(token.split("\\.")[1].getBytes()), "UTF-8"));
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (BarramentoException e) {
                        codigoRetorno = "1";
                        mensagemRetorno = "Ocorreu um erro durante a solicita\u00e7\u00e3o de acesso a dados do contribuinte. " + e.getMessage();
                        ex = new BarramentoException((String)mensagemRetorno, codigoRetorno, e);
                    }
                } else {
                    codigoRetorno = "1";
                    mensagemRetorno = "Dados de entrada incorretos. Estado inv\u00e1lido.";
                    ex = new BarramentoException((String)mensagemRetorno, codigoRetorno);
                }
            }
            String responseQuery = "exercicio=" + ConstantesGlobais.EXERCICIO + "&codigoRetorno=" + codigoRetorno + "&mensagemRetorno=" + URLEncoder.encode((String)mensagemRetorno, StandardCharsets.ISO_8859_1);
            url = URL_AUTENTICACAO_GOV_CONFRIMA_LOGIN + "?" + responseQuery;
            ret = true;
        } else {
            url = URL_AUTENTICACAO_GOV_LOGIN + "?exercicio=" + ConstantesGlobais.EXERCICIO + "&state=" + originalState;
            ret = false;
        }
        BarramentoITRFService.redirectHTTP(httpExchange, url);
        if (ex != null) {
            throw ex;
        }
        return ret;
    }

    public static void redirectHTTP(HttpExchange httpExchange, String url) throws BarramentoException {
        httpExchange.getResponseHeaders().add("Content-Type", "text/html; charset=UTF-8");
        httpExchange.getResponseHeaders().add("Cache-Control", "no-cache, no-store, must-revalidate");
        httpExchange.getResponseHeaders().add("Location", url);
        try {
            httpExchange.sendResponseHeaders(301, 0L);
            httpExchange.getResponseBody().close();
        }
        catch (Exception e) {
            throw new BarramentoException("Ocorreu um erro ao acessar servi\u00e7o para confirma\u00e7\u00e3o de Login.", RETORNO_ERRO);
        }
    }

    public static void stopHTTPLocalhostServer() {
        if (server != null) {
            ExecutorService ex = (ExecutorService)server.getExecutor();
            try {
                ex.submit(() -> ex.shutdown());
                server.stop(0);
                server = null;
                System.out.println("\nHTTP stoping server");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void initHTTPLocalhostServer(Runnable executarAposSucesso, Runnable executarAposErro, String state) throws BarramentoException {
        try {
            if (server == null) {
                server = HttpServer.create(new InetSocketAddress(9991), 0);
                ExecutorService ex = Executors.newSingleThreadExecutor();
                server.createContext(CONTEXTO_LOCALHOST_GOV, httpExchange -> {
                    System.out.println("-----------------------------------------");
                    System.out.println("Executando /itr/login");
                    System.out.println("-----------------------------------------");
                    try {
                        if (BarramentoITRFService.login(httpExchange, state)) {
                            executarAposSucesso.run();
                        }
                    }
                    catch (BarramentoException e) {
                        e.printStackTrace();
                        executarAposErro.run();
                    }
                });
                server.setExecutor(ex);
                server.start();
                System.out.println("HTTP server started");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            RetornoBarramento retornoBarramento = new RetornoBarramento();
            retornoBarramento.setCodigoRetorno(RETORNO_ERRO);
            retornoBarramento.setMensagemRetorno("N\u00e3o foi poss\u00edvel iniciar o servi\u00e7o de Login");
            retornoBarramento.setException(e.getMessage());
            throw new BarramentoException(retornoBarramento);
        }
    }

    public static String obterTokenAcessoITR(String code, String state) throws BarramentoException {
        RetornoBarramento retornoBarramento;
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put("code", code);
        parametros.put("state", state);
        String hashParametros = BarramentoITRUtil.gerarHashParametros(parametros);
        String json = StringUtils.newStringUtf8(BarramentoITRFService.chamarServicoRestPost(URL_AUTENTICACAO_GOV_TOKEN, parametros, hashParametros)).trim();
        if (!ConstantesGlobaisITR.FASE.equalsIgnoreCase("Producao")) {
            System.out.println("Parametros: " + ((Object)parametros).toString());
            System.out.println("Retorno: " + json);
        }
        if (!(retornoBarramento = (RetornoBarramento)new Gson().fromJson(json, RetornoBarramento.class)).getCodigoRetorno().equals(RETORNO_OK)) {
            throw new BarramentoException(retornoBarramento);
        }
        return retornoBarramento.getConteudo();
    }

    public static UsuarioLogado obterUsuarioLogado(String token) throws BarramentoException {
        UsuarioLogado usuario;
        try {
            String json = new String(Base64.decodeBase64(token.split("\\.")[1].getBytes()), "UTF-8");
            usuario = (UsuarioLogado)new Gson().fromJson(json, UsuarioLogado.class);
        }
        catch (Throwable e) {
            RetornoBarramento retBarramento = new RetornoBarramento();
            retBarramento.setCodigoRetorno(RETORNO_ERRO);
            retBarramento.setMensagemRetorno("Servi\u00e7o retornou um dado inv\u00e1lido.");
            retBarramento.setException(ExceptionUtils.getStackTrace((Throwable)e));
            throw new BarramentoException(retBarramento);
        }
        return usuario;
    }

    public static String gerarAssinaturaBase64(X509CertificadoWrapper certificado, byte[] conteudo) throws AplicacaoException {
        try {
            byte[] assinatura = certificado.assinaPKCS7(Hash.MESMO_DO_CERTIFICADO, conteudo, certificado.getSenhaContainer(), true, true);
            return new String(Base64.encodeBase64(assinatura, true, true));
        }
        catch (ErroAoGerarPKCS7 e) {
            throw new AplicacaoException("Ocorreu um erro durante assinatura de dados.", e, false);
        }
    }

    public static Date obterDataServidor() throws BarramentoException {
        RetornoBarramento retornoBarramento;
        String url = URL_DATA_HORA;
        String retorno = StringUtils.newStringUtf8(BarramentoITRFService.chamarServicoRestGet(url, null, null));
        if (!ConstantesGlobaisITR.FASE.equalsIgnoreCase("Producao")) {
            System.out.println("Retorno: " + retorno);
        }
        try {
            if (retorno.matches("^\\d{14}$")) {
                return new SimpleDateFormat("yyyyMMddHHmmss").parse(retorno);
            }
            retornoBarramento = (RetornoBarramento)new Gson().fromJson(retorno, RetornoBarramento.class);
        }
        catch (Exception e) {
            retornoBarramento = new RetornoBarramento();
            retornoBarramento.setCodigoRetorno(RETORNO_ERRO);
            retornoBarramento.setMensagemRetorno(MensagemUtil.getMensagem("nuvem.erro.servico_indisponivel"));
            retornoBarramento.setException("Erro durante consulta a Data atual. [Retorno:" + retorno + "]");
        }
        throw new BarramentoException(retornoBarramento);
    }

    private static byte[] chamarServicoRestGet(String url, Map<String, String> parametros, String hash) {
        return BarramentoITRFService.chamarServicoRest("GET", url, parametros, hash);
    }

    private static byte[] chamarServicoRestPost(String url, Map<String, String> parametros, String hash) {
        return BarramentoITRFService.chamarServicoRest("POST", url, parametros, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] chamarServicoRest(String method, String url, Map<String, String> parametros, String hash) {
        String msgErro;
        HttpURLConnection con = null;
        try {
            URL obj = new URL(url);
            con = BarramentoITRFService.getURLConnection(obj);
            byte[] byArray = BarramentoITRFService.chamarServicoRest(con, method, parametros, hash);
            return byArray;
        }
        catch (IOException e) {
            LogPPGD.erro((String)("Erro de conex\u00e3o: " + e));
            e.printStackTrace();
            msgErro = MensagemUtil.getMensagem("nuvem.erro.inesperado");
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        RetornoBarramento retornoBarramento = new RetornoBarramento();
        retornoBarramento.setCodigoRetorno(RETORNO_ERRO);
        retornoBarramento.setMensagemRetorno(msgErro);
        return StringUtils.getBytesUtf8(new Gson().toJson((Object)retornoBarramento));
    }

    private static byte[] chamarServicoRest(HttpURLConnection con, String method, Map<String, String> parametros, String hash) {
        byte[] retorno = null;
        RetornoBarramento retornoBarramento = new RetornoBarramento();
        try {
            ByteArrayOutputStream baf;
            BufferedInputStream bis;
            int responseCode;
            boolean first = true;
            StringBuilder urlParameters = null;
            if (parametros != null && !parametros.isEmpty()) {
                urlParameters = new StringBuilder();
                for (String nomeParametro : parametros.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        urlParameters.append("&");
                    }
                    String valorParametro = parametros.get(nomeParametro);
                    urlParameters.append(nomeParametro).append("=").append(valorParametro);
                }
            }
            con.setRequestMethod(method);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setRequestProperty("charset", "iso-8859-1");
            if (urlParameters != null) {
                con.setRequestProperty("Content-Length", Integer.toString(urlParameters.toString().getBytes().length));
            }
            if (hash != null) {
                con.setRequestProperty("hash", hash);
            }
            con.setRequestProperty("versao_pgd", versaoPGD);
            con.setRequestProperty("exercicio", ConstantesGlobais.EXERCICIO);
            con.setDoOutput(true);
            if (urlParameters != null) {
                try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                    wr.writeBytes(urlParameters.toString());
                    wr.flush();
                }
                catch (Exception e) {
                    throw new AplicacaoException("nuvem.erro.inesperado", e);
                }
            }
            if ((responseCode = con.getResponseCode()) == 200) {
                bis = new BufferedInputStream(con.getInputStream());
                try {
                    baf = new ByteArrayOutputStream(50);
                    try {
                        int read = 0;
                        int bufSize = 512;
                        byte[] buffer = new byte[bufSize];
                        while ((read = bis.read(buffer)) != -1) {
                            baf.write(buffer, 0, read);
                        }
                        retorno = baf.toByteArray();
                    }
                    finally {
                        baf.close();
                    }
                }
                finally {
                    bis.close();
                }
                return retorno;
            }
            bis = new BufferedInputStream(con.getErrorStream());
            try {
                baf = new ByteArrayOutputStream(50);
                try {
                    int read = 0;
                    int bufSize = 512;
                    byte[] buffer = new byte[bufSize];
                    while ((read = bis.read(buffer)) != -1) {
                        baf.write(buffer, 0, read);
                    }
                    retornoBarramento.setException(new String(baf.toByteArray()));
                }
                finally {
                    baf.close();
                }
            }
            finally {
                bis.close();
            }
            if (responseCode / 100 == 5) {
                retornoBarramento.setMensagemRetorno(MensagemUtil.getMensagem("nuvem.erro.servico_indisponivel"));
            } else {
                retornoBarramento.setMensagemRetorno(MensagemUtil.getMensagem("nuvem.erro.inesperado"));
            }
        }
        catch (AplicacaoException e) {
            LogPPGD.erro((String)e.getMessage());
            e.printStackTrace();
            retornoBarramento.setMensagemRetorno(e.getMessage());
        }
        catch (Throwable e) {
            LogPPGD.erro((String)e.getMessage());
            e.printStackTrace();
            retornoBarramento.setMensagemRetorno(MensagemUtil.getMensagem("nuvem.erro.inesperado"));
        }
        retornoBarramento.setCodigoRetorno(RETORNO_ERRO);
        return StringUtils.getBytesUtf8(new Gson().toJson((Object)retornoBarramento));
    }

    private static HttpURLConnection getURLConnection(String url) throws AplicacaoException {
        try {
            return BarramentoITRFService.getURLConnection(new URL(url));
        }
        catch (IOException e) {
            throw new AplicacaoException("N\u00e3o \u00e9 poss\u00edvel conectar ao servi\u00e7o.", e, false);
        }
    }

    private static HttpURLConnection getURLConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    public static UsuarioLogado getUsuarioLogado() {
        return usuarioLogado;
    }
}

