/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.nuvem;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import serpro.ppgd.app.MensagensIf;
import serpro.ppgd.itr.exception.AplicacaoException;
import serpro.ppgd.itr.gui.util.ObfuscatedString;
import serpro.ppgd.negocio.util.LogPPGD;

public final class BarramentoITRUtil {
    private static final String HASH_KEY = new ObfuscatedString(new long[]{5248493371353446733L, -1145172901818804059L, 7965234193472123598L}).toString();
    private static final String HASH_ALGORITHM = "HmacSHA1";
    private static final String DEFAULT_ENCODING = "UTF-8";

    private BarramentoITRUtil() {
    }

    public static String UTF8toISO(String str) {
        Charset utf8charset = Charset.forName(DEFAULT_ENCODING);
        Charset iso88591charset = Charset.forName("ISO-8859-1");
        ByteBuffer inputBuffer = ByteBuffer.wrap(str.getBytes());
        CharBuffer data = utf8charset.decode(inputBuffer);
        ByteBuffer outputBuffer = iso88591charset.encode(data);
        byte[] outputData = outputBuffer.array();
        return new String(outputData);
    }

    public static String compactarDeclaracao(InputStream inputStream) throws AplicacaoException {
        String retorno = null;
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ZipOutputStream zos = new ZipOutputStream(bos);){
            int len;
            ZipEntry ze = new ZipEntry("declaracao");
            zos.putNextEntry(ze);
            while ((len = inputStream.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            zos.closeEntry();
            retorno = Base64.encodeBase64URLSafeString(bos.toByteArray());
        }
        catch (IOException e) {
            throw new AplicacaoException(MensagensIf.NUVEM_ERRO_COMPACTAR_DECLARACAO, e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return retorno;
    }

    public static byte[] descompactarDeclaracao(String declaracaoCompactada) throws AplicacaoException {
        byte[] buffer = new byte[1024];
        byte[] retorno = null;
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(Base64.decodeBase64(declaracaoCompactada)));
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                while ((len = zis.read(buffer)) > 0) {
                    baos.write(buffer, 0, len);
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            retorno = baos.toByteArray();
        }
        catch (IOException e) {
            throw new AplicacaoException(MensagensIf.NUVEM_ERRO_DESCOMPACTAR_DECLARACAO);
        }
        return retorno;
    }

    public static String gerarHashParametros(Map<String, String> mapParametros) {
        StringBuilder parametrosConcatenados = new StringBuilder();
        for (String chave : mapParametros.keySet()) {
            parametrosConcatenados.append(mapParametros.get(chave));
        }
        return BarramentoITRUtil.generateHash(parametrosConcatenados.toString());
    }

    public static String generateHash(String text) {
        SecretKeySpec keySpec = new SecretKeySpec(HASH_KEY.getBytes(), HASH_ALGORITHM);
        try {
            Mac mac = Mac.getInstance(HASH_ALGORITHM);
            mac.init(keySpec);
            byte[] rawMac = mac.doFinal(text.getBytes(DEFAULT_ENCODING));
            byte[] hexBytes = new Hex().encode(rawMac);
            return new String(hexBytes, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException | IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
            LogPPGD.erro((String)e.getMessage());
            return null;
        }
    }
}

