/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.tabelas;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import serpro.ppgd.formatosexternos.hash.UtilitariosHash;
import serpro.ppgd.formatosexternos.hash.excecao.HashIncorretoException;
import serpro.ppgd.itr.tabelas.PreencheElementoTabelaIf;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.TrataErroSistemicoIf;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.repositorio.RepositorioTabelasBasicasIf;
import serpro.ppgd.repositorio.repositorioXML.RepositorioTabelasBasicasXML;

public abstract class CadastroTabelasITR {
    private static RepositorioTabelasBasicasIf repositorioTabelasBasicas = new RepositorioTabelasBasicasXML();
    private static TrataErroSistemicoIf trataErro = FabricaTratamentoErro.getTrataErroSistemico();
    private static boolean testarCRC = true;
    private static Map municipios = new Hashtable();
    private static Map municipiosCalamidade = new Hashtable();
    private static List ufs = new Vector();
    private static List tipoLogradouroImovel = new Vector();
    private static List tipoLogradouroContribuinte = new Vector();
    private static String EXTENSAO_ARQ_DADOS = ".txt";
    private static String EXTENSAO_ARQ_HASH = ".hsh";
    private static String NOME_ARQ_TIPOSLOGRADOURO_IMOVEL = "TiposLogradourosImovel";
    private static String NOME_ARQ_ESTADOS = "Estados";
    private static String NOME_ARQ_UF_MT = "MT";
    private static String NOME_ARQ_TIPOSLOGRADOURO_CONTRIBUINTE = "TiposLogradourosContribuinte";
    private static String NOME_ARQ_MUNICIPIOS_EM_CALAMIDADE = "MunicipiosCalamidade";

    public static List getListaMunicipios(String pCodUf) {
        if (!municipios.containsKey(pCodUf)) {
            municipios.put(pCodUf, CadastroTabelasITR.getMunicipiosDaUf(pCodUf));
        }
        List retorno = (List)municipios.get(pCodUf);
        return retorno;
    }

    private static List getMunicipiosDaUf(String pArquivo) {
        final Vector retorno = new Vector();
        CadastroTabelasITR.carregaArquivo(pArquivo, new PreencheElementoTabelaIf(){

            @Override
            public void preencheElementoTabela(ElementoTabela pElementoTabela, String linha, int numLinha) {
                if (numLinha != 1) {
                    String codRegiao = linha.substring(0, 1);
                    String codMunicipio = linha.substring(1, 5);
                    String indiceLotacao = linha.substring(5, 8);
                    String nomeMunicipio = linha.substring(8, 48);
                    String V1 = linha.substring(48, 61);
                    String V2 = linha.substring(61, 74);
                    String V3 = linha.substring(74, 87);
                    String V4 = linha.substring(87, 100);
                    String codigoUFIBGE = linha.substring(100, 102);
                    String codigoMunicipioIBGE = linha.substring(102, 107);
                    String uaMunicipio = linha.substring(107, 114);
                    int lenLinhaEsperado = 242;
                    if (linha.length() < lenLinhaEsperado) {
                        lenLinhaEsperado = linha.length();
                    }
                    String faixaCeps = linha.substring(114, lenLinhaEsperado);
                    pElementoTabela.setConteudo(0, codMunicipio.trim());
                    pElementoTabela.setConteudo(1, nomeMunicipio.trim());
                    pElementoTabela.setConteudo(2, indiceLotacao.trim());
                    pElementoTabela.setConteudo(3, codRegiao.trim());
                    pElementoTabela.setConteudo(4, faixaCeps.trim());
                    pElementoTabela.setConteudo(5, V1.trim());
                    pElementoTabela.setConteudo(6, V2.trim());
                    pElementoTabela.setConteudo(7, V3.trim());
                    pElementoTabela.setConteudo(8, V4.trim());
                    pElementoTabela.setConteudo(9, codigoUFIBGE.trim());
                    pElementoTabela.setConteudo(10, codigoMunicipioIBGE.trim());
                    pElementoTabela.setConteudo(11, uaMunicipio.trim());
                    retorno.add(pElementoTabela);
                }
            }
        });
        return retorno;
    }

    public static List getUfs() {
        if (ufs.isEmpty()) {
            CadastroTabelasITR.carregaArquivo(NOME_ARQ_ESTADOS, new PreencheElementoTabelaIf(){

                @Override
                public void preencheElementoTabela(ElementoTabela pElementoTabela, String linha, int numLinha) {
                    pElementoTabela.setConteudo(0, UtilitariosString.removeAcentos((String)linha.trim().toUpperCase()));
                    pElementoTabela.setConteudo(1, linha.trim());
                    ufs.add(pElementoTabela);
                }
            });
            FabricaUtilitarios.ordenarElementosPorColuna((int)0, (List)ufs);
        }
        return ufs;
    }

    private static void ordenarElementosPorColuna(final int pColuna, List pColecao) {
        Collections.sort(pColecao, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                ElementoTabela elemento1 = (ElementoTabela)arg0;
                ElementoTabela elemento2 = (ElementoTabela)arg1;
                if (pColuna >= elemento1.size()) {
                    return UtilitariosString.removeAcentos((String)elemento1.getConteudo(0)).compareTo(UtilitariosString.removeAcentos((String)elemento2.getConteudo(0)));
                }
                return UtilitariosString.removeAcentos((String)elemento1.getConteudo(pColuna)).compareTo(UtilitariosString.removeAcentos((String)elemento2.getConteudo(pColuna)));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void carregaArquivo(String pNome, PreencheElementoTabelaIf preenchedor) {
        int indexCod;
        HashIncorretoException exception = null;
        String[] codificacao = new String[]{"UTF-8", "UTF-16", "Cp1252", "ISO-8859-1"};
        for (indexCod = 0; indexCod < codificacao.length; ++indexCod) {
            try {
                UtilitariosHash.validarCRCArquivo((String)(pNome + EXTENSAO_ARQ_DADOS), (String)(pNome + EXTENSAO_ARQ_HASH), (String)codificacao[indexCod]);
                break;
            }
            catch (HashIncorretoException e) {
                exception = e;
                continue;
            }
        }
        if (indexCod < codificacao.length) {
            InputStream ioStr = null;
            try {
                String linha = null;
                ioStr = ClassLoader.getSystemClassLoader().getResourceAsStream(pNome + EXTENSAO_ARQ_DADOS);
                InputStreamReader i = new InputStreamReader(ioStr, codificacao[indexCod]);
                BufferedReader in = new BufferedReader(i);
                int numLinha = 1;
                while ((linha = in.readLine()) != null) {
                    if (linha.trim().length() > 0) {
                        ElementoTabela e = new ElementoTabela();
                        preenchedor.preencheElementoTabela(e, linha, numLinha);
                    }
                    ++numLinha;
                }
            }
            catch (Exception exception2) {
            }
            finally {
                try {
                    ioStr.close();
                }
                catch (Exception exception3) {}
            }
        } else {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico((Throwable)exception);
        }
    }

    public static List getTiposLogradouroImovel() {
        if (tipoLogradouroImovel.isEmpty()) {
            CadastroTabelasITR.carregaArquivo(NOME_ARQ_TIPOSLOGRADOURO_IMOVEL, new PreencheElementoTabelaIf(){

                @Override
                public void preencheElementoTabela(ElementoTabela pElementoTabela, String linha, int numLinha) {
                    pElementoTabela.setConteudo(0, UtilitariosString.removeAcentos((String)linha.trim().toUpperCase()));
                    pElementoTabela.setConteudo(1, linha.trim());
                    tipoLogradouroImovel.add(pElementoTabela);
                }
            });
        }
        return tipoLogradouroImovel;
    }

    public static List getTiposLogradouroContribuinte() {
        if (tipoLogradouroContribuinte.isEmpty()) {
            CadastroTabelasITR.carregaArquivo(NOME_ARQ_TIPOSLOGRADOURO_CONTRIBUINTE, new PreencheElementoTabelaIf(){

                @Override
                public void preencheElementoTabela(ElementoTabela pElementoTabela, String linha, int numLinha) {
                    pElementoTabela.setConteudo(0, UtilitariosString.removeAcentos((String)linha.trim().toUpperCase()));
                    pElementoTabela.setConteudo(1, linha.trim());
                    tipoLogradouroContribuinte.add(pElementoTabela);
                }
            });
        }
        return tipoLogradouroContribuinte;
    }

    public static boolean verificaMunicipioEmCalamidade(String pCodMunicipio) {
        if (municipiosCalamidade.isEmpty()) {
            CadastroTabelasITR.carregaArquivo(NOME_ARQ_MUNICIPIOS_EM_CALAMIDADE, new PreencheElementoTabelaIf(){

                @Override
                public void preencheElementoTabela(ElementoTabela pElementoTabela, String linha, int numLinha) {
                    municipiosCalamidade.put(linha.trim(), linha.trim());
                }
            });
        }
        return municipiosCalamidade.containsKey(pCodMunicipio);
    }

    public static void main(String[] args) {
        System.out.println("Gerando Hash dos municipios decretados em calamidade p\u00fablica...");
        CadastroTabelasITR.gerarHashTabela(NOME_ARQ_MUNICIPIOS_EM_CALAMIDADE);
        System.out.println("Gerando Hash dos Tipos de Logradouros do Endere\u00e7o do Imovel...");
        CadastroTabelasITR.gerarHashTabela(NOME_ARQ_TIPOSLOGRADOURO_IMOVEL);
        System.out.println("Gerando Hash dos Tipos de Logradouros do Endere\u00e7o do Contribuinte...");
        CadastroTabelasITR.gerarHashTabela(NOME_ARQ_TIPOSLOGRADOURO_CONTRIBUINTE);
        System.out.println("Gerando Hash para UF MT. Inclusao do novo municipio Boa Esperan\u00e7a do Norte...");
        CadastroTabelasITR.gerarHashTabela(NOME_ARQ_UF_MT);
        System.out.println("                                           ");
        System.out.println("===========================================");
        System.out.println("Procedimento de gera\u00e7\u00e3o do hash finalizado.");
        System.out.println("===========================================");
    }

    public static void gerarHashTabela(String nomeArquivo) {
        try {
            UtilitariosHash.geraCRCArquivo((String)(nomeArquivo + EXTENSAO_ARQ_DADOS), (String)(nomeArquivo + EXTENSAO_ARQ_HASH), (String)"ISO-8859-1");
        }
        catch (HashIncorretoException e) {
            e.printStackTrace();
        }
    }

    public static int gerarListaMunicipiosCalamidade() {
        int qtd = 0;
        URL url = Thread.currentThread().getContextClassLoader().getResource(NOME_ARQ_MUNICIPIOS_EM_CALAMIDADE + EXTENSAO_ARQ_DADOS);
        String pathArqs = url.getPath();
        File fileArqs = new File(pathArqs);
        if (fileArqs.exists()) {
            if (fileArqs.isFile()) {
                fileArqs = fileArqs.getParentFile();
            }
            String[] nomeArqsCalamidade = fileArqs.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches("municipios-calamidade-(\\w\\w)\\" + EXTENSAO_ARQ_DADOS);
                }
            });
            for (int i = 0; i < nomeArqsCalamidade.length; ++i) {
                System.out.println(nomeArqsCalamidade[i]);
                String uf = nomeArqsCalamidade[i].substring("municipios-calamidade-".length(), "municipios-calamidade-".length() + 2);
                qtd += CadastroTabelasITR.gerarListaMunicipiosCalamidade(uf);
            }
        }
        return qtd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gerarListaMunicipiosCalamidade(String uf) {
        System.out.println("Gerar municipios em calamidade - " + uf);
        int qtd = 0;
        BufferedReader inMunicipiosITR = null;
        BufferedReader inMunicipiosCalamidade = null;
        BufferedWriter outMunicipiosCalamidadeITR = null;
        BufferedWriter outMunicipiosCalamidadeNaoCadastrados = null;
        try {
            inMunicipiosITR = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(uf + EXTENSAO_ARQ_DADOS)));
            inMunicipiosCalamidade = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("municipios-calamidade-" + uf + EXTENSAO_ARQ_DADOS), "UTF-8"));
            outMunicipiosCalamidadeITR = new BufferedWriter(new FileWriter("municipios-calamidade" + EXTENSAO_ARQ_DADOS, true));
            outMunicipiosCalamidadeNaoCadastrados = new BufferedWriter(new FileWriter("municipios-calamidade-nao-cadastrados" + EXTENSAO_ARQ_DADOS, true));
            inMunicipiosITR.readLine();
            boolean lerMunicipioITR = true;
            String municipio = null;
            String municipioITR = null;
            while ((municipio = inMunicipiosCalamidade.readLine()) != null) {
                String nomeMunicipio = municipio.trim();
                if (nomeMunicipio.isEmpty()) continue;
                nomeMunicipio = UtilitariosString.removeAcentos((String)nomeMunicipio);
                nomeMunicipio = nomeMunicipio.toUpperCase();
                System.out.println("Buscando: \"" + municipio + "\"");
                int comparacao = 0;
                String nomeMunicipioITR = null;
                while (!lerMunicipioITR || (municipioITR = inMunicipiosITR.readLine()) != null) {
                    nomeMunicipioITR = municipioITR.substring(8, 48);
                    nomeMunicipioITR = nomeMunicipioITR.trim();
                    nomeMunicipioITR = UtilitariosString.removeAcentos((String)nomeMunicipioITR);
                    nomeMunicipioITR = nomeMunicipioITR.toUpperCase();
                    comparacao = nomeMunicipio.compareTo(nomeMunicipioITR);
                    lerMunicipioITR = true;
                    if (comparacao > 0) continue;
                }
                if (municipioITR != null && comparacao == 0) {
                    outMunicipiosCalamidadeITR.write(municipioITR.substring(1, 5) + "\n");
                    System.out.println("Gravando: \"" + nomeMunicipioITR + "\"");
                    ++qtd;
                    continue;
                }
                lerMunicipioITR = false;
                System.out.println("Nao encontrado: \"" + municipio + "\"");
                outMunicipiosCalamidadeNaoCadastrados.write(uf + " - " + municipio + "\n");
            }
            outMunicipiosCalamidadeITR.flush();
            outMunicipiosCalamidadeNaoCadastrados.flush();
            System.out.println("Arquivo gerado - " + uf + " Qtd: " + qtd);
            int n = qtd;
            return n;
        }
        catch (IOException e) {
            e.printStackTrace();
            int n = 0;
            return n;
        }
        finally {
            if (inMunicipiosITR != null) {
                try {
                    inMunicipiosITR.close();
                }
                catch (IOException iOException) {}
            }
            if (inMunicipiosCalamidade != null) {
                try {
                    inMunicipiosCalamidade.close();
                }
                catch (IOException iOException) {}
            }
            if (outMunicipiosCalamidadeITR != null) {
                try {
                    outMunicipiosCalamidadeITR.close();
                }
                catch (IOException iOException) {}
            }
            if (outMunicipiosCalamidadeNaoCadastrados != null) {
                try {
                    outMunicipiosCalamidadeNaoCadastrados.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

