/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.txt;

import java.util.Vector;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.aquisicaoalienacao.InformacaoAquisicaoAlienacao;
import serpro.ppgd.itr.aquisicaoalienacao.InformacaoDesapropriacao;
import serpro.ppgd.itr.atividadeextrativa.ItemAtividadeExtrativa;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.demaiscondominos.Condomino;
import serpro.ppgd.itr.nuvem.BarramentoITRFService;
import serpro.ppgd.itr.nuvem.UsuarioLogado;
import serpro.ppgd.itr.txt.ConstantesRepositorioTxt;
import serpro.ppgd.itr.util.CpfCnpjUtil;
import serpro.ppgd.itr.util.DataUtil;
import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosString;

public class ConversorObjetoRegistros {
    public RegistroTxt gerarRegHeader(DeclaracaoITR dec) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_ITR", "ITR");
        reg.fieldByName("SISTEMA").set("ITR     ");
        reg.fieldByName("EXERCICIO PGD").set(ConstantesGlobais.EXERCICIO);
        reg.fieldByName("ANO_BASE").set(ConstantesGlobais.EXERCICIO);
        reg.fieldByName("CODIGO_RECNET").set("3509");
        if (dec.getIdentificadorDeclaracao().getRetificadora().formatado().equals(Logico.SIM)) {
            reg.fieldByName("RETIFICADORA").set("1");
        } else if (dec.getIdentificadorDeclaracao().getRetificadora().formatado().equals(Logico.NAO)) {
            reg.fieldByName("RETIFICADORA").set("0");
        } else {
            reg.fieldByName("RETIFICADORA").set("0");
        }
        reg.fieldByName("NIRF").set(dec.getIdentificadorDeclaracao().getNirf().naoFormatado());
        reg.fieldByName("TIPO NI").set("3");
        reg.fieldByName("VERSAO PGD").set(ConstantesRepositorioTxt.VERSAO_PGD);
        reg.fieldByName("NOME IMOVEL").set(UtilitariosString.retiraCaracteresEspeciais((String)dec.getImovel().getNomeImovel().naoFormatado()).trim());
        reg.fieldByName("UF IMOVEL").set(dec.getImovel().getUf().naoFormatado());
        reg.fieldByName("HASHCODE_ACUMULADO").set(0);
        reg.fieldByName("CERTIFICAVEL").set("1");
        reg.fieldByName("UF CONTRIBUINTE").set(dec.getContribuinte().getUf().naoFormatado());
        reg.fieldByName("TIPO NI CONTRIBUINTE").set(dec.getImovel().getPessoaFisica());
        reg.fieldByName("NI CONTRIBUINTE").set(dec.getContribuinte().getNi().naoFormatado());
        reg.fieldByName("NR_RECIBO_ANTERIOR").set(dec.getIdentificadorDeclaracao().getNumeroReciboDeclaracaoAnterior().naoFormatado());
        reg.fieldByName("CPF INVENTARIANTE").set(dec.getContribuinte().getCpfInventariante().naoFormatado());
        reg.fieldByName("CPF REPRESENTANTE").set(dec.getContribuinte().getCpfRepresentante().naoFormatado());
        reg.fieldByName("VALOR_IMPOSTO DEVIDO").set(dec.getCalculoImposto().getImpostoDevido());
        reg.fieldByName("CODIGO MUNICIPIO IMOVEL").set(dec.getImovel().getMunicipio().naoFormatado());
        reg.fieldByName("CODIGO MUNICIPIO CONTRIBUINTE").set(dec.getContribuinte().getMunicipio().naoFormatado());
        reg.fieldByName("PLATAFORMAPGD").set("2");
        reg.fieldByName("INDICADOR IMUNIDADE").set(dec.getImovel().getIsento());
        reg.fieldByName("DATA NASCIMENTO").set(dec.getContribuinte().getDataNascimento().naoFormatado());
        reg.fieldByName("SISTEMA OPERACIONAL").setLimitado(System.getProperty("os.name"));
        String[] javaVersion = System.getProperty("java.version").split("\\.");
        reg.fieldByName("VERSAO JVM").setLimitado(javaVersion[0] + javaVersion[1] + "0");
        reg.fieldByName("CEP IMOVEL").set(dec.getImovel().getCep().naoFormatado());
        reg.fieldByName("CEP CONTRIBUINTE").set(dec.getContribuinte().getCep().naoFormatado());
        if (!dec.getAquisicaoAlienacao().getAquisicaoTotal().isVazio()) {
            reg.fieldByName("IND_AQUIS_TOTAL").set(1);
        } else {
            reg.fieldByName("IND_AQUIS_TOTAL").set(0);
        }
        if (!dec.getAquisicaoAlienacao().getAquisicaoParcial().isVazio()) {
            reg.fieldByName("IND_AQUIS_PARCIAL").set(1);
        } else {
            reg.fieldByName("IND_AQUIS_PARCIAL").set(0);
        }
        if (!dec.getAquisicaoAlienacao().getAlienacaoParcial().isVazio()) {
            reg.fieldByName("IND_ALIEN_PARCIAL").set(1);
        } else {
            reg.fieldByName("IND_ALIEN_PARCIAL").set(0);
        }
        if (!dec.getAquisicaoAlienacao().getDesapropriacao().isVazio()) {
            reg.fieldByName("IND_DESAPROPRIACAO").set(1);
        } else {
            reg.fieldByName("IND_DESAPROPRIACAO").set(0);
        }
        if (ConstantesGlobaisITR.ALTERACAO_DADOS) {
            reg.fieldByName("INDICADOR ALTERACAO DIAC IMOVEL").set(1);
        } else {
            reg.fieldByName("INDICADOR ALTERACAO DIAC IMOVEL").set(0);
        }
        reg.fieldByName("INDICADOR ALTERACAO DIAC CONTRIBUINTE").set(0);
        reg.fieldByName("INDICADOR CONDOMINIO").set(dec.getImovel().getPertenceCondominio());
        reg.fieldByName("AREA TOTAL IMOVEL").set((Valor)dec.getImovel().getAreaTotal());
        reg.fieldByName("IND_OBRIG_ENTREGA").set(dec.getImovel().getIsento().asString().equals(Logico.SIM) ? 0 : (dec.obrigadoDeclarar() != false ? 1 : 0));
        reg.fieldByName("INDICADOR EMQUADRAMENTO").set(dec.getImovel().getMotivoIsencao().isVazio() ? "0" : dec.getImovel().getMotivoIsencao().naoFormatado());
        reg.fieldByName("QUANTIDADE QUOTAS").set(dec.getCalculoImposto().getQtdCotas());
        reg.fieldByName("VALOR QUOTA").set(dec.getCalculoImposto().getValorQuota());
        this.gerarUsuarioAutenticadoGovBr(reg, dec);
        if (ConstantesGlobaisITR.VERSAO_TESTES) {
            reg.fieldByName("VERSAO DESENVOLVIMENTO").set(FabricaUtilitarios.getProperties().getProperty("versao_testes_txt", ""));
        } else if (ConstantesGlobaisITR.VERSAO_HOMOLOGACAO) {
            reg.fieldByName("VERSAO DESENVOLVIMENTO").set(FabricaUtilitarios.getProperties().getProperty("versao_homologacao_txt", ""));
        }
        return reg;
    }

    private void gerarUsuarioAutenticadoGovBr(RegistroTxt reg, DeclaracaoITR dec) throws GeracaoTxtException {
        UsuarioLogado user = ITRUtil.obterUsuarioLogado(dec.getContribuinte().getNi().naoFormatado());
        String ni = CpfCnpjUtil.formatarHeaderValidador(null);
        String cpfRepresentanteCnpj = CpfCnpjUtil.formatarHeaderValidador(null);
        String dtNascPfOuRlCnpj = CpfCnpjUtil.formatarHeaderValidador(null);
        if (user != null && !"bronze".equals(user.getNivelAcessoGov())) {
            ni = CpfCnpjUtil.formatarHeaderValidador(user.getNi());
            dtNascPfOuRlCnpj = DataUtil.formatarDataGPDDMMYYYY(user.getDataNascimento());
            cpfRepresentanteCnpj = CpfCnpjUtil.formatarHeaderValidador(user.getSub());
        }
        reg.fieldByName("NI AUTENTICADO GOV").set(ni);
        reg.fieldByName("CPF REP LEGAL CNPJ AUTENTICADO GOV").set(cpfRepresentanteCnpj);
        reg.fieldByName("DATA NASC CPF OU REP LEGAL CNPJ AUTENTICADO GOV").set(dtNascPfOuRlCnpj);
    }

    public RegistroTxt gerarRegDiacDiat(DeclaracaoITR dec) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_ITR", "F1");
        reg.fieldByName("TIPO").set("F1");
        reg.fieldByName("NIRF").set(dec.getIdentificadorDeclaracao().getNirf().naoFormatado());
        reg.fieldByName("NOME IMOVEL").set(UtilitariosString.retiraCaracteresEspeciais((String)dec.getImovel().getNomeImovel().naoFormatado()).trim());
        reg.fieldByName("CODIGO IMOVEL INCRA").set(dec.getImovel().getCodigoIncra().naoFormatado());
        reg.fieldByName("TIPO LOGRADOURO IMOVEL").set(UtilitariosString.removeAcentos((String)dec.getImovel().getTipoLogradouro().getConteudoAtual(1)));
        reg.fieldByName("ENDERECO IMOVEL").set(UtilitariosString.retiraCaracteresEspeciais((String)dec.getImovel().getLogradouro().naoFormatado()).trim());
        reg.fieldByName("DISTRITO IMOVEL").set(UtilitariosString.retiraCaracteresEspeciais((String)dec.getImovel().getDistrito().naoFormatado()).trim());
        reg.fieldByName("CEP IMOVEL").set(dec.getImovel().getCep().naoFormatado());
        reg.fieldByName("UF IMOVEL").set(dec.getImovel().getUf().naoFormatado());
        reg.fieldByName("CODIGO MUNICIPIO IMOVEL").set(dec.getImovel().getMunicipio().naoFormatado());
        reg.fieldByName("MUNICIPIO LOCALIZACAO IMOVEL").set(UtilitariosString.removeAcentos((String)dec.getImovel().getMunicipio().getConteudoAtual(1)));
        reg.fieldByName("INDICADOR IMUNIDADE").set(dec.getImovel().getIsento());
        reg.fieldByName("INDICADOR EMQUADRAMENTO").set(dec.getImovel().getMotivoIsencao().isVazio() ? "0" : dec.getImovel().getMotivoIsencao().naoFormatado());
        if (dec.getIdentificadorDeclaracao().getRetificadora().formatado().equals(Logico.SIM)) {
            reg.fieldByName("RETIFICADORA").set("1");
        } else if (dec.getIdentificadorDeclaracao().getRetificadora().formatado().equals(Logico.NAO)) {
            reg.fieldByName("RETIFICADORA").set("0");
        } else {
            reg.fieldByName("RETIFICADORA").set("0");
        }
        reg.fieldByName("NR_RECIBO_ANTERIOR").set(dec.getIdentificadorDeclaracao().getNumeroReciboDeclaracaoAnterior().naoFormatado());
        if (ConstantesGlobaisITR.ALTERACAO_DADOS) {
            reg.fieldByName("INDICADOR ALTERACAO DIAC IMOVEL").set(1);
        } else {
            reg.fieldByName("INDICADOR ALTERACAO DIAC IMOVEL").set(0);
        }
        reg.fieldByName("INDICADOR CONDOMINIO").set(dec.getImovel().getPertenceCondominio());
        reg.fieldByName("INDICADOR ALTERACAO DIAC CONDOMINIO").set("3");
        reg.fieldByName("TOTAL CONDOMINOS").set(dec.getDemaisCondominos().getTotalCondominos());
        if (dec.getImovel().getPessoaFisica().formatado().equals("1")) {
            reg.fieldByName("TIPO DECLARANTE").set("2");
            reg.fieldByName("CPF CONTRIBUINTE").set(dec.getContribuinte().getNi().naoFormatado());
        } else if (dec.getImovel().getPessoaFisica().formatado().equals("2")) {
            reg.fieldByName("TIPO DECLARANTE").set("4");
            reg.fieldByName("CNPJ CONTRIBUINTE").set(dec.getContribuinte().getNi().naoFormatado());
        }
        reg.fieldByName("NOME CONTRIBUINTE").set(UtilitariosString.retiraCaracteresEspeciais((String)dec.getContribuinte().getNomeContribuinte().naoFormatado()).trim());
        reg.fieldByName("DATA NASCIMENTO").set(dec.getContribuinte().getDataNascimento().naoFormatado());
        reg.fieldByName("CPF CONJUGE").set(dec.getContribuinte().getCpfConjuge().naoFormatado());
        reg.fieldByName("TIPO LOGRADOURO CONTRIBUINTE").set(dec.getContribuinte().getTipoLogradouro().getConteudoAtual(1));
        reg.fieldByName("ENDERECO CONTRIBUINTE").set(UtilitariosString.retiraCaracteresEspeciais((String)dec.getContribuinte().getLogradouro().naoFormatado()).trim());
        reg.fieldByName("NUMERO ENDERECO CONTRIBUINTE").set(UtilitariosString.retiraCaracteresEspeciais((String)dec.getContribuinte().getNumero().naoFormatado()).trim());
        reg.fieldByName("COMPLEMENTO_ENDERECO_CONTRIBUINTE").set(UtilitariosString.retiraCaracteresEspeciais((String)dec.getContribuinte().getComplemento().naoFormatado()).trim());
        reg.fieldByName("DISTRITO CONTRIBUINTE").set(UtilitariosString.retiraCaracteresEspeciais((String)dec.getContribuinte().getBairro().naoFormatado()).trim());
        reg.fieldByName("CEP CONTRIBUINTE").set(dec.getContribuinte().getCep().naoFormatado());
        reg.fieldByName("UF CONTRIBUINTE").set(dec.getContribuinte().getUf().formatado());
        reg.fieldByName("CODIGO MUNICIPIO CONTRIBUINTE").set(dec.getContribuinte().getMunicipio().naoFormatado());
        reg.fieldByName("MUNICIPIO CONTRIBUINTE").set(dec.getContribuinte().getMunicipio().getConteudoAtual(1));
        reg.fieldByName("DDD TELEFONE DECLARANTE").set(dec.getContribuinte().getDddTelefone().naoFormatado());
        reg.fieldByName("NUM TELEFONE DECLARANTE").set(dec.getContribuinte().getNumeroTelefone().naoFormatado());
        reg.fieldByName("CPF INVENTARIANTE").set(dec.getContribuinte().getCpfInventariante().naoFormatado());
        reg.fieldByName("NOME INVENTARIANTE").set(UtilitariosString.retiraCaracteresEspeciais((String)dec.getContribuinte().getNomeInventariante().naoFormatado()).trim());
        reg.fieldByName("CPF REPRESENTANTE").set(dec.getContribuinte().getCpfRepresentante().naoFormatado());
        reg.fieldByName("NOME REPRESENTANTE").set(UtilitariosString.retiraCaracteresEspeciais((String)dec.getContribuinte().getNomeRepresentante().naoFormatado()).trim());
        reg.fieldByName("INDICADOR ALTERACAO DIAC CONTRIBUINTE").set("3");
        reg.fieldByName("AREA TOTAL IMOVEL").set((Valor)dec.getImovel().getAreaTotal());
        reg.fieldByName("AREA PRESERVACAO PERMANENTE").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaPreservacaoPermanente());
        reg.fieldByName("AREA RESERVA LEGAL").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaLegal());
        reg.fieldByName("AREA RESERVA PARTICULAR").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaReservaParticular());
        reg.fieldByName("AREA INTERESSE ECOLOGICO").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaInteresseEcologico());
        reg.fieldByName("AREA SERVIDAO FLORESTAL").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaServidaoFlorestal());
        reg.fieldByName("AREA FLORESTAS NATIVAS").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaFlorestasNativas());
        reg.fieldByName("AREA ALAGADA USINA HIDRELETRICA").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAlagada());
        reg.fieldByName("AREA OCUPADA COM BENFEITORIAS UTEIS").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaOcupada());
        if (dec.getImovel().getIsento().formatado().equals(Logico.NAO)) {
            reg.fieldByName("AREA TRIBUTAVEL").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaTributavel());
            reg.fieldByName("AREA APROVEITAVEL").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaImovel().getAreaAproveitavel());
        }
        reg.fieldByName("AREA PRODUTOS VEGETAIS").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaProdutosVegetais());
        reg.fieldByName("AREA EM DESCANSO").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaEmDescanso());
        reg.fieldByName("AREA REFLORESTAMENTO").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaReflorestamento());
        reg.fieldByName("AREA PASTAGENS").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaPastagens());
        reg.fieldByName("AREA EXPLORACAO EXTRATIVA").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaExploracaoExtrativa());
        reg.fieldByName("AREA ATIVIDADE GRANJEIRA").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaAtividadeGranjeira());
        reg.fieldByName("AREA FRUSTACAO SAFRA").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaFrustracaoSafra());
        reg.fieldByName("AREA TOTAL UTILIZADA").set((Valor)dec.getUtilizacaoImovel().getDistribuicaoAreaUtilizada().getAreaUtilizadaPelaAR());
        reg.fieldByName("GRAU DE UTILIZACAO").set(dec.getUtilizacaoImovel().getGrauUtilizacao());
        reg.fieldByName("AREA DEMAIS BENFEITORIAS").set((Valor)dec.getAreaNaoUtilizada().getDistribuicaoPelaAR().getDemaisBenfeitorias());
        reg.fieldByName("AREA MINERACAO").set((Valor)dec.getAreaNaoUtilizada().getDistribuicaoPelaAR().getMineracao());
        reg.fieldByName("AREA IMPRESTAVEIS").set((Valor)dec.getAreaNaoUtilizada().getDistribuicaoPelaAR().getImprestaveis());
        reg.fieldByName("AREA INEXPLORADAS").set((Valor)dec.getAreaNaoUtilizada().getDistribuicaoPelaAR().getInexploradas());
        reg.fieldByName("AREA OUTRAS").set((Valor)dec.getAreaNaoUtilizada().getDistribuicaoPelaAR().getOutras());
        reg.fieldByName("AREA TOTAL NAO UTILIZADA").set((Valor)dec.getAreaNaoUtilizada().getDistribuicaoPelaAR().getAreaNaoUtilizada());
        reg.fieldByName("NUM PROCESSO ADA IBAMA").set(dec.getUtilizacaoImovel().getNumProcessoADAIbama().naoFormatado());
        reg.fieldByName("NUMERO CAR").set(dec.getUtilizacaoImovel().getNumeroCAR().naoFormatado());
        reg.fieldByName("AREA PASTAGEM NAO ACEITA").set((Valor)dec.getAreaNaoUtilizada().getAreasNaoAceitas().getAreaPastagem());
        reg.fieldByName("AREA EXPLORACAO EXTRATIVA NAO ACEITA").set((Valor)dec.getAreaNaoUtilizada().getAreasNaoAceitas().getAreaExploracaoExtrativa());
        reg.fieldByName("AREA TOTAL NAO ACEITA").set((Valor)dec.getAreaNaoUtilizada().getAreasNaoAceitas().getAreaTotalNaoAceita());
        reg.fieldByName("AREA TOTAL NAO UTILIZADA E NAO ACEITA").set((Valor)dec.getAreaNaoUtilizada().getAreaTotalNaoUtilizada());
        reg.fieldByName("VALOR TOTAL IMOVEL").set(dec.getCalculoImposto().getValorTotalImovel());
        reg.fieldByName("VALOR BENFEITORIAS").set(dec.getCalculoImposto().getValorBenfeitorias());
        reg.fieldByName("VALOR CULTURAS PASTAGENS FLORESTAS").set(dec.getCalculoImposto().getValorCulturas());
        reg.fieldByName("VALOR TERRA NUA").set(dec.getCalculoImposto().getValorTerraNua());
        if (dec.getImovel().getIsento().formatado().equals(Logico.NAO)) {
            reg.fieldByName("VALOR TERRA NUA TRIBUTAVEL").set(dec.getCalculoImposto().getValorTerraNuaTributavel());
            reg.fieldByName("VALOR ALIQUOTA").set(dec.getCalculoImposto().getAliquota());
            reg.fieldByName("VALOR IMPOSTO CALCULADO").set(dec.getCalculoImposto().getImpostoCalculado());
            reg.fieldByName("VALOR IMPOSTO DEVIDO").set(dec.getCalculoImposto().getImpostoDevido());
            reg.fieldByName("QUANTIDADE QUOTAS").set(dec.getCalculoImposto().getQtdCotas());
            reg.fieldByName("VALOR QUOTA").set(dec.getCalculoImposto().getValorQuota());
        }
        reg.fieldByName("INDICADOR LOCALIZACAO").set(dec.getImovel().getMunicipio().getConteudoAtual(3));
        String indiceRendimentoPecuario = Logico.SIM.equals(dec.getImovel().getIsento().formatado()) ? "00000" : dec.getImovel().getMunicipio().getConteudoAtual(2);
        reg.fieldByName("INDICE RENDIMENTO PECUARIA").set(indiceRendimentoPecuario);
        reg.fieldByName("TIPO DECLARACAO").set(dec.getImovel().enquadramento() ? "1" : "2");
        return reg;
    }

    public Vector gerarRegsCondominos(DeclaracaoITR dec) throws GeracaoTxtException {
        Vector<RegistroTxt> regs = new Vector<RegistroTxt>();
        if (dec.getImovel().getPertenceCondominio().formatado().equals(Logico.SIM)) {
            Condomino condContrib = new Condomino();
            condContrib.getNi().setConteudo(dec.getContribuinte().getNi().formatado());
            condContrib.getNome().setConteudo(dec.getContribuinte().getNomeContribuinte().formatado());
            condContrib.getPercentual().setConteudo(dec.getContribuinte().getParticCondominio().formatado());
            RegistroTxt reg = this.gerarRegCondomino(condContrib, dec.getIdentificadorDeclaracao());
            regs.add(reg);
            for (Condomino condomino : dec.getDemaisCondominos().itens()) {
                if (condomino.isVazio()) continue;
                reg = this.gerarRegCondomino(condomino, dec.getIdentificadorDeclaracao());
                regs.add(reg);
            }
        }
        return regs;
    }

    public RegistroTxt gerarRegCondomino(Condomino condomino, IdentificadorDeclaracao idDec) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_ITR", "F2");
        reg.fieldByName("TIPO").set("F2");
        reg.fieldByName("NIRF").set(idDec.getNirf().naoFormatado());
        reg.fieldByName("CPFCNPJ CONDOMINO").set(condomino.getNi().naoFormatado());
        reg.fieldByName("NOME CONDOMINO").set(UtilitariosString.retiraCaracteresEspeciais((String)condomino.getNome().naoFormatado()).trim());
        reg.fieldByName("PERCENTUAL").set(condomino.getPercentual());
        return reg;
    }

    public Vector gerarRegsAquisTotal(DeclaracaoITR dec) throws GeracaoTxtException {
        Vector<RegistroTxt> regs = new Vector<RegistroTxt>();
        for (InformacaoAquisicaoAlienacao aquis : dec.getAquisicaoAlienacao().getAquisicaoTotal().itens()) {
            if (aquis.isVazio()) continue;
            regs.add(this.gerarRegAquisAlien(aquis, "F31"));
        }
        return regs;
    }

    public Vector gerarRegsAquisParcial(DeclaracaoITR dec) throws GeracaoTxtException {
        Vector<RegistroTxt> regs = new Vector<RegistroTxt>();
        for (InformacaoAquisicaoAlienacao aquis : dec.getAquisicaoAlienacao().getAquisicaoParcial().itens()) {
            if (aquis.isVazio()) continue;
            regs.add(this.gerarRegAquisAlien(aquis, "F32"));
        }
        return regs;
    }

    public Vector gerarRegsAlienParcial(DeclaracaoITR dec) throws GeracaoTxtException {
        Vector<RegistroTxt> regs = new Vector<RegistroTxt>();
        for (InformacaoAquisicaoAlienacao alien : dec.getAquisicaoAlienacao().getAlienacaoParcial().itens()) {
            if (alien.isVazio()) continue;
            regs.add(this.gerarRegAquisAlien(alien, "F33"));
        }
        return regs;
    }

    public RegistroTxt gerarRegAquisAlien(InformacaoAquisicaoAlienacao infoAquisAlien, String tipoReg) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_ITR", tipoReg);
        reg.fieldByName("TIPO").set(tipoReg);
        reg.fieldByName("CPFCNPJ ALIENANTE").set(infoAquisAlien.getNiAlienanteAdquirente().naoFormatado());
        reg.fieldByName("DATA").set(infoAquisAlien.getData().naoFormatado());
        reg.fieldByName("NIRF").set(infoAquisAlien.getNirfImovelAlienanteAdquirente().naoFormatado());
        reg.fieldByName("AREA").set((Valor)infoAquisAlien.getArea());
        return reg;
    }

    public Vector gerarRegsDesapropriacao(DeclaracaoITR dec) throws GeracaoTxtException {
        Vector<RegistroTxt> regs = new Vector<RegistroTxt>();
        for (InformacaoDesapropriacao des : dec.getAquisicaoAlienacao().getDesapropriacao().itens()) {
            if (des.isVazio()) continue;
            RegistroTxt reg = new RegistroTxt("ARQ_ITR", "F34");
            reg.fieldByName("TIPO").set("F34");
            reg.fieldByName("CNPJ_DESAPROPRIANTE").set(des.getCnpjDesaproprianteAdquirente().naoFormatado());
            reg.fieldByName("DATA").set(des.getData().naoFormatado());
            reg.fieldByName("AREA").set((Valor)des.getArea());
            regs.add(reg);
        }
        return regs;
    }

    public RegistroTxt gerarRegAtivPecuaria(DeclaracaoITR dec) throws GeracaoTxtException {
        if (dec.getImovel().enquadramento() && !dec.getAtividadePecuaria().isVazio()) {
            RegistroTxt reg = new RegistroTxt("ARQ_ITR", "F5");
            reg.fieldByName("TIPO").set("F5");
            reg.fieldByName("NIRF").set(dec.getIdentificadorDeclaracao().getNirf().naoFormatado());
            reg.fieldByName("QTD CABECA GRANDE PORTE").set(dec.getAtividadePecuaria().getRebanho().getItemRebanhoGP().getQtdCabecas());
            reg.fieldByName("QTD CABECA GRANDE PORTE AJUSTADA").set(dec.getAtividadePecuaria().getRebanho().getItemRebanhoGP().getQtdCabecasAjustado());
            reg.fieldByName("QTD CABECA MEDIO PORTE").set(dec.getAtividadePecuaria().getRebanho().getItemRebanhoMP().getQtdCabecas());
            reg.fieldByName("QTD CABECA MEDIO PORTE AJUSTADA").set(dec.getAtividadePecuaria().getRebanho().getItemRebanhoMP().getQtdCabecasAjustado());
            reg.fieldByName("TOTAL REBANHO").set((Valor)dec.getAtividadePecuaria().getRebanho().getTotalRebanhoAjustado());
            reg.fieldByName("AREA PASTAGEM NATIVA").set((Valor)dec.getAtividadePecuaria().getAreaServidaPastagem().getPastagemNativa());
            reg.fieldByName("AREA PASTAGEM PLANTADA").set((Valor)dec.getAtividadePecuaria().getAreaServidaPastagem().getPastagemPlantada());
            reg.fieldByName("AREA FORRAGEIRA CORTE").set((Valor)dec.getAtividadePecuaria().getAreaServidaPastagem().getForrageiraCorte());
            reg.fieldByName("AREA PASTAGEM DECLARADA").set((Valor)dec.getAtividadePecuaria().getAreaServidaPastagem().getPastagemDeclarada());
            reg.fieldByName("INDICE RENDIMENTO PECUARIA").set(dec.getAtividadePecuaria().getAreaServidaPastagem().getIndiceLotacaoPecuaria());
            reg.fieldByName("AREA PASTAGEM CALCULADA").set((Valor)dec.getAtividadePecuaria().getAreaServidaPastagem().getPastagemCalculada());
            reg.fieldByName("AREA SERVIDA PASTAGEM ACEITA").set((Valor)dec.getAtividadePecuaria().getAreaServidaPastagem().getPastagemAceita());
            reg.fieldByName("AREA PASTAGEM FORMACAO").set((Valor)dec.getAtividadePecuaria().getAreaServidaPastagem().getPastagemEmFormacao());
            reg.fieldByName("AREA PROJETO TECNICO").set((Valor)dec.getAtividadePecuaria().getAreaServidaPastagem().getImplantadaObjetoProjetoTecnico());
            reg.fieldByName("AREA TOTAL PASTAGEM").set((Valor)dec.getAtividadePecuaria().getAreaServidaPastagem().getTotal());
            reg.fieldByName("ORGAO PROJETO TECNICO").set(dec.getAtividadePecuaria().getAreaServidaPastagem().getOrgao().naoFormatado());
            reg.fieldByName("DATA PROJETO TECNICO").set(dec.getAtividadePecuaria().getAreaServidaPastagem().getData().naoFormatado());
            return reg;
        }
        return null;
    }

    public Vector gerarRegsAtivExtrativa(DeclaracaoITR dec) throws GeracaoTxtException {
        Vector<RegistroTxt> regs = new Vector<RegistroTxt>();
        if (dec.getImovel().enquadramento()) {
            RegistroTxt reg = null;
            if (!dec.getAtividadeExtrativa().getAcaciaNegra().isVazio()) {
                reg = this.gerarRegAtivExtrativa("F601", dec.getAtividadeExtrativa().getAcaciaNegra(), dec.getIdentificadorDeclaracao());
                regs.add(reg);
            }
            if (!dec.getAtividadeExtrativa().getBabacu().isVazio()) {
                reg = this.gerarRegAtivExtrativa("F602", dec.getAtividadeExtrativa().getBabacu(), dec.getIdentificadorDeclaracao());
                regs.add(reg);
            }
            if (!dec.getAtividadeExtrativa().getBorracha().isVazio()) {
                reg = this.gerarRegAtivExtrativa("F603", dec.getAtividadeExtrativa().getBorracha(), dec.getIdentificadorDeclaracao());
                regs.add(reg);
            }
            if (!dec.getAtividadeExtrativa().getCarnauba().isVazio()) {
                reg = this.gerarRegAtivExtrativa("F604", dec.getAtividadeExtrativa().getCarnauba(), dec.getIdentificadorDeclaracao());
                regs.add(reg);
            }
            if (!dec.getAtividadeExtrativa().getCastanha().isVazio()) {
                reg = this.gerarRegAtivExtrativa("F605", dec.getAtividadeExtrativa().getCastanha(), dec.getIdentificadorDeclaracao());
                regs.add(reg);
            }
            if (!dec.getAtividadeExtrativa().getGuarana().isVazio()) {
                reg = this.gerarRegAtivExtrativa("F606", dec.getAtividadeExtrativa().getGuarana(), dec.getIdentificadorDeclaracao());
                regs.add(reg);
            }
            if (!dec.getAtividadeExtrativa().getMadeira().isVazio()) {
                reg = this.gerarRegAtivExtrativa("F607", dec.getAtividadeExtrativa().getMadeira(), dec.getIdentificadorDeclaracao());
                regs.add(reg);
            }
            if (!dec.getAtividadeExtrativa().getProduto().isVazio()) {
                reg = this.gerarRegAtivExtrativa("F608", dec.getAtividadeExtrativa().getProduto(), dec.getIdentificadorDeclaracao());
                reg.fieldByName("DATA PLANO MANEJO").set(dec.getAtividadeExtrativa().getDataAprovacaoIbama().naoFormatado());
                regs.add(reg);
            }
            if (!dec.getAtividadeExtrativa().getOutros().isVazio()) {
                reg = this.gerarRegAtivExtrativa("F609", dec.getAtividadeExtrativa().getOutros(), dec.getIdentificadorDeclaracao());
                regs.add(reg);
            }
            if (!dec.getAtividadeExtrativa().getAreaExploracaoExtrativa().isVazio()) {
                reg = new RegistroTxt("ARQ_ITR", "F699");
                reg.fieldByName("TIPO").set("F699");
                reg.fieldByName("NIRF").set(dec.getIdentificadorDeclaracao().getNirf().naoFormatado());
                reg.fieldByName("AREA ACEITA").set((Valor)dec.getAtividadeExtrativa().getAreaExploracaoExtrativa());
                regs.add(reg);
            }
        }
        return regs;
    }

    public RegistroTxt gerarRegAtivExtrativa(String tipoReg, ItemAtividadeExtrativa item, IdentificadorDeclaracao idDec) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_ITR", tipoReg);
        reg.fieldByName("TIPO").set(tipoReg);
        reg.fieldByName("NIRF").set(idDec.getNirf().naoFormatado());
        reg.fieldByName("AREA PLANTADA").set((Valor)item.getArea());
        reg.fieldByName("QTD PRODUZIDA").set(item.getQtdProduzida());
        reg.fieldByName("RENDIMENTO MINIMO").set(item.getRendMinimo());
        reg.fieldByName("AREA CALCULADA").set((Valor)item.getAreaCalculada());
        reg.fieldByName("AREA ACEITA").set((Valor)item.getAreaAceita());
        return reg;
    }

    public RegistroTxt gerarRegTrailler(DeclaracaoITR dec) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_ITR", "T9");
        reg.fieldByName("TIPO").set("T9");
        reg.fieldByName("SISTEMA").set(ConstantesRepositorioTxt.VALOR_TRAILLER_SISTEMA);
        reg.fieldByName("NI CONTRIBUINTE").set(dec.getContribuinte().getNi().naoFormatado());
        reg.fieldByName("NIRF").set(dec.getIdentificadorDeclaracao().getNirf().naoFormatado());
        reg.fieldByName("DATA PROGRAMA").set(ConstantesRepositorioTxt.VALOR_TRAILLER_DATA_PROGRAMA);
        reg.fieldByName("QTD REGISTROS").set(0);
        reg.fieldByName("HASH DECLARACAO").set(0);
        return reg;
    }

    public RegistroTxt gerarRegTraillerRecibo(DeclaracaoITR dec) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_ITR", "R9");
        reg.fieldByName("TIPO").set("R9");
        reg.fieldByName("SISTEMA").set(ConstantesRepositorioTxt.VALOR_TRAILLER_SISTEMA);
        reg.fieldByName("NI CONTRIBUINTE").set(dec.getContribuinte().getNi().naoFormatado());
        reg.fieldByName("NIRF").set(dec.getIdentificadorDeclaracao().getNirf().naoFormatado());
        reg.fieldByName("DATA PROGRAMA").set(ConstantesRepositorioTxt.VALOR_TRAILLER_DATA_PROGRAMA);
        reg.fieldByName("QTD REGISTROS").set(0);
        reg.fieldByName("HASH RECIBO").set(0);
        return reg;
    }

    private String gerarUsuarioAutenticadoGov() {
        UsuarioLogado user = BarramentoITRFService.getUsuarioLogado();
        if (user != null && !"bronze".equals(user.getNivelAcessoGov())) {
            return CpfCnpjUtil.formatarHeaderValidador(user.getNi());
        }
        return CpfCnpjUtil.formatarHeaderValidador(null);
    }
}

