/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.txt;

import java.util.Iterator;
import java.util.List;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.aquisicaoalienacao.AquisicaoAlienacao;
import serpro.ppgd.itr.aquisicaoalienacao.InformacaoAquisicaoAlienacao;
import serpro.ppgd.itr.aquisicaoalienacao.InformacaoDesapropriacao;
import serpro.ppgd.itr.areanaoutilizada.AreaNaoUtilizada;
import serpro.ppgd.itr.areanaoutilizada.AreasNaoAceitas;
import serpro.ppgd.itr.areanaoutilizada.DistribuicaoAR;
import serpro.ppgd.itr.atividadeextrativa.AtividadeExtrativa;
import serpro.ppgd.itr.atividadeextrativa.ItemAtividadeExtrativa;
import serpro.ppgd.itr.atividadepecuaria.AreaServidaPastagem;
import serpro.ppgd.itr.atividadepecuaria.AtividadePecuaria;
import serpro.ppgd.itr.atividadepecuaria.ItemRebanho;
import serpro.ppgd.itr.atividadepecuaria.Rebanho;
import serpro.ppgd.itr.calculoimposto.CalculoImposto;
import serpro.ppgd.itr.contribuinte.Contribuinte;
import serpro.ppgd.itr.declaracao.ComplementoRecibo;
import serpro.ppgd.itr.demaiscondominos.Condomino;
import serpro.ppgd.itr.demaiscondominos.DemaisCondominos;
import serpro.ppgd.itr.imovel.Imovel;
import serpro.ppgd.itr.utilizacaoimovel.DistribuicaoAreaImovel;
import serpro.ppgd.itr.utilizacaoimovel.DistribuicaoAreaUtilizada;
import serpro.ppgd.itr.utilizacaoimovel.UtilizacaoImovel;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;

public class ConversorRegistrosObjeto {
    public void montarImovelRecibo(RegistroTxt regHeader, RegistroTxt regDiacDiat, ComplementoRecibo recibo) throws GeracaoTxtException {
        recibo.getNumeroRecibo().setConteudo(regHeader.fieldByName("HASHCODE_ACUMULADO").asString());
        if (regHeader.fieldByName("RETIFICADORA").asString().equals("1")) {
            recibo.getRetificadora().setConteudo(Logico.SIM);
        } else if (regHeader.fieldByName("RETIFICADORA").asString().equals("0")) {
            recibo.getRetificadora().setConteudo(Logico.NAO);
        }
        recibo.getImune().setConteudo(regDiacDiat.fieldByName("INDICADOR IMUNIDADE").asString());
        recibo.getEnquadramento().setConteudo(regDiacDiat.fieldByName("INDICADOR EMQUADRAMENTO").asString());
        recibo.getAreaImovel().setConteudo(regDiacDiat.fieldByName("AREA TOTAL IMOVEL").asValor());
        recibo.getNomeImovel().setConteudo(regDiacDiat.fieldByName("NOME IMOVEL").asString());
        recibo.getCepImovel().setConteudo(regDiacDiat.fieldByName("CEP IMOVEL").asString());
        recibo.getLogradouroImovel().setConteudo(regDiacDiat.fieldByName("ENDERECO IMOVEL").asString());
        recibo.getTipoLogradouroImovel().setConteudo(regDiacDiat.fieldByName("TIPO LOGRADOURO IMOVEL").asString());
        recibo.getDistritoImovel().setConteudo(regDiacDiat.fieldByName("DISTRITO IMOVEL").asString());
        recibo.getNomeMunicipioImovel().setConteudo(regDiacDiat.fieldByName("MUNICIPIO LOCALIZACAO IMOVEL").asString());
        recibo.getUfImovel().setConteudo(regDiacDiat.fieldByName("UF IMOVEL").asString());
        if (!regDiacDiat.fieldByName("CPF CONTRIBUINTE").asString().equals("00000000000")) {
            recibo.getNiContribuinte().setConteudo(regDiacDiat.fieldByName("CPF CONTRIBUINTE").asString());
        } else if (!regDiacDiat.fieldByName("CNPJ CONTRIBUINTE").asString().equals("00000000000000")) {
            recibo.getNiContribuinte().setConteudo(regDiacDiat.fieldByName("CNPJ CONTRIBUINTE").asString());
        }
        String tipoDeclarante = regDiacDiat.fieldByName("TIPO DECLARANTE").asString();
        if (tipoDeclarante.equals("2")) {
            recibo.getTipoContribuinte().setConteudo("1");
        } else if (tipoDeclarante.equals("4")) {
            recibo.getTipoContribuinte().setConteudo("2");
        }
        recibo.getNomeContribuinte().setConteudo(regDiacDiat.fieldByName("NOME CONTRIBUINTE").asString());
        recibo.getNomeMunicipioContribuinte().setConteudo(regDiacDiat.fieldByName("MUNICIPIO CONTRIBUINTE").asString());
        recibo.getUfContribuinte().setConteudo(regDiacDiat.fieldByName("UF CONTRIBUINTE").asString());
        recibo.getNumeroEdnderecoContribuinte().setConteudo(regDiacDiat.fieldByName("NUMERO ENDERECO CONTRIBUINTE").asString());
        recibo.getTelefoneContribuinte().setConteudo(regDiacDiat.fieldByName("NUM TELEFONE DECLARANTE").asString());
        recibo.getDddTelefoneContribuinte().setConteudo(regDiacDiat.fieldByName("DDD TELEFONE DECLARANTE").asString());
        recibo.getBairroEnderecoContribuinte().setConteudo(regDiacDiat.fieldByName("DISTRITO CONTRIBUINTE").asString());
        recibo.getCepContribuinte().setConteudo(regDiacDiat.fieldByName("CEP CONTRIBUINTE").asString());
        recibo.getComplementoEnderecoContribuinte().setConteudo(regDiacDiat.fieldByName("COMPLEMENTO_ENDERECO_CONTRIBUINTE").asString());
        recibo.getLogradouroContribuinte().setConteudo(regDiacDiat.fieldByName("ENDERECO CONTRIBUINTE").asString());
        recibo.getTipoLogradouroContribuinte().setConteudo(regDiacDiat.fieldByName("TIPO LOGRADOURO CONTRIBUINTE").asString());
        recibo.getImpostoCalculado().setConteudo(regDiacDiat.fieldByName("VALOR IMPOSTO CALCULADO").asValor());
        recibo.getImpostoDevido().setConteudo(regDiacDiat.fieldByName("VALOR IMPOSTO DEVIDO").asValor());
        recibo.getValorTributavel().setConteudo(regDiacDiat.fieldByName("VALOR TERRA NUA TRIBUTAVEL").asValor());
        recibo.getQtdQuotas().setConteudo(regDiacDiat.fieldByName("QUANTIDADE QUOTAS").asValor());
        recibo.getValorQuota().setConteudo(regDiacDiat.fieldByName("VALOR QUOTA").asValor());
    }

    public void montarDadosRecibo(RegistroTxt regDados, RegistroTxt regNotificacao, RegistroTxt regValidador01, List regsValidador02, ComplementoRecibo recibo) throws GeracaoTxtException {
        recibo.getNirf().setConteudo(regDados.fieldByName("NIRF").asString());
        recibo.getDataRecepcao().setConteudo(regDados.fieldByName("DATA RECEPCAO").asString());
        recibo.getHoraRecepcao().setConteudo(regDados.fieldByName("HORA RECEPCAO").asString());
        recibo.getLocalRecepcao().setConteudo(regDados.fieldByName("LOCAL RECEPCAO").asString());
        recibo.getAssinaturaEletronica().setConteudo(regDados.fieldByName("ASSINATURA ELETRONICA").asString());
        recibo.getGatewayNoAr().setConteudo(regDados.fieldByName("GATEWAY PAGAMENTO").asString());
        recibo.getAplicativoTransmissao().setConteudo(regDados.fieldByName("INDICADOR TRANSMISSAO").asString());
        recibo.getExpressaoAplicativoTransmissao().setConteudo(regDados.fieldByName("INDICADOR EXPRESSAO").asString());
        recibo.getCodAgenteTransmissor().setConteudo(regDados.fieldByName("CODIGO AGENTE").asString());
        recibo.getAssinaturaDeclaracao().setConteudo(regDados.fieldByName("NI ASSINATURA").asString());
        recibo.getControleSRF().setConteudo(regDados.fieldByName("CONTROLE_SRF").asString());
        if (regNotificacao != null) {
            recibo.getNomeDelegadoSRF().setConteudo(regNotificacao.fieldByName("NOME DELEGADO").asString());
            recibo.getNumMatriculaDelegadoSRF().setConteudo(regNotificacao.fieldByName("MATRICULA DELEGADO").asString());
            recibo.getTipoDelegadoSRF().setConteudo(regNotificacao.fieldByName("CARGO DELEGADO").asString());
            Object dataVencimento = regNotificacao.fieldByName("DATA VENCIMENTO").asString();
            dataVencimento = ((String)dataVencimento).substring(6, 8) + ((String)dataVencimento).substring(4, 6) + ((String)dataVencimento).substring(0, 4);
            recibo.getDataVencimento().setConteudo((String)dataVencimento);
            recibo.getQtdMesesAtraso().setConteudo(regNotificacao.fieldByName("QTD MESES").asString());
            recibo.getValorMulta().setConteudo(regNotificacao.fieldByName("VALOR MULTA").asValor());
            recibo.getNumSequencial().setConteudo(regNotificacao.fieldByName("NUMERO SEQUENCIAL").asString());
            recibo.getTipoDelegacia().setConteudo(regNotificacao.fieldByName("TIPO DELEGACIA").asString());
            recibo.getNomeUA().setConteudo(regNotificacao.fieldByName("NOME UNIDADE ATENDIMENTO").asString());
            Object dataRecepcaoOriginal = regNotificacao.fieldByName("DATA RECEPCAO ORIGINAL").asString();
            dataRecepcaoOriginal = ((String)dataRecepcaoOriginal).substring(6, 8) + ((String)dataRecepcaoOriginal).substring(4, 6) + ((String)dataRecepcaoOriginal).substring(0, 4);
            recibo.getDataRecepcaoOriginal().setConteudo((String)dataRecepcaoOriginal);
        }
        if (regValidador01 != null) {
            recibo.getIndAreaImovelDifCafir().setConteudo(regValidador01.fieldByName("IND_AREA_DIFERENTE").asString());
            recibo.getIndNiContribuinteDifCafir().setConteudo(regValidador01.fieldByName("IND_NI_CONTRIBUINTE_DIFERENTE").asString());
            recibo.getIndVinculacao().setConteudo(regValidador01.fieldByName("IND_VINCULACAO").asString());
        }
        if (regsValidador02 != null && regsValidador02.size() > 0) {
            for (RegistroTxt regAviso : regsValidador02) {
                ComplementoRecibo.AvisoCNIR aviso = recibo.new ComplementoRecibo.AvisoCNIR();
                aviso.getAreaInicial().setConteudo(regAviso.fieldByName("AREA_INICIAL").asValor());
                aviso.getAreaFinal().setConteudo(regAviso.fieldByName("AREA_FINAL").asValor());
                Object dataInicial = regAviso.fieldByName("DATA_INICIAL").asString();
                dataInicial = ((String)dataInicial).substring(6, 8) + ((String)dataInicial).substring(4, 6) + ((String)dataInicial).substring(0, 4);
                aviso.getDataInicial().setConteudo((String)dataInicial);
                Object dataFinal = regAviso.fieldByName("DATA_FINAL").asString();
                dataFinal = ((String)dataFinal).substring(6, 8) + ((String)dataFinal).substring(4, 6) + ((String)dataFinal).substring(0, 4);
                aviso.getDataFinal().setConteudo((String)dataFinal);
                recibo.getColecaoAvisoCNIR().add((ObjetoNegocio)aviso);
            }
        }
    }

    public void montarIdentificadorDeclaracao(RegistroTxt regDiacDiat, IdentificadorDeclaracao idDec) throws GeracaoTxtException {
        idDec.getNirf().setConteudo(regDiacDiat.fieldByName("NIRF").asString());
        idDec.getNomeImovel().setConteudo(regDiacDiat.fieldByName("NOME IMOVEL").asString());
        if (!regDiacDiat.fieldByName("CPF CONTRIBUINTE").asString().equals("00000000000")) {
            idDec.getNiContribuinte().setConteudo(regDiacDiat.fieldByName("CPF CONTRIBUINTE").asString());
        } else if (!regDiacDiat.fieldByName("CNPJ CONTRIBUINTE").asString().equals("00000000000000")) {
            idDec.getNiContribuinte().setConteudo(regDiacDiat.fieldByName("CNPJ CONTRIBUINTE").asString());
        }
        idDec.getNomeContribuinte().setConteudo(regDiacDiat.fieldByName("NOME CONTRIBUINTE").asString());
        idDec.getNumeroReciboDeclaracaoAnterior().setConteudo(regDiacDiat.fieldByName("NR_RECIBO_ANTERIOR").asString());
        if (regDiacDiat.fieldByName("RETIFICADORA").asString().equals("1")) {
            idDec.getRetificadora().setConteudo(Logico.SIM);
        } else if (regDiacDiat.fieldByName("RETIFICADORA").asString().equals("0")) {
            idDec.getRetificadora().setConteudo(Logico.NAO);
        }
    }

    public void montarContribuinte(RegistroTxt regDiacDiat, Contribuinte contrib) throws GeracaoTxtException {
        if (!regDiacDiat.fieldByName("CPF CONTRIBUINTE").asString().equals("00000000000")) {
            contrib.getNi().setConteudo(regDiacDiat.fieldByName("CPF CONTRIBUINTE").asString());
        } else if (!regDiacDiat.fieldByName("CNPJ CONTRIBUINTE").asString().equals("00000000000000")) {
            contrib.getNi().setConteudo(regDiacDiat.fieldByName("CNPJ CONTRIBUINTE").asString());
        }
        contrib.getNomeContribuinte().setConteudo(regDiacDiat.fieldByName("NOME CONTRIBUINTE").asString());
        if (!regDiacDiat.fieldByName("CPF CONJUGE").asString().equals("00000000000")) {
            contrib.getCpfConjuge().setConteudo(regDiacDiat.fieldByName("CPF CONJUGE").asString());
        }
        if (!regDiacDiat.fieldByName("DATA NASCIMENTO").asString().equals("00000000")) {
            contrib.getDataNascimento().setConteudo(regDiacDiat.fieldByName("DATA NASCIMENTO").asString());
        }
        contrib.getLogradouro().setConteudo(regDiacDiat.fieldByName("ENDERECO CONTRIBUINTE").asString());
        contrib.getTipoLogradouro().setConteudo(regDiacDiat.fieldByName("TIPO LOGRADOURO CONTRIBUINTE").asString());
        contrib.getNumero().setConteudo(regDiacDiat.fieldByName("NUMERO ENDERECO CONTRIBUINTE").asString());
        contrib.getBairro().setConteudo(regDiacDiat.fieldByName("DISTRITO CONTRIBUINTE").asString());
        if (!regDiacDiat.fieldByName("CEP CONTRIBUINTE").asString().equals("00000000")) {
            contrib.getCep().setConteudo(regDiacDiat.fieldByName("CEP CONTRIBUINTE").asString());
        }
        contrib.getComplemento().setConteudo(regDiacDiat.fieldByName("COMPLEMENTO_ENDERECO_CONTRIBUINTE").asString());
        contrib.getUf().setConteudo(regDiacDiat.fieldByName("UF CONTRIBUINTE").asString());
        contrib.getMunicipio().setConteudo(regDiacDiat.fieldByName("CODIGO MUNICIPIO CONTRIBUINTE").asString());
        contrib.getDddTelefone().setConteudo(regDiacDiat.fieldByName("DDD TELEFONE DECLARANTE").asString());
        contrib.getNumeroTelefone().setConteudo(regDiacDiat.fieldByName("NUM TELEFONE DECLARANTE").asString());
        if (!regDiacDiat.fieldByName("CPF INVENTARIANTE").asString().equals("00000000000")) {
            contrib.getCpfInventariante().setConteudo(regDiacDiat.fieldByName("CPF INVENTARIANTE").asString());
        }
        contrib.getNomeInventariante().setConteudo(regDiacDiat.fieldByName("NOME INVENTARIANTE").asString());
        if (!regDiacDiat.fieldByName("CPF REPRESENTANTE").asString().equals("00000000000")) {
            contrib.getCpfRepresentante().setConteudo(regDiacDiat.fieldByName("CPF REPRESENTANTE").asString());
        }
        contrib.getNomeRepresentante().setConteudo(regDiacDiat.fieldByName("NOME REPRESENTANTE").asString());
    }

    public void montarImovel(RegistroTxt regDiacDiat, Imovel imovel) throws GeracaoTxtException {
        imovel.getNomeImovel().setConteudo(regDiacDiat.fieldByName("NOME IMOVEL").asString());
        imovel.getAreaTotal().setConteudo(regDiacDiat.fieldByName("AREA TOTAL IMOVEL").asValor());
        if (!regDiacDiat.fieldByName("CODIGO IMOVEL INCRA").asString().equals("0000000000000")) {
            imovel.getCodigoIncra().setConteudo(regDiacDiat.fieldByName("CODIGO IMOVEL INCRA").asString());
        }
        imovel.getIsento().setConteudo(regDiacDiat.fieldByName("INDICADOR IMUNIDADE").asString());
        imovel.getMotivoIsencao().setConteudo(regDiacDiat.fieldByName("INDICADOR EMQUADRAMENTO").asString());
        if (!regDiacDiat.fieldByName("CEP IMOVEL").asString().equals("00000000")) {
            imovel.getCep().setConteudo(regDiacDiat.fieldByName("CEP IMOVEL").asString());
        }
        imovel.getDistrito().setConteudo(regDiacDiat.fieldByName("DISTRITO IMOVEL").asString());
        imovel.getTipoLogradouro().setConteudo(regDiacDiat.fieldByName("TIPO LOGRADOURO IMOVEL").asString());
        imovel.getLogradouro().setConteudo(regDiacDiat.fieldByName("ENDERECO IMOVEL").asString());
        imovel.getUf().setConteudo(regDiacDiat.fieldByName("UF IMOVEL").asString());
        String codigoMunicipioImovel = regDiacDiat.fieldByName("CODIGO MUNICIPIO IMOVEL").asString();
        if (codigoMunicipioImovel.equals("0000")) {
            imovel.getMunicipio().setConteudo("");
        } else {
            imovel.getMunicipio().setConteudo(codigoMunicipioImovel);
        }
        imovel.getPertenceCondominio().setConteudo(regDiacDiat.fieldByName("INDICADOR CONDOMINIO").asString());
        String tipoDeclarante = regDiacDiat.fieldByName("TIPO DECLARANTE").asString();
        if (tipoDeclarante.equals("2")) {
            imovel.getPessoaFisica().setConteudo("1");
        } else if (tipoDeclarante.equals("4")) {
            imovel.getPessoaFisica().setConteudo("2");
        }
    }

    public void montarDemaisCondominos(List regsCondominos, List regsDiacDiat, Contribuinte contribuinte, DemaisCondominos condominos) throws GeracaoTxtException {
        if (regsCondominos.size() > 0) {
            RegistroTxt reg = (RegistroTxt)regsCondominos.get(0);
            contribuinte.getParticCondominio().setConteudo(reg.fieldByName("PERCENTUAL").asValor());
        }
        if (regsDiacDiat.size() > 0) {
            RegistroTxt regDiatDiat = (RegistroTxt)regsDiacDiat.get(0);
            condominos.getTotalCondominos().setConteudo(regDiatDiat.fieldByName("TOTAL CONDOMINOS").asValor());
        }
        for (int i = 1; i < regsCondominos.size(); ++i) {
            RegistroTxt reg = (RegistroTxt)regsCondominos.get(i);
            Condomino cond = new Condomino();
            cond.getNi().setConteudo(reg.fieldByName("CPFCNPJ CONDOMINO").asString());
            cond.getNome().setConteudo(reg.fieldByName("NOME CONDOMINO").asString());
            cond.getPercentual().setConteudo(reg.fieldByName("PERCENTUAL").asValor());
            condominos.recuperarLista().add(cond);
        }
    }

    public void montarAquisicaoAlienacao(List regsAquisicaoParcial, List regsAquisicaoTotal, List regsAlienacaoParcial, List regsDesapropriacao, AquisicaoAlienacao aquisAlien) throws GeracaoTxtException {
        this.montarAquisicaoAlienacao(regsAlienacaoParcial, aquisAlien.getAlienacaoParcial());
        this.montarAquisicaoAlienacao(regsAquisicaoParcial, aquisAlien.getAquisicaoParcial());
        this.montarAquisicaoAlienacao(regsAquisicaoTotal, aquisAlien.getAquisicaoTotal());
        this.montarDesapropriacao(regsDesapropriacao, aquisAlien.getDesapropriacao());
    }

    public void montarAquisicaoAlienacao(List regs, Colecao colecao) throws GeracaoTxtException {
        Iterator it = regs.iterator();
        while (it.hasNext()) {
            int i = colecao.novoObjeto();
            if (i < 0) continue;
            InformacaoAquisicaoAlienacao item = (InformacaoAquisicaoAlienacao)((Object)colecao.recuperarLista().get(i));
            RegistroTxt reg = (RegistroTxt)it.next();
            item.getArea().setConteudo(reg.fieldByName("AREA").asValor());
            item.getData().setConteudo(reg.fieldByName("DATA").asString());
            item.getNiAlienanteAdquirente().setConteudo(reg.fieldByName("CPFCNPJ ALIENANTE").asString());
            item.getNirfImovelAlienanteAdquirente().setConteudo(reg.fieldByName("NIRF").asString());
        }
    }

    public void montarDesapropriacao(List regs, Colecao colecao) throws GeracaoTxtException {
        for (RegistroTxt reg : regs) {
            InformacaoDesapropriacao item = new InformacaoDesapropriacao();
            item.getArea().setConteudo(reg.fieldByName("AREA").asValor());
            item.getCnpjDesaproprianteAdquirente().setConteudo(reg.fieldByName("CNPJ_DESAPROPRIANTE").asString());
            item.getData().setConteudo(reg.fieldByName("DATA").asString());
            colecao.recuperarLista().add(item);
        }
    }

    public void montarAreaNaoUtilizada(RegistroTxt regDiacDiat, AreaNaoUtilizada areaNaoUtil) throws GeracaoTxtException {
        this.montarAreasNaoAceitas(regDiacDiat, areaNaoUtil.getAreasNaoAceitas());
        this.montarDistribuicaoAR(regDiacDiat, areaNaoUtil.getDistribuicaoPelaAR());
        areaNaoUtil.getAreaTotalNaoUtilizada().setConteudo(regDiacDiat.fieldByName("AREA TOTAL NAO UTILIZADA E NAO ACEITA").asValor());
    }

    public void montarDistribuicaoAR(RegistroTxt regDiat, DistribuicaoAR distribAR) throws GeracaoTxtException {
        distribAR.getAreaNaoUtilizada().setConteudo(regDiat.fieldByName("AREA TOTAL NAO UTILIZADA").asValor());
        distribAR.getDemaisBenfeitorias().setConteudo(regDiat.fieldByName("AREA DEMAIS BENFEITORIAS").asValor());
        distribAR.getImprestaveis().setConteudo(regDiat.fieldByName("AREA IMPRESTAVEIS").asValor());
        distribAR.getInexploradas().setConteudo(regDiat.fieldByName("AREA INEXPLORADAS").asValor());
        distribAR.getMineracao().setConteudo(regDiat.fieldByName("AREA MINERACAO").asValor());
        distribAR.getOutras().setConteudo(regDiat.fieldByName("AREA OUTRAS").asValor());
    }

    public void montarAreasNaoAceitas(RegistroTxt regDiat, AreasNaoAceitas areaNaoAceita) throws GeracaoTxtException {
        areaNaoAceita.getAreaExploracaoExtrativa().setConteudo(regDiat.fieldByName("AREA EXPLORACAO EXTRATIVA NAO ACEITA").asValor());
        areaNaoAceita.getAreaPastagem().setConteudo(regDiat.fieldByName("AREA PASTAGEM NAO ACEITA").asValor());
        areaNaoAceita.getAreaTotalNaoAceita().setConteudo(regDiat.fieldByName("AREA TOTAL NAO ACEITA").asValor());
    }

    public void montarUtilizacaoImovel(RegistroTxt regDiacDiat, UtilizacaoImovel utilizacaoImovel) throws GeracaoTxtException {
        this.montarDistribuicaoAreaImovel(regDiacDiat, utilizacaoImovel.getDistribuicaoAreaImovel());
        this.montarDistribuicaoAreaUtilizada(regDiacDiat, utilizacaoImovel.getDistribuicaoAreaUtilizada());
        utilizacaoImovel.getGrauUtilizacao().setConteudo(regDiacDiat.fieldByName("GRAU DE UTILIZACAO").asValor());
        utilizacaoImovel.getNumProcessoADAIbama().setConteudo(regDiacDiat.fieldByName("NUM PROCESSO ADA IBAMA").asString());
        utilizacaoImovel.getNumeroCAR().setConteudo(regDiacDiat.fieldByName("NUMERO CAR").asString());
    }

    public void montarDistribuicaoAreaUtilizada(RegistroTxt regDiat, DistribuicaoAreaUtilizada distribArea) throws GeracaoTxtException {
        distribArea.getAreaProdutosVegetais().setConteudo(regDiat.fieldByName("AREA PRODUTOS VEGETAIS").asValor());
        distribArea.getAreaEmDescanso().setConteudo(regDiat.fieldByName("AREA EM DESCANSO").asValor());
        distribArea.getAreaReflorestamento().setConteudo(regDiat.fieldByName("AREA REFLORESTAMENTO").asValor());
        distribArea.getAreaPastagens().setConteudo(regDiat.fieldByName("AREA PASTAGENS").asValor());
        distribArea.getAreaExploracaoExtrativa().setConteudo(regDiat.fieldByName("AREA EXPLORACAO EXTRATIVA").asValor());
        distribArea.getAreaAtividadeGranjeira().setConteudo(regDiat.fieldByName("AREA ATIVIDADE GRANJEIRA").asValor());
        distribArea.getAreaFrustracaoSafra().setConteudo(regDiat.fieldByName("AREA FRUSTACAO SAFRA").asValor());
        distribArea.getAreaUtilizadaPelaAR().setConteudo(regDiat.fieldByName("AREA TOTAL UTILIZADA").asValor());
    }

    public void montarDistribuicaoAreaImovel(RegistroTxt regDiat, DistribuicaoAreaImovel distribArea) throws GeracaoTxtException {
        distribArea.getAreaPreservacaoPermanente().setConteudo(regDiat.fieldByName("AREA PRESERVACAO PERMANENTE").asValor());
        distribArea.getAreaReservaLegal().setConteudo(regDiat.fieldByName("AREA RESERVA LEGAL").asValor());
        distribArea.getAreaReservaParticular().setConteudo(regDiat.fieldByName("AREA RESERVA PARTICULAR").asValor());
        distribArea.getAreaInteresseEcologico().setConteudo(regDiat.fieldByName("AREA INTERESSE ECOLOGICO").asValor());
        distribArea.getAreaServidaoFlorestal().setConteudo(regDiat.fieldByName("AREA SERVIDAO FLORESTAL").asValor());
        distribArea.getAreaFlorestasNativas().setConteudo(regDiat.fieldByName("AREA FLORESTAS NATIVAS").asValor());
        distribArea.getAreaAlagada().setConteudo(regDiat.fieldByName("AREA ALAGADA USINA HIDRELETRICA").asValor());
        distribArea.getAreaTributavel().setConteudo(regDiat.fieldByName("AREA TRIBUTAVEL").asValor());
        distribArea.getAreaOcupada().setConteudo(regDiat.fieldByName("AREA OCUPADA COM BENFEITORIAS UTEIS").asValor());
        distribArea.getAreaAproveitavel().setConteudo(regDiat.fieldByName("AREA APROVEITAVEL").asValor());
    }

    public void montarCalculoImposto(RegistroTxt regDiacDiat, CalculoImposto calcImposto) throws GeracaoTxtException {
        calcImposto.getValorTotalImovel().setConteudo(regDiacDiat.fieldByName("VALOR TOTAL IMOVEL").asValor());
        calcImposto.getValorBenfeitorias().setConteudo(regDiacDiat.fieldByName("VALOR BENFEITORIAS").asValor());
        calcImposto.getValorCulturas().setConteudo(regDiacDiat.fieldByName("VALOR CULTURAS PASTAGENS FLORESTAS").asValor());
        calcImposto.getValorTerraNua().setConteudo(regDiacDiat.fieldByName("VALOR TERRA NUA").asValor());
        calcImposto.getValorTerraNuaTributavel().setConteudo(regDiacDiat.fieldByName("VALOR TERRA NUA TRIBUTAVEL").asValor());
        calcImposto.getAliquota().setConteudo(regDiacDiat.fieldByName("VALOR ALIQUOTA").asValor());
        calcImposto.getImpostoCalculado().setConteudo(regDiacDiat.fieldByName("VALOR IMPOSTO CALCULADO").asValor());
        calcImposto.getImpostoDevido().setConteudo(regDiacDiat.fieldByName("VALOR IMPOSTO DEVIDO").asValor());
        calcImposto.getQtdCotas().setConteudo(regDiacDiat.fieldByName("QUANTIDADE QUOTAS").asValor());
        calcImposto.getValorQuota().setConteudo(regDiacDiat.fieldByName("VALOR QUOTA").asValor());
    }

    public void montarAtividadePecuaria(RegistroTxt regAtivPecuaria, AtividadePecuaria ativPecuaria) throws GeracaoTxtException {
        this.montarAreaServidaPastagem(regAtivPecuaria, ativPecuaria.getAreaServidaPastagem());
        this.montarRebanho(regAtivPecuaria, ativPecuaria.getRebanho());
    }

    public void montarRebanho(RegistroTxt regAtivPecuaria, Rebanho rebanho) throws GeracaoTxtException {
        this.montarRebanhoGP(regAtivPecuaria, rebanho.getItemRebanhoGP());
        this.montarRebanhoMP(regAtivPecuaria, rebanho.getItemRebanhoMP());
        rebanho.getTotalRebanhoAjustado().setConteudo(regAtivPecuaria.fieldByName("TOTAL REBANHO").asValor());
    }

    public void montarRebanhoGP(RegistroTxt regAtivPecuaria, ItemRebanho item) throws GeracaoTxtException {
        item.getQtdCabecas().setConteudo(regAtivPecuaria.fieldByName("QTD CABECA GRANDE PORTE").asValor());
        item.getQtdCabecasAjustado().setConteudo(regAtivPecuaria.fieldByName("QTD CABECA GRANDE PORTE AJUSTADA").asValor());
    }

    public void montarRebanhoMP(RegistroTxt regAtivPecuaria, ItemRebanho item) throws GeracaoTxtException {
        item.getQtdCabecas().setConteudo(regAtivPecuaria.fieldByName("QTD CABECA MEDIO PORTE").asValor());
        item.getQtdCabecasAjustado().setConteudo(regAtivPecuaria.fieldByName("QTD CABECA MEDIO PORTE AJUSTADA").asValor());
    }

    public void montarAreaServidaPastagem(RegistroTxt regAtivPecuaria, AreaServidaPastagem areaPastagem) throws GeracaoTxtException {
        areaPastagem.getPastagemNativa().setConteudo(regAtivPecuaria.fieldByName("AREA PASTAGEM NATIVA").asValor());
        areaPastagem.getPastagemPlantada().setConteudo(regAtivPecuaria.fieldByName("AREA PASTAGEM PLANTADA").asValor());
        areaPastagem.getForrageiraCorte().setConteudo(regAtivPecuaria.fieldByName("AREA FORRAGEIRA CORTE").asValor());
        areaPastagem.getPastagemDeclarada().setConteudo(regAtivPecuaria.fieldByName("AREA PASTAGEM DECLARADA").asValor());
        areaPastagem.getIndiceLotacaoPecuaria().setConteudo(regAtivPecuaria.fieldByName("INDICE RENDIMENTO PECUARIA").asValor());
        areaPastagem.getPastagemCalculada().setConteudo(regAtivPecuaria.fieldByName("AREA PASTAGEM CALCULADA").asValor());
        areaPastagem.getPastagemAceita().setConteudo(regAtivPecuaria.fieldByName("AREA SERVIDA PASTAGEM ACEITA").asValor());
        areaPastagem.getPastagemEmFormacao().setConteudo(regAtivPecuaria.fieldByName("AREA PASTAGEM FORMACAO").asValor());
        areaPastagem.getImplantadaObjetoProjetoTecnico().setConteudo(regAtivPecuaria.fieldByName("AREA PROJETO TECNICO").asValor());
        areaPastagem.getTotal().setConteudo(regAtivPecuaria.fieldByName("AREA TOTAL PASTAGEM").asValor());
        areaPastagem.getOrgao().setConteudo(regAtivPecuaria.fieldByName("ORGAO PROJETO TECNICO").asString());
        if (regAtivPecuaria.fieldByName("DATA PROJETO TECNICO").asInteger() > 0) {
            areaPastagem.getData().setConteudo(regAtivPecuaria.fieldByName("DATA PROJETO TECNICO").asString());
        }
    }

    public void montarAtividadeExtrativa(List regsAtivExtrativa, AtividadeExtrativa ativExtrativa) throws GeracaoTxtException {
        for (int i = 0; i < regsAtivExtrativa.size(); ++i) {
            RegistroTxt reg = (RegistroTxt)regsAtivExtrativa.get(i);
            if (reg.getTipo().equals("F601")) {
                this.montarItemAtividadeExtrativa(reg, ativExtrativa.getAcaciaNegra());
            }
            if (reg.getTipo().equals("F602")) {
                this.montarItemAtividadeExtrativa(reg, ativExtrativa.getBabacu());
            }
            if (reg.getTipo().equals("F603")) {
                this.montarItemAtividadeExtrativa(reg, ativExtrativa.getBorracha());
            }
            if (reg.getTipo().equals("F604")) {
                this.montarItemAtividadeExtrativa(reg, ativExtrativa.getCarnauba());
            }
            if (reg.getTipo().equals("F605")) {
                this.montarItemAtividadeExtrativa(reg, ativExtrativa.getCastanha());
            }
            if (reg.getTipo().equals("F606")) {
                this.montarItemAtividadeExtrativa(reg, ativExtrativa.getGuarana());
            }
            if (reg.getTipo().equals("F607")) {
                this.montarItemAtividadeExtrativa(reg, ativExtrativa.getMadeira());
            }
            if (reg.getTipo().equals("F608")) {
                this.montarItemAtividadeExtrativa(reg, ativExtrativa.getProduto());
                String dataAprovacaoIbama = reg.fieldByName("DATA PLANO MANEJO").asString();
                if (dataAprovacaoIbama.equals("00000000")) {
                    ativExtrativa.getDataAprovacaoIbama().setConteudo("");
                } else {
                    ativExtrativa.getDataAprovacaoIbama().setConteudo(dataAprovacaoIbama);
                }
            }
            if (reg.getTipo().equals("F609")) {
                this.montarItemAtividadeExtrativa(reg, ativExtrativa.getOutros());
            }
            if (!reg.getTipo().equals("F699")) continue;
            ativExtrativa.getAreaExploracaoExtrativa().setConteudo(reg.fieldByName("AREA ACEITA").asValor());
        }
    }

    public void montarItemAtividadeExtrativa(RegistroTxt reg, ItemAtividadeExtrativa item) throws GeracaoTxtException {
        item.getArea().setConteudo(reg.fieldByName("AREA PLANTADA").asValor());
        item.getQtdProduzida().setConteudo(reg.fieldByName("QTD PRODUZIDA").asValor());
        item.getRendMinimo().setConteudo(reg.fieldByName("RENDIMENTO MINIMO").asValor());
        item.getAreaCalculada().setConteudo(reg.fieldByName("AREA CALCULADA").asValor());
        item.getAreaAceita().setConteudo(reg.fieldByName("AREA ACEITA").asValor());
    }
}

