/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.txt;

import java.util.List;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.contribuinte.Contribuinte;
import serpro.ppgd.itr.demaiscondominos.DemaisCondominos;
import serpro.ppgd.itr.imovel.Imovel;
import serpro.ppgd.itr.txt.ConversorRegistrosObjeto;
import serpro.ppgd.itr.utilizacaoimovel.DistribuicaoAreaImovel;
import serpro.ppgd.itr.utilizacaoimovel.UtilizacaoImovel;
import serpro.ppgd.negocio.Logico;

public class ConversorRegistrosObjetoExercicioAnterior
extends ConversorRegistrosObjeto {
    @Override
    public void montarDistribuicaoAreaImovel(RegistroTxt regDiat, DistribuicaoAreaImovel distribArea) throws GeracaoTxtException {
        distribArea.getAreaPreservacaoPermanente().setConteudo(regDiat.fieldByName("AREA PRESERVACAO PERMANENTE").asValor());
        distribArea.getAreaReservaLegal().setConteudo(regDiat.fieldByName("AREA RESERVA LEGAL").asValor());
        distribArea.getAreaReservaParticular().setConteudo(regDiat.fieldByName("AREA RESERVA PARTICULAR").asValor());
        distribArea.getAreaInteresseEcologico().setConteudo(regDiat.fieldByName("AREA INTERESSE ECOLOGICO").asValor());
        distribArea.getAreaServidaoFlorestal().setConteudo(regDiat.fieldByName("AREA SERVIDAO FLORESTAL").asValor());
        distribArea.getAreaFlorestasNativas().setConteudo(regDiat.fieldByName("AREA FLORESTAS NATIVAS").asValor());
        distribArea.getAreaTributavel().setConteudo(regDiat.fieldByName("AREA TRIBUTAVEL").asValor());
        distribArea.getAreaOcupada().setConteudo(regDiat.fieldByName("AREA OCUPADA COM BENFEITORIAS UTEIS").asValor());
        distribArea.getAreaAproveitavel().setConteudo(regDiat.fieldByName("AREA APROVEITAVEL").asValor());
    }

    @Override
    public void montarUtilizacaoImovel(RegistroTxt regDiacDiat, UtilizacaoImovel utilizacaoImovel) throws GeracaoTxtException {
        utilizacaoImovel.getDistribuicaoAreaImovel().getAreaPreservacaoPermanente().setConteudo(regDiacDiat.fieldByName("AREA PRESERVACAO PERMANENTE").asValor());
        utilizacaoImovel.getNumProcessoADAIbama().setConteudo(regDiacDiat.fieldByName("NUM PROCESSO ADA IBAMA").asString());
        utilizacaoImovel.getNumeroCAR().setConteudo(regDiacDiat.fieldByName("NUMERO CAR").asString());
    }

    @Override
    public void montarIdentificadorDeclaracao(RegistroTxt regDiacDiat, IdentificadorDeclaracao idDec) throws GeracaoTxtException {
        super.montarIdentificadorDeclaracao(regDiacDiat, idDec);
        idDec.getNumeroReciboDeclaracaoAnterior().clear();
        idDec.getRetificadora().clear();
    }

    @Override
    public void montarImovel(RegistroTxt regDiacDiat, Imovel imovel) throws GeracaoTxtException {
        super.montarImovel(regDiacDiat, imovel);
        imovel.getIsento().setConteudo(Logico.NAO);
        imovel.getMotivoIsencao().clear();
    }

    @Override
    public void montarContribuinte(RegistroTxt regDiacDiat, Contribuinte contrib) throws GeracaoTxtException {
        super.montarContribuinte(regDiacDiat, contrib);
        contrib.getDddTelefone().clear();
        String ddd = regDiacDiat.fieldByName("DDD TELEFONE DECLARANTE").asString().trim();
        if (ddd.length() <= contrib.getDddTelefone().getMaximoCaracteres()) {
            contrib.getDddTelefone().setConteudo(ddd);
        }
    }

    @Override
    public void montarDemaisCondominos(List regsCondominos, List regsDiacDiat, Contribuinte contribuinte, DemaisCondominos condominos) throws GeracaoTxtException {
        super.montarDemaisCondominos(regsCondominos, regsDiacDiat, contribuinte, condominos);
    }
}

