/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.txt;

import serpro.hash.Crc32;
import serpro.ppgd.formatosexternos.txt.DocumentoTXTDefault;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.util.TabelaMensagens;
import serpro.util.PLong;

public class DocumentoTxtComplRecibo
extends DocumentoTXTDefault {
    public static final String TIPO_ARQ_COMPL_RECIBO = "ARQ_RECIBO";
    public static final String TRAILLER_RECIBO = "TC";
    private TabelaMensagens tab = TabelaMensagens.getTabelaMensagens();

    public DocumentoTxtComplRecibo(String path) {
        super(TIPO_ARQ_COMPL_RECIBO, path);
    }

    public void validarCRCAcumulado() throws GeracaoTxtException {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        String hashCalculado = null;
        long hashCalculadoLinhaAnterior = 0L;
        for (int i = 0; i <= this.arquivo().size() - 1; ++i) {
            long hash;
            String linha = (String)this.arquivo().get(i);
            String hashLido = linha.substring(linha.length() - 10);
            StringBuffer sbLinha = new StringBuffer("");
            sbLinha.append(linha.substring(0, linha.length() - 10));
            if (hashCalculadoLinhaAnterior != 0L) {
                pLong.setValue(hashCalculadoLinhaAnterior);
            }
            hashCalculadoLinhaAnterior = hash = crc32.CalcCrc32(sbLinha.toString(), sbLinha.toString().length(), pLong);
            hashCalculado = crc32.getStrCrc32();
            if (!hashLido.trim().equals(hashCalculado.trim())) {
                throw new GeracaoTxtException(MensagemUtil.getMensagem("900045"));
            }
            if (i != this.arquivo().size() - 1 || linha.startsWith(TRAILLER_RECIBO)) continue;
            throw new GeracaoTxtException(MensagemUtil.getMensagem("900045"));
        }
    }
}

