/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.txt;

import java.util.Vector;
import serpro.hash.Crc32;
import serpro.ppgd.formatosexternos.txt.DocumentoTXTDefault;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.util.TabelaMensagens;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.util.Validador;
import serpro.util.PLong;

public class DocumentoTxtITR
extends DocumentoTXTDefault {
    private String hashAcumuladoLido;
    public static final String TIPO_ARQ_DECLARACAO = "ARQ_ITR";
    public static final String TIPO_ARQ_DECLARACAO_EXERCICIO_ANTERIOR = "ARQ_ITR_ANO_ANTERIOR";
    public static final String TIPO_ARQ_COPIA_SEGURANCA_ANTERIOR = "ARQ_ITR_COPIA_SEGURANCA_ANO_ANTERIOR";
    public static final String REG_HEADER = "ITR";
    public static final String REG_CORPO_RECIBO = "L";
    public static final String REG_CORPO_DECLARACAO = "F";
    public static final String REG_F1_DIAC_DIAT = "F1";
    public static final String REG_DEMAIS_CONDOMINOS = "F2";
    public static final String REG_AQUISICAO_ALIENACAO = "F3";
    public static final String REG_ATIVIDADE_EXTRATIVA = "F6";
    public static final String REG_ATIVIDADE_PECUARIA = "F5";
    public static final String REG_CORPORECIBO_L36 = "L36";
    public static final String REG_CORPORECIBO_L37 = "L37";
    public static final String TRAILLER_DECLARACAO = "T9";
    public static final String TRAILLER_RECIBO = "R9";
    public static final String CAMPO_F1_DIAC_DIAT_CPF_CONTRIB = "CPF CONTRIBUINTE";
    public static final String CAMPO_F1_DIAC_DIAT_CNPJ_CONTRIB = "CNPJ CONTRIBUINTE";
    public static final String CAMPO_F1_DIAC_DIAT_QTD_QUOTAS = "QUANTIDADE QUOTAS";
    public static final String CAMPO_F1_DIAC_DIAT_ISENTO = "INDICADOR IMUNIDADE";
    public static final String CAMPO_HASHCODE = "HASHCODE";
    public static final String CAMPO_HEADER_HASHCODEDECLARACAO = "HASHCODE_ACUMULADO";
    public static final String CAMPO_TRAILLER_DECLARACAO_HASHCODE = "HASH DECLARACAO";
    public static final String CAMPO_TRAILLER_RECIBO_HASHCODE = "HASH RECIBO";
    public static final String CAMPO_QTD_REGISTROS = "QTD REGISTROS";
    private TabelaMensagens tab = TabelaMensagens.getTabelaMensagens();
    private String hashCodeGeradoParaDeclaracaoGravadaParaEntrega = "";

    public DocumentoTxtITR(String pTipoDec, String path) {
        super(pTipoDec, path);
    }

    private String preparaNomeArquivoParaCrc() {
        String filenameTemp = UtilitariosArquivo.extraiNomeArquivo((String)this.getPath()).toUpperCase();
        String filename = UtilitariosArquivo.extraiNomeAquivoSemExtensao((String)filenameTemp);
        if (filename.length() > 8) {
            filename = filename.substring(0, 8);
        }
        filename = filename.concat(UtilitariosArquivo.extraiExtensaoAquivo((String)filenameTemp));
        return filename;
    }

    private void verificacoesCRCHeader(boolean isValidacao) throws GeracaoTxtException {
        String filename = this.preparaNomeArquivoParaCrc();
        String pLinha = (String)this.arquivo().get(0);
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        StringBuffer linha = new StringBuffer(filename);
        linha.append(pLinha.substring(0, pLinha.length() - 10));
        crc32.CalcCrc32(linha.toString(), linha.length(), pLong);
        String hashLido = pLinha.substring(pLinha.length() - 10, pLinha.length());
        String hashCalculado = crc32.getStrCrc32();
        if (isValidacao) {
            this.validaHash(hashLido, hashCalculado);
        } else {
            this.preencheHashDeLinha(0, hashCalculado, REG_HEADER);
        }
    }

    private void validaHash(String pHashLido, String pHashCalculado) throws GeracaoTxtException {
        if (!pHashLido.equals(pHashCalculado)) {
            throw new GeracaoTxtException(MensagemUtil.getMensagem("900045"));
        }
    }

    private void preencheHashDeLinha(int pos, String pHash, String pTipoReg) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt(this.getTipoArquivo(), pTipoReg);
        reg.setLinha((String)this.arquivo().get(pos));
        reg.fieldByName(CAMPO_HASHCODE).set(pHash);
        this.atualizarRegistros(pos, reg);
    }

    public void verificacoesCRCGravacaoParaEntrega(boolean isValidacao) throws GeracaoTxtException {
        PLong pLongAcumulado = new PLong();
        Crc32 crc32Acumulado = new Crc32();
        String hashAcumuladoCalculadoDeclaracao = "";
        String hashAcumuladoCalculadoRecibo = "";
        long hashCalculadoLinhaAnterior = 0L;
        int totalLinhasCorpoDec = 0;
        int totalLinhasCorpoRecibo = 0;
        StringBuffer strCRCTraillerDeclaracao = new StringBuffer();
        if (isValidacao) {
            this.verificacoesCRCHeader(true);
        }
        for (int i = 1; i < this.arquivo().size() - 1; ++i) {
            StringBuffer linhaPreenchida;
            PLong pLong;
            Crc32 crcAtual;
            String linha = (String)this.arquivo().get(i);
            if (linha.startsWith(REG_CORPO_RECIBO)) {
                ++totalLinhasCorpoRecibo;
            } else if (linha.startsWith(REG_CORPO_DECLARACAO)) {
                ++totalLinhasCorpoDec;
            }
            String conteudoLimpo = linha.substring(0, linha.length() - 10);
            if (!conteudoLimpo.startsWith(REG_CORPO_RECIBO) && !conteudoLimpo.startsWith(TRAILLER_RECIBO)) {
                if (!conteudoLimpo.startsWith(TRAILLER_DECLARACAO)) {
                    crcAtual = new Crc32();
                    pLong = new PLong();
                    pLong.setValue(0L);
                    linha = (String)this.arquivo().get(i);
                    conteudoLimpo = linha.substring(0, linha.length() - 10);
                    crcAtual.CalcCrc32(conteudoLimpo, conteudoLimpo.length(), pLong);
                    String hashLido = linha.substring(linha.length() - 10, linha.length());
                    String hashCalculado = crcAtual.getStrCrc32();
                    if (isValidacao) {
                        this.validaHash(hashLido, hashCalculado);
                    } else if (linha.startsWith(REG_AQUISICAO_ALIENACAO)) {
                        this.preencheHashDeLinha(i, hashCalculado, linha.substring(0, 3));
                    } else if (linha.startsWith(REG_ATIVIDADE_EXTRATIVA)) {
                        this.preencheHashDeLinha(i, hashCalculado, linha.substring(0, 4));
                    } else {
                        this.preencheHashDeLinha(i, hashCalculado, linha.substring(0, 2));
                    }
                    strCRCTraillerDeclaracao.append(hashCalculado);
                } else {
                    linha = (String)this.arquivo().get(i);
                    conteudoLimpo = linha.substring(0, linha.length() - 10);
                    Crc32 crc32HashConcatenado = new Crc32();
                    crc32HashConcatenado.CalcCrc32(strCRCTraillerDeclaracao.toString(), strCRCTraillerDeclaracao.toString().length(), new PLong());
                    String strCrcConcatenadoCalculado = crc32HashConcatenado.getStrCrc32();
                    RegistroTxt traillerDeclaracao = new RegistroTxt(this.getTipoArquivo(), TRAILLER_DECLARACAO);
                    traillerDeclaracao.setLinha(linha);
                    String strCrcConcatenadoLido = traillerDeclaracao.fieldByName(CAMPO_TRAILLER_DECLARACAO_HASHCODE).asString();
                    if (isValidacao) {
                        this.validaHash(strCrcConcatenadoLido, strCrcConcatenadoCalculado);
                    } else {
                        this.preencheHashTraillerDeclaracao(i, strCrcConcatenadoCalculado, String.valueOf(totalLinhasCorpoDec));
                    }
                }
                linha = (String)this.arquivo().get(i);
                conteudoLimpo = linha.substring(0, linha.length() - 10);
                if (hashCalculadoLinhaAnterior != 0L) {
                    pLongAcumulado.setValue(hashCalculadoLinhaAnterior);
                }
                hashCalculadoLinhaAnterior = crc32Acumulado.CalcCrc32(linha, linha.length(), pLongAcumulado);
                hashAcumuladoCalculadoDeclaracao = crc32Acumulado.getStrCrc32();
                if (!conteudoLimpo.startsWith(TRAILLER_DECLARACAO)) continue;
                if (isValidacao) {
                    this.validarCRCdeclaracao(hashAcumuladoCalculadoDeclaracao);
                } else {
                    this.preencheHashAcumuladoHeader(hashAcumuladoCalculadoDeclaracao);
                    this.verificacoesCRCHeader(false);
                }
                hashAcumuladoCalculadoRecibo = hashAcumuladoCalculadoDeclaracao;
                continue;
            }
            if (!conteudoLimpo.startsWith(REG_CORPO_RECIBO)) continue;
            linha = (String)this.arquivo().get(i);
            conteudoLimpo = linha.substring(0, linha.length() - 10);
            if (!isValidacao && linha.startsWith(REG_CORPORECIBO_L36)) {
                linhaPreenchida = new StringBuffer(linha);
                String hashDecSemDV = UtilitariosString.formataComPontos((String)this.hashCodeGeradoParaDeclaracaoGravadaParaEntrega, (int)2);
                linhaPreenchida.replace(3, 3 + hashDecSemDV.length(), hashDecSemDV);
                this.arquivo().set(i, linhaPreenchida.toString());
                linha = (String)this.arquivo().get(i);
                conteudoLimpo = linha.substring(0, linha.length() - 10);
            } else if (!isValidacao && linha.startsWith(REG_CORPORECIBO_L37)) {
                linhaPreenchida = new StringBuffer(linha);
                Object DV = "";
                int dv1 = Validador.calcularModulo11((String)this.hashCodeGeradoParaDeclaracaoGravadaParaEntrega, null, (int)2);
                DV = (String)DV + dv1;
                int dv2 = Validador.calcularModulo11((String)(this.hashCodeGeradoParaDeclaracaoGravadaParaEntrega + dv1), null, (int)2);
                DV = (String)DV + dv2;
                String hashComDV = UtilitariosString.formataComPontos((String)(this.hashCodeGeradoParaDeclaracaoGravadaParaEntrega + (String)DV), (int)2);
                linhaPreenchida.replace(32, 32 + hashComDV.length(), hashComDV);
                this.arquivo().set(i, linhaPreenchida.toString());
                linha = (String)this.arquivo().get(i);
                conteudoLimpo = linha.substring(0, linha.length() - 10);
            }
            crcAtual = new Crc32();
            pLong = new PLong();
            pLong.setValue(0L);
            crcAtual.CalcCrc32(conteudoLimpo, conteudoLimpo.length(), pLong);
            String hashCalculado = crcAtual.getStrCrc32();
            if (!isValidacao) {
                this.preencheHashDeLinha(i, hashCalculado, linha.substring(0, 1));
            }
            linha = (String)this.arquivo().get(i);
            conteudoLimpo = linha.substring(0, linha.length() - 10);
            if (hashCalculadoLinhaAnterior != 0L) {
                pLongAcumulado.setValue(hashCalculadoLinhaAnterior);
            }
            hashCalculadoLinhaAnterior = crc32Acumulado.CalcCrc32(linha, linha.length(), pLongAcumulado);
            hashAcumuladoCalculadoRecibo = crc32Acumulado.getStrCrc32();
        }
        this.verificacoesCRCRecibo(isValidacao, hashAcumuladoCalculadoRecibo, String.valueOf(totalLinhasCorpoRecibo));
    }

    public void verificacoesCRCGravacaoCopiaSeguranca(boolean isValidacao) throws GeracaoTxtException {
        for (int i = 0; i < this.arquivo().size(); ++i) {
            Crc32 crcAtual = new Crc32();
            PLong pLong = new PLong();
            pLong.setValue(0L);
            String linha = (String)this.arquivo().get(i);
            String conteudoLimpo = linha.substring(0, linha.length() - 10);
            crcAtual.CalcCrc32(conteudoLimpo, conteudoLimpo.length(), pLong);
            String hashLido = linha.substring(linha.length() - 10, linha.length());
            String hashCalculado = crcAtual.getStrCrc32();
            if (isValidacao) {
                this.validaHash(hashLido, hashCalculado);
                continue;
            }
            if (linha.startsWith(REG_AQUISICAO_ALIENACAO)) {
                this.preencheHashDeLinha(i, hashCalculado, linha.substring(0, 3));
                continue;
            }
            if (linha.startsWith(REG_ATIVIDADE_EXTRATIVA)) {
                this.preencheHashDeLinha(i, hashCalculado, linha.substring(0, 4));
                continue;
            }
            this.preencheHashDeLinha(i, hashCalculado, linha.substring(0, 2));
        }
    }

    private void preencheHashAcumuladoHeader(String hashAcumulado) throws GeracaoTxtException {
        String linhaHeader = (String)this.arquivo().get(0);
        RegistroTxt reg = new RegistroTxt(this.getTipoArquivo(), REG_HEADER);
        reg.setLinha(linhaHeader);
        reg.fieldByName(CAMPO_HEADER_HASHCODEDECLARACAO).set(hashAcumulado);
        this.hashCodeGeradoParaDeclaracaoGravadaParaEntrega = hashAcumulado;
        this.atualizarRegistros(0, reg);
    }

    private void preencheHashTraillerDeclaracao(int pos, String hashConcatenado, String totalLinhasDecl) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt(this.getTipoArquivo(), TRAILLER_DECLARACAO);
        reg.setLinha((String)this.arquivo().get(pos));
        reg.fieldByName(CAMPO_TRAILLER_DECLARACAO_HASHCODE).set(hashConcatenado);
        reg.fieldByName(CAMPO_QTD_REGISTROS).set(totalLinhasDecl);
        Crc32 crcAtual = new Crc32();
        PLong pLong = new PLong();
        pLong.setValue(0L);
        String linha = reg.getLinha();
        String conteudoLimpo = linha.substring(0, linha.length() - 10);
        crcAtual.CalcCrc32(conteudoLimpo, conteudoLimpo.length(), pLong);
        String hashCalculado = crcAtual.getStrCrc32();
        reg.fieldByName(CAMPO_HASHCODE).set(hashCalculado);
        this.atualizarRegistros(pos, reg);
    }

    private void validarCRCdeclaracao(String pHashCalculado) throws GeracaoTxtException {
        RegistroTxt registroHeader = new RegistroTxt(this.getTipoArquivo(), REG_HEADER);
        registroHeader.setLinha((String)this.arquivo().get(0));
        String hashAcumuladoLido = registroHeader.fieldByName(CAMPO_HEADER_HASHCODEDECLARACAO).asString();
        if (!hashAcumuladoLido.equals(pHashCalculado)) {
            throw new GeracaoTxtException(MensagemUtil.getMensagem("900045"));
        }
    }

    private void verificacoesCRCRecibo(boolean isValidacao, String pHashCalculado, String totalLinhasRec) throws GeracaoTxtException {
        RegistroTxt registroTraillerRecibo = new RegistroTxt(this.getTipoArquivo(), TRAILLER_RECIBO);
        registroTraillerRecibo.setLinha((String)this.arquivo().get(this.arquivo().size() - 1));
        if (!isValidacao) {
            registroTraillerRecibo.fieldByName(CAMPO_TRAILLER_RECIBO_HASHCODE).set(pHashCalculado);
            registroTraillerRecibo.fieldByName(CAMPO_QTD_REGISTROS).set(totalLinhasRec);
            Crc32 crcAtual = new Crc32();
            PLong pLong = new PLong();
            pLong.setValue(0L);
            String linha = registroTraillerRecibo.getLinha();
            String conteudoLimpo = linha.substring(0, linha.length() - 10);
            crcAtual.CalcCrc32(conteudoLimpo, conteudoLimpo.length(), pLong);
            String hashCalculadoLinha = crcAtual.getStrCrc32();
            this.atualizarRegistros(this.arquivo().size() - 1, registroTraillerRecibo);
            this.preencheHashDeLinha(this.arquivo().size() - 1, hashCalculadoLinha, TRAILLER_RECIBO);
        }
    }

    protected void antesDeTransformarObjDaDeclaracaoEmRegistrosTXT(RegistroTxt pRegAtual) throws GeracaoTxtException {
    }

    protected void antesDeTransformarTXTEmObjDaDeclaracao(String pTipoArq, String pTipoReg, RegistroTxt pRegAtual) throws GeracaoTxtException {
    }

    protected void incluirLinhas(Vector linhas) {
        String so = System.getProperty("os.name").toUpperCase();
        for (int i = 0; i < linhas.size(); ++i) {
            String linha = (String)linhas.elementAt(i);
            if (!linha.startsWith(REG_CORPO_RECIBO) || so.indexOf("WIND") == -1) {
                linha = UtilitariosString.retiraCaracteresEspeciais((String)linha);
            }
            this.arquivo().add(linha);
        }
        this.setAlterado();
    }
}

