/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.txt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.IdentificadorDeclaracao;
import serpro.ppgd.itr.declaracao.ComplementoRecibo;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.gui.IdImovel;
import serpro.ppgd.itr.txt.ConstantesRepositorioTxt;
import serpro.ppgd.itr.txt.ConversorObjetoRegistros;
import serpro.ppgd.itr.txt.ConversorRegistrosObjeto;
import serpro.ppgd.itr.txt.ConversorRegistrosObjetoExercicioAnterior;
import serpro.ppgd.itr.txt.DocumentoTxtComplRecibo;
import serpro.ppgd.itr.txt.DocumentoTxtITR;
import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.TabelaMensagens;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.repositorio.RepositorioException;

public class RepositorioDeclaracaoTxt {
    private void gerarRegistros(DeclaracaoITR dec, DocumentoTxtITR doc) throws GeracaoTxtException {
        ConversorObjetoRegistros conversor = new ConversorObjetoRegistros();
        RegistroTxt regDiacDiat = conversor.gerarRegDiacDiat(dec);
        Vector regs = new Vector();
        regs.add(regDiacDiat);
        doc.setFicha(regs);
        regs = conversor.gerarRegsCondominos(dec);
        doc.setFicha(regs);
        regs = conversor.gerarRegsAquisTotal(dec);
        doc.setFicha(regs);
        regs = conversor.gerarRegsAquisParcial(dec);
        doc.setFicha(regs);
        regs = conversor.gerarRegsAlienParcial(dec);
        doc.setFicha(regs);
        regs = conversor.gerarRegsDesapropriacao(dec);
        doc.setFicha(regs);
        RegistroTxt regAtivPecuraria = conversor.gerarRegAtivPecuaria(dec);
        if (regAtivPecuraria != null) {
            regs = new Vector();
            regs.add(regAtivPecuraria);
            doc.setFicha(regs);
        }
        regs = conversor.gerarRegsAtivExtrativa(dec);
        doc.setFicha(regs);
    }

    public File gravarParaEntrega(DeclaracaoITR dec, File destino) throws GeracaoTxtException, IOException {
        File fileDec = new File(destino.getPath() + File.separator + this.obterNomeArquivoDec(dec.getIdentificadorDeclaracao()));
        if (this.obterNovoFileFilterArquivoDecTransmitida().accept(fileDec)) {
            File fileRec = this.obterArquivoRec(fileDec);
            fileRec.delete();
        }
        if (fileDec.exists() && fileDec.isFile()) {
            File copia = new File(fileDec.getPath());
            copia.delete();
        }
        if (fileDec.exists() && fileDec.isFile()) {
            File backup = new File(destino.getPath() + File.separator + this.obterNomeArquivoDecBkp(dec.getIdentificadorDeclaracao()));
            fileDec.renameTo(backup);
        }
        DocumentoTxtITR doc = new DocumentoTxtITR("ARQ_ITR", fileDec.getPath());
        ConversorObjetoRegistros conversor = new ConversorObjetoRegistros();
        RegistroTxt regHeader = conversor.gerarRegHeader(dec);
        Vector<RegistroTxt> regs = new Vector<RegistroTxt>();
        regs.add(regHeader);
        doc.setFicha(regs);
        this.gerarRegistros(dec, doc);
        RegistroTxt regTrailler = conversor.gerarRegTrailler(dec);
        regs = new Vector();
        regs.add(regTrailler);
        doc.setFicha(regs);
        RegistroTxt regTraillerRecibo = conversor.gerarRegTraillerRecibo(dec);
        regs = new Vector();
        regs.add(regTraillerRecibo);
        doc.setFicha(regs);
        doc.verificacoesCRCGravacaoParaEntrega(false);
        doc.salvar();
        return new File(fileDec.getPath());
    }

    public void gravarCopiaSeguranca(DeclaracaoITR dec, File destino) throws GeracaoTxtException {
        try {
            File fileDec = new File(destino.getPath() + File.separator + this.obterNomeArquivoDecCopia(dec.getIdentificadorDeclaracao()));
            if (fileDec.exists()) {
                new File(fileDec.getPath()).delete();
            }
            DocumentoTxtITR doc = new DocumentoTxtITR("ARQ_ITR", fileDec.getPath());
            this.gerarRegistros(dec, doc);
            doc.verificacoesCRCGravacaoCopiaSeguranca(false);
            doc.salvar();
        }
        catch (IOException e) {
            throw new GeracaoTxtException((Throwable)e);
        }
        catch (GeracaoTxtException e) {
            throw e;
        }
    }

    public void gravarCopiaDeclaracaoTransmitida(File arqDecOrigem, File destino) throws GeracaoTxtException {
        if (!this.obterNovoFileFilterArquivoDecTransmitida().accept(arqDecOrigem)) {
            throw new GeracaoTxtException("N\u00e3o foi encontrado o Recibo para esta declara\u00e7\u00e3o.");
        }
        this.copiarDeclaracaoGravada(arqDecOrigem, destino, true);
    }

    public void importarDeclaracaoGravada(File arqDecOrigem) throws GeracaoTxtException {
        File destino = new File(ConstantesGlobaisITR.PATH_GRAVADAS);
        boolean transmitida = false;
        if (this.obterNovoFileFilterArquivoDecTransmitida().accept(arqDecOrigem)) {
            transmitida = true;
        }
        this.copiarDeclaracaoGravada(arqDecOrigem, destino, transmitida);
    }

    protected void copiarDeclaracaoGravada(File arqDecOrigem, File destino, boolean transmitida) {
        if (!destino.getPath().equals(arqDecOrigem.getParent())) {
            File arq = new File(destino.getPath() + File.separator + arqDecOrigem.getName());
            if (arq.exists()) {
                arq.delete();
            }
            UtilitariosArquivo.copiaArquivo((String)arqDecOrigem.getPath(), (String)destino.getPath());
            if (transmitida) {
                File arqRecOrigem = this.obterArquivoRec(arqDecOrigem);
                arq = new File(destino.getPath() + File.separator + arqRecOrigem.getName());
                if (arq.exists()) {
                    arq.delete();
                }
                UtilitariosArquivo.copiaArquivo((String)arqRecOrigem.getPath(), (String)destino.getPath());
            }
        }
    }

    public ComplementoRecibo restaurarRecibo(File arqDec) throws RepositorioException {
        if (!this.obterNovoFileFilterArquivoDecTransmitida().accept(arqDec)) {
            throw new RepositorioException("Arquivo selecionado n\u00e3o possui recibo.");
        }
        File arqRec = this.obterArquivoRec(arqDec);
        DocumentoTxtITR docDec = new DocumentoTxtITR("ARQ_ITR", arqDec.getPath());
        try {
            docDec.ler();
            docDec.verificacoesCRCGravacaoParaEntrega(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RepositorioException(MensagemUtil.getMensagem("900065"));
        }
        DocumentoTxtComplRecibo docRec = new DocumentoTxtComplRecibo(arqRec.getPath());
        try {
            docRec.ler();
            docRec.validarCRCAcumulado();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RepositorioException(MensagemUtil.getMensagem("900065"));
        }
        ComplementoRecibo recibo = new ComplementoRecibo();
        try {
            this.montarImovelRecibo(docDec, recibo);
            this.montarDadosRecibo(docRec, recibo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositorioException("Ocorreu um erro durante impress\u00e3o do reibo.");
        }
        return recibo;
    }

    public void montarImovelRecibo(DocumentoTxtITR doc, ComplementoRecibo recibo) throws GeracaoTxtException, IOException {
        RegistroTxt regHeader = (RegistroTxt)doc.getRegistrosTxt("ITR").get(0);
        RegistroTxt regDiacDiat = (RegistroTxt)doc.getRegistrosTxt("F1").get(0);
        ConversorRegistrosObjeto conversor = new ConversorRegistrosObjeto();
        conversor.montarImovelRecibo(regHeader, regDiacDiat, recibo);
    }

    public void montarDadosRecibo(DocumentoTxtComplRecibo docRecibo, ComplementoRecibo recibo) throws GeracaoTxtException {
        ConversorRegistrosObjeto conversor = new ConversorRegistrosObjeto();
        List regsDados = docRecibo.getRegistrosTxt("RC");
        if (regsDados.size() > 0) {
            RegistroTxt regDados = (RegistroTxt)regsDados.get(0);
            List regsNotificacao = docRecibo.getRegistrosTxt("NC");
            RegistroTxt regNotificacao = null;
            if (regsNotificacao.size() > 0) {
                regNotificacao = (RegistroTxt)regsNotificacao.get(0);
            }
            List regsValidador01 = docRecibo.getRegistrosTxt("VC");
            RegistroTxt regValidador01 = null;
            if (regsValidador01.size() > 0) {
                regValidador01 = (RegistroTxt)regsValidador01.get(0);
            }
            List regsValidador02 = docRecibo.getRegistrosTxt("VC02");
            conversor.montarDadosRecibo(regDados, regNotificacao, regValidador01, regsValidador02, recibo);
        }
    }

    public DeclaracaoITR restaurarDeclaracao(File arquivo, boolean copia) throws Exception {
        if (copia && !this.obterNovoFileFilterArquivoCopiaSeguranca().accept(arquivo) || !copia && !this.obterNovoFileFilterArquivoDec().accept(arquivo)) {
            return null;
        }
        String path = arquivo.getPath();
        DocumentoTxtITR doc = new DocumentoTxtITR("ARQ_ITR", path);
        try {
            doc.ler();
            if (copia) {
                doc.verificacoesCRCGravacaoCopiaSeguranca(true);
            } else {
                doc.verificacoesCRCGravacaoParaEntrega(true);
            }
        }
        catch (Exception ex) {
            throw new RepositorioException(TabelaMensagens.getTabelaMensagens().msg("900065"));
        }
        String nirf = null;
        try {
            List regs = doc.getRegistrosTxt("F1");
            RegistroTxt reg = (RegistroTxt)regs.get(0);
            nirf = reg.fieldByName("NIRF").asString();
        }
        catch (GeracaoTxtException e) {
            throw new Exception(e.getMessage());
        }
        IdentificadorDeclaracao idDec = new IdentificadorDeclaracao();
        idDec.getNirf().setConteudo(nirf);
        DeclaracaoITR dec = new DeclaracaoITR(idDec);
        this.montarDeclaracao(doc, dec);
        return dec;
    }

    public void montarDeclaracao(DocumentoTxtITR doc, DeclaracaoITR dec) throws GeracaoTxtException {
        ConversorRegistrosObjeto conversor = new ConversorRegistrosObjeto();
        List regsDiacDiat = doc.getRegistrosTxt("F1");
        if (regsDiacDiat.size() > 0) {
            RegistroTxt reg = (RegistroTxt)regsDiacDiat.get(0);
            conversor.montarIdentificadorDeclaracao(reg, dec.getIdentificadorDeclaracao());
            conversor.montarContribuinte(reg, dec.getContribuinte());
            conversor.montarImovel(reg, dec.getImovel());
            conversor.montarAreaNaoUtilizada(reg, dec.getAreaNaoUtilizada());
            conversor.montarUtilizacaoImovel(reg, dec.getUtilizacaoImovel());
            conversor.montarCalculoImposto(reg, dec.getCalculoImposto());
        }
        List regsCondominos = doc.getRegistrosTxt("F2");
        conversor.montarDemaisCondominos(regsCondominos, regsDiacDiat, dec.getContribuinte(), dec.getDemaisCondominos());
        List regsAquisParcial = doc.getRegistrosTxt("F32");
        List regsAquisTotal = doc.getRegistrosTxt("F31");
        List regsAlienParcial = doc.getRegistrosTxt("F33");
        List regsDesapropriacao = doc.getRegistrosTxt("F34");
        conversor.montarAquisicaoAlienacao(regsAquisParcial, regsAquisTotal, regsAlienParcial, regsDesapropriacao, dec.getAquisicaoAlienacao());
        List regsAtivPecuaria = doc.getRegistrosTxt("F5");
        if (regsAtivPecuaria.size() > 0) {
            RegistroTxt reg = (RegistroTxt)regsAtivPecuaria.get(0);
            conversor.montarAtividadePecuaria(reg, dec.getAtividadePecuaria());
        }
        Vector regsAtivExtrativa = new Vector();
        regsAtivExtrativa.addAll(doc.getRegistrosTxt("F601"));
        regsAtivExtrativa.addAll(doc.getRegistrosTxt("F602"));
        regsAtivExtrativa.addAll(doc.getRegistrosTxt("F603"));
        regsAtivExtrativa.addAll(doc.getRegistrosTxt("F604"));
        regsAtivExtrativa.addAll(doc.getRegistrosTxt("F605"));
        regsAtivExtrativa.addAll(doc.getRegistrosTxt("F606"));
        regsAtivExtrativa.addAll(doc.getRegistrosTxt("F607"));
        regsAtivExtrativa.addAll(doc.getRegistrosTxt("F608"));
        regsAtivExtrativa.addAll(doc.getRegistrosTxt("F609"));
        conversor.montarAtividadeExtrativa(regsAtivExtrativa, dec.getAtividadeExtrativa());
    }

    public DeclaracaoITR recuperarDeclaracaoExercicioAnterior(File arquivo) throws Exception {
        DocumentoTxtITR doc = null;
        if (!this.obterNovoFileFilterArquivoExercicioAnterior().accept(arquivo)) {
            throw new RepositorioException("Arquivo inv\u00e1lido.");
        }
        doc = new DocumentoTxtITR("ARQ_ITR_EXERCICIO_ANTERIOR", arquivo.getPath());
        try {
            doc.ler();
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        if (arquivo.getName().endsWith("DEC")) {
            doc.verificacoesCRCGravacaoParaEntrega(true);
        } else {
            doc.verificacoesCRCGravacaoCopiaSeguranca(true);
        }
        String nirf = null;
        try {
            List regs = doc.getRegistrosTxt("F1");
            RegistroTxt reg = (RegistroTxt)regs.get(0);
            nirf = reg.fieldByName("NIRF").asString();
        }
        catch (GeracaoTxtException e) {
            throw new Exception(e.getMessage());
        }
        IdentificadorDeclaracao idDec = new IdentificadorDeclaracao();
        idDec.getNirf().setConteudo(nirf);
        DeclaracaoITR dec = new DeclaracaoITR(idDec);
        this.montarDeclaracaoExercicioAnterior(doc, dec);
        return dec;
    }

    private void montarDeclaracaoExercicioAnterior(DocumentoTxtITR doc, DeclaracaoITR dec) throws GeracaoTxtException {
        ConversorRegistrosObjetoExercicioAnterior conversor = new ConversorRegistrosObjetoExercicioAnterior();
        List regsDiacDiat = doc.getRegistrosTxt("F1");
        if (regsDiacDiat.size() > 0) {
            RegistroTxt reg = (RegistroTxt)regsDiacDiat.get(0);
            conversor.montarIdentificadorDeclaracao(reg, dec.getIdentificadorDeclaracao());
            conversor.montarContribuinte(reg, dec.getContribuinte());
            conversor.montarImovel(reg, dec.getImovel());
        }
        List regsCondominos = doc.getRegistrosTxt("F2");
        conversor.montarDemaisCondominos(regsCondominos, regsDiacDiat, dec.getContribuinte(), dec.getDemaisCondominos());
    }

    public String obterNirfArquivoDeclaracao(File arquivo) {
        if (this.obterNovoFileFilterArquivoDec().accept(arquivo)) {
            return arquivo.getName().substring(0, 8);
        }
        return null;
    }

    public String obterNirfArquivoCopiaSeguranca(File arquivo) {
        if (this.obterNovoFileFilterArquivoCopiaSeguranca().accept(arquivo)) {
            return arquivo.getName().substring(0, 8);
        }
        return null;
    }

    public String obterNirfArquivoExercicioAnterior(File arquivo) {
        if (this.obterNovoFileFilterArquivoExercicioAnterior().accept(arquivo)) {
            return arquivo.getName().substring(0, 8);
        }
        return null;
    }

    public static String obterNomeArquivoSemExtensao(IdentificadorDeclaracao id) {
        StringBuffer nome = new StringBuffer(id.getNirf().naoFormatado());
        nome.append("-ITR-");
        nome.append(ConstantesGlobais.EXERCICIO);
        nome.append("-");
        if (id.getRetificadora().formatado().equals(Logico.SIM)) {
            nome.append("RETIF");
            if (ConstantesGlobaisITR.NUM_RECIBO_ARQ_RETIF) {
                nome.append("-" + id.getNumeroReciboDeclaracaoAnterior().naoFormatado());
            }
        } else {
            nome.append("ORIGI");
        }
        return nome.toString();
    }

    public String obterNomeArquivoDec(IdentificadorDeclaracao id) {
        return RepositorioDeclaracaoTxt.obterNomeArquivoSemExtensao(id) + ".DEC";
    }

    public String obterNomeArquivoDecCopia(IdentificadorDeclaracao id) {
        return RepositorioDeclaracaoTxt.obterNomeArquivoSemExtensao(id) + ".DBK";
    }

    public String obterNomeArquivoRec(IdentificadorDeclaracao id) {
        return RepositorioDeclaracaoTxt.obterNomeArquivoSemExtensao(id) + ".REC";
    }

    private File obterArquivoRec(File arqDec) {
        String path = arqDec.getPath();
        return new File(path.substring(0, path.length() - "DEC".length()) + "REC");
    }

    public String obterNomeArquivoDecBkp(IdentificadorDeclaracao id) {
        return RepositorioDeclaracaoTxt.obterNomeArquivoSemExtensao(id) + ".BAK";
    }

    public FileFilter obterNovoFileFilterArquivoDec() {
        return new DeclaracaoITRFileFilter(ConstantesRepositorioTxt.EXP_REG_ARQ_DEC);
    }

    public javax.swing.filechooser.FileFilter obterNovoFileChooserFilterArquivoDec() {
        return new DeclaracaoITRFileChooserFilter(ConstantesRepositorioTxt.EXP_REG_ARQ_DEC, "Arquivos .DEC");
    }

    public FileFilter obterNovoFileFilterArquivoDecTransmitida() {
        return this.obterNovoFileFilterArquivoDecTransmitida(false, false);
    }

    public FileFilter obterNovoFileFilterArquivoDecTransmitidaMaed() {
        return this.obterNovoFileFilterArquivoDecTransmitida(true, false);
    }

    public FileFilter obterNovoFileFilterArquivoDecUltimaTransmitida() {
        return this.obterNovoFileFilterArquivoDecTransmitida(false, true);
    }

    public FileFilter obterNovoFileFilterArquivoDecTransmitida(final boolean comMaed, final boolean ultimaTrasmitida) {
        return new DeclaracaoITRFileFilter(ConstantesRepositorioTxt.EXP_REG_ARQ_DEC){

            @Override
            public boolean accept(File pathname) {
                if (super.accept(pathname)) {
                    File arqRec = RepositorioDeclaracaoTxt.this.obterArquivoRec(pathname);
                    try {
                        RegistroTxt regHeaderDec = RepositorioDeclaracaoTxt.this.obterPrimeirosRegistros(pathname, "ARQ_ITR", "ITR", 1).get(0);
                        String exercicio = regHeaderDec.fieldByName("EXERCICIO PGD").asString();
                        if (!exercicio.equals(ConstantesGlobais.EXERCICIO)) {
                            return false;
                        }
                        List<RegistroTxt> regsRec = RepositorioDeclaracaoTxt.this.obterPrimeirosRegistros(arqRec, "ARQ_RECIBO", new String[]{"RC", "NC"}, new int[]{1, 1});
                        RegistroTxt regDadosRec = null;
                        RegistroTxt regNotificacaoRec = null;
                        for (RegistroTxt regRec : regsRec) {
                            if (regRec.getTipo().equals("RC")) {
                                regDadosRec = regRec;
                                continue;
                            }
                            if (!regRec.getTipo().equals("NC")) continue;
                            regNotificacaoRec = regRec;
                        }
                        String nomeArqDec = pathname.getName();
                        if (ultimaTrasmitida && nomeArqDec.contains("ORIGI")) {
                            nomeArqDec = nomeArqDec.replace("ORIGI", "RETIF");
                            File arqDecRetificadora = new File(pathname.getParent() + File.separator + nomeArqDec);
                            if (arqDecRetificadora.exists()) {
                                return false;
                            }
                        }
                        return arqRec.exists() && arqRec.isFile() && RepositorioDeclaracaoTxt.this.controleSRF(regHeaderDec, regDadosRec) && (!comMaed || regNotificacaoRec != null);
                    }
                    catch (GeracaoTxtException e) {
                        LogPPGD.erro((String)("Erro GeracaoTxtException: " + e.getMessage()));
                    }
                    catch (IOException e) {
                        LogPPGD.erro((String)("Erro IOException: " + e.getMessage()));
                    }
                    catch (Exception e) {
                        LogPPGD.erro((String)("Erro Exception: " + e.getMessage()));
                    }
                }
                return false;
            }
        };
    }

    private boolean controleSRF(RegistroTxt regHeaderDec, RegistroTxt regDadosRec) throws GeracaoTxtException, IOException {
        String controleSRFcodificado = regDadosRec.fieldByName("CONTROLE_SRF").asString();
        String controleDecodificado = this.decodificaControleSRF(controleSRFcodificado.getBytes());
        String hash = regHeaderDec.fieldByName("HASHCODE_ACUMULADO").asString();
        return hash.equals(controleDecodificado);
    }

    private String decodificaControleSRF(byte[] bits) {
        if (null == bits) {
            throw new NullPointerException("Campo nulo.");
        }
        if (bits.length != 10) {
            throw new IllegalArgumentException("Campo inv\u00e1lido.");
        }
        BigInteger crc32 = BigInteger.ZERO;
        for (int i = 0; i < 32; ++i) {
            if (!((bits[i % 10] & 1 << i / 10) != 0)) continue;
            crc32 = crc32.setBit(i);
        }
        Object stCrc = crc32.toString();
        while (((String)stCrc).length() < 10) {
            stCrc = "0" + (String)stCrc;
        }
        return stCrc;
    }

    public FileFilter obterNovoFileFilterArquivoCopiaSeguranca() {
        return new DeclaracaoITRFileFilter(ConstantesRepositorioTxt.EXP_REG_ARQ_COPIA);
    }

    public javax.swing.filechooser.FileFilter obterNovoFileChooserFilterArquivoCopiaSeguranca() {
        return new DeclaracaoITRFileChooserFilter(ConstantesRepositorioTxt.EXP_REG_ARQ_COPIA, "Arquivos .DBK");
    }

    public FileFilter obterNovoFileFilterArquivoExercicioAnterior() {
        return new DeclaracaoITRFileFilter(ConstantesRepositorioTxt.EXP_REG_ARQ_EXERCICIO_ANTERIOR);
    }

    public javax.swing.filechooser.FileFilter obterNovoFileChooserFilterArquivoExercicioAnterior() {
        return new DeclaracaoITRFileChooserFilter(ConstantesRepositorioTxt.EXP_REG_ARQ_EXERCICIO_ANTERIOR, "Arquivos .DEC, .DBK");
    }

    public List<RegistroTxt> obterPrimeirosRegistros(File arq, String tipoArq, String[] tiposReg, int[] qtdRegs) throws GeracaoTxtException, IOException {
        Vector<RegistroTxt> list = new Vector<RegistroTxt>();
        BufferedReader arqDec = null;
        try {
            arqDec = new BufferedReader(new FileReader(arq));
            String reg = null;
            int i = 0;
            int qtdLido = 0;
            while (i < tiposReg.length && i < qtdRegs.length) {
                if (qtdLido < qtdRegs[i]) {
                    reg = arqDec.readLine();
                    if (reg != null) {
                        if (!reg.startsWith(tiposReg[i])) continue;
                        RegistroTxt registroTxt = new RegistroTxt(tipoArq, tiposReg[i]);
                        registroTxt.setLinha(reg);
                        list.add(registroTxt);
                        ++qtdLido;
                        continue;
                    }
                    break;
                }
                qtdLido = 0;
                ++i;
            }
        }
        catch (GeracaoTxtException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (arqDec != null) {
                    arqDec.close();
                }
            }
            catch (Exception exception) {}
        }
        return list;
    }

    public List<RegistroTxt> obterPrimeirosRegistros(File arq, String tipoArq, String tipoReg, int qtdRegs) throws GeracaoTxtException, IOException {
        return this.obterPrimeirosRegistros(arq, tipoArq, new String[]{tipoReg}, new int[]{qtdRegs});
    }

    public int obterStatusIdImovel(IdentificadorDeclaracao id) {
        File arqRec;
        File arqDec = new File(ConstantesGlobaisITR.PATH_TRANSMITIDAS + File.separator + this.obterNomeArquivoDec(id));
        if (arqDec.exists() && arqDec.isFile() && (arqRec = new File(ConstantesGlobaisITR.PATH_TRANSMITIDAS + File.separator + this.obterNomeArquivoRec(id))).exists() && arqRec.isFile()) {
            return 3;
        }
        return 0;
    }

    public String obterRecibo(IdentificadorDeclaracao id) {
        File arqDec = new File(ConstantesGlobaisITR.PATH_TRANSMITIDAS + File.separator + this.obterNomeArquivoDec(id));
        try {
            List<RegistroTxt> regs = this.obterPrimeirosRegistros(arqDec, "ARQ_ITR", "ITR", 1);
            RegistroTxt reg = regs.get(0);
            return reg.fieldByName("HASHCODE_ACUMULADO").asString();
        }
        catch (GeracaoTxtException geracaoTxtException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    public IdImovel obterIdImovelRepositorio(IdentificadorDeclaracao id) {
        IdImovel idImovel = new IdImovel();
        idImovel.setNirf(ITRUtil.formatarIdentificacaoImovel(id.getNirf().naoFormatado()));
        if (!id.getRetificadora().isVazio()) {
            idImovel.setRetificadora(id.getRetificadora().naoFormatado().equals(Logico.SIM));
        }
        idImovel.setNomeImovel(id.getNomeImovel().formatado());
        idImovel.setNomeContribuinte(id.getNomeContribuinte().formatado());
        idImovel.setNiContribuinte(id.getNiContribuinte().formatado());
        idImovel.setStatus(this.obterStatusIdImovel(id));
        if (idImovel.getStatus() == 3) {
            idImovel.setRecibo(ITRUtil.formatarRecibo(this.obterRecibo(id)));
        }
        return idImovel;
    }

    public IdImovel obterIdImovelDecGravada(File arqDec) {
        IdImovel idImovel = new IdImovel();
        if (arqDec.exists() && arqDec.isFile()) {
            try {
                List<RegistroTxt> regs = this.obterPrimeirosRegistros(arqDec, "ARQ_ITR", new String[]{"ITR", "F1"}, new int[]{1, 1});
                RegistroTxt reg = regs.get(0);
                String nirf = reg.fieldByName("NIRF").asString();
                String retificadora = reg.fieldByName("RETIFICADORA").asString();
                String nomeImovel = reg.fieldByName("NOME IMOVEL").asString();
                String niContribuinte = reg.fieldByName("NI CONTRIBUINTE").asString();
                String recibo = reg.fieldByName("HASHCODE_ACUMULADO").asString();
                reg = regs.get(1);
                String nomeContribuinte = reg.fieldByName("NOME CONTRIBUINTE").asString();
                idImovel.setNirf(ITRUtil.formatarIdentificacaoImovel(nirf));
                idImovel.setNomeImovel(nomeImovel.trim());
                idImovel.setNiContribuinte(UtilitariosString.formataNI((String)niContribuinte));
                idImovel.setNomeContribuinte(nomeContribuinte.trim());
                if (retificadora.equals(Logico.SIM)) {
                    idImovel.setRetificadora(true);
                } else if (retificadora.equals(Logico.NAO)) {
                    idImovel.setRetificadora(false);
                }
                if (this.obterNovoFileFilterArquivoDecTransmitida().accept(arqDec)) {
                    idImovel.setStatus(3);
                    idImovel.setRecibo(ITRUtil.formatarRecibo(recibo.trim()));
                }
            }
            catch (GeracaoTxtException geracaoTxtException) {
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return idImovel;
    }

    public static class DeclaracaoITRFileChooserFilter
    extends javax.swing.filechooser.FileFilter {
        private Pattern patternDecITR;
        private String description;

        public DeclaracaoITRFileChooserFilter(String regExp, String description) {
            this.patternDecITR = Pattern.compile(regExp);
            this.description = description;
        }

        @Override
        public boolean accept(File f) {
            if (f != null && f.getName() != null && f.getName().length() > 0 && f.isFile()) {
                return this.patternDecITR.matcher(f.getName()).matches();
            }
            return true;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    public static class DeclaracaoITRFileFilter
    implements FileFilter {
        private Pattern patternDecITR;

        public DeclaracaoITRFileFilter(String regExp) {
            this.patternDecITR = Pattern.compile(regExp);
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname != null && pathname.getName() != null && pathname.getName().length() > 0 && pathname.isFile()) {
                return this.patternDecITR.matcher(pathname.getName()).matches();
            }
            return false;
        }
    }
}

