/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.txt;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigInteger;
import serpro.hash.Crc32;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.itr.declaracao.ComplementoRecibo;
import serpro.ppgd.itr.txt.DocumentoTxtITR;
import serpro.ppgd.itr.txt.RepositorioComplRecibo;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.util.PLong;

public class UtilitariosTXT {
    public static boolean controleSRFBate(File dec, File rec) throws RepositorioException, IOException, GeracaoTxtException {
        ComplementoRecibo complRecibo = new ComplementoRecibo();
        RepositorioComplRecibo repositorioRecibo = new RepositorioComplRecibo();
        repositorioRecibo.recupera(complRecibo, rec.getPath());
        String controleSRFcodificado = complRecibo.getControleSRF().asString();
        String controleDecodificado = UtilitariosTXT.decodificaControleSRF(controleSRFcodificado.getBytes());
        DocumentoTxtITR doc = new DocumentoTxtITR("ARQ_ITR", dec.getPath());
        doc.ler();
        try {
            doc.verificacoesCRCGravacaoParaEntrega(true);
        }
        catch (GeracaoTxtException e) {
            throw new RepositorioException("Arquivo Conrrompido", (Throwable)e);
        }
        RegistroTxt headerDec = (RegistroTxt)doc.getRegistrosTxt("ITR").get(0);
        String hash = headerDec.fieldByName("HASHCODE_ACUMULADO").asString();
        return hash.equals(controleDecodificado);
    }

    public static String decodificaControleSRF(byte[] bits) {
        if (null == bits) {
            throw new NullPointerException("Campo nulo.");
        }
        if (bits.length != 10) {
            throw new IllegalArgumentException("Campo inv\u00e1lido.");
        }
        BigInteger crc32 = BigInteger.ZERO;
        for (int i = 0; i < 32; ++i) {
            if (!((bits[i % 10] & 1 << i / 10) != 0)) continue;
            crc32 = crc32.setBit(i);
        }
        Object stCrc = crc32.toString();
        while (((String)stCrc).length() < 10) {
            stCrc = "0" + (String)stCrc;
        }
        return stCrc;
    }

    public static File getRECCorrespondente(File aDec) {
        File retVal = null;
        String arqDEC = aDec.getPath();
        String arqREC = arqDEC.substring(0, arqDEC.length() - 4) + ".REC";
        File fileRec = new File(arqREC);
        if (fileRec.exists()) {
            retVal = fileRec;
        }
        return retVal;
    }

    public static void gravarArqHash(String nomeArq) throws IOException {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        String hashCalculado = null;
        long hashCalculadoLinhaAnterior = 0L;
        String linha = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(UtilitariosArquivo.getResource((String)("/" + nomeArq), UtilitariosTXT.class), "ISO-8859-1"));){
            while ((linha = in.readLine()) != null) {
                long hash;
                if (hashCalculadoLinhaAnterior != 0L) {
                    pLong.setValue(hashCalculadoLinhaAnterior);
                }
                hashCalculadoLinhaAnterior = hash = crc32.CalcCrc32(linha, linha.length(), pLong);
                hashCalculado = crc32.getStrCrc32();
            }
        }
        System.out.println("hashCalculado=" + hashCalculado);
        String nomeArqHash = UtilitariosTXT.class.getResource("/" + nomeArq).getFile();
        System.out.println("arqPath=" + nomeArqHash);
        nomeArqHash = nomeArqHash.substring(0, nomeArqHash.length() - ".txt".length());
        File arqHash = new File(nomeArqHash + ".hsh");
        PrintWriter out = new PrintWriter(arqHash, "ISO-8859-1");
        out.println(hashCalculado);
        out.close();
    }

    public static void main(String[] args) throws Exception {
    }
}

