/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.util;

import java.util.Properties;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public class AplicacaoPropertiesUtil {
    private static Properties propriedadesApp = FabricaUtilitarios.getProperties();
    private static String nomeVersao;

    public static String getTituloVersao() {
        if (nomeVersao == null) {
            StringBuilder lSb = new StringBuilder(10);
            lSb.append(AplicacaoPropertiesUtil.getNomeAplicacao());
            lSb.append(" ");
            lSb.append(AplicacaoPropertiesUtil.getExercicio());
            lSb.append(" - Vers\u00e3o ");
            if (!AplicacaoPropertiesUtil.isBeta()) {
                lSb.append(AplicacaoPropertiesUtil.getVersao());
            }
            if (AplicacaoPropertiesUtil.getFase() != null) {
                lSb.append(" - ");
                lSb.append(AplicacaoPropertiesUtil.getFase());
                lSb.append(" ");
                lSb.append(AplicacaoPropertiesUtil.isTestes() ? AplicacaoPropertiesUtil.getVersaoTeste() : AplicacaoPropertiesUtil.getVersaoHomologacao());
            }
            nomeVersao = lSb.toString();
        }
        return nomeVersao;
    }

    public static String getExercicio() {
        return propriedadesApp.getProperty("exercicio");
    }

    public static int getExercicioAsInt() {
        return Integer.parseInt(propriedadesApp.getProperty("exercicio"));
    }

    public static String getTitulo() {
        return propriedadesApp.getProperty("titulo");
    }

    public static String getNomeAplicacao() {
        return propriedadesApp.getProperty("nomeAplicacao");
    }

    public static String getVersao() {
        return propriedadesApp.getProperty("versao");
    }

    public static String getVersaoTeste() {
        return propriedadesApp.getProperty("versao_teste");
    }

    public static String getVersaoHomologacao() {
        return propriedadesApp.getProperty("versao_hom");
    }

    public static String getNomeAplicacaoPorExtenso() {
        return propriedadesApp.getProperty("nomeAplicacaoExtenso");
    }

    public static String getFase() {
        return AplicacaoPropertiesUtil.isTestes() ? "Testes " : (AplicacaoPropertiesUtil.isBeta() ? "Beta " : (AplicacaoPropertiesUtil.isHomologacao() ? "Homologa\u00e7\u00e3o " : (AplicacaoPropertiesUtil.isDesenvolvimento() ? "Desenvolvimento " : null)));
    }

    public static boolean isTestes() {
        return Boolean.valueOf(propriedadesApp.getProperty("versao_testes"));
    }

    public static boolean isBeta() {
        return Boolean.valueOf(propriedadesApp.getProperty("versao_beta"));
    }

    public static boolean isHomologacao() {
        return Boolean.valueOf(propriedadesApp.getProperty("versao_homologacao"));
    }

    public static boolean isDesenvolvimento() {
        return ConstantesGlobaisITR.FASE.equalsIgnoreCase("Desenvolvimento");
    }

    public static String getSiteIRPF() {
        return propriedadesApp.getProperty("aplicacao.site.irpf");
    }

    public static String getSiteCorreiosBuscaCEP() {
        return propriedadesApp.getProperty("aplicacao.site.correios");
    }

    public static String getSiteADAIbama() {
        return propriedadesApp.getProperty("aplicacao.site.ada.ibama");
    }

    public static String getSiteCAR() {
        return propriedadesApp.getProperty("aplicacao.site.car");
    }
}

