/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.json.JSONException;
import org.json.JSONObject;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.DarfPayload;
import serpro.ppgd.itr.calculoimposto.VTN;
import serpro.ppgd.itr.gui.util.PdfUtil;
import serpro.ppgd.itr.util.ArquivoUtil;
import serpro.ppgd.itr.util.DataUtil;
import serpro.ppgd.itr.util.HashUtil;
import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.itr.util.JsonUtil;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.LogPPGD;

public class BarramentoUtil {
    public static final String API_VTN = "/barramento/sipt/consulta/vtn";
    public static final String COD_MSG_DARF = "0000D";
    public static final String TITULO_MSG_DARF = "Impressao do Darf";
    public static final String API_DARF = "/barramento/darf";
    public static final String COD_MSG_NL = "0000N";
    public static final String TITULO_MSG_NL = "Impress\u00e3o da Notifica\u00e7\u00e3o";
    public static final String API_NL = "/barramento/notificacao";
    public static final String COD_MSG_REC = "0000R";
    public static final String TITULO_MSG_REC = "Impress\u00e3o do Recibo";
    public static final String API_REC = "/barramento/recibo";
    public static final String COD_MSG_DEC = "0000I";
    public static final String TITULO_MSG_DEC = "Impress\u00e3o da Declara\u00e7\u00e3o";
    public static final String API_DEC = "/barramento/declaracao";

    public static void main(String[] args) {
        String nomeArquivo = "17752043-ITR-2025-ORIGI";
        BarramentoUtil.gerarDarfImpostoTest();
        BarramentoUtil.gerarDeclaracaoTest(nomeArquivo);
        BarramentoUtil.gerarReciboTest(nomeArquivo);
    }

    public static void forceTLS() {
        System.setProperty("https.protocols", "TLSv1.2");
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static VTN consultarVTNs(String codMunicipio, String exercico) {
        BarramentoUtil.forceTLS();
        VTN vtn = null;
        try {
            String endereco = BarramentoUtil.getEnderecoBarramento().concat(API_VTN).concat("/").concat(codMunicipio).concat("/").concat(exercico);
            URL url = new URL(endereco);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("Accept", "application/json");
            con.setReadTimeout(5000);
            con.setDoOutput(true);
            if (con.getResponseCode() == 200) {
                String rTxt = IOUtils.toString((InputStream)con.getInputStream());
                JSONObject rJson = new JSONObject(rTxt);
                vtn = new VTN();
                vtn.getValor1().setCasasDecimais(4);
                vtn.getValor2().setCasasDecimais(4);
                vtn.getValor3().setCasasDecimais(4);
                vtn.getValor4().setCasasDecimais(4);
                vtn.setCodMunicipio(codMunicipio);
                vtn.getValor1().setConteudo(ITRUtil.formatVtn(rJson.getString("valor1")));
                vtn.getValor2().setConteudo(ITRUtil.formatVtn(rJson.getString("valor2")));
                vtn.getValor3().setConteudo(ITRUtil.formatVtn(rJson.getString("valor3")));
                vtn.getValor4().setConteudo(ITRUtil.formatVtn(rJson.getString("valor4")));
            } else {
                int codRetorno = con.getResponseCode();
                String msgRetorno = IOUtils.toString((InputStream)con.getErrorStream());
                msgRetorno = new String(msgRetorno.getBytes(), "UTF-8");
                String msgErro = "A chamada ao servi\u00e7o do barramento ITR retornou o erro com codigo (".concat(Integer.toString(codRetorno)).concat(") e mensagem (").concat(con.getResponseMessage()).concat(").").concat("\nErro:" + msgRetorno);
                System.err.println("");
                System.err.println(msgErro);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogPPGD.erro((String)("Ocorreu um erro inesperado na tentativa de consultar os VTNs no SIPT Web via barramento: " + e.getMessage()));
            vtn = null;
        }
        return vtn;
    }

    public static String imprimirDarfSenda(DarfPayload dp) {
        BarramentoUtil.forceTLS();
        try {
            String endereco = BarramentoUtil.getEnderecoBarramento().concat(API_DARF);
            URL url = new URL(endereco);
            byte[] postData = JsonUtil.createJson(dp).getBytes(StandardCharsets.UTF_8);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("Accept", "application/json");
            con.setRequestProperty("hash", HashUtil.createHash(dp));
            con.setRequestProperty("Content-Length", Integer.toString(postData.length));
            con.setRequestProperty("Connection", "close");
            con.setReadTimeout(30000);
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.write(postData);
            if (con.getResponseCode() == 200) {
                String respostaTexto = IOUtils.toString((InputStream)con.getInputStream());
                JSONObject respostaJson = new JSONObject(respostaTexto);
                return respostaJson.getString("pdf");
            }
            BarramentoUtil.tratarErroRetorno(con, COD_MSG_DARF, TITULO_MSG_DARF);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogPPGD.erro((String)("Ocorreu um erro inesperado na tentativa de obter o DARF via barramento: " + e.getMessage()));
            MensagemUtil.exibirErroPorCodigo(COD_MSG_DARF, TITULO_MSG_DARF);
        }
        return "";
    }

    public static String imprimirNotificacao(String dec, String rec) {
        BarramentoUtil.forceTLS();
        try {
            String endereco = BarramentoUtil.getEnderecoBarramento().concat(API_NL);
            HttpsURLConnection con = BarramentoUtil.getConn(dec, rec, endereco);
            if (con.getResponseCode() == 200) {
                String respostaTexto = IOUtils.toString((InputStream)con.getInputStream());
                JSONObject respostaJson = new JSONObject(respostaTexto);
                return respostaJson.getString("pdf");
            }
            BarramentoUtil.tratarErroRetorno(con, COD_MSG_NL, TITULO_MSG_NL);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogPPGD.erro((String)("Ocorreu um erro inesperado na tentativa da impressao da notifica\u00e7\u00e3o de lan\u00e7amento via Ditr Web: " + e.getMessage()));
            MensagemUtil.exibirErroPorCodigo(COD_MSG_NL, TITULO_MSG_NL);
        }
        return "";
    }

    public static String imprimirRecibo(String dec, String rec) {
        BarramentoUtil.forceTLS();
        try {
            String endereco = BarramentoUtil.getEnderecoBarramento().concat(API_REC);
            HttpsURLConnection con = BarramentoUtil.getConn(dec, rec, endereco);
            if (con.getResponseCode() == 200) {
                String respostaTexto = IOUtils.toString((InputStream)con.getInputStream());
                JSONObject respostaJson = new JSONObject(respostaTexto);
                return respostaJson.getString("pdf");
            }
            BarramentoUtil.tratarErroRetorno(con, COD_MSG_REC, TITULO_MSG_REC);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogPPGD.erro((String)("Ocorreu um erro inesperado na tentativa da impressao do recibo via Ditr Web: " + e.getMessage()));
            MensagemUtil.exibirErroPorCodigo(COD_MSG_REC, TITULO_MSG_REC);
        }
        return "";
    }

    public static String imprimirDeclaracao(String dec, String rec) {
        BarramentoUtil.forceTLS();
        try {
            String endereco = BarramentoUtil.getEnderecoBarramento().concat(API_DEC);
            HttpsURLConnection con = BarramentoUtil.getConn(dec, rec, endereco);
            if (con.getResponseCode() == 200) {
                String respostaTexto = IOUtils.toString((InputStream)con.getInputStream());
                JSONObject respostaJson = new JSONObject(respostaTexto);
                return respostaJson.getString("pdf");
            }
            BarramentoUtil.tratarErroRetorno(con, COD_MSG_DEC, TITULO_MSG_DEC);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Ocorreu um erro inesperado na tentativa da impressao da declara\u00e7\u00e3o via Ditr Web: " + e.getMessage());
            MensagemUtil.exibirErroPorCodigo(COD_MSG_DEC, TITULO_MSG_DEC);
        }
        return "";
    }

    private static HttpsURLConnection getConn(String dec, String rec, String endereco) throws MalformedURLException, IOException, ProtocolException {
        URL url = new URL(endereco);
        byte[] postData = JsonUtil.createJsonDecRecNL(dec, rec).getBytes(StandardCharsets.UTF_8);
        HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/json");
        con.setRequestProperty("Content-Length", Integer.toString(postData.length));
        con.setRequestProperty("Connection", "close");
        con.setReadTimeout(30000);
        con.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        wr.write(postData);
        return con;
    }

    private static void tratarErroRetorno(HttpURLConnection con, String codigoMensagem, String tituloMensagem) throws IOException {
        int codRetorno = con.getResponseCode();
        String msgRetorno = IOUtils.toString((InputStream)con.getErrorStream());
        msgRetorno = new String(msgRetorno.getBytes(), "UTF-8");
        String msgErro = "A chamada ao servi\u00e7o do barramento ITR retornou o erro com codigo (".concat(Integer.toString(codRetorno)).concat(") e mensagem (").concat(con.getResponseMessage()).concat(").").concat("\nErro:" + msgRetorno);
        System.err.println("");
        System.err.println(msgErro);
        System.out.println("");
        System.out.println(msgErro);
        if (codRetorno == 400 || codRetorno == 404) {
            MensagemUtil.exibirErroPorMensagem(BarramentoUtil.msgJsonToString(msgRetorno), tituloMensagem);
        }
        if (codRetorno == 500 || codRetorno == 502) {
            MensagemUtil.exibirErroPorCodigo(codigoMensagem, tituloMensagem);
        }
    }

    private static String getEnderecoBarramento() {
        if (ConstantesGlobaisITR.FASE.equalsIgnoreCase("Desenvolvimento")) {
            return ConstantesGlobaisITR.URL_BARRAMENTO_DES;
        }
        if (ConstantesGlobaisITR.FASE.equalsIgnoreCase("Homologacao")) {
            return ConstantesGlobaisITR.URL_BARRAMENTO_HOM;
        }
        return ConstantesGlobaisITR.URL_BARRAMENTO_PRO;
    }

    private static String msgJsonToString(String json) {
        try {
            if (json.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(json);
                return jsonObject.getString("mensagem");
            }
            return json;
        }
        catch (JSONException e) {
            return "";
        }
    }

    private static void gerarDarfImpostoTest() {
        try {
            DarfPayload dp = new DarfPayload();
            dp.setTipoNi(1);
            dp.setNi("80114504504");
            dp.setCodigoReceita(1070);
            dp.setValorPrincipal(4600.0);
            dp.setNumeroReferencia("01Q8W1HS");
            dp.setNirf("01Q8W1HS");
            dp.setObservacao1("CIB: 01Q8W1H-S");
            dp.setObservacao2("1\u00aa QUOTA");
            dp.setCota(1);
            dp.setDataVencimento(DataUtil.formatarDataDarf(null));
            dp.setDataPeriodoApuracao(DataUtil.formatarDataDarf("01/01/" + ConstantesGlobais.EXERCICIO));
            dp.setArea("8.8");
            dp.setExercicio(Integer.valueOf(ConstantesGlobais.EXERCICIO));
            String pdfBase64 = BarramentoUtil.imprimirDarfSenda(dp);
            if (StringUtils.isNotEmpty((CharSequence)pdfBase64)) {
                PdfUtil.exibirPdf(pdfBase64, TITULO_MSG_DARF, "Arquivo.pdf");
            } else {
                System.out.println("Ocorreu um erro inesperado. PDF n\u00e3o retornado pelo SENDA.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void gerarDeclaracaoTest(String nomeArquivo) {
        try {
            String dec = ArquivoUtil.lerArquivoToBase64("/home/s801145045/ProgramasRFB/ITR2025/gravadas/" + nomeArquivo + ".DEC");
            String rec = ArquivoUtil.lerArquivoToBase64("/home/s801145045/ProgramasRFB/ITR2025/gravadas/" + nomeArquivo + ".REC");
            String pdfBase64 = BarramentoUtil.imprimirDeclaracao(dec, rec);
            System.out.println("PDF Retornado:");
            System.out.println(pdfBase64);
            if (StringUtils.isNotEmpty((CharSequence)pdfBase64)) {
                PdfUtil.exibirPdf(pdfBase64, TITULO_MSG_DEC, "dec.pdf");
            } else {
                System.out.println("Ocorreu um erro inesperado. PDF n\u00e3o retornado pela Ditr Web.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void gerarReciboTest(String nomeArquivo) {
        try {
            String dec = ArquivoUtil.lerArquivoToBase64("/home/s801145045/ProgramasRFB/ITR2025/gravadas/" + nomeArquivo + ".DEC");
            String rec = ArquivoUtil.lerArquivoToBase64("/home/s801145045/ProgramasRFB/ITR2025/gravadas/" + nomeArquivo + ".REC");
            String pdfBase64 = BarramentoUtil.imprimirRecibo(dec, rec);
            System.out.println("PDF Retornado:");
            System.out.println(pdfBase64);
            if (StringUtils.isNotEmpty((CharSequence)pdfBase64)) {
                PdfUtil.exibirPdf(pdfBase64, TITULO_MSG_REC, "rec.pdf");
            } else {
                System.out.println("Ocorreu um erro inesperado. PDF n\u00e3o retornado pela Ditr Web.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void consultarVTNsTest() {
        VTN vtn = BarramentoUtil.consultarVTNs("9027", "2024");
        System.out.println("V1 = " + vtn.getValor1().getConteudoFormatado());
        System.out.println("V2 = " + vtn.getValor2().getConteudoFormatado());
        System.out.println("V3 = " + vtn.getValor3().getConteudoFormatado());
        System.out.println("V4 = " + vtn.getValor4().getConteudoFormatado());
    }
}

