/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.util;

public class CpfCnpjUtil {
    public static String getLabel(String ni) {
        if (CpfCnpjUtil.isCPF(ni)) {
            return "CPF";
        }
        return "CNPJ";
    }

    public static boolean isCPF(String ni) {
        return ni.length() <= 11;
    }

    public static String formatar(String ni) {
        if (ni == null || "".equals(ni)) {
            return "";
        }
        String niSoNumeros = ni.replaceAll("\\.", "").replaceAll("\\-", "");
        if (CpfCnpjUtil.isCPF(niSoNumeros)) {
            return CpfCnpjUtil.formatarCPF(niSoNumeros);
        }
        return CpfCnpjUtil.formatarCNPJ(niSoNumeros);
    }

    public static String formatarHeaderValidador(String ni) {
        if (ni == null || "".equals(ni)) {
            return "";
        }
        return ni.replaceAll("\\.", "").replaceAll("\\-", "");
    }

    public static String formatarCPF(String cpf) {
        StringBuilder sb = new StringBuilder();
        sb.append(cpf.substring(0, 3));
        sb.append(".");
        sb.append(cpf.substring(3, 6));
        sb.append(".");
        sb.append(cpf.substring(6, 9));
        sb.append("-");
        sb.append(cpf.substring(9, 11));
        return sb.toString();
    }

    public static String formatarCNPJ(String cnpj) {
        StringBuilder sb = new StringBuilder();
        sb.append(cnpj.substring(0, 2));
        sb.append(".");
        sb.append(cnpj.substring(2, 5));
        sb.append(".");
        sb.append(cnpj.substring(5, 8));
        sb.append("/");
        sb.append(cnpj.substring(8, 12));
        sb.append("-");
        sb.append(cnpj.substring(12, 14));
        return sb.toString();
    }
}

