/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.util;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import serpro.ppgd.itr.util.AplicacaoPropertiesUtil;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.DataHora;

public class DataUtil {
    public static Date obterDataAtual() {
        return new Date();
    }

    public static Integer obterAnoExercicio() {
        String lAnoExercicio = AplicacaoPropertiesUtil.getExercicio();
        return new Integer(lAnoExercicio);
    }

    public static Integer obterAnoAnteriorExercicio() {
        return DataUtil.obterAnoExercicio() - 1;
    }

    public static boolean isDataHoje(Date pData) {
        Calendar lHoje = Calendar.getInstance();
        DataUtil.zerarHorario(lHoje);
        Calendar lData = Calendar.getInstance();
        lData.setTime(pData);
        DataUtil.zerarHorario(lData);
        return lHoje.equals(lData);
    }

    public static boolean isDataHoje(Data pData) {
        return DataUtil.isDataHoje(pData.asDate());
    }

    public static boolean isDataHoje(DataHora pData) {
        return DataUtil.isDataHoje(pData.asDate());
    }

    public static void zerarHorario(Calendar pCalendario) {
        pCalendario.set(11, 0);
        pCalendario.set(12, 0);
        pCalendario.set(13, 0);
        pCalendario.set(14, 0);
    }

    public static void zerarData(Calendar pCalendario) {
        pCalendario.set(5, 0);
        pCalendario.set(2, 0);
        pCalendario.set(1, 0);
    }

    public static boolean isDataNoAnoExercicio(Data data) {
        if (!data.isVazio()) {
            String anoAtual = DataUtil.obterAnoExercicio().toString();
            if (data.getAno().equals(anoAtual)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAnoDataAnteriorAoAnoExercicio(Data data) {
        try {
            if (data.asString().trim().length() == 0) {
                return false;
            }
            if (new Integer(data.getAno()) < DataUtil.obterAnoExercicio()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isAnoDataAnteriorAno(Data data, Integer pAno) {
        try {
            if (data.asString().trim().length() == 0) {
                return false;
            }
            if (new Integer(data.getAno()) < pAno) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean verificarIntercecaoPeriodos(Date pDataInicio1, Date pDataFim1, Date pDataInicio2, Date pDataFim2) {
        return pDataFim1.after(pDataInicio2) && pDataInicio1.before(pDataFim2);
    }

    public static boolean verificarIntercecaoPeriodos(Data pDataInicio1, Data pDataFim1, Data pDataInicio2, Data pDataFim2) {
        return DataUtil.verificarIntercecaoPeriodos(pDataInicio1.asDate(), pDataFim1.asDate(), pDataInicio2.asDate(), pDataFim2.asDate());
    }

    public static int obterPrimeiroDiaUtilDeMaio(int ano) {
        Calendar c = Calendar.getInstance(new Locale("pt", "BR"));
        c.set(1, ano);
        c.set(2, 4);
        for (int dia = 2; dia <= 4; ++dia) {
            c.set(5, dia);
            if (c.get(7) == 7 || c.get(7) == 1) continue;
            return dia;
        }
        return 0;
    }

    public static String obterPrimeiroDiaUtilDeMaioString(int ano) {
        DecimalFormat df = new DecimalFormat("00");
        return df.format(DataUtil.obterPrimeiroDiaUtilDeMaio(ano));
    }

    public static int obterUltimoDiaUtilMes(int mes, int ano) {
        int maxDias;
        Calendar c = Calendar.getInstance(new Locale("pt", "BR"));
        c.set(1, ano);
        c.set(2, mes - 1);
        for (int dia = maxDias = c.getActualMaximum(5); dia > maxDias - 3; --dia) {
            c.set(5, dia);
            if (c.get(7) == 7 || c.get(7) == 1) continue;
            return dia;
        }
        return 0;
    }

    public static String obterUltimoDiaUtilMesString(int mes, int ano) {
        DecimalFormat df = new DecimalFormat("00");
        return df.format(DataUtil.obterUltimoDiaUtilMes(mes, ano));
    }

    public static String date2MesAno(Date pData) {
        Calendar lCalendar = Calendar.getInstance();
        lCalendar.setTime(pData);
        return String.format("%02d", lCalendar.get(2) + 1) + lCalendar.get(1);
    }

    public static String formatarDataSemBarras(Date pData) {
        SimpleDateFormat lSdf = new SimpleDateFormat("ddMMyyyy");
        return lSdf.format(pData);
    }

    public static String formatarDataDarf(String pData) {
        Date ldata = new Date();
        String dataService = "";
        try {
            SimpleDateFormat formatoProperties = new SimpleDateFormat("dd/MM/yyyy");
            if (StringUtils.isNotEmpty((CharSequence)pData)) {
                ldata = formatoProperties.parse(pData);
            }
            SimpleDateFormat formatoService = new SimpleDateFormat("yyyy-MM-dd");
            dataService = formatoService.format(ldata);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dataService;
    }

    public static String formatarDataGP(String pData) {
        Date ldata = new Date();
        String dataService = "";
        try {
            SimpleDateFormat formatoProperties = new SimpleDateFormat("dd/MM/yyyy");
            if (StringUtils.isNotEmpty((CharSequence)pData)) {
                ldata = formatoProperties.parse(pData);
            }
            SimpleDateFormat formatoService = new SimpleDateFormat("yyyyMMdd");
            dataService = formatoService.format(ldata);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dataService;
    }

    public static String formatarDataGPDDMMYYYY(String pData) {
        Date ldata = new Date();
        String dataService = "";
        try {
            SimpleDateFormat formatoProperties = new SimpleDateFormat("yyyyMMdd");
            if (StringUtils.isNotEmpty((CharSequence)pData)) {
                ldata = formatoProperties.parse(pData);
            }
            SimpleDateFormat formatoService = new SimpleDateFormat("ddMMyyyy");
            dataService = formatoService.format(ldata);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dataService;
    }
}

