/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import serpro.ppgd.gui.NavegadorHtml;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.ITRFacade;
import serpro.ppgd.itr.calamidade.rs.MunicipiosRS;
import serpro.ppgd.itr.declaracao.ComplementoRecibo;
import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.nuvem.BarramentoITRFService;
import serpro.ppgd.itr.nuvem.UsuarioLogado;
import serpro.ppgd.itr.txt.UtilitariosTXT;
import serpro.ppgd.itr.util.ArquivoUtil;
import serpro.ppgd.itr.util.CpfCnpjUtil;
import serpro.ppgd.itr.validadores.ValidadorCIB;
import serpro.ppgd.itr.validadores.ValidadorNirf;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.util.Validador;

public class ITRUtil {
    private static final String ARQUIVO_INI = "IRPF" + ConstantesGlobais.EXERCICIO + ".INI";
    public static final int EM_PREENCHIMENTO = 0;
    public static final int EM_PENDENCIA = 1;
    public static final int EM_IMPORTACAO = 2;
    private static String nomeArquivo = null;
    private static int estadoSistema = 0;
    public static boolean temDeclaracaoAberta = false;
    public static String DIR_DADOS;
    public static boolean usaAcessibilidade;
    private static final String MASCARA_NIRF = "*.***.***-*";
    private static final String MASCARA_CIB = "*******-*";
    private static final String BASE32_CROCKFORD = "0123456789ABCDEFGHJKMNPQRSTVWXYZ ";

    public static boolean isQuadroAvisosExibidos() {
        return ControladorGui.getJanelaPrincipal().isMensagensAvisoComplementaresAtivadas();
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version").replaceAll("[.\\-_]", "").substring(0, 3);
    }

    public static String compactarPathString(File path, int tamMax, int qtdIni) {
        Object ret = null;
        String strPath = path.getPath();
        if (strPath.length() > tamMax) {
            String inicio = strPath.substring(0, qtdIni);
            String fim = strPath.substring(strPath.length() - (tamMax - qtdIni));
            int fimOffset = fim.indexOf(File.separator);
            if (fimOffset < 0) {
                fimOffset = 0;
            }
            int inicioOffset = inicio.lastIndexOf(File.separator);
            ret = inicio.substring(0, inicioOffset + 1) + " ... " + fim.substring(fimOffset);
        } else {
            ret = strPath;
        }
        return ret;
    }

    public static String formatarRecibo(String numRecibo) {
        StringBuffer recibo = new StringBuffer(numRecibo);
        if (recibo.length() == 10) {
            recibo.append(ITRUtil.obtemDVNumRecibo(numRecibo));
        }
        return UtilitariosString.formataComPontos((String)recibo.toString(), (int)2);
    }

    public static String obtemDVNumRecibo(String numRecibo) {
        Object DV = "";
        int dv1 = Validador.calcularModulo11((String)numRecibo, null, (int)2);
        DV = (String)DV + dv1;
        int dv2 = Validador.calcularModulo11((String)(numRecibo + dv1), null, (int)2);
        DV = (String)DV + dv2;
        return DV;
    }

    public static String inserirQuebraLinha(String str, int qtdCaracteres, String quebraLinha) {
        StringTokenizer tkStr = new StringTokenizer(str, quebraLinha);
        StringBuffer ret = new StringBuffer();
        while (tkStr.hasMoreTokens()) {
            String s = UtilitariosString.insereQuebraDeLinha((String)tkStr.nextToken(), (int)qtdCaracteres, (String)quebraLinha);
            ret.append(s + quebraLinha);
        }
        return ret.toString();
    }

    public static int verificaData(String data) {
        int inAno;
        int inMes;
        int inDia;
        if (data == null || data.equals("  /  /    ")) {
            return 1;
        }
        int maxDia = 31;
        StringTokenizer tokenizer = new StringTokenizer(data, "/");
        if (tokenizer.countTokens() != 3) {
            return 1;
        }
        String token = tokenizer.nextToken();
        try {
            inDia = Integer.parseInt(token);
        }
        catch (Exception e) {
            return 1;
        }
        token = tokenizer.nextToken();
        try {
            inMes = Integer.parseInt(token);
        }
        catch (Exception e) {
            return 1;
        }
        token = tokenizer.nextToken();
        try {
            inAno = Integer.parseInt(token);
        }
        catch (Exception e) {
            return 1;
        }
        if (inMes <= 0 || inMes >= 13) {
            return 3;
        }
        maxDia = new GregorianCalendar(inAno, inMes - 1, 1).getActualMaximum(5);
        if (inDia <= 0 || inDia > maxDia) {
            return 2;
        }
        return 0;
    }

    public static void setEstadoSistema(int estadoSistema) {
        ITRUtil.estadoSistema = estadoSistema;
    }

    public static int getEstadoSistema() {
        return estadoSistema;
    }

    public static void exibirArquivoNavegador(byte[] bytes, String nome) {
        try {
            String nomeArq = nomeArquivo == null ? nome : nomeArquivo;
            nomeArquivo = null;
            Object caminho = null;
            caminho = FabricaUtilitarios.isLinux() || FabricaUtilitarios.isMac() ? UtilitariosArquivo.getPathUsuario() : UtilitariosArquivo.getPathAplicacao();
            caminho = (String)caminho + nomeArq;
            FileOutputStream stream = new FileOutputStream((String)caminho);
            stream.write(bytes);
            stream.close();
            NavegadorHtml.executarNavegador((String)("file://" + (String)caminho));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            String msg = "Erro ao gerar o PDF, verifique se um PDF gerado anteriormente encontra-se aberto.";
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), msg, "Erro", 0);
        }
    }

    public static boolean isCIB(String identificacao) {
        return !StringUtils.isNumeric((CharSequence)identificacao) && !StringUtils.isEmpty((CharSequence)identificacao);
    }

    public static String formatarIdentificacaoImovel(String identificacao) {
        if (ITRUtil.isCIB(identificacao = identificacao.toUpperCase())) {
            return identificacao.substring(0, 7) + "-" + identificacao.substring(7, 8);
        }
        return UtilitariosString.formataNIRF((String)identificacao);
    }

    public static String limparFormatacaoIdentificacaoImovel(String identificacao) {
        identificacao = identificacao.trim().toUpperCase();
        identificacao = identificacao.replace("-", "");
        identificacao = identificacao.replace(".", "");
        return identificacao.trim();
    }

    public static String obterMascaraIdentificacaoImovel(String identificacao) {
        if (ITRUtil.isCIB(identificacao)) {
            return MASCARA_CIB;
        }
        return MASCARA_NIRF;
    }

    public static String obterCaracteresValidosIdentificacaoImovel() {
        return BASE32_CROCKFORD + BASE32_CROCKFORD.toLowerCase();
    }

    public static boolean isNumeroImovelValido(String numero) {
        if (ITRUtil.isCIB(numero)) {
            return new ValidadorCIB().validate(numero);
        }
        return new ValidadorNirf().validate(numero);
    }

    public static boolean isMunicipioCalamidadeRS(Integer codigoMunicipio) {
        MunicipiosRS municipiosRS = MunicipiosRS.obterPorcodigoTOM(Integer.parseInt(ConstantesGlobais.EXERCICIO), codigoMunicipio);
        return !municipiosRS.equals((Object)MunicipiosRS.MUNICIPIO_INEXISTENTE);
    }

    public static String obterDeclaracaoBase64(DeclaracaoITR dec) {
        File arquivoDEC = null;
        try {
            arquivoDEC = ITRFacade.gravarParaEntrega(new File(System.getProperty("user.dir")), dec.getIdentificadorDeclaracao().getNirf().naoFormatado());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String caminhoDec = arquivoDEC.getAbsoluteFile().toString();
        String decBase64 = ArquivoUtil.lerArquivoToBase64(caminhoDec);
        ArquivoUtil.apagarArquivo(caminhoDec);
        return decBase64;
    }

    public static String obterDeclaracaoBase64(ComplementoRecibo recibo) {
        return ArquivoUtil.lerArquivoToBase64(recibo.getPathArquivo());
    }

    public static String obterReciboBase64(ComplementoRecibo recibo) {
        return ITRUtil.obterReciboBase64(recibo.getPathArquivo());
    }

    public static String obterReciboBase64(String caminhoDeclaracao) {
        File fileRec = UtilitariosTXT.getRECCorrespondente(new File(caminhoDeclaracao));
        return ArquivoUtil.lerArquivoToBase64(fileRec.getAbsolutePath());
    }

    public static String obterReciboBase64(DeclaracaoITR dec) {
        String reciboBase64 = "";
        String nomeAquivoDec = ITRFacade.obterNomeArquivoDec(dec.getIdentificadorDeclaracao());
        String pastaTransmitidas = ITRFacade.obterPastaPadraoTransmitidas().getAbsolutePath();
        File arquivoDec = new File(pastaTransmitidas.concat(File.separator).concat(nomeAquivoDec));
        if (arquivoDec.exists()) {
            return ITRUtil.obterReciboBase64(arquivoDec.getAbsolutePath());
        }
        return reciboBase64;
    }

    public static ComplementoRecibo getRecibo(File arqDec) {
        try {
            return ITRFacade.getRecibo(arqDec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatVtn(String numero) {
        numero = numero.trim();
        if ((numero = numero.replace(".", "")).length() >= 13) {
            return numero;
        }
        return String.format("%013d", Integer.parseInt(numero));
    }

    public static UsuarioLogado obterUsuarioLogado(String usuarioDec) {
        UsuarioLogado user;
        if (ConstantesGlobaisITR.ACESSO_GOV) {
            user = BarramentoITRFService.getUsuarioLogado();
        } else {
            user = new UsuarioLogado();
            user.setNivelAcessoGov("ouro");
            if (CpfCnpjUtil.isCPF(usuarioDec)) {
                user.setSub(usuarioDec);
                user.setDataNascimento("");
            } else {
                user.setCnpj(usuarioDec);
                user.setSub("");
                user.setDataNascimento("");
            }
        }
        return user;
    }

    static {
        String executandoSobJWS = System.getProperty("ppgd.jws");
        if (executandoSobJWS != null && executandoSobJWS.trim().equals("true")) {
            DIR_DADOS = System.getProperty("user.home") + "/ITR" + ConstantesGlobais.EXERCICIO + "/aplicacao/dados";
        } else {
            String arqConf = UtilitariosArquivo.getPathAplicacao() + ARQUIVO_INI;
            if (new File(arqConf).exists()) {
                try {
                    Properties prop = new Properties();
                    prop.load(new FileInputStream(arqConf));
                    String dirDados = (String)prop.get("aplicacao.diretorio.dados");
                    usaAcessibilidade = prop.containsKey("aplicacao.acessibilidade.habilitado") ? new Boolean(prop.getProperty("aplicacao.acessibilidade.habilitado")) : false;
                    if (!dirDados.trim().equals("")) {
                        FabricaUtilitarios.getProperties().setProperty("aplicacao.diretorio.dados", dirDados);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            DIR_DADOS = UtilitariosArquivo.getPathDados();
        }
    }
}

