/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import javax.json.Json;
import javax.json.JsonObject;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.DarfPayload;

public class JsonUtil {
    public static String getJson(Object obj) {
        String json = "";
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        try {
            json = mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            System.err.println("Ocorreu um erro na transforma\u00e7\u00e3o do objeto para json");
            e.printStackTrace();
        }
        return json;
    }

    public static String getGson(Object obj) {
        String json = "";
        Gson gson = new Gson();
        json = gson.toJson(obj);
        return json;
    }

    public static String createJson(DarfPayload dp) {
        JsonObject json = Json.createObjectBuilder().add("tipoNi", dp.getTipoNi().intValue()).add("ni", dp.getNi()).add("codigoReceita", dp.getCodigoReceita().intValue()).add("valorPrincipal", dp.getValorPrincipal().doubleValue()).add("numeroReferencia", dp.getNumeroReferencia()).add("nirf", dp.getNirf()).add("observacao1", dp.getObservacao1()).add("observacao2", dp.getObservacao2()).add("cota", dp.getCota().intValue()).add("area", dp.getArea()).add("dataVencimento", dp.getDataVencimento()).add("dataPeriadoApuracao", dp.getDataPeriodoApuracao()).add("exercicio", dp.getExercicio().intValue()).build();
        String jsonString = json.toString();
        if (!ConstantesGlobaisITR.FASE.equalsIgnoreCase("Producao")) {
            System.out.println("DEBUG: Json gerado no PGD para o barramento p/ Darf :" + jsonString);
        }
        return jsonString;
    }

    public static String createJsonDecRecNL(String dec, String rec) {
        JsonObject json = Json.createObjectBuilder().add("dec", dec).add("rec", rec).build();
        String jsonString = json.toString();
        if (!ConstantesGlobaisITR.FASE.equalsIgnoreCase("Producao")) {
            System.out.println("DEBUG: Json gerado no PGD para impress\u00e3o do recibo/NL na DITR Web :" + jsonString);
        }
        return jsonString;
    }
}

