/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.util;

import java.util.HashMap;
import java.util.StringTokenizer;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.gui.util.GuiUtil;
import serpro.ppgd.itr.util.Chave;
import serpro.ppgd.negocio.exception.MensagemNaoEncontradaException;
import serpro.ppgd.negocio.util.TabelaMensagens;
import serpro.ppgd.negocio.util.UtilitariosString;

public class MensagemUtil {
    private static HashMap<Chave, String> cacheMensagens = new HashMap();
    private static TabelaMensagens tabelaMensagens = TabelaMensagens.getTabelaMensagens();
    private static Class<?> classeConstantes = ConstantesGlobaisITR.class;

    public static StringBuffer tratarMsgRetornoReceitanet(StringBuffer msgBuffer) {
        String msg = msgBuffer.toString();
        msg = msg.replace("NIRF", "CIB");
        msg = msg.replace("Nirf", "CIB");
        msg = msg.replace("nirf", "CIB");
        msg = msg.replace("Nenhum dos servidores respondeu ao pedido de conex\u00e3o.", "N\u00e3o foi poss\u00edvel estabelecer conex\u00e3o com o servidor ou alguma de suas integra\u00e7\u00f5es.");
        msg = msg.replace("Verifique se sua configura\u00e7\u00e3o de rede est\u00e1 de acordo com as instru\u00e7\u00f5es constantes no endere\u00e7o:\nwww.receita.fazenda.gov.br, Perguntas e Respostas, Receitanet.", "Verifique se sua configura\u00e7\u00e3o de rede est\u00e1 de acordo com as instru\u00e7\u00f5es constantes no Perguntas e Respostas do Receitanet no site da RFB na Internet, no endere\u00e7o:\nhttps://www.gov.br/receitafederal/pt-br.");
        return new StringBuffer(msg);
    }

    public static String substituirTags(String mensagem, Class<?> classeConstantes) {
        String prefix = "@(";
        String sufix = ")";
        StringBuilder msg = new StringBuilder(mensagem);
        int i = 0;
        int i_ = 0;
        int f = 0;
        int f_ = 0;
        while ((i = msg.indexOf(prefix, f)) > -1 && (f_ = msg.indexOf(sufix, i_ = i + prefix.length())) > -1) {
            f = f_ + sufix.length();
            String nome = msg.substring(i_, f_);
            if (!nome.isEmpty()) {
                try {
                    String valor = classeConstantes.getField(nome).get(null).toString();
                    msg.replace(i, f, valor);
                    f = i + valor.length();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            i = f;
        }
        return msg.toString();
    }

    public static String getMensagem(String pChaveString) {
        String lRetorno = null;
        Chave lChave = new Chave(pChaveString);
        lRetorno = cacheMensagens.get(lChave);
        if (lRetorno == null) {
            try {
                lRetorno = MensagemUtil.substituirTags(tabelaMensagens.msg(pChaveString), classeConstantes);
            }
            catch (MensagemNaoEncontradaException e) {
                lRetorno = pChaveString;
            }
            cacheMensagens.put(lChave, lRetorno);
        }
        return lRetorno;
    }

    public static String getMensagem(String pChaveString, String[] pMsgArgs) {
        String lRetorno = null;
        Chave lChave = new Chave(pChaveString, pMsgArgs);
        lRetorno = cacheMensagens.get(lChave);
        if (lRetorno == null) {
            try {
                lRetorno = MensagemUtil.substituirTags(tabelaMensagens.msg(pChaveString, pMsgArgs), classeConstantes);
            }
            catch (MensagemNaoEncontradaException e) {
                lRetorno = pChaveString;
            }
            cacheMensagens.put(lChave, lRetorno);
        }
        return lRetorno;
    }

    public static String getMensagemComQuebraDeLinha(String pChaveString, int pTamanhoLinha) {
        return UtilitariosString.insereQuebraDeLinha((String)MensagemUtil.getMensagem(pChaveString), (int)pTamanhoLinha, (String)"\n");
    }

    public static String getMensagemComQuebraDeLinha(String pChaveString, String[] pArgs, int pTamanhoLinha) {
        return UtilitariosString.insereQuebraDeLinha((String)MensagemUtil.getMensagem(pChaveString, pArgs), (int)pTamanhoLinha, (String)"\n");
    }

    public static String getMensagemComQuebraDeLinha(String pChaveString) {
        String quebraLinha = "\n";
        int qtdCaracteres = 100;
        String str = MensagemUtil.getMensagem(pChaveString);
        StringBuffer ret = new StringBuffer();
        String[] partes = str.split(quebraLinha);
        for (int i = 0; i < partes.length; ++i) {
            String s = UtilitariosString.insereQuebraDeLinha((String)partes[i], (int)qtdCaracteres, (String)quebraLinha);
            ret.append(s + quebraLinha);
        }
        return ret.toString();
    }

    public static String getMensagemComQuebraDeLinhaHTML(String pChaveString) {
        if (pChaveString.toUpperCase().indexOf("<HTML>") == -1) {
            return UtilitariosString.insereQuebraDeLinha((String)("<html>" + MensagemUtil.getMensagem(pChaveString) + "</html>"), (int)70, (String)"<br>");
        }
        return UtilitariosString.insereQuebraDeLinha((String)MensagemUtil.getMensagem(pChaveString), (int)70, (String)"<br>");
    }

    public static String getMensagemComQuebraDeLinha(String pChaveString, String[] pArgs) {
        String quebraLinha = "\n";
        int qtdCaracteres = 100;
        String str = MensagemUtil.getMensagem(pChaveString, pArgs);
        StringTokenizer tkStr = new StringTokenizer(str, "\n");
        StringBuffer ret = new StringBuffer();
        while (tkStr.hasMoreTokens()) {
            String s = UtilitariosString.insereQuebraDeLinha((String)tkStr.nextToken(), (int)qtdCaracteres, (String)quebraLinha);
            ret.append(s + quebraLinha);
        }
        return ret.toString();
    }

    public static void exibirErroPorCodigo(String pCodigoErro, String pTitulo) {
        try {
            GuiUtil.informa(TabelaMensagens.getTabelaMensagens().msg(pCodigoErro, new String[]{""}), pTitulo, 0);
        }
        catch (MensagemNaoEncontradaException e) {
            e.printStackTrace();
        }
    }

    public static void exibirErroPorMensagem(String pMsgErro, String pTitulo) {
        if (pMsgErro.length() < 35) {
            pMsgErro.concat("\n                                        ");
        }
        GuiUtil.informa(pMsgErro, pTitulo, 0);
    }
}

