/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.util;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import serpro.ppgd.negocio.util.LogPPGD;

public class SingleInstanceUtil {
    public static boolean lock() {
        boolean bloqueado = false;
        try {
            File jarFile = new File(SingleInstanceUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            File lockFile = new File(jarFile.getAbsolutePath() + ".lock");
            if (lockFile.exists()) {
                LogPPGD.aviso((String)"O programa j\u00e1 est\u00e1 em execu\u00e7\u00e3o ou esteje e foi encerrado abruptamente.");
            }
            lockFile.createNewFile();
            RandomAccessFile file = new RandomAccessFile(lockFile, "rw");
            FileLock lock = file.getChannel().tryLock();
            if (lock == null) {
                LogPPGD.aviso((String)"O programa j\u00e1 est\u00e1 em execu\u00e7\u00e3o.");
                bloqueado = true;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    lock.release();
                    file.close();
                    lockFile.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }));
        }
        catch (Exception e) {
            LogPPGD.aviso((String)"Ocorreu um erro no bloqueio de mais de uma inst\u00e2ncia do aplicativo.");
        }
        return bloqueado;
    }

    public static void main(String[] args) {
        if (SingleInstanceUtil.lock()) {
            LogPPGD.aviso((String)"Bloqueado!!!");
        } else {
            LogPPGD.aviso((String)"Liberado!!");
        }
    }
}

