/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.util.update;

import br.gov.serpro.updater.AtualizacaoException;
import br.gov.serpro.updater.PgdUpdater;
import br.gov.serpro.updater.ReleaseUpdateProperties;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import jupar.Downloader;
import jupar.objects.Release;
import org.apache.commons.io.FileUtils;
import serpro.ppgd.itr.ConstantesGlobaisITR;
import serpro.ppgd.itr.exception.AplicacaoException;
import serpro.ppgd.itr.util.AplicacaoPropertiesUtil;
import serpro.ppgd.itr.util.update.ITRUpdateProperties;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class ITRUpdater {
    public final String NOME_ARQ_LATEST = "latest.xml";
    public final String NOME_ARQ_PROPRIEDADES = "release_properties.xml";
    public final String NOME_ARQ_UPDATE_JAR = "pgd-updater.jar";
    public final String PATH_PASTA_UPDATE_DESENVOLVIMENTO = "http://downloaditr.dev.serpro/" + ConstantesGlobais.EXERCICIO + "/update/";
    public final String PATH_PASTA_UPDATE_TESTES = "http://downloaditr.hom.serpro.gov.br/Testes/" + ConstantesGlobais.EXERCICIO + "/update/";
    public final String PATH_PASTA_UPDATE_HOMOLOGACAO = "http://downloaditr.hom.serpro.gov.br/" + ConstantesGlobais.EXERCICIO + "/update/";
    public final String PATH_PASTA_UPDATE_PRODUCAO = "https://downloaditr.receita.fazenda.gov.br/" + ConstantesGlobais.EXERCICIO + "/update/";
    public final String PATH_ENDERECO_UPDATE_DESENVOLVIMENTO = this.PATH_PASTA_UPDATE_DESENVOLVIMENTO + "latest.xml";
    public final String PATH_ENDERECO_UPDATE_TESTES = this.PATH_PASTA_UPDATE_TESTES + "latest.xml";
    public final String PATH_ENDERECO_UPDATE_HOMOLOGACAO = this.PATH_PASTA_UPDATE_HOMOLOGACAO + "latest.xml";
    public final String PATH_ENDERECO_UPDATE_PRODUCAO = this.PATH_PASTA_UPDATE_PRODUCAO + "latest.xml";
    public final String NOME_PASTA_TEMP = "tmp_ITR" + ConstantesGlobais.EXERCICIO;
    public final String NOME_PASTA_APLICATIVO = ".itr";
    public final String NOME_ITR_APP_MAC = "ITR" + ConstantesGlobais.EXERCICIO + ".app";
    public final String NOME_ITR_EXE_WIN = "ITR" + ConstantesGlobais.EXERCICIO + ".exe";
    public static int TIPO_AMBIENTE_UPDATER_DESENVOLVIMENTO = 1;
    public static int TIPO_AMBIENTE_UPDATER_HOMOLOGACAO = 2;
    public static int TIPO_AMBIENTE_UPDATER_PRODUCAO = 3;
    private int ambienteUpdater = TIPO_AMBIENTE_UPDATER_DESENVOLVIMENTO;
    private PgdUpdater updater = null;
    private File pastaBase = null;
    private static ITRUpdater instance = null;

    protected ITRUpdater() {
    }

    public static ITRUpdater getInstance() {
        if (instance == null) {
            instance = new ITRUpdater();
        }
        return instance;
    }

    protected PgdUpdater getPgdUpdater() {
        if (this.updater == null) {
            this.updater = new PgdUpdater();
            this.updater.setReleasePropertiesPath(new File(UtilitariosArquivo.getPathDados() + File.separator + "release_properties.xml").getAbsolutePath());
            try {
                this.updater.setLogFile(new File(UtilitariosArquivo.getPathUsuario() + File.separator + "updater.log"));
            }
            catch (AtualizacaoException e) {
                e.printStackTrace();
            }
        }
        return this.updater;
    }

    protected String obterIdentificadorVersao(String versao, String release) {
        Object strVersao = versao;
        try {
            if (release != null && release.trim().length() > 0 && Integer.parseInt(release) > 0) {
                if (ConstantesGlobaisITR.VERSAO_TESTES) {
                    strVersao = (String)strVersao + "_Testes_" + release;
                } else if (ConstantesGlobaisITR.VERSAO_HOMOLOGACAO) {
                    strVersao = (String)strVersao + "_Hom_" + release;
                }
            }
            if (ConstantesGlobaisITR.FASE.equalsIgnoreCase("Desenvolvimento")) {
                strVersao = (String)strVersao + "_Des";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strVersao;
    }

    protected ITRUpdateProperties obterUpdateProperties(Release latest) throws AplicacaoException {
        try {
            String ultimaVersao = this.obterIdentificadorVersao(latest.getpkgver(), latest.getPkgrel());
            String versaoAtual = this.obterIdentificadorVersao(AplicacaoPropertiesUtil.getVersao(), ConstantesGlobaisITR.VERSAO_TESTES ? AplicacaoPropertiesUtil.getVersaoTeste() : (ConstantesGlobaisITR.VERSAO_HOMOLOGACAO ? AplicacaoPropertiesUtil.getVersaoHomologacao() : null));
            Gson g = new Gson();
            ITRUpdateProperties updateProperties = (ITRUpdateProperties)g.fromJson(latest.getMessage(), ITRUpdateProperties.class);
            updateProperties.setUltimaVersao(ultimaVersao);
            updateProperties.setVersaoAtual(versaoAtual);
            updateProperties.setTipoAtualizacao(ITRUpdateProperties.TipoAtualizacao.valueOf(latest.getseverity()));
            if (updateProperties.getArquivoZip() != null && updateProperties.getArquivoZip().trim().length() > 0) {
                updateProperties.setArquivoZip(updateProperties.getArquivoZip().replaceAll("\\@", updateProperties.getVersaoAtual() + "_update_" + updateProperties.getUltimaVersao()));
            }
            if (updateProperties.getUltimaVersaoManual() != null && !updateProperties.getUltimaVersaoManual().trim().isEmpty()) {
                Release relVersaoManual = new Release();
                Release relVersaoAtual = new Release();
                relVersaoAtual.setpkgver(AplicacaoPropertiesUtil.getVersao());
                if (ConstantesGlobaisITR.VERSAO_TESTES) {
                    relVersaoAtual.setPkgrel(AplicacaoPropertiesUtil.getVersaoTeste());
                } else {
                    relVersaoAtual.setPkgrel(AplicacaoPropertiesUtil.getVersaoHomologacao());
                }
                String[] versaoManual = updateProperties.getUltimaVersaoManual().split("_");
                relVersaoManual.setpkgver(versaoManual[0]);
                if (versaoManual.length > 1) {
                    relVersaoManual.setPkgrel(versaoManual[1]);
                }
                updateProperties.setDownloadManual(relVersaoManual.compareTo((Object)relVersaoAtual) > 0);
            }
            return updateProperties;
        }
        catch (Exception e) {
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
    }

    public ITRUpdateProperties temAtualizacaoCompletada() throws AplicacaoException {
        PgdUpdater updater = this.getPgdUpdater();
        ITRUpdateProperties itrProperties = null;
        try {
            ReleaseUpdateProperties properies = updater.getReleaseUpdateProperties();
            if (properies != null && properies.getUpdateStatus() == ReleaseUpdateProperties.UpdateStatus.UpdateCompleted) {
                itrProperties = this.obterUpdateProperties(properies.getLatestRelease());
            }
        }
        catch (AtualizacaoException e) {
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
        return itrProperties;
    }

    public ITRUpdateProperties atualizacaoPendente() throws AplicacaoException {
        PgdUpdater updater = this.getPgdUpdater();
        ITRUpdateProperties updateProperties = null;
        try {
            ReleaseUpdateProperties releaseProperties = updater.registerUpdateStatusUpdateNotStarted();
            if (releaseProperties != null) {
                updateProperties = this.obterUpdateProperties(releaseProperties.getLatestRelease());
            }
        }
        catch (AtualizacaoException e) {
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
        return updateProperties;
    }

    public boolean verificarUltimaVersaoAposPeriodo() throws AplicacaoException {
        PgdUpdater updater = this.getPgdUpdater();
        try {
            ReleaseUpdateProperties releaseProperties = updater.getReleaseUpdateProperties();
            if (releaseProperties != null && releaseProperties.getUpdateStatus() != ReleaseUpdateProperties.UpdateStatus.UpdateCompleted) {
                ITRUpdateProperties updateProperties = this.obterUpdateProperties(releaseProperties.getLatestRelease());
                String dataUltimaConsulta = releaseProperties.getQueryDate();
                Calendar cal = Calendar.getInstance();
                cal.setLenient(false);
                cal.clear();
                cal.set(Integer.parseInt(dataUltimaConsulta.substring(0, 4)), Integer.parseInt(dataUltimaConsulta.substring(4, 6)) - 1, Integer.parseInt(dataUltimaConsulta.substring(6, 8)), Integer.parseInt(dataUltimaConsulta.substring(8, 10)), Integer.parseInt(dataUltimaConsulta.substring(10, 12)));
                cal.add(12, updateProperties.getPeriodoEspera());
                long dataProximaConsulta = Long.parseLong(updater.getDateTime(cal.getTime()));
                long dataAtual = Long.parseLong(updater.getDateTime(new Date()));
                if (dataAtual <= dataProximaConsulta) {
                    return false;
                }
            }
        }
        catch (AtualizacaoException | NumberFormatException e) {
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
        return true;
    }

    public ITRUpdateProperties verificarUltimaVersaoOnline() throws AplicacaoException {
        ITRUpdateProperties updateProperties = null;
        PgdUpdater updater = this.getPgdUpdater();
        try {
            Release latest = updater.verificarVersao(this.getEnderecoArqUltimaVersao(), AplicacaoPropertiesUtil.getVersao(), ConstantesGlobaisITR.VERSAO_TESTES ? AplicacaoPropertiesUtil.getVersaoTeste() : (ConstantesGlobaisITR.VERSAO_HOMOLOGACAO ? AplicacaoPropertiesUtil.getVersaoHomologacao() : ""));
            if (latest != null) {
                updateProperties = this.obterUpdateProperties(latest);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new AplicacaoException("atualizar.erro.verificacao", ex);
        }
        return updateProperties;
    }

    public String getJavaCommand() {
        Object javaCommand = "java";
        File javaHomePath = new File(System.getProperty("java.home") + File.separator + "bin");
        if (javaHomePath.exists() && javaHomePath.isDirectory()) {
            javaCommand = javaHomePath.getAbsolutePath() + File.separator + (String)javaCommand;
        }
        return javaCommand;
    }

    public void execNavegador(String endereco) throws AplicacaoException {
        File baseDir = this.obterPastaBase();
        File updaterJar = new File(baseDir, "pgd-updater.jar");
        ArrayList<Object> cmd = new ArrayList<Object>();
        cmd.add(this.getJavaCommand());
        cmd.add("-jar");
        cmd.add(updaterJar.getAbsolutePath());
        cmd.add("-B");
        cmd.add("-appName");
        cmd.add("ITR" + ConstantesGlobais.EXERCICIO);
        cmd.add("-url");
        cmd.add(endereco);
        System.err.println("cmdDir=" + baseDir);
        System.err.println("cmd=" + cmd.toString());
        try {
            Runtime.getRuntime().exec(cmd.toArray(new String[0]), null, baseDir);
        }
        catch (Throwable ex) {
            throw new AplicacaoException("atualizar.erro.navegador", new String[]{endereco, ConstantesGlobais.EXERCICIO}, ex);
        }
    }

    public void execUpdate(ITRUpdateProperties updateProperties) throws AplicacaoException {
        File baseDir = this.obterPastaBase();
        String releaseUpdateProperties = this.getPgdUpdater().getReleasePropertiesPath();
        File updaterJar = new File(baseDir, "pgd-updater.jar");
        File tempDir = this.obterPastaTemp();
        File logFile = this.getPgdUpdater().getLogFile();
        Object comando = null;
        ArrayList<Object> cmd = new ArrayList<Object>();
        String javaCommand = this.getJavaCommand();
        File itrExecFile = null;
        comando = FabricaUtilitarios.isWindows() && (itrExecFile = new File(baseDir, this.NOME_ITR_EXE_WIN)).exists() ? itrExecFile.getAbsolutePath() : (FabricaUtilitarios.isMac() && (itrExecFile = new File(baseDir.getParentFile().getParentFile().getParentFile(), this.NOME_ITR_APP_MAC)).exists() ? "open#" + itrExecFile.getAbsolutePath() : javaCommand + "#-jar#pgditr.jar");
        cmd.add(javaCommand);
        cmd.add("-jar");
        cmd.add(updaterJar.getAbsolutePath());
        cmd.add("-U");
        cmd.add("-W");
        cmd.add("-appName");
        cmd.add("ITR" + ConstantesGlobais.EXERCICIO);
        cmd.add("-tempDir");
        cmd.add(tempDir.getAbsolutePath());
        cmd.add("-destDir");
        cmd.add(baseDir.getAbsolutePath());
        cmd.add("-zipFile");
        cmd.add(updateProperties.getArquivoZip());
        cmd.add("-releaseUpdateProperties");
        cmd.add(releaseUpdateProperties);
        cmd.add("-logFile");
        cmd.add(logFile.getAbsolutePath());
        cmd.add("-appComandSeparator");
        cmd.add("#");
        cmd.add("-appComand");
        cmd.add(comando);
        System.err.println("cmdDir=" + baseDir);
        System.err.println("cmd=" + cmd.toString());
        try {
            Runtime.getRuntime().exec(cmd.toArray(new String[0]), null, baseDir);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new AplicacaoException("atualizar.erro.update", ex);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new AplicacaoException("atualizar.erro.update", ex);
        }
    }

    public void download(ITRUpdateProperties updateProperties, Downloader.DownloadProgress progress) throws AplicacaoException {
        PgdUpdater updater = this.getPgdUpdater();
        updater.setDownloadProgress(progress);
        File tempDir = this.obterPastaTemp();
        try {
            if (tempDir.exists()) {
                FileUtils.deleteDirectory((File)tempDir);
            }
            FileUtils.forceMkdir((File)tempDir);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AplicacaoException("atualizar.erro.download", e);
        }
        try {
            updater.getLogger().info("Iniciando download da vers\u00e3o: " + updateProperties.getUltimaVersao() + " (" + updateProperties.getTipoAtualizacao() + "). Vers\u00e3o Atual: " + updateProperties.getVersaoAtual() + ".");
            updater.executarDownload(updateProperties.getEnderecoServidor(), tempDir.getAbsolutePath(), updateProperties.getArquivoZip());
        }
        catch (AtualizacaoException e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof SocketTimeoutException) {
                throw new AplicacaoException("atualizar.erro.download.timeout", e);
            }
            throw new AplicacaoException("atualizar.erro.download", e);
        }
    }

    public boolean temPermissaoEscritaPastaBase() {
        try {
            return this.obterPastaBase() != null;
        }
        catch (AplicacaoException aplicacaoException) {
            return false;
        }
    }

    public boolean temPermissaoEscritaPasta(File pasta) {
        try {
            File arquivoTeste = new File(pasta, "test.txt");
            arquivoTeste.createNewFile();
            arquivoTeste.delete();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public File obterPastaTemp() throws AplicacaoException {
        return new File(this.obterPastaAplicativo(), this.NOME_PASTA_TEMP);
    }

    public File obterPastaAplicativo() throws AplicacaoException {
        File appHomeDir = null;
        try {
            appHomeDir = new File(new File(System.getProperty("user.home")), ".itr");
            if (!appHomeDir.exists()) {
                FileUtils.forceMkdir((File)appHomeDir);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AplicacaoException("atualizar.erro.generico", e);
        }
        return appHomeDir;
    }

    public File obterPastaBase() throws AplicacaoException {
        if (this.pastaBase == null) {
            try {
                this.pastaBase = new File(ITRUpdater.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new AplicacaoException("atualizar.erro.generico", ex);
            }
            if (this.pastaBase.isFile()) {
                this.pastaBase = this.pastaBase.getParentFile();
            }
            if (!this.temPermissaoEscritaPasta(this.pastaBase)) {
                throw new AplicacaoException("atualizar.erro.generico");
            }
        }
        return this.pastaBase;
    }

    public String getEnderecoArqUltimaVersao() {
        if (ConstantesGlobaisITR.FASE.equalsIgnoreCase("Desenvolvimento")) {
            return this.PATH_ENDERECO_UPDATE_DESENVOLVIMENTO;
        }
        if (ConstantesGlobaisITR.VERSAO_TESTES) {
            return this.PATH_ENDERECO_UPDATE_TESTES;
        }
        if (ConstantesGlobaisITR.VERSAO_HOMOLOGACAO) {
            return this.PATH_ENDERECO_UPDATE_HOMOLOGACAO;
        }
        return this.PATH_ENDERECO_UPDATE_PRODUCAO;
    }

    public int getAmbienteUpdater() {
        return this.ambienteUpdater;
    }

    public void setAmbienteUpdater(int ambienteUpdater) {
        this.ambienteUpdater = ambienteUpdater;
    }
}

