/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.utilizacaoimovel;

import java.math.BigDecimal;
import java.util.List;
import serpro.ppgd.itr.ObjetoNegocioITR;
import serpro.ppgd.itr.gui.utilizacaoimovel.PainelUtilizacaoImovel;
import serpro.ppgd.itr.utilizacaoimovel.DistribuicaoAreaImovel;
import serpro.ppgd.itr.utilizacaoimovel.DistribuicaoAreaUtilizada;
import serpro.ppgd.itr.utilizacaoimovel.ValidadorCAR;
import serpro.ppgd.itr.utilizacaoimovel.ValidadorGrauUtilizacao;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class UtilizacaoImovel
extends ObjetoNegocioITR
implements ObjetoFicha {
    private Valor grauUtilizacao = new Valor((ObjetoNegocio)this, "20. GRAU DE UTILIZA\u00c7\u00c3O (%)", 3, 1);
    private Alfa numProcessoADAIbama = new Alfa((ObjetoNegocio)this, "N\u00famero do recibo do ADA/Ibama", 14);
    private Alfa numeroCAR = new Alfa((ObjetoNegocio)this, "N\u00famero do CAR", 43);
    protected DistribuicaoAreaImovel distribuicaoAreaImovel = new DistribuicaoAreaImovel();
    protected DistribuicaoAreaUtilizada distribuicaoAreaUtilizada = new DistribuicaoAreaUtilizada();
    private Valor paramVEL18 = new Valor((ObjetoNegocio)this, "Tratamento do Par\u00e2metro(TP) 18");
    private Valor paramVEL19 = new Valor((ObjetoNegocio)this, "Tratamento do Par\u00e2metro(TP) 19");

    public UtilizacaoImovel() {
        this.getGrauUtilizacao().setReadOnly(true);
        this.adicionarObservadores();
        this.adicionarValidadores();
        this.setFicha("Utiliza\u00e7\u00e3o do Im\u00f3vel");
    }

    private void adicionarValidadores() {
        this.getNumeroCAR().addValidador((ValidadorIf)new ValidadorCAR(2, "[a-g|A-G|i|I||l-p|L-P|r-t|R-T]{2}[0-9]{7}[0-9|a-f|A-F]{32}"));
        this.getGrauUtilizacao().addValidador((ValidadorIf)new ValidadorGrauUtilizacao(3));
    }

    private void adicionarObservadores() {
        Observador observadorAreas = new Observador(){

            public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
                this.setAtivo(false);
                UtilizacaoImovel.this.getGrauUtilizacao().setObservadoresAtivos(false);
                if (UtilizacaoImovel.this.getDistribuicaoAreaImovel().getAreaAproveitavel().isVazio()) {
                    if (!UtilizacaoImovel.this.getDistribuicaoAreaImovel().getAreaTributavel().isVazio()) {
                        UtilizacaoImovel.this.getGrauUtilizacao().setConteudo("100,0");
                    } else {
                        UtilizacaoImovel.this.getGrauUtilizacao().clear();
                    }
                } else {
                    BigDecimal a = new BigDecimal(UtilizacaoImovel.this.getDistribuicaoAreaUtilizada().getAreaUtilizadaPelaAR().asString().replace(',', '.'));
                    BigDecimal b = new BigDecimal(UtilizacaoImovel.this.getDistribuicaoAreaImovel().getAreaAproveitavel().asString().replace(',', '.'));
                    BigDecimal r = a.divide(b, 6, 1);
                    r = r.multiply(new BigDecimal("100"));
                    r = r.setScale(2, 1);
                    r = r.setScale(1, 0);
                    Valor aux = new Valor(r.toString().replace('.', ','));
                    UtilizacaoImovel.this.getGrauUtilizacao().clear();
                    UtilizacaoImovel.this.getGrauUtilizacao().setConteudo(aux.getConteudoFormatado());
                }
                this.setAtivo(true);
                UtilizacaoImovel.this.getGrauUtilizacao().setObservadoresAtivos(true);
                UtilizacaoImovel.this.getGrauUtilizacao().disparaObservadores();
            }
        };
        this.getDistribuicaoAreaImovel().getAreaAproveitavel().addObservador(observadorAreas);
        this.getDistribuicaoAreaUtilizada().getAreaUtilizadaPelaAR().addObservador(observadorAreas);
    }

    public void verificaADAIbamaHabilitado() {
        if (this.getDistribuicaoAreaImovel().getAreaPreservacaoPermanente().isVazio() && this.getDistribuicaoAreaImovel().getAreaReservaLegal().isVazio() && this.getDistribuicaoAreaImovel().getAreaReservaParticular().isVazio() && this.getDistribuicaoAreaImovel().getAreaInteresseEcologico().isVazio() && this.getDistribuicaoAreaImovel().getAreaServidaoFlorestal().isVazio() && this.getDistribuicaoAreaImovel().getAreaAlagada().isVazio() && this.getDistribuicaoAreaImovel().getAreaFlorestasNativas().isVazio()) {
            this.getNumProcessoADAIbama().clear();
            this.getNumProcessoADAIbama().setReadOnly(true);
            this.getNumProcessoADAIbama().setHabilitado(false);
        } else {
            this.getNumProcessoADAIbama().setReadOnly(false);
            this.getNumProcessoADAIbama().setHabilitado(true);
        }
    }

    public Valor getGrauUtilizacao() {
        return this.grauUtilizacao;
    }

    public void setGrauUtilizacao(Valor grauUtilizacao) {
        this.grauUtilizacao = grauUtilizacao;
    }

    public Alfa getNumProcessoADAIbama() {
        return this.numProcessoADAIbama;
    }

    public void setNumProcessoADAIbama(Alfa numProcessoADAIbama) {
        this.numProcessoADAIbama = numProcessoADAIbama;
    }

    public DistribuicaoAreaImovel getDistribuicaoAreaImovel() {
        return this.distribuicaoAreaImovel;
    }

    public void setDistribuicaoAreaImovel(DistribuicaoAreaImovel distribuicaoAreaImovel) {
        this.distribuicaoAreaImovel = distribuicaoAreaImovel;
    }

    public DistribuicaoAreaUtilizada getDistribuicaoAreaUtilizada() {
        return this.distribuicaoAreaUtilizada;
    }

    public void setDistribuicaoAreaUtilizada(DistribuicaoAreaUtilizada distribuicaoAreaUtilizada) {
        this.distribuicaoAreaUtilizada = distribuicaoAreaUtilizada;
    }

    public Valor getParamVEL18() {
        return this.paramVEL18;
    }

    public void setParamVEL18(Valor paramVEL18) {
        this.paramVEL18 = paramVEL18;
    }

    public Valor getParamVEL19() {
        return this.paramVEL19;
    }

    public void setParamVEL19(Valor paramVEL19) {
        this.paramVEL19 = paramVEL19;
    }

    public void zera() {
        this.grauUtilizacao.clear();
        this.numProcessoADAIbama.clear();
        this.distribuicaoAreaImovel.zeraValores();
        this.distribuicaoAreaUtilizada.zeraValores();
        this.numeroCAR.clear();
    }

    protected List recuperarListaCamposPendencia() {
        List retorno = super.recuperarListaCamposPendencia();
        retorno.add(this.paramVEL18);
        retorno.add(this.paramVEL19);
        retorno.add(this.numProcessoADAIbama);
        retorno.add(this.numeroCAR);
        retorno.add(this.grauUtilizacao);
        return retorno;
    }

    public String getClasseFicha() {
        return PainelUtilizacaoImovel.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public Alfa getNumeroCAR() {
        return this.numeroCAR;
    }

    public void setNumeroCAR(Alfa numeroCAR) {
        this.numeroCAR = numeroCAR;
    }

    public String getTituloFichaDashboard() {
        return null;
    }
}

