/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.utilizacaoimovel;

import serpro.ppgd.itr.declaracao.DeclaracaoITR;
import serpro.ppgd.itr.gui.ControladorGui;
import serpro.ppgd.itr.util.MensagemUtil;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ValidadorCAR
extends ValidadorNaoNulo {
    private String caracteresValidos;

    public ValidadorCAR(byte severidade) {
        super(severidade);
    }

    public ValidadorCAR(byte severidade, String msg, String caracteresValidos) {
        super(severidade);
        this.setMensagemValidacao(msg);
        this.caracteresValidos = caracteresValidos;
    }

    public ValidadorCAR(byte severidade, String caracteresValidos) {
        super(severidade);
        this.caracteresValidos = caracteresValidos;
    }

    public RetornoValidacao validarImplementado(String msgAux) {
        if (!this.getInformacao().asString().matches(this.caracteresValidos)) {
            this.setMensagemValidacao(msgAux);
            RetornoValidacao ret = new RetornoValidacao(msgAux, this.getSeveridade());
            return ret;
        }
        return null;
    }

    public RetornoValidacao validarImplementado() {
        if (this.getInformacao().asString().equals("")) {
            return null;
        }
        if (!this.getInformacao().asString().matches(this.caracteresValidos)) {
            RetornoValidacao ret = new RetornoValidacao(MensagemUtil.getMensagem("110252"), this.getSeveridade());
            return ret;
        }
        return this.avaliarFormacaoCAR(this.getInformacao().asString());
    }

    private RetornoValidacao avaliarFormacaoCAR(String numeroCAR) {
        DeclaracaoITR dec = ControladorGui.getDeclaracaoAberta();
        if (dec != null) {
            String ufUpper = numeroCAR.substring(0, 2).toUpperCase();
            if (!ufUpper.equals(dec.getImovel().getUf().getConteudoFormatado())) {
                return new RetornoValidacao(MensagemUtil.getMensagem("110253"), this.getSeveridade());
            }
            if (!numeroCAR.substring(2, 4).equals(dec.getImovel().getMunicipio().getElementoTabela().getConteudo(9))) {
                return new RetornoValidacao(MensagemUtil.getMensagem("110254"), this.getSeveridade());
            }
            if (!numeroCAR.substring(4, 9).equals(dec.getImovel().getMunicipio().getElementoTabela().getConteudo(10))) {
                return new RetornoValidacao(MensagemUtil.getMensagem("110255"), this.getSeveridade());
            }
        }
        return null;
    }

    public String getCaracteresValidos() {
        return this.caracteresValidos;
    }

    public void setCaracteresValidos(String caracteresValidos) {
        this.caracteresValidos = caracteresValidos;
    }
}

