/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.validadores;

import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;

public class ValidadorCIB
extends ValidadorDefault {
    private static final int[] WEIGHT = new int[]{4, 3, 9, 5, 7, 1, 8};
    private static final char[] BASE32_CROCKFORD = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};

    public ValidadorCIB() {
        super((byte)0);
    }

    public ValidadorCIB(byte severidade, String msg) {
        super(severidade);
        this.setMensagemValidacao(msg);
    }

    public RetornoValidacao validarImplementado() {
        RetornoValidacao retorno = this.validarCIB(this.getInformacao().naoFormatado());
        return retorno;
    }

    private RetornoValidacao validarCIB(String cib) {
        if (!ITRUtil.isCIB(cib)) {
            return null;
        }
        if (this.validate(cib)) {
            return null;
        }
        this.setSeveridade((byte)3);
        return new RetornoValidacao("CIB inv\u00e1lido.");
    }

    public boolean validate(String code) {
        if (code.length() < 8) {
            return false;
        }
        code = code.toUpperCase();
        String codeWithoutDv = code.substring(0, 7);
        char dv = code.charAt(7);
        char dvCalc = ValidadorCIB.calculateMod31(ValidadorCIB.stringToInt(codeWithoutDv));
        return dvCalc == dv;
    }

    public String generateCodeWithDV(String codeWithoutDv) {
        return codeWithoutDv + ValidadorCIB.calculateMod31(ValidadorCIB.stringToInt(codeWithoutDv));
    }

    private static char calculateMod31(int[] number) {
        int sum = 0;
        for (int i = 0; i < WEIGHT.length; ++i) {
            sum += number[i] * WEIGHT[i];
        }
        int dv = sum % 31;
        return ValidadorCIB.crockfordEncode(dv);
    }

    private static int[] stringToInt(String str) {
        int[] exit = new int[str.length()];
        for (int i = 0; i < exit.length; ++i) {
            int decoded;
            exit[i] = decoded = ValidadorCIB.crockfordDecode(str.charAt(i));
        }
        return exit;
    }

    private static int crockfordDecode(char caracter) {
        for (int y = 0; y < BASE32_CROCKFORD.length; ++y) {
            if (BASE32_CROCKFORD[y] != caracter) continue;
            return y;
        }
        return 0;
    }

    private static char crockfordEncode(int dig) {
        return BASE32_CROCKFORD[dig];
    }
}

