/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.validadores;

import serpro.ppgd.itr.util.ITRUtil;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;

public class ValidadorNirf
extends ValidadorDefault {
    public ValidadorNirf() {
        super((byte)0);
    }

    public ValidadorNirf(byte severidade, String msg) {
        super(severidade);
        this.setMensagemValidacao(msg);
    }

    public RetornoValidacao validarImplementado() {
        RetornoValidacao retorno = this.validarNirf(this.getInformacao().naoFormatado());
        return retorno;
    }

    private RetornoValidacao validarNirf(String nirf) {
        if (ITRUtil.isCIB(nirf)) {
            return null;
        }
        if (this.validate(nirf)) {
            return null;
        }
        this.setSeveridade((byte)3);
        return new RetornoValidacao("Nirf inv\u00e1lido.");
    }

    public boolean validate(String nirf) {
        String dvCalculado = "";
        String dv = "0";
        if (nirf.length() == 8 && !nirf.equals("00000000")) {
            dv = nirf.substring(7);
            dvCalculado = this.calcularDvNirf(nirf);
            if (Integer.parseInt(dv) == Integer.parseInt(dvCalculado)) {
                return true;
            }
        }
        return false;
    }

    private String calcularDvNirf(String nirf) {
        int soma;
        int dv = soma = 0;
        for (int i = 0; i < 7; ++i) {
            soma += Integer.parseInt(nirf.substring(i, i + 1)) * (8 - i);
        }
        dv = this.calculaDv(soma);
        return String.valueOf(dv);
    }

    private int calculaDv(int soma) {
        int dv = 11 - soma % 11;
        if (dv > 9) {
            dv = 0;
        }
        return dv;
    }
}

