/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.itr.validadores;

import java.util.StringTokenizer;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;

public class ValidadorNomeITR
extends ValidadorDefault {
    public static final String NOME_MAIS_60 = "@1 tem mais que 60 caracteres.";
    public static final String NOME_MENOS_2 = "@1 tem menos de 2 partes.";
    public static final String NOME_MAIS_15 = "@1 tem mais de 15 partes.";
    public static final String NOME_1_CARACTER = "Primeira parte do @1 tem somente um caracter.";
    public static final String NOME_MAIS_20 = "Parte do @1 tem mais de 20 caracteres.";
    public static final String NOME_3_CONSECUTIVOS = "@1 com 3 ou mais caracteres iguais consecutivos.";
    public static final String NOME_NUMERICO = "@1 n\u00e3o pode ter n\u00fameros.";
    public static final String NOME_INVALIDO = "@1 tem caracteres inv\u00e1lidos.";
    public static final String NOME_ESPOLIO = "Deve ser informado o @1 sem a palavra ESP\u00d3LIO.";
    private String nomeCampo = null;

    public ValidadorNomeITR(byte severidade) {
        super(severidade);
    }

    public ValidadorNomeITR(byte severidade, String nomeCampo) {
        super(severidade);
        this.nomeCampo = nomeCampo;
    }

    public RetornoValidacao validarImplementado() {
        RetornoValidacao retorno;
        if (this.nomeCampo == null) {
            this.nomeCampo = this.getInformacao().getNomeCampo();
        }
        if ((retorno = this.validarNomeCompleto(this.getInformacao().asString())) != null) {
            retorno.setSeveridade(this.getSeveridade());
            if (this.getMensagemValidacao().trim().length() > 0) {
                retorno.setMensagemValidacao(this.getMensagemValidacao());
            }
        }
        return retorno;
    }

    private RetornoValidacao validarNomeCompleto(String nomeCompleto) {
        this.setSeveridade((byte)3);
        if (nomeCompleto.length() > 60) {
            return new RetornoValidacao(NOME_MAIS_60.replaceFirst("@1", this.nomeCampo));
        }
        StringTokenizer testeNomeCompleto = new StringTokenizer(nomeCompleto);
        int quantidadeTokens = testeNomeCompleto.countTokens();
        if (quantidadeTokens > 15) {
            return new RetornoValidacao(NOME_MAIS_15.replaceFirst("@1", this.nomeCampo));
        }
        RetornoValidacao rValidacao = null;
        boolean primeiraVez = true;
        while (testeNomeCompleto.hasMoreTokens()) {
            String testeNome = testeNomeCompleto.nextToken();
            rValidacao = this.validarNome(testeNome);
            if (rValidacao == null) continue;
            return rValidacao;
        }
        if (quantidadeTokens < 2) {
            this.setSeveridade((byte)2);
            return new RetornoValidacao(NOME_MENOS_2.replaceFirst("@1", this.nomeCampo));
        }
        return null;
    }

    private RetornoValidacao validarNome(String parteNomeCompleto) {
        int letrasRepetidas = 1;
        for (int j = 1; j < parteNomeCompleto.length(); ++j) {
            letrasRepetidas = parteNomeCompleto.charAt(j) == parteNomeCompleto.charAt(j - 1) ? ++letrasRepetidas : 1;
            if (letrasRepetidas == 3 && !parteNomeCompleto.equals("III")) {
                return new RetornoValidacao(NOME_3_CONSECUTIVOS.replaceFirst("@1", this.nomeCampo));
            }
            if (!Character.isDigit(parteNomeCompleto.charAt(j - 1))) continue;
            return new RetornoValidacao(NOME_NUMERICO.replaceFirst("@1", this.nomeCampo));
        }
        if (Character.isDigit(parteNomeCompleto.charAt(parteNomeCompleto.length() - 1))) {
            return new RetornoValidacao(NOME_NUMERICO.replaceFirst("@1", this.nomeCampo));
        }
        if ("ESPOLIO".equals(parteNomeCompleto.toUpperCase()) || "ESP\u00d3LIO".equals(parteNomeCompleto.toUpperCase())) {
            return new RetornoValidacao(NOME_ESPOLIO.replaceFirst("@1", this.nomeCampo));
        }
        return null;
    }
}

