/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.listener.ValueChangeEvent;
import serpro.ppgd.gui.xbeans.listener.ValueChangeListener;
import serpro.ppgd.negocio.Informacao;

public abstract class JEditCampoTextoAbstract
extends JEditCampo {
    private String valorAntigo;

    public JEditCampoTextoAbstract() {
        this.associarEventos();
        System.out.println("----JEditCampoTextoAbstract");
    }

    public JEditCampoTextoAbstract(Informacao campo) {
        super(campo);
        this.associarEventos();
    }

    public JEditCampoTextoAbstract(Informacao campo, String idAjuda) {
        super(campo, idAjuda);
        this.associarEventos();
    }

    @Override
    public int getBaseline(int width, int height) {
        JTextComponent editor = (JTextComponent)this.getComponenteEditor();
        if (editor != null) {
            return editor.getBaseline(width, height);
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        JTextComponent editor = (JTextComponent)this.getComponenteEditor();
        if (editor != null) {
            return editor.getBaselineResizeBehavior();
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    public void addValueChangeListener(ValueChangeListener pListener) {
        this.listenerList.add(ValueChangeListener.class, pListener);
    }

    public void removeValueChangeListener(ValueChangeListener pListener) {
        this.listenerList.remove(ValueChangeListener.class, pListener);
    }

    public ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.listenerList.getListeners(ValueChangeListener.class);
    }

    protected void fireValueChangeListener() {
        ValueChangeListener[] listeners;
        for (ValueChangeListener changeListener : listeners = this.getValueChangeListeners()) {
            changeListener.valueChanged(new ValueChangeEvent(this, this.getInformacao().asString()));
        }
    }

    protected void associarEventos() {
        this.getComponenteEditor().addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                String lValorAtual = ((JTextComponent)JEditCampoTextoAbstract.this.getComponenteEditor()).getText();
                if (lValorAtual != null && !lValorAtual.equals(JEditCampoTextoAbstract.this.valorAntigo)) {
                    JEditCampoTextoAbstract.this.fireValueChangeListener();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                JEditCampoTextoAbstract.this.valorAntigo = ((JTextComponent)JEditCampoTextoAbstract.this.getComponenteEditor()).getText();
            }
        });
    }

    @Override
    protected void readOnlyPropertyChange(boolean readOnly) {
        JTextComponent editor = (JTextComponent)this.getComponenteEditor();
        if (readOnly) {
            editor.setEditable(false);
        } else {
            editor.setEditable(true);
        }
    }

    @Override
    protected void habilitadoPropertyChange(boolean habilitado) {
        this.getComponenteEditor().setEnabled(habilitado);
        JLabel rotulo = this.getRotulo();
        if (rotulo != null) {
            this.getRotulo().setEnabled(habilitado);
        }
    }

    @Override
    public void setEstiloFonte(int estilo) {
        Font f = this.getComponenteEditor().getFont();
        f = f.deriveFont(estilo);
        this.getComponenteEditor().setFont(f);
    }

    @Override
    public void setIncrementoTamanhoFonte(int incremento) {
        this.incrementoTamanhoFonte = incremento;
        Font f = this.getComponenteEditor().getFont();
        if (this.tamanhoOriginal == -1.0f) {
            this.tamanhoOriginal = f.getSize2D();
        }
        f = f.deriveFont(this.tamanhoOriginal + (float)incremento);
        this.getComponenteEditor().setFont(f);
    }

    @Override
    public int getIncrementoTamanhoFonte() {
        return this.incrementoTamanhoFonte;
    }
}

